define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$sce",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "restService",
            function ($scope, $state, $sce, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils, restService) {
                $scope.configformTitle = appUtils.getString("maintance_term_settingconf_title");
                $scope.TIPS = appUtils.getString("maintance_term_instruction_tips");
                $scope.TIPS2 = $sce.trustAsHtml(appUtils.getString("maintance_term_instruction_tips2"));
                $scope.TIPS3 = appUtils.getString("maintance_term_instruction_tips3");
                $scope.AUTO_BAK = appUtils.getString("maintance_term_autobak_title");
                $scope.MANUAL_BAK = appUtils.getString("maintance_term_manualbak_title");
                $scope.MANUAL_TIPS = appUtils.getString("maintance_term_manual_tips");
                var isAutoBackup = false, isFocusPwd = false, isFocusDataPwd=false;
                var inputModels = {
                    ftpServerId: {
                        id: "ftpServerId",
                        value: "",
                        val: function (value) {
                            if ($.trim(value)) {
                                inputModels.ftpServerId.value = $.trim(value);
                                return inputModels.ftpServerId;
                            }
                            return inputModels.ftpServerId.value;
                        }
                    },
                    ip: {
                        id: "ip",
                        width: constsService.W3,
                        require: true,
                        extendFunction: ["checkIP"],
                        validate: "checkIP : extend function;",
                        value: "",
                        val: function (value) {
                            var current = $('#ip');
                            if ($.trim(value)) {
                                current.widget().option('value', $.trim(value));
                                return current;
                            }
                            return current.widget().getValue();
                        }
                    },
                    port: {
                        id: "port",
                        width: constsService.W3,
                        value: "22",
                        min: "1",
                        max: "65535",
                        require: true,
                        change: function () {
                            var port = $("#port").widget();
                            if (port.option("value") == "") {
                                port.option("value", "22");
                                $scope.model.port.value = "22";
                            }
                        },
                        validate: [{
                            validFn: "required"
                        }, {
                            validFn: "rangeValue",
                            params: [1, 65535],
                            errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                        }, {
                            validFn: "integer"
                        }],
                        val: function (value) {
                            var current = $('#port');
                            if ($.trim(value)) {
                                current.widget().option('value', $.trim(value));
                                return current;
                            }
                            return current.widget().option('value');
                        }
                    },
                    password: {
                        id: "ftpPassword",
                        width: constsService.W3,
                        require: true,
                        validate: constsService.VALID.DES_REMARK_REQUIRED,
                        value: "",
                        type: 'password',
                        val: function (value) {
                            var current = $('#ftpPassword');
                            if ($.trim(value)) {
                                current.widget().option('value', $.trim(value));
                                return current;
                            }
                            return current.widget().getValue();
                        },
                        focus: function(event) {
                            if (!isFocusPwd) {
                                isFocusPwd = true;
                                $('#ftpPassword').widget().option('value', "");
                            }
                        }
                    },
                    name: {
                        width: constsService.W3,
                        id: "ftpUserName",
                        require: true,
                        validate: constsService.VALID.DES_REMARK_REQUIRED,
                        value: "",
                        val: function (value) {
                            var current = $('#ftpUserName');
                            if ($.trim(value)) {
                                current.widget().option('value', $.trim(value));
                                return current;
                            }
                            return current.widget().getValue();
                        }
                    },
                    dataPassword:{
                        width: constsService.W3,
                        id:"dataPassword",
                        require:true,
                        extendFunction: ["checkDataPassword"],
                        validate: "checkDataPassword : extend function;",
                        value:"",
                        type:"password",
                        display:true,
                        message:appUtils.getString("system_data_export_to_local"),
                        val:function(value){
                            var current=$("#dataPassword");
                            if($.trim(value)){
                                current.widget().option("value",$.trim(value));
                                return current;
                            }
                            return current.widget().getValue();
                        },
                        focus:function(event){
                            if(!isFocusDataPwd){
                                isFocusDataPwd=true;
                                $("#dataPassword").widget().option("value","");
                            }
                        }
                    }
                };

                $scope.model = {
                    labels: {
                        ip: appUtils.getString("maintance_term_sftp_ip_label") + ":",
                        port: appUtils.getString("maintance_term_sftp_port_label") + ":",
                        password: appUtils.getString("maintance_term_sftp_password_label") + ":",
                        name: appUtils.getString("maintance_term_sftp_name_label") + ":",
                        dataPassword:appUtils.getString("export_dataPassword_label")+":"
                    },
                    "switch": {
                        id: "switch",
                        items: [{
                            label: appUtils.getString("maintance_term_manualbak_title"),
                            value: "on"
                        }, {
                            label: appUtils.getString("maintance_term_autobak_title"),
                            value: "off"
                        }],
                        standard: false,
                        change: function (param) {
                            var preSection = $("#switch").widget().option("selected");
                            isAutoBackup = preSection == "on";
                            for (var field in inputModels) {
                                if(field=="dataPassword"){
                                    inputModels[field].display=isAutoBackup;
                                }
                                inputModels[field].disable = !isAutoBackup;
                                inputModels[field].require = isAutoBackup;
                            }
                            $scope.btnTest.disable = !isAutoBackup;
                            $scope.btnTest.hide = !isAutoBackup;
                            $scope.$apply();
                        },
                        val: function(value) {
                            var current = $('#switch');
                            if ($.trim(value)) {
                                $scope.model['switch'].selected = $.trim(value);
                                return current;
                            }
                            return current.widget().getSelectId();
                        }
                    },
                    ip: inputModels.ip,
                    port: inputModels.port,
                    name: inputModels.name,
                    password: inputModels.password,
                    dataPassword:inputModels.dataPassword
                };
                $scope.btnOk = {
                    id: "btnCreateOk",
                    text: appUtils.getString("common_term_confirm_button"),
                    authKey: appUtils.checkRight("ism.drm.dump.configdata.setting.operateID"),
                    click: function () {
                        var result = UnifyValid.FormValid($("#resetForm"), {focusInvalid: true});
                        if (!result) {
                            return;
                        }
                        var msg = ""
                        if (isAutoBackup) {
                            restService.getFtpHostKey({ip:$scope.model.ip.val(),port:$scope.model.port.val()}, {
                                success: function(result) {
                                    var keysWin = angular.copy(constsService.KEYS_WIN);
                                    keysWin.helpId = "dataExportWinHelp";
                                    keysWin.data = {
                                        callback: function(param, scope) {
                                            scope.keys = [result.hostKey];
                                            scope.$apply();
                                        }
                                    };
                                    appUtils.showWindow(keysWin, function() {
                                        var options = this.options;
                                        message.warn({
                                            "content": appUtils.getString("system_conf_enabled_msg", $.encoder.encodeForHTML($scope.model.ip.val())),
                                            "ok": function() {
                                                requestAjax.setFTPInfo();
                                                $("#" + options.winId).widget().destroy();
                                            }
                                        });
                                    });
                                }
                            });
                        } else {
                            message.warn({
                                "content": appUtils.getString("system_conf_disabled_msg"),
                                "ok": function () {
                                    requestAjax.setFTPInfo();
                                }
                            });
                        }

                    }
                };

                $scope.btnCancel = {
                    id: "btnCreateCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        _init();
                        isFocusPwd = false;
                        isFocusDataPwd=false;
                        $('#resetForm').find('.tiny-tips-box').remove();
                    }
                };

                $scope.btnTest = {
                    id: "btnTest",
                    hide: true,
                    disable: true,
                    text: appUtils.getString("ism.drm.recover.play.drilling.btn.txt"),
                    click: function () {
                        var result = UnifyValid.FormValid($("#resetForm"), {focusInvalid: true});
                        if (!result) {
                            return;
                        }
                        restService.testAutoBackupConfig([], function(result) {
                            message.prompt(appUtils.getString("common_term_operationsyn_success_label"));
                        });
                    }
                };

                $scope.btnExport = {
                    id: "btnExport",
                    authKey : appUtils.checkRight("ism.drm.dump.configdata.scan"),
                    text: appUtils.getString("common_term_export_button"),
                    click: function () {
                        var win=angular.copy(constsService.EXPORT_PWD_WIN);
                        if(appUtils.isEn()){
                            win.width = 450;
                            win.height = 338;
                        };
                        win.title=appUtils.getString("system_data_export_title");
                        appUtils.showWindow(win,function(){
                            var valid = UnifyValid.FormValid($("#" + this.options.winContentId), {focusInvalid: true});
                            if (!valid) {
                                return;
                            }

                            var callback = function() {
                                $("#" + win.winId).widget().destroy();
                            }

                            var params = {
                                dataPassword: $("#exportPwd").widget().getValue(),
                                confirmPassword: $("#confirmPwd").widget().getValue(),
                                isDataAnonymous: false
                            }

                            appUtils.export("/system/action/exportSysConfigData", null, "GET", callback, null, params);
                        });
                    }
                };

                var requestAjax = {
                    setFTPInfo: function () {
                        var requestObj = {
                            ftpServerId: "",
                            autoBackupFlag: isAutoBackup
                        };
                        for (var field in inputModels) {
                            var obj = inputModels[field];
                            requestObj[obj.id] = obj.val();
                            if ((!isFocusPwd && field == "password")||(!isFocusDataPwd && field == "dataPassword")) {
                                requestObj[obj.id] = "";
                            }
                        }
                        if(!isAutoBackup){
                            delete requestObj.dataPassword;
                        } else {
                            requestObj['hostKey'] = $.trim($(".msg-container").text());
                        }
                        mask.show();
                        communicationService.put(utilService.getResouceUrl("/system/action/setFTPInfo"), requestObj)
                            .promise().always(function (result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    "content": appUtils.getString("common_term_operation_success_label"),
                                    "ok": function () {
                                    }
                                });
                            }
                        });
                    },
                    getFTPInfo: function () {
                        communicationService.get(utilService.getResouceUrl("/system/action/getFTPInfo"))
                            .promise().always(function (result) {
                                if (!exception.check(result)) {
                                    isAutoBackup = true;
                                    for (var field in inputModels) {
                                        var obj = inputModels[field];
                                        obj.val("");
                                        obj.disable = !isAutoBackup;
                                        obj.require = isAutoBackup;
                                        obj.display=isAutoBackup;
                                    }
                                    $scope.btnTest.disable = !isAutoBackup;
                                    $scope.btnTest.hide = !isAutoBackup;
                                    $scope.$apply();
                                    return;
                                }

                                if (!result) {
                                    isAutoBackup = false;
                                    $scope.model["switch"].val(isAutoBackup ? "off" : "on");
                                    for (var field in inputModels) {
                                        var obj = inputModels[field];
                                        if(field=="dataPassword"){
                                            obj.display=false;
                                        }
                                        obj.disable = true;
                                        obj.require = false;
                                    }
                                    $scope.$apply();
                                    return;
                                }

                                isAutoBackup = result.autoBackupFlag;
                                $scope.model["switch"].val(isAutoBackup ? "off" : "on");
                                for (var field in inputModels) {
                                    var obj = inputModels[field];
                                    if (field == "password") {
                                        _.isEmpty(result.ftpUserName)?obj.val(""):obj.val("********");
                                    }
                                    else if(field=="dataPassword"){
                                        _.isEmpty(result.ftpUserName)?obj.val(""):obj.val("********");
                                        obj.display=isAutoBackup;
                                    }
                                    else {
                                        obj.val(result[obj.id]);
                                    }
                                    obj.disable = !isAutoBackup;
                                    obj.require = isAutoBackup;
                                }

                                $scope.btnTest.disable = !isAutoBackup;
                                $scope.btnTest.hide = !isAutoBackup;
                                $scope.$apply();
                        });
                    }
                };
                //校验加密密码方法
                UnifyValid.checkDataPassword = function() {
                    var dataPassword = $scope.model.dataPassword.val(),
                        isChecked = appUtils.checkUserPwd(dataPassword, 8, 2, 15),
                        pwdArray = dataPassword.split("");

                    if (dataPassword === "********" && !isFocusDataPwd) {
                        return "";
                    }

                    for (var i = 0; i < pwdArray.length; i++) {
                        if (pwdArray[i] == " ") {
                            return appUtils.getString("validate_term_dataPwd_error", 8, 15);
                        }
                    }
                    if (!dataPassword) {
                        return appUtils.getString("common_term_empty_label");
                    }
                    if (!isChecked) {
                        return appUtils.getString("validate_term_dataPwd_error", 8, 15);
                    }

                    return "";
                }

                UnifyValid.checkIP = function() {
                    var val = this[0].value;
                    if (_.isEmpty(val)) {
                        return appUtils.getString("common_term_empty_label");
                    };
                    if (!appUtils.validIPv4OrIPv6Address(val)) {
                        return appUtils.getString("validate_ipv4_ipv6_label");
                    }
                    return "";
                };


                $scope.$on('$destroy', function() {
                    delete UnifyValid.checkIP;
                    delete UnifyValid.checkDataPassword;
                });

                var _init = function () {
                	appUtils.checkRight("ism.drm.dump.configdata.setting.operateID") &&
                    requestAjax.getFTPInfo();
                };

                _init();

            }];
        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.sysData.ctrl', ctrler);
        return module;
    });
