define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                var cpuData = [], memoData = [], totalPoints = 8, cpuTimeoutFn, memoTimeoutFn;

                $scope.TITLE1 = appUtils.getString("performance_term_setting_title");
                $scope.TITLE2 = appUtils.getString("performance_term_system_title");
                $scope.MEMO = appUtils.getString("performance_term_memo_title");
                $scope.DISK = appUtils.getString("performance_term_disk_title");
                $scope.DB = appUtils.getString("performance_term_database_title") + " (GaussDB)";
                $scope.yaxisUnitUnit = appUtils.getString('common_term_userd_unit_label');
                $scope.WIDTH = "506px";
                $scope.HEIGHT = "280px";
                $scope.cpuPercent = 0;
                $scope.memPercent = 0;
                $scope.diskPercent = 0;

                $scope.btnOk = {
                    id: "btnCreateOk",
                    authKey: appUtils.checkRight("lego.sys.systemMonitor.Threshold.modify"),
                    text: appUtils.getString("common_term_confirm_button"),
                    click: function () {
                        var result = UnifyValid.FormValid($("#form1"), {focusInvalid: true});
                        if (!result) {
                            return;
                        }
                        var cpuPercent = $("#cpu").widget().option("value");
                        var memPercent = $("#memo").widget().option("value");
                        var diskPercent = $("#diskPercent").widget().option("value");
                        var params = {cpuPercent: cpuPercent, memPercent: memPercent, diskPercent: diskPercent};
                        mask.show();
                        communicationService.put(utilService.getResouceUrl("/system/action/modifySysmTreshold"), params).promise().always(function (result) {
                            mask.hide();
                            if (exception.check(result)) {
                                _init(), _getDiskData(), _getDatabaseData();
                                message.success(appUtils.getString("common_term_operation_success_label"));
                            }
                        });
                    }
                };

                $scope.btnCancel = {
                    id: "btnCreateCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        _init();
                    }
                };

                $scope.model = {
                    labels: {
                        cpu: appUtils.getString("performance_term_cpuuseage_label") + ":",
                        memo: appUtils.getString("performance_term_memouseage_label") + ":",
                        disk: appUtils.getString("performance_term_diskuseage_label") + ":"
                    },
                    cpu: {
                        id: "cpu",
                        min: "1",
                        max: "99",
                        value: 90,
                        width: constsService.W3,
                        validate: "required",
                        change: function () {
                            if ($("#cpu").widget().option("value") === "") {
                                $("#cpu").widget().option("value", $scope.cpuPercent);
                            }
                        }
                    },
                    memo: {
                        id: "memo",
                        value: 90,
                        min: "1",
                        max: "99",
                        width: constsService.W3,
                        validate: "required",
                        change: function () {
                            if ($("#memo").widget().option("value") === "") {
                                $("#memo").widget().option("value", $scope.memPercent);
                            }
                        }
                    },
                    disk: {
                        id: "diskPercent",
                        value: 90,
                        min: "1",
                        max: "99",
                        width: constsService.W3,
                        validate: "required",
                        change: function () {
                            if ($("#diskPercent").widget().option("value") === "") {
                                $("#diskPercent").widget().option("value", $scope.diskPercent);
                            }
                        }
                    }
                };

                $scope.$on("$destroy", function () {
                    if (cpuTimeoutFn) {
                        clearInterval(cpuTimeoutFn);
                    }
                    if (memoTimeoutFn) {
                        clearInterval(memoTimeoutFn);
                    }
                });

                function getCpuData() {
                    if (cpuData.length > totalPoints) {
                        cpuData = cpuData.slice(1);
                    }
                    var res = [];
                    for (var i = 0; i < cpuData.length; ++i) {
                        res.push([cpuData[i].time, cpuData[i].cpuPer]);
                    }
                    return res;
                }

                function getMemoData() {
                    if (memoData.length > totalPoints) {
                        memoData = memoData.slice(1);
                    }
                    var res = [];
                    for (var i = 0; i < memoData.length; ++i) {
                        res.push([memoData[i].time, memoData[i].memoPer])
                    }
                    return res;
                }

                function _setCpuData() {
                    communicationService.get(utilService.getResouceUrl("/system/action/queryCPUStatus")).promise().always(function (result) {
                        if (exception.check(result)) {
                            var tmp = [];
                            tmp.time = appUtils.encodeForHTML(result.time);
                            tmp.cpuPer = appUtils.encodeForHTML(result.cpuPer);
                            if (cpuData.length == 0) {
                                cpuData.push(tmp);
                            }
                            var isExisted = false;
                            _.each(cpuData, function (d) {
                                if (d.time === tmp.time) {
                                    isExisted = true;
                                }
                            })

                            if (!isExisted) {
                                cpuData.push(tmp);
                            }

                        }
                    });
                };

                function _setMemoData() {
                    communicationService.get(utilService.getResouceUrl("/system/action/queryMemStatus")).promise().always(function (result) {
                        if (exception.check(result)) {
                            var tmp = [];
                            tmp.time = appUtils.encodeForHTML(result.time);
                            tmp.memoPer = appUtils.encodeForHTML(result.memoPer);

                            if (memoData.length == 0) {
                                memoData.push(tmp);
                            }
                            var isExisted = false;
                            _.each(memoData, function (d) {
                                if (d.time === tmp.time) {
                                    isExisted = true;
                                }
                            })

                            if (!isExisted) {
                                memoData.push(tmp);
                            }
                        }
                    });
                };

                var updateInterval = 4000, diskchart, hchart;

                var options1 = {
                    "id": "cpuChart",
                    "width": $scope.WIDTH,
                    "height": $scope.HEIGHT,
                    "grid": {
                        "show": true,
                        "backgroundColor": "#fff"
                    },
                    "data": [],
                    "yfield": "y",
                    "xfield": "x",
                    "series": {
                        'points': {
                            "show": false,
                            "symbol": "ring"
                        },
                        "lines": {
                            "show": true,
                            "zero": false
                        },
                        "threshold": [
                            {
                                below: 80,
                                belowColor: constsService.CLOLOR_ORANGE,
                                lineColor: constsService.CLOLOR_ORANGE
                            },
                            {
                                below: 90,
                                belowColor: constsService.COLOR_RED,
                                lineColor: constsService.COLOR_RED
                            }
                        ],
                        "shadowSize": 0,
                        "color": constsService.COLOR_GREEN,
                        "section": {
                            "borderStyle": constsService.COLOR_GREEN,
                            "lineWidth": 2,
                            "linePattern": "dashed"
                        }
                    },
                    "trackingLine": {
                        "mode": "x"
                    },
                    "tips": {
                        "tipType": "track",
                        "xDateFormat": "%H:%M:%S",
                        "content": appUtils.getStringWithColon("common_term_time_label") + "%x0</br>" + appUtils.getStringWithColon("common_term_userd_unit_label") + "%y0.2"
                    },
                    "xaxis": {
                        tickLength: 10,
                        ticks: 4,
                        mode: "time",
                        timeformat: "%H:%M:%S"
                    },
                    "yaxis": {
                        "min": 0,
                        "max": 100
                    }
                };

                var linePlot = new tinyWidget.Lineplot(options1);

                var options0 = {
                    "id": "memoChart",
                    "width": $scope.WIDTH,
                    "height": $scope.HEIGHT,
                    "grid": {
                        "show": true,
                        "backgroundColor": "#fff"
                    },
                    "data": [],
                    "series": {
                        'points': {
                            "show": false,
                            "symbol": "ring"
                        },
                        "lines": {
                            "show": true,
                            "zero": false
                        },
                        "threshold": [
                            {
                                value: 80,
                                aboveColor: constsService.CLOLOR_ORANGE,
                                lineColor: constsService.CLOLOR_ORANGE
                            },
                            {
                                value: 90,
                                aboveColor: constsService.COLOR_RED,
                                lineColor: constsService.COLOR_RED
                            }
                        ],
                        "color": constsService.COLOR_GREEN,
                        "shadowSize": 0
                    },
                    "trackingLine": {
                        mode: "x"
                    },
                    "tips": {
                        "tipType": "track",
                        "xDateFormat": "%H:%M:%S",
                        "content": appUtils.getStringWithColon("common_term_time_label") + "%x0</br>" + appUtils.getStringWithColon("common_term_userd_unit_label") + "%y0.2"
                    },
                    "xaxis": {
                        tickLength: 10,
                        ticks: 4,
                        mode: "time",
                        timeformat: "%H:%M:%S"
                    },
                    "yaxis": {
                        "min": 0,
                        "max": 100,
                    },
                    "legend": {
                        "show": true,
                        "location": "ne",
                        "noColumns": 5,
                        "container": $("#memoChartLegend")
                    }
                };

                var linePlot3 = new tinyWidget.Lineplot(options0);

                function update() {
                    $("#cpuChart").widget().reDrawLines([getCpuData()]);
                    $("#cpuChart").widget().setupGrid();
                    $("#cpuChart").widget().draw();
                    $("#memoChart").widget().reDrawLines([getMemoData()]);
                    $("#memoChart").widget().setupGrid();
                    $("#memoChart").widget().draw();
                    setTimeout(function () {
                        if ("settings.performance" == $.trim($state.current.name)) {
                            update();
                        }
                    }, updateInterval);
                }

                function _getDiskData() {
                    var usedData = [], unusedData = [], xTicks = [];
                    communicationService.get(utilService.getResouceUrl("/system/action/queryDiskStatus")).promise().always(function (result) {

                        if (exception.check(result)) {
                            _.each(result, function (d, index) {
                                var data1 = [], data2 = [], ticks = [];
                                data1.push(index);
                                data1.push(appUtils.encodeForHTML($.trim(d.used)));
                                data2.push(index);
                                data2.push(appUtils.encodeForHTML($.trim(d.unused)));
                                ticks.push(index);
                                ticks.push(appUtils.encodeForHTML($.trim(d.partitionName)));
                                usedData.push(data1);
                                unusedData.push(data2);
                                xTicks.push(ticks);
                            });

                            var dataSet = [
                                {
                                    label: appUtils.getString("common_term_used_capacity_label") + " (GB)",
                                    data: usedData,
                                    color: constsService.COLOR_GREEN,
                                    bars: {fill: true, fillColor: constsService.COLOR_GREEN}
                                },
                                {
                                    label: appUtils.getString("common_term_unused_capacity_label") + " (GB)",
                                    data: unusedData,
                                    color: constsService.COLOR_GREY,
                                    bars: {fill: true, fillColor: constsService.COLOR_GREY}
                                },
                            ];

                            var options2 = {
                                "id": "disk",
                                "width": $scope.WIDTH,
                                "height": $scope.HEIGHT,
                                "grid": {
                                    "show": true,
                                    "backgroundColor": "#fff"
                                },
                                "data": dataSet,
                                series: {
                                    stack: 0,
                                    bars: {
                                        show: true,
                                        barWidth: 0.1,
                                        align: "center",
                                        horizontal: false
                                    }
                                },
                                tips: {
                                    "tipType": "hover",
                                    "content": appUtils.getStringWithColon("common_term_disk_location_label") + "%tx</br>" + "%s" + ":" + "%y.2"
                                },
                                "xaxis": {
                                    tickLength: xTicks.length,
                                    ticks: xTicks,
                                },
                                legend: {
                                    enableClick: false,
                                    noColumns: 2,
                                    margin: [185, 280],
                                    position: "ne",
                                    labelFormatter: function(label, series) {
                                        return '<span class="seriesCls">' + label + '</span>'
                                    }
                                }
                            };

                            var diskchart = new tinyWidget.Lineplot(options2);
                        }
                    });
                }

                function _getDatabaseData() {
                    var usedData = [], unusedData = [], xTicks = [];
                    communicationService.get(utilService.getResouceUrl("/system/action/queryDBStatus")).promise().always(function (result) {
                        if (exception.check(result)) {
                            _.each(result, function (d, index) {
                                var data1 = [], data2 = [], ticks = [];
                                data1.push(index);
                                data1.push(appUtils.encodeForHTML($.trim(d.used)));
                                data2.push(index);
                                data2.push(appUtils.encodeForHTML($.trim(d.unused)));
                                ticks.push(index);
                                ticks.push(appUtils.encodeForHTML($.trim(d.dbName)));
                                usedData.push(data1);
                                unusedData.push(data2);
                                xTicks.push(ticks);
                            });

                            var dataSet = [
                                {
                                    label: appUtils.getString("common_term_used_capacity_label") + " (MB)",
                                    data: usedData,
                                    color: constsService.COLOR_GREEN,
                                    bars: {fill: true, fillColor: constsService.COLOR_GREEN}
                                },
                                {
                                    label: appUtils.getString("common_term_unused_capacity_label") + " (MB)",
                                    data: unusedData,
                                    color: constsService.COLOR_GREY,
                                    bars: {fill: true, fillColor: constsService.COLOR_GREY}
                                },
                            ];


                            var options = {
                                "id": "database",
                                "width": $scope.WIDTH,
                                "height": $scope.HEIGHT,
                                "grid": {
                                    "show": true,
                                    "backgroundColor": "#fff"
                                },
                                "data": dataSet,
                                series: {
                                    stack: 0,
                                    bars: {
                                        show: true,
                                        barWidth: 0.1,
                                        align: "center",
                                        horizontal: false
                                    }
                                },
                                tips: {
                                    "tipType": "hover",
                                    "content": appUtils.getStringWithColon("common_term_name_label") + "%tx</br>" + "%s" + ":" + "%y.2"
                                },
                                "xaxis": {
                                    tickLength: xTicks.length,
                                    ticks: xTicks,
                                },
                                legend: {
                                    enableClick: false,
                                    noColumns: 0,
                                    margin: [145, 280],
                                    position: "ne",
                                    labelFormatter: function(label, series) {
                                        return '<span class="seriesCls">' + label + '</span>'
                                    }
                                }
                            };
                            var databsechart = new tinyWidget.Lineplot(options);
                        }
                    });
                }

                update();

                cpuTimeoutFn = setInterval(function () {
                    if ("settings.performance" == $.trim($state.current.name)) {
                        _setCpuData();
                    }
                }, 3000);
                memoTimeoutFn = setInterval(function () {
                    if ("settings.performance" == $.trim($state.current.name)) {
                        _setMemoData();
                    }
                }, 3000);

                _getDiskData(), _getDatabaseData();

                function _init() {
                    communicationService.get(utilService.getResouceUrl("/system/action/querySysmTreshold")).promise().always(function (result) {
                        if (exception.check(result)) {
                            $scope.cpuPercent = appUtils.encodeForHTML(result.cpuPercent);
                            $scope.memPercent = appUtils.encodeForHTML(result.memPercent);
                            $scope.diskPercent = appUtils.encodeForHTML(result.diskPercent);
                            $("#cpu").widget().option("value", result.cpuPercent);
                            $("#memo").widget().option("value", result.memPercent);
                            $("#diskPercent").widget().option("value", result.diskPercent);
                        }
                    });
                };

                _init();
            }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.performance.ctrl', ctrler);
        return module;
    })
