define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "message",
        "constsService",
        "appUtils",
        "infoTransferredService",
        "restService",
        function($scope, message, constsService, appUtils, infoTransferredService, restService) {
            var data = $("#" + constsService.PROXY_ADD_EDIT_WIN.winId).widget().option("data");
            $("#" + constsService.PROXY_ADD_EDIT_WIN.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function() {
                    var params = {
                        password: ""
                    };
                    if (!UnifyValid.FormValid($("#" + constsService.PROXY_ADD_EDIT_WIN.verifyId), { focusInvalid: true })) {
                        return;
                    };

                    if (!_.isUndefined($("#password").widget())) {
                        params.password = $("#password").widget().getValue();
                    } else {
                        params.password = ""
                    }

                    params.name = $("#proxyName").widget().getValue();
                    params.address = $("#address").widget().getValue();
                    params.port = $("#port").widget().option("value");
                    params.userName = $("#userName").widget().getValue();
                    params.anonymous = $("#anonymous").widget().option("checked");
                    var configs = {
                        data: params,
                        success: function() {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    !_.isUndefined(data.callback) && data.callback();
                                    $("#" + constsService.PROXY_ADD_EDIT_WIN.winId).widget().destroy();
                                }
                            })
                        }
                    };
                    data.isCreateProxy ? restService.createProxy([], configs) : restService.editProxy([data.proxyId], configs);
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + constsService.PROXY_ADD_EDIT_WIN.winId).widget().destroy();
                }
            }]);
            $scope.model = {
                labels: {
                    name: appUtils.getStringWithColon("common_term_name_label"),
                    address: appUtils.getStringWithColon("openStack_httpsMessage_label"),
                    port: appUtils.getStringWithColon("common_term_port_label"),
                    userName: appUtils.getStringWithColon("common_term_username_label"),
                    pwd: appUtils.getStringWithColon("common_term_password_label"),
                    anonymous: appUtils.getStringWithColon("proxy_table_anonymous_label"),
                },
                isCreateProxy: data.isCreateProxy,
                name: {
                    id: "proxyName",
                    width: constsService.W4,
                    value: data.name,
                    disabled: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [31],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 31)
                    }],
                },
                address: {
                    id: "address",
                    width: constsService.W4,
                    value: data.address,
                    disabled: false,
                    extendFunction: ["checkAddr"],
                    validate: "checkAddr : extend function;"
                },
                port: {
                    id: "port",
                    width: constsService.W4,
                    value: data.port || "80",
                    min: "1",
                    max: "65535",
                    change: function() {
                        var v = $("#" + this.id).widget().options.value;
                        if (!/^\d+$/.test(v)) {
                            $("#" + this.id).widget().option("value", "80");
                        }
                    },
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }]
                },
                userName: {
                    id: "userName",
                    width: constsService.W4,
                    value: data.isCreateProxy ? "" : data.anonymous ? "" : data.userName,
                    disabled: data.isCreateProxy ? false : data.anonymous,
                    require: !data.anonymous,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [512],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 512)
                    }],
                },
                pwd: {
                    id: "password",
                    key: "password",
                    type: "password",
                    display: false,
                    width: constsService.W4,
                    editWidth: 210,
                    value: "",
                    require: !data.anonymous,
                    disabled: data.isCreateProxy ? false : data.anonymous,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [512],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 512)
                    }],
                },
                passwordBtn: {
                    id: "passwordBtn",
                    key: "passwordBtn",
                    text: appUtils.getString("common_term_edit_button"),
                    text_: appUtils.getString("site_backuppool_canceleditpassword_label"),
                    click: function(event) {
                        $scope.model.pwd.display = !$scope.model.pwd.display;
                        $scope.model.pwd.value = "";
                        $scope.$apply();
                    }
                },
                anonymous: {
                    id: "anonymous",
                    width: constsService.W4,
                    text: appUtils.getString("common_term_enable_label"),
                    value: data.anonymous,
                    checked: data.anonymous,
                    change: function() {
                        var isAnonymous = $("#" + this.id).widget().option("checked");
                        isAnonymous && ($('#password').widget().option("value", ""));
                        isAnonymous && ($('#userName').widget().option("value", ""));
                        $scope.model.pwd.disabled = isAnonymous;
                        $scope.model.userName.disabled = isAnonymous;
                        $scope.model.pwd.require = !isAnonymous;
                        $scope.model.userName.require = !isAnonymous;
                        $scope.model.userName.validate = !isAnonymous ? constsService.VALID.NAME_REQUIRED : [];
                        $scope.model.pwd.validate = !isAnonymous ? $scope.pwdValidate : [];
                    }
                }
            };

            UnifyValid.checkAddr = function() {
                var val = this[0].value;
                var ipReg =
                    /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                var httpsReg =
                    /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (ipReg.test(val) || httpsReg.test(val)) {
                    return "";
                }
                if (!ipReg.test(val) && !httpsReg.test(val)) {
                    return appUtils.getString("validate_proxy_address_label");
                }
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkAddr;
            });
            $scope.pwdValidate = angular.copy($scope.model.pwd.validate);
        }
    ];

    var module = angular.module("recoverydirector.setting.config");
    module.tinyController("setting.addModifyProxyCtrl", ctrl);
    return module;
})