define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "infoTransferredService",
        function($scope, constsService, appUtils, restService, statusEnumService, message, infoTransferredService) {

            var _getOpNode = function() {
                var opNode = $("#datasTable").widget().getHoverData()[0];
                return opNode;
            };

            var _modifyAddProxy = function(datas) {
                var win = angular.copy(constsService.PROXY_ADD_EDIT_WIN);
                if (datas.isCreateProxy) {
                    win.title = appUtils.getString("proxy_win_create_label")
                } else {
                    win.title = appUtils.getString("proxy_win_edit_label")
                }
                datas.callback = _queryProxys;
                win.data = datas;
                appUtils.showWindow(win);
            };

            var _deleteProxy = function() {
                var name = _getOpNode().name;
                var proxyId = _getOpNode().proxyId;
                message.warn({
                    content: appUtils.getString("proxy_delete_warn_label", name),
                    ok: function() {
                        restService.deleteProxy([proxyId], function() {
                            message.success({
                                content: appUtils.getString(
                                    "common_term_operation_success_label"
                                ),
                                ok: function() {
                                    _queryProxys();
                                }
                            })
                        });
                    }
                });
            };

            var _queryProxys = function() {
                restService.queryProxys([], function(result) {
                    $scope.model.datasTable.data = appUtils.encodeForHTML(result.records);
                    $scope.model.datasTable.totalRecords = result.totalCount;
                    $scope.$apply();
                })
            };

            $scope.model = {
                btnCreate: {
                    id: "btnCreate",
                    right: "9403",
                    text: appUtils.getString("common_term_create_button"),
                    click: function() {
                        _modifyAddProxy({isCreateProxy: true});
                    }
                },
                btnRefresh: {
                    text: appUtils.getString("common_term_refresh_button"),
                    click: _queryProxys
                },
                datasTable: {
                    id: "datasTable",
                    data: [],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    totalRecords: 0,
                    paginationStyle: "full_numbers",
                    startPage: 0,
                    pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    paging: "auto",
                    operateButtonCount: 2,
                    buttonContainerPosition: "right",
                    columns: [{
                        "mData": "proxyId",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("openStack_httpsMessage_label"),
                        "mData": "address",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_port_label"),
                        "mData": "port",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_username_label"),
                        "mData": "userName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("proxy_table_anonymous_label"),
                        "mData": "anonymous",
                        "bSortable": false
                    }],
                    callback: function(evtObj) {},
                    sortCallback: function(th, sortObj) {},
                    renderRow: function(nRow, aData, iDataIndex) {
                        var anonymous = statusEnumService.getStatus("IS_ENABLE_ANONYMOUS", $.trim(
                            aData['anonymous']));
                        $("td[tdtitle='" + appUtils.getString("proxy_table_anonymous_label") + "']",
                            nRow).html(anonymous);
                    },
                    cellClickActive: function(e, param) {},
                    hoverActive: function(e, param) {},
                    opAreaConfig: appUtils.flilterOperRight([{
                        id: "iconBtnEdit",
                        authKey: "9403",
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString(
                            "common_term_edit_button") + "'></div>",
                        clickActive: function() {
                            _modifyAddProxy(_.extend(_getOpNode(), {isCreateProxy: false}));
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "9403",
                        template: "<div class='iconbutton-delete'  title='" + appUtils.getString(
                            "common_term_delete_button") + "'></div>",
                        clickActive: function() {
                            _deleteProxy();
                        }
                    }])
                }
            };

            _queryProxys();

        }
    ]
    var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.backupProxy.ctrl', ctrl);
    return module;
})