define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",

            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                $scope.configformTitle = $stateParams.id ? appUtils.getString("role_term_edit_title") : appUtils.getString("role_term_add_title");
                $scope.btnOk = {
                    id: "btnCreateOk",
                    text: appUtils.getString("common_term_confirm_button"),
                    click: function () {
                        var param = {};
                        var result = UnifyValid.FormValid($("#form"), {focusInvalid: true});
                        if (!result) {
                            return;
                        }

                        var des = $("#description").widget().getValue();
                        var znode = $("#roleTree").widget().getZTreeObj().getCheckedNodes(true);
                        var tmp = [];
                        for (var i = 0; i < znode.length; i++) {
                            tmp.push(znode[i].id);
                        }
                        if (tmp.length == 0) {
                            message.error(appUtils.getString("role_term_edit_message"));
                            return;
                        }
                        param.roleDes = des;
                        param.optIdsSet = tmp;
                        var url = "/roles/";
                        if ($stateParams.id) {
                            url = "/roles/" + $stateParams.id;
                            param.roleName = $.trim($("#nameContainer").text());
                            communicationService.put(utilService.getResouceUrl(url), param).promise().always(function (response) {
                                if (exception.check(response)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function () {
                                            $state.go("settings.roleList");
                                        }
                                    })
                                }
                            });
                            return;
                        }
                        var name = $("#name").widget().getValue();
                        param.roleName = name;
                        communicationService.post(utilService.getResouceUrl(url), param).promise().always(function (response) {
                            if (exception.check(response)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function () {
                                        $state.go("settings.roleList");
                                    }
                                })
                            }
                        });
                    }
                };

                $scope.btnCancel = {
                    id: "btnCreateCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        $state.go("settings.roleList");
                    }
                };

                var __checkNodeCallback = function(evtObj, id, node) {
                    if (node.checked) {
                        var depId = __privilege_deps__[$.trim(node.id)];
                        var depNode = $("#roleTree").widget().getZTreeObj().getNodeByParam("id", depId);
                        if (depNode) {
                            $("#roleTree").widget().getZTreeObj().checkNode(depNode, true, true, null);
                            __checkNodeCallback(null,null,depNode);
                        }
                    } else {
                        var nodeId = __privilege_view__[$.trim(node.id)];
                        if (typeof nodeId === "string") {
                            var node = $("#roleTree").widget().getZTreeObj().getNodeByParam("id", nodeId);
                            if (node) {
                                $("#roleTree").widget().getZTreeObj().checkNode(node, false, true, null);
                            }
                        } else {
                            _.each(nodeId, function(id) {
                                var node = $("#roleTree").widget().getZTreeObj().getNodeByParam("id", id);
                                if (node) {
                                    $("#roleTree").widget().getZTreeObj().checkNode(node, false, true, null);
                                }
                            });
                        }
                    }

                };

                $scope.model = {
                    labels: {
                        name: appUtils.getString("role_term_name_label") + ":",
                        description: appUtils.getString("common_term_description_column") + ":",
                        right: appUtils.getString("role_term_right_label") + ":"
                    },
                    tbName: {
                        id: "name",
                        width:constsService.DESCR_WIDTH,
                        value: "",
                        validate: constsService.VALID.ROLE_NAME_REQUIRED,
                        val: function(value) {
                            var target = $("#name");
                            if ($.trim(value)) {
                                target.widget().option('value', $.trim(value));
                                return target;
                            } else {
                                return target.widget().getValue();
                            }
                        }
                    },
                    tbDescription: {
                    	id : "description",
						value : "",
                        labelcls: "label-middle",
                        type : "multi",
						height:constsService.DESCR_HEIGHT,
		                width:constsService.DESCR_WIDTH,
						validate : constsService.VALID.DES_REMARK_HUNDRED,
                        val: function(value) {
                            var target = $("#description");
                            if ($.trim(value)) {
                                target.widget().option('value', $.trim(value));
                                return target;
                            } else {
                                return target.widget().getValue();
                            }
                        }
                    },
                    roleTree: {
                        "id": "roleTree",
                            "width": "400px",
                            "height": "300px",
                            "setting": {
                            view: {
                                selectedMulti: false
                            },
                            check: {
                                enable: true
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onCheck: __checkNodeCallback
                            }
                        },
                            "values": []
                    }
                };

                $scope.model.tbName.disable = $stateParams.id ? true : false;
                function _init() {
                    if ($stateParams.id) {
                        communicationService.get(utilService.getResouceUrl("/roles/" + $stateParams.id)).promise().always(function (response) {
                            if (exception.check(response)) {
                                $scope.model.tbName.val(response.roleName);
                                $scope.model.tbDescription.val(response.roleDes);
                            }
                        });
                    }
                };

                var __privilege_view__ = {
                    //resource
                    "9317":"9316",
                    //site,
                    "9323":"9322",
                    // protection group
                    "9006":"9004",
                    // recovery plan
                    "9105":"9100",
                    // TOPO
                    "9202":"9200",
                    // Current alarm
                    "76":"75",
                    // history alarm
                    "83":"82",
                    // remote notify
                    "117":"116",
                    // alarm voice
                    "124":"123",
                    // protection group executing report
                    "9205":"9204",
                    // revoery plan test report
                    "9208":"9207",
                    // resources
                    "9351":"9350",
                    // site management
                    "9302":"9301",
                    // resources mapping
                    "9401":"9400",
                    // system performance
                    "157":"156",
                    // operation log backup
                    "161":"160",
                    // alarm backup
                    "165":"164",
                    //person data
                    "9378":"9377",
                    // system operation log
                    "170":"169",
                    // trap ip manage
                    "271":["272", "273", "274"],
                    // trap settings
                    "316":"317",
                    // notify server
                    "200":"199",
                    // remote information
                    "218":"212",
                    // station information
                    "219":"216",
                    //systemNetwork
                    "9393":"9392",
                    "9390":"9389"
                };

                var __privilege_deps__ = {
                    // protection group
                    "9007":"9006",
                    "9008":"9006",
                    "9009":"9006",
                    "9010":"9006",
                    "9011":"9006",
                    "9012":"9006",
                    "9013":"9006",
                    "9014":"9006",
                    "9088":"9006",
                    // recovery plan
                    "9106":"9105",
                    "9109":"9105",
                    "9110":"9105",
                    "9121":"9105",
                    "9111":"9105",
                    "9112":"9105",
                    "9107":"9105",
                    "9108":"9105",
                    "9113":"9105",
                    "9123":"9105",
                    "9124":"9105",
                    // TOPO
                    "9211":"9202",
                    // Current alarm
                    "77":"76",
                    "78":"76",
                    "91":"76",
                    "80":"76",
                    // history alarm
                    "84":"83",
                    // remote notify
                    "118":"117",
                    "122":"117",
                    "119":"117",
                    "120":"117",
                    // alarm voice
                    "125":"124",
                    // protection group executing report
                    "9206":"9205",
                    // revoery plan test report
                    "9209":"9208",
                    // resources
                    "9353":"9351",
                    "9354":"9351",
                    "9356":"9351",
                    "9355":"9351",
                    // resource management
                    "9318":"9317",
                    "9319":"9317",
                    "9320":"9317",
                    "9321":"9317",
                    "9322":"9317",
                    //site management
                    "9324":"9323",
                    "9325":"9323",
                    "9326":"9323",
                    "9327":"9323",
                    "9328":"9323",
                    "9323":"9317",
                    // resources mapping
                    "9402":"9401",
                    "9403":"9401",
                    "9404":"9401",
                    "9405":"9401",
                    "9406":"9401",
                    "9407":"9401",
                    "9408":"9401",
                    "9409":"9401",
                    "9410":"9401",
                    // system performance
                    "158":"157",
                    // operation log backup
                    "162":"161",
                    "163":"161",
                    // alarm backup
                    "166":"165",
                    "167":"165",
                    // system operation log
                    "171":"170",
                    // trap ip manage
                    "272":"271",
                    "274":"271",
                    "273":"271",
                    // trap settings
                    "317":"316",
                    // notify server
                    "201":"200",
                    // remote information
                    "214":"218",
                    "213":"218",
                    "215":"218",
                    // station information
                    "217":"219",
                    //systemNetwork
                    "9394":"9393",
                    "9391":"9390"
                };

                var __initPrivileges = function() {
                    if ($stateParams.id) {
                        mask.show();
                        var userPrivileges = [];
                        communicationService.get(utilService.getResouceUrl("/roles/action/getPrivilegeTree?roleId=" + $stateParams.id))
                            .promise().always(function (response) {
                                if (!exception.check(response)) {
                                    mask.hide();
                                    return;
                                }
                                _.each(response, function(privilege) {
                                    userPrivileges.push(privilege.id);
                                });
                                communicationService.get(utilService.getResouceUrl("/roles/action/getPrivilegeTree")).promise().always(function (response) {
                                    if (!exception.check(response)) {
                                        mask.hide();
                                        return;
                                    }
                                    _.each(response, function(privilege) {
                                        privilege.name = $.encoder.encodeForHTML(appUtils.getString(privilege.name) || privilege.name);
                                        privilege.pId = privilege.pid;
                                        if (_.contains(userPrivileges, privilege.id)) {
                                            privilege.checked = true;
                                        }
                                    });
                                    $scope.model.roleTree.values = response;
                                    $scope.$apply();
                                    mask.hide();
                                });
                        });
                    } else {
                        mask.show();
                        communicationService.get(utilService.getResouceUrl("/roles/action/getPrivilegeTree")).promise().always(function (response) {
                            if (!exception.check(response)) {
                                mask.hide();
                                return;
                            }
                            _.each(response, function (d) {
                                d.name = $.encoder.encodeForHTML(appUtils.getString(d.name));
                                d.pId = d.pid;
                            })
                            $scope.model.roleTree.values = response;
                            $scope.$apply();
                            mask.hide();
                        });
                    }
                };

                _init();
                __initPrivileges();
            }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.roleAdd.ctrl', ctrler);
        return module;
    }
)
