define(["tiny-common/UnifyValid", "tiny-widgets/Window"], function(UnifyValid, Window) {
	"use strict";
	var ctrler = [
		"$scope",
		"$state",
		"$stateParams",
		"exception",
		"message",
		"communicationService",
		"utilService",
		"mask",
		"constsService",
		"appUtils",
        "constsService",
        "cookieService",
		function($scope, $state, $stateParams ,exception, message, communicationService, utilService, mask, constsService, appUtils, Consts, cookieService) {
            var curScope = $scope;

			$scope.enabledEdit = false;
			$scope.enabledDel = false;
			$scope.btnCreate = {
                id : "btnCreate",
                text : appUtils.getString("common_term_create_button"),
                click : function() {
                    $state.go("settings.roleAdd", {id:""});
                }
            };
            var __props__ = {
                roleUserWinOptions : {
                    winId: "win_role_users_id",
                    title: appUtils.getString("plat_role_show_users_title"),
                    width: Consts.WIN_SIZE.S5[0],
                    height: Consts.WIN_SIZE.S5[1],
                    minimizable: false,
                    maximizable: false,
                    "content-type": "url",
                    content: "app/business/recoverydirector/setting/views/role/roleUsers.html"
                },
                roleViewWinOptions: {
                    winId: "win_role_view_id",
                    title: appUtils.getString("plat_role_view_title"),
                    width: appUtils.isEn() ? "560px" : "520px",
                    height: "520px",
                    minimizable: false,
                    maximizable: false,
                    "content-type": "url",
                    content: "app/business/recoverydirector/setting/views/role/roleView.html"
                },
                pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                pageIndex: 1,
                orderBy: "iRoleID",
                orderType: "asc",
                queryUri: "/roles?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}"
            };
            var showRoleInfo = function(roleId) {
                var winOption = __props__.roleViewWinOptions;
                winOption.buttons = [{
                    label: appUtils.getString("common_term_close_button"),
                    handler: function() {
                        $("#" + __props__.roleViewWinOptions.winId).widget().destroy();
                    }
                }];

                winOption.data = {roleId: roleId};
                var win = new Window(winOption);
                win.show();
            }
            var showRoleUsers = function(roleId) {
                var winOption = __props__.roleUserWinOptions;
                winOption.buttons = [{
                    label: appUtils.getString("common_term_close_button"),
                    handler: function(){
                        $("#" + __props__.roleUserWinOptions.winId).widget().destroy();
                    }
                }];
                winOption.data = {roleId: roleId};

                var win = new Window(winOption);
                win.show();
            };
            $scope.datasTable = {
                id : "datasTable",
                paginationStyle:"full_numbers",
                columns : [{
                    "sTitle" : "roleId",
                    "mData" : "roleId",
                    "bVisible" : false
                }, {
                    "sTitle" : appUtils.getString("role_term_name_label"),
                    "mData" : "roleName"
                }, {
                    "sTitle" : appUtils.getString("role_term_related_label"),
                    "mData" : "userNum",
                    "bSortable": true
                },
                {
                    "sTitle" : appUtils.getString("user_term_des_label"),
                    "mData" : "roleDes"
                }],
                displayLength: __props__.pageSize,
                totalRecords:0,
                callback :function(evtObj) {
                    __props__.pageIndex = evtObj.currentPage;
                    mask.show();
                    __initDataTable(function() {
                        mask.hide();
                    });
                },
                sortCallback: function(thead, sortObj) {
                    mask.show();
                    __props__.orderBy = $scope.datasTable.columns[sortObj[0][0]].mData;
                    __props__.orderType = sortObj[0][1];
                    __initDataTable(function() {
                        mask.hide();
                    });
                },
                renderRow : function(nRow, aData, iDataIndex) {
                    $('td:eq(0)', nRow).html("<a href='javascript:void(0)' id='"+$.trim(aData['roleName'])+"Role' style='text-decoration:none;' class='text-link'>" +$.trim(aData['roleName'])+ "</a>");
                    $('td:eq(0)', nRow).find('>a').click(function() {
                        showRoleInfo(aData['roleId']);
                    });
                    //OC admin用户
                    if(aData.roleId == "-1") {
                      $('td:eq(1)', nRow).html("--");
                    }else {
                      $('td:eq(1)', nRow).html("<a href='javascript:void(0)' id='"+$.trim(aData['roleName'])+"Num' style='text-decoration:none;' class='text-link'>" +$.trim(aData['userNum'])+ "</a>");
                      $('td:eq(1)', nRow).find('>a').click(function() {
                          showRoleUsers(aData['roleId']);
                      });
                    }
                },
                operateButtonCount: 2,
                buttonContainerPosition: "right",
                data : [],
                opAreaConfig: [{
                            id : "iconBtnEdit",
                            authKey: "lego.sys.role.edit",
                            template : "<div class='iconbutton-edit' title='"+appUtils.getString("common_term_edit_button")+"'></div>",
                            clickActive : function() {
                                if($scope.enabledEdit){
                                    $scope.editAction();
                                }
                            }
                        }, {
                            id : "iconBtnDel",
                            authKey: "lego.sys.role.delete",
                            template : "<div class='iconbutton-delete' title='"+appUtils.getString("common_term_delete_button")+"'></div>",
                            clickActive : function() {
                                if($scope.enabledDel){
                                    $scope.deleteAction();
                                }
                            }
                        }],
                cellClickActive : function(e, param) {
                    $scope.current = param;
                 },
                 hoverActive : function(e, param) {
                     if(param.roleId == "1" ||  param.roleId == "2" || param.roleId == "3" || param.roleId == "4" || param.roleId == "-1"){
                         $scope.enabledEdit = false;
                         $scope.enabledDel = false;
                         $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                         $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                     }else{
                         $scope.enabledEdit = true;
                         $scope.enabledDel = true;
                         $("#iconBtnEdit div").addClass("iconbutton-edit").removeClass("iconbutton-edit-disabled");
                         $("#iconBtnDel div").addClass("iconbutton-delete").removeClass("iconbutton-delete-disabled");
                     }
                 }
            };

          $scope.editAction = function(){
              $state.go("settings.roleAdd",{id:_getOptId()});

          };
          $scope.deleteAction = function(){
              var roleIds = [_getOptId()];
              message.warn({content: appUtils.getString("role_term_delete_message",_getOptName()), ok: function(){
                  mask.show();
                 communicationService.remove(utilService.getResouceUrl("/roles"),roleIds).promise().always(function(response){
                     if(!exception.check(response)) {
                         mask.hide();
                         return;
                     }
                     __props__.pageIndex = 1;
                     $scope.datasTable.curPage = {pageIndex: 1};
                     __initDataTable(function() {
                         mask.hide();
                         message.success(appUtils.getString("common_term_operation_success_label"));
                     });
                 });
                }
              });
          };

          $scope.refreshDataTable  = function(){
              mask.show();
              __props__.pageIndex = 1;
              $scope.datasTable.curPage = {pageIndex: 1};
              __initDataTable(function() {
                  mask.hide();
              })
          };

          var _getOptId = function(){
             return  $("#datasTable").widget().getHoverData()[0].roleId;
          };
          var _getOptName = function(){
             return  $("#datasTable").widget().getHoverData()[0].roleName;
          };

          var __initDataTable = function(callback) {
              var url = appUtils.stringFormat(__props__.queryUri, __props__.pageSize, __props__.pageIndex - 1, __props__.orderBy, __props__.orderType);
              communicationService.get(utilService.getResouceUrl(url)).promise().always(function(response) {
                  if (!exception.check(response)) {
                      mask.hide();
                      return;
                  }

                    var arr = [];
                    _.each(response.roleList, function(d) {
                        var tmo =_.pick(d, "roleId", "roleName", "userNum","roleDes");
                        arr.push(tmo);
                    });
                    if(response["total"] > __props__.pageSize){
                        $scope.datasTable.paging = true;
                    }else{
                        $scope.datasTable.paging = false;
                        __props__.pageIndex = 1;
                        $scope.datasTable.curPage = {pageIndex: 1};
                    }
                    $scope.datasTable.data = appUtils.encodeForHTML(arr);
                    $scope.datasTable.totalRecords = response["total"];
                    if (typeof callback === "function") {
                        (callback)();
                    }
                    $scope.$apply();
              });
          };

          $scope.refreshDataTable();
    }];

	var module = angular.module('recoverydirector.setting.config');
  module.tinyController('settings.roleList.ctrl', ctrler);
  return module;
})
