define([], function() {
        "use strict";
        var ctrl = ["$scope", "$timeout", "constsService", "appUtils", "communicationService", "utilService", "exception",
			function($scope,$timeout, Consts ,appUtils, communicationService, utilService, exception) {
                $scope.table = {
                    id : "roleUsersTable",
                    displayLength : Consts.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    checkbox : false,
                    columns : [{
                        "sTitle" : appUtils.getString("user_term_username_label"),
                        "mData" : "name",
                        "bSortable" : false
                    },{
                        "sTitle" : appUtils.getString("user_term_des_label"),
                        "mData" : "desc",
                        "bSortable" : false
                    }],
                    renderRow : function(nRow, aData, iDataIndex){
                    }
                };

                (function init(){
                    var role = $('#win_role_users_id').widget().option('data');
                    communicationService.get(utilService.getResouceUrl("/roles/" + role.roleId)).promise().always(function(result) {
                        if (!exception.check(result)) {
                            return;
                        }

                        var users = [];
                        _.each(result.userSet, function(user) {
                            users.push({
                                name: $.encoder.encodeForHTML(user.userName),
                                desc: $.encoder.encodeForHTML($.trim(user.description))
                            });
                        });

                        $scope.table.data = users;
                        $scope.$apply();
                    });
                }());

			}];

	var module = angular.module("recoverydirector.setting.config");
	module.tinyController("roleUsersCtrl", ctrl);
	return module;
});
