define([], function() {
        "use strict";
        var ctrl = ["$scope", "constsService", "appUtils", "communicationService", "utilService", "exception",
			function($scope, Consts, appUtils, communicationService, utilService, exception) {
                var ViewModel = {
                    name: {
                        id: "win_role_id",
                        label: appUtils.getStringWithColon("role_term_name_label"),
                        width: Consts.DESCR_WIDTH,
                        disable: true,
                        value: ""
                    },
                    des: {
                        id: "win_role_des",
                        type: "multi",
                        label: appUtils.getStringWithColon("common_term_description_column"),
                        disable: false,
                        readonly: true,
                        height: Consts.DESCR_HEIGHT,
                        width: Consts.DESCR_WIDTH,
                        value: ""
                    }
                };

                $scope.model = {
                    rights: {
                        "id": "winRightsTree",
                        label: appUtils.getStringWithColon("role_term_right_label"),
                        "width": "400px",
                        "height": "300px",
                        "setting": {
                            view: {
                                selectedMulti: false
                            },
                            check: {
                                enable: false
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onClick: function (event, id, node) {
                                }
                            }
                        },
                        "values": []
                    },
                    name: ViewModel.name,
                    des: ViewModel.des
                };
                $scope.table = {
                    id : "roleUsersTable",
                    displayLength : Consts.TABLE_COUNT_PER_PAGE,
                    checkbox : false,
                    columns : [{
                        "sTitle" : appUtils.getString("user_term_username_label"),
                        "mData" : "name",
                        "bSortable" : false
                    },{
                        "sTitle" : appUtils.getString("user_term_des_label"),
                        "mData" : "desc",
                        "bSortable" : false
                    }],
                    renderRow : function(nRow, aData, iDataIndex){
                    }
                };

                (function init(){
                    var role = $('#win_role_view_id').widget().option('data');
                    communicationService.get(utilService.getResouceUrl("/roles/" + role.roleId)).promise().always(function(result) {
                        if (!exception.check(result)) {
                            return;
                        }

                        $scope.model.name.value = $.trim(result.roleName);
                        $scope.model.des.value = $.trim(result.roleDes);
                        $scope.$apply();
                    });

                    communicationService.get(utilService.getResouceUrl("/roles/action/getPrivilegeTree?roleId=" + role.roleId))
                    .promise().always(function(result){
                        if (!exception.check(result)) {
                            return;
                        }

                        var count = 0;
                        _.each(result, function(ele, index) {
                            ele.pId = ele.pid;
                            ele.name = appUtils.getString(ele.name);
                            count++;
                        });

                        $scope.model.rights.values = result;
                        $scope.$apply();
                    });
                }());

			}];

	var module = angular.module("recoverydirector.setting.config");
	module.tinyController("roleViewCtrl", ctrl);
	return module;
});

