define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService",
        "appUtils",
        function($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {

            $scope.DAY = appUtils.getString("securtiy_term_day_field_label");
            $scope.MINUTES = appUtils.getString("securtiy_term_minute_field_label");
            $scope.TIMES = appUtils.getString("securtiy_term_times_field_label");
            $scope.SPECIAL_CHAR = appUtils.getString("securtiy_term_specialchar_field_label");
            $scope.PASS_POLICY = appUtils.getString("securtiy_term_passwordpolicy_field_label");
            $scope.SESSION_TIMEOUT = appUtils.getString("securtiy_term_sessiontimeout_field_label");
            $scope.LOGIN_POLICY = appUtils.getString("securtiy_term_loginpolicy_field_label");
            $scope.TIMEOUT_TIP = appUtils.getString("securtiy_term_timeout_tips");
            $scope.configformTitle = $stateParams.id ? appUtils.getString("securtiy_term_passwordpolicy_field_label") : appUtils.getString("securtiy_term_passwordpolicy_field_label");

            $scope.btnOk = {
                id: "btnCreateOk",
                text: appUtils.getString("common_term_confirm_button"),
                click: function() {
                    var result = UnifyValid.FormValid($("#restForm"), { focusInvalid: true });
                    if (!result) {
                        return;
                    }
                    var param = {};
                    param.passLenVal = parseInt($("#minwidth").widget().getSelectedId(), 10);
                    param.passComplexVal = parseInt($("#complex").widget().getSelectedId(), 10);
                    param.passCtrl = $("#passwordtime").widget().option("selected") == "on" ? true : false;
                    param.usefulLife = $("#time").widget().getValue();
                    param.minlifetime = $("#passwordRetainTime").widget().getValue();
                    param.sessionTime = $("#timeout").widget().getValue();
                    param.passErrNum = $("#errortimes").widget().getValue();
                    param.passLockTime = $("#locktime").widget().getValue();
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/securitypolicy"), param).promise().always(function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            message.success(appUtils.getString("common_term_operation_success_label"));
                        }
                    });
                }
            };

            $scope.btnCancel = {
                id: "btnCreateCancel",
                text: appUtils.getString("common_term_cancel_button"),
                click: function() {
                    mask.show();
                    _init();
                }
            };

            $scope.p_modify = appUtils.checkRight("lego.sys.sysLoginPolicy.modify");
            $scope.model = {
                labels: {
                    complex: appUtils.getString("securtiy_term_complex_field_label") + ":",
                    minwidth: appUtils.getString("securtiy_term_minlength_field_label") + ":",
                    right: appUtils.getString("role_term_right_label") + ":",
                    passwordtime: appUtils.getString("securtiy_term_passwordtime_field_label") + ":",
                    time: appUtils.getString("securtiy_term_time_field_label") + ":",
                    sessiontimeout: appUtils.getString("securtiy_term_sessiontimeout_field_label") + ":",
                    timeout: appUtils.getString("securtiy_term_timeout_field_label") + ":",
                    loginpolicy: appUtils.getString("securtiy_term_loginpolicy_field_label") + ":",
                    errortimes: appUtils.getString("securtiy_term_errortimes_field_label") + ":",
                    passwordRetainTime: appUtils.getString("securtiy_term_passwordRetainTime_field_label") + ":",
                    locktime: appUtils.getString("securtiy_term_locktime_field_label") + ":"
                },
                complex: {
                    id: "complex",
                    width: constsService.W4,
                    values: [{ selectId: "2", label: appUtils.getString("securtiy_term_complex_2_field_label") }, { selectId: "4", label: appUtils.getString("securtiy_term_complex_4_field_label") }],
                    defaultSelectid: "2",
                    validate: "",
                    disable: !$scope.p_modify
                },
                minwidth: {
                    id: "minwidth",
                    width: constsService.W4,
                    values: [{ selectId: "8", label: appUtils.getString("securtiy_term_minlength_8char_field_label") }, { selectId: "10", label: appUtils.getString("securtiy_term_minlength_10char_field_label") }],
                    defaultSelectid: "8",
                    validate: "",
                    disable: !$scope.p_modify
                },
                passwordtime: {
                    id: "passwordtime",
                    items: [{ label: appUtils.getString("common_term_enable_label"), value: "on" },
                        { label: appUtils.getString("common_term_disable_label"), value: "off" }
                    ],
                    standard: true,
                    disable: !$scope.p_modify,
                    change: function() {
                        var selected = $("#passwordtime").widget().option("selected");
                        if (selected == "on") {
                            $scope.model.passwordRetainTime.disabled = true;
                            $scope.model.time.disabled = true;
                            $scope.model.passwordRetainTime.require = false;
                            $scope.model.time.require = false;
                        }
                        if (selected == "off") {
                            $scope.model.passwordRetainTime.disabled = false;
                            $scope.model.time.disabled = false;
                            $scope.model.passwordRetainTime.require = true;
                            $scope.model.time.require = true;
                        }
                    }
                },
                time: {
                    id: "time",
                    width: constsService.W4,
                    disable: !$scope.p_modify,
                    validate: "required;integer;maxValue(360);minValue(60)"
                },
                passwordRetainTime: {
                    id: "passwordRetainTime",
                    width: constsService.W4,
                    disable: !$scope.p_modify,
                    validate: "required;integer;maxValue(9999);minValue(1)",
                    tip: appUtils.getString("settings_security_passwordRetainTime_tip")
                },
                timeout: {
                    id: "timeout",
                    width: constsService.W4,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 100],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 100)
                    }, {
                        validFn: "integer"
                    }],
                    disable: !$scope.p_modify,
                    tip: appUtils.getString("settings_security_timeout_tip")
                },
                errortimes: {
                    id: "errortimes",
                    width: constsService.W4,
                    disable: !$scope.p_modify,
                    require: true,
                    validate: "required;integer;maxValue(9);minValue(1)",
                    tip: appUtils.getString("settings_security_errortimes_tip")
                },
                locktime: {
                    id: "locktime",
                    width: constsService.W4,
                    disable: !$scope.p_modify,
                    require: true,
                    validate: "required;integer;maxValue(2000);minValue(3)",
                    tip: appUtils.getString("settings_security_locktime_tip")
                },
                credentialsContainerClass: "configform-subcontainer"
            };

            var _init = function() {
                var url = "/securitypolicy";
                mask.show();
                communicationService.get(utilService.getResouceUrl(url)).promise().always(_updateUI);
            };
            var _updateUI = function(result) {
                mask.hide();
                if (!exception.check(result)) {
                    return;
                }
                $("#minwidth").widget().opChecked(parseInt(result.passLenVal, 10));
                $("#complex").widget().opChecked(parseInt(result.passComplexVal, 10));
                $scope.model.passwordtime.selected = result.passCtrl ? "on" : "off";
                $("#time").widget().option("value", result.usefulLife);
                $("#timeout").widget().option("value", result.sessionTime);
                $("#errortimes").widget().option("value", result.passErrNum);
                $("#locktime").widget().option("value", result.passLockTime);
                $("#passwordRetainTime").widget().option("value", result.minlifetime == null ? "3" : result.minlifetime);

                if (!result.passCtrl) {
                    $scope.model.passwordRetainTime.disabled = true;
                    $scope.model.time.disabled = true;
                    $scope.model.passwordRetainTime.require = false;
                    $scope.model.time.require = false;
                } else {
                    $scope.model.passwordRetainTime.disabled = false;
                    $scope.model.time.disabled = false;
                    $scope.model.passwordRetainTime.require = true;
                    $scope.model.time.require = true;
                }
                $scope.$apply();
            };

            mask.show();
            _init();

            var z = setTimeout(function() {
                var w = $(".tiny_form_td_label").eq(4).width();
                $(".tiny_form_td_label").each(function() {
                    $(this).width(w);
                })
                clearTimeout(z);
            }, 0)
        }
    ]

    var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.securityPolicy.ctrl', ctrler);
    return module;
})