define(["app/framework/base/services/systemResService"], function(SystemResService) {
    "use strict";
    var ctrler = ["$scope", "$state", "communicationService", "utilService", "exception", "appUtils",
        function($scope, $state, communicationService, utilService, exception, appUtils) {
            $scope.id = "settings_layout_id";
            var lay = new tinyWidget.Layout({
                "id": "settings_layout_id",
                "subheight": 108,
                "isAutoActive": false
            });

            $scope.isShowLic = function() {
                if (!$scope.isRD) {
                    return false;
                }
                var user = appUtils.getCurrentUser();
                return angular.isDefined(user) && (user.isAdministrator || user.isAdmin);
            };
            $scope.isUltraVR = window.isUltraVR;
            $scope.isPrivateConsole = window.isPrivateConsole;

            $scope.containStorage = false;
            $scope.containHost = false;
            $scope.containVcenter = false;
            $scope.containCloud = false;
            $scope.containVRG = false;
            $scope.isRD = false;
			$scope.isLicenseShow = "true" != "false";
            $scope.fufillTypeLayout = function() {
                var systemResService = new SystemResService(communicationService, utilService);
                systemResService.getSupportResource().always(function(result) {
                    if (exception.check(result)) {
                        _.each(result, function(d) {
                            if (d.type == "ism.deviceType.storage.mainType") {
                                $scope.containStorage = true;
                            }
                            if (d.type == "ism.drm.deviceType.drhost.mainType") {
                                $scope.containHost = true;
                            }
                            if (d.type == "ism.drm.deviceType.drvsphere.mainType") {
                                $scope.containVcenter = true;
                            }
                            if (d.type == "ism.drm.deviceType.cloud.mainType") {
                                $scope.containCloud = true;
                            }
                            if (d.type == "ism.drm.deviceType.vrg.mainType") {
                                $scope.containVRG = true;
                            }
                        });

                     communicationService.get(utilService.getResouceUrl("/softwareInfo")).always(function(result) {
                         if (exception.check(result)) {
                            $scope.isRD = (result.productModel == "OceanStor BCManager");
                            $("li[authKey]").each(function(i) {
                                var authKey = $(this).attr("authKey");
                                if (authKey.indexOf(",") > -1) {
                                    var arr = authKey.split(",");
                                    for (var k = 0; k < arr.length; k++) {
                                        if (!appUtils.checkRight(arr[k])) {
                                            $("li[authKey]").eq(i).hide();
                                            break;
                                        }
                                    }
                                } else if (authKey != (authKey = authKey.replace("()", ""))) {
                                    !$scope[authKey]() && $("li[authKey]").eq(i).hide();
                                } else {
                                    if (!appUtils.checkRight(authKey)) {
                                        $("li[authKey]").eq(i).hide();
                                    }
                                }
                            });
                           $scope.$apply();
                        }
                     })
                   }
                });

                $(".tiny-layout-sideli").each(function() {
                    if ($(this).find(".tiny-layout-sideli2[style]").length == $(this).find(".tiny-layout-sideli2").length) {
                        $(this).hide();
                    }
                })
            };

            $scope.fufillTypeLayout();

            $scope.$on("$stateChangeSuccess", function() {
                if ($state.includes('settings.discoveryList')) {
                    lay.opActive($("a[ui-sref='settings.discoveryList']").last());
                } else {

                    var cur = $("a[ui-sref='" + $state.$current.name + "']").last();
                    var ref_url = $("a[ref-url='" + $state.$current.name + "']").last();
                    if (cur.length > 0) {
                        lay.opActive(cur);
                    }
                    if (ref_url > 0) {
                        lay.opActive(ref_url);
                    } else {
                        var isActive = false;
                        $("a[ref-url^='settings']").each(function(i) {
                            var ref_url = $("a[ref-url^='settings']").eq(i).attr("ref-url");
                            if (ref_url && ref_url.indexOf($state.$current.name) > -1) {
                                //为了和其他tab保持一致，不记录状态，默认到第一个 TODO
                                isActive = true;
                                lay.opActive($("a[ref-url^='settings']").eq(i));
                            }
                        });

                        if (isActive || angular.isUndefined($state.params.type)) {
                            return;
                        }

                        //资源映射添加时的路由控制
                        var addMappingUrl = "settings.resourceMappingView.addWizard";
                        var type = $state.params.type;

                        if (-1 === $state.$current.name.indexOf(addMappingUrl)) {
                            return;
                        }

                        var id = "rm" + type.toLocaleLowerCase();
                        id = id.replace("quickstart", "");
                        lay.opActive($("a[id='" + id + "']"));
                    }

                }

            });

            $scope.setChildChecked = function(e) {

            };

            $scope.VCENTER = appUtils.getString("vcenter_title");
            $scope.SETTINGS = appUtils.getString("settings_title");
            $scope.RES = appUtils.getString("resource_title");
            $scope.STORAGE = appUtils.getString("storage_title");
            $scope.HOST = appUtils.getString("host_title");
            $scope.CLOUD = appUtils.getString("cloud_title");
            $scope.R_VRG = appUtils.getString("vrg_title");
            $scope.SITE = appUtils.getString("site_manage_title");
            $scope.ALL_SITE = appUtils.getString("site_title");
            $scope.ONLINE_USER = appUtils.getString("online_user_title");
            $scope.USER = appUtils.getString("user_title");
            $scope.ROLE = appUtils.getString("role_title");
            $scope.SECURITY = appUtils.getString("policy_title");
            $scope.SYSTEM_MONITOR = appUtils.getString("system_monitor_title");
            $scope.PERF = appUtils.getString("performance_title");
            $scope.MANTANCE = appUtils.getString("system_data_maintance_title");
            $scope.OPERATOR_BAK = appUtils.getString("operlog_maintance_title");
            $scope.ALARM_BAK = appUtils.getString("alarmlog_maintance_title");
            $scope.SYSTEM_CONFIG = appUtils.getString("sysData_title");
            $scope.EXPORT = appUtils.getString("dataexport_title");
            $scope.LOG_MGR = appUtils.getString("systemlog_title");
            $scope.SYSTEM_LOG = appUtils.getString("sysoperlog_title");
            $scope.DEBUG_LOG = appUtils.getString("settings_logmgr_debug_log_menu_text");
            $scope.SERVER_INFO = appUtils.getString("server_title");
            $scope.SERVER = appUtils.getString("server_notifyserver_title");
            $scope.REMOTE_MANTANCE = appUtils.getString("cloudservice_title");
            $scope.REMOTE_MANTANCE_INFO = appUtils.getString("cloudservice_maintain_title");
            $scope.STATION = appUtils.getString("cloudservice_station_title");
            $scope.SYSTEM_MANAGER = appUtils.getString("system_user_title");

            $scope.RM = appUtils.getString("resource_mapping_title");
            $scope.CLUSTER = appUtils.getString("resource_mapping_cluster_title");
            $scope.MHOST = appUtils.getString("resource_mapping_host_title");
            $scope.NETWORK = appUtils.getString("resource_mapping_network_title");
            $scope.PROT_GROUP = appUtils.getString("resource_mapping_prot_group_title");
            $scope.SECURITY_GROUP = appUtils.getString("resource_mapping_security_group_title");
            $scope.DATA_STORE = appUtils.getString("resource_mapping_data_store_title");
            $scope.VRG = appUtils.getString("resource_mapping_vrg_title");
            $scope.QUICK_START = appUtils.getString("resource_mapping_quick_start_title");

            $scope.CM = appUtils.getString("classificationManage_title");
            $scope.CM_SETTING = appUtils.getString("classificationManage_setting_title");
            $scope.LICENSE = appUtils.getString("license_manage_title");
            $scope.CLOUD_SERVICES_MANAGE = appUtils.getString("thirdservcie_title");
            $scope.OC_MANAGE = appUtils.getString("thirdservcie_oc_title");
            $scope.SYS_MANAGE = appUtils.getString("thirdservcie_sysnetwork_title");
            $scope.SYSLOG_MANAGE = appUtils.getString("syslognotify_title");
            $scope.BACK_UP_PROXY_MENU = appUtils.getString("proxy_leftmenu_label");
            $scope.BACK_UP_PROXY_NAVIGATE = appUtils.getString("proxy_menu_navigate_label");
            $scope.AREA_MANAGE_LABEL = appUtils.getString("site_create_areamanager_label");
            $scope.PERSONAL_DATA = appUtils.getString("ism.drm.personal.data.menuname");

        }
    ];

    var module = angular.module('recoverydirector.setting.config');
    module.tinyController('settings.ctrl', ctrler);
    return module;
});
