define([], function() {
	"use strict";
	var ctrler = [
		"$scope",
		"$state",
		"$stateParams",
		"$compile",
		"exception",
		"message",
		"communicationService",
		"utilService",
		"mask",
		"constsService",
		"appUtils",
		"statusEnumService",
		"infoTransferredService",
		function($scope, $state, $stateParams , $compile, exception, message,communicationService, utilService, mask,constsService ,appUtils,statusEnumService,infoTransferredService) {

			$scope.LEVEL = appUtils.getString("syslog_term_level_label")+": ";
			$scope.RESULT = appUtils.getString("syslog_term_result_label")+": ";
			$scope.ADVANCED_LABEL = appUtils.getString("common_term_adgsearch_button");
			$scope.SEARCH = appUtils.getString("common_term_search_button");
			$scope.REFRESH = appUtils.getString("common_term_refresh_button");
			$scope.isAdvatageQuery =  false;
			$scope.startPage = 0 ;
			var loadLoginFailed,
				loadLoginFilter;
			if(!_.isUndefined(infoTransferredService.get("sysLog", "loadLoginFailed"))) {
				loadLoginFailed = infoTransferredService.get("sysLog", "loadLoginFailed");
			};
			infoTransferredService.remove("sysLog", "loadLoginFailed");
			var highQuery = false;
		    $scope.btnCreate = {
				id : "btnExport",
				authKey: appUtils.checkRight("lego.sys.sysLog.operLog.exportExl"),
				text : appUtils.getString("common_term_export_button"),
				click : function() {
			    	var url = "/operationlogs/action/exportLog";
			    	var datasTable = $("#datasTable").widget().getTableCheckedItems();
	                if (!utilService.isNotEmpty(datasTable)) {
	                  		  message.error(appUtils.getString("common_term_select_data_least_label"));
	                  		  return false;
	               	}else{
	                var params = [];
	               	angular.forEach(datasTable, function(obj, i) {
	                		params.push(obj.id);
	               	});
	               	 var ids = params.join(",");
	                }

	                url = url + '?ids=' + ids;
	                var adminObj;
	                adminObj = getAdminValue(adminObj);
			    	url = gerExportParam(url);
			    	appUtils.export(url +'&sortField=alarmName&sortType=desc',adminObj,"get");
				}
			};
			$scope.btnDel = {
					id : "btnExportAll",
					text : appUtils.getString("common_term_exportall_button"),
					click : function() {
				    var url = "/operationlogs/action/exportLog";
				    url = url + '?ids=';
				    var adminObj;
                    adminObj = getAdminValue(adminObj);
		    	    url = gerExportParam(url);
		    	    appUtils.export(url +'&sortField=alarmName&sortType=desc',adminObj,"get");
				}
			};

			$scope.btnQuery= {
					id : "btnQuery",
					text : appUtils.getString("common_term_search_button"),
					click : function() {

				}

			};
			var ngdom = $("<div></div>");

	        $scope.advanceSearchPop =
	        {
	           "id" : "advanceSearchPopId",
	           "elementId" : "advanceSearchPopEleId",
	           "template" : ngdom,
	           "popStyle": {
				   "width": window.isEn ? '440px': '400px',
	                "height":'260px'
	            }
	        };

	        // 弹出高级搜索框
	        $scope.showAdvanceSearch = function(callback){
	            ngdom.load("app/business/recoverydirector/setting/views/syslog/advanceSearch.html", function()
	            {
	                $compile($("#advanceSearchDiv"))($scope);
	                $scope.$apply();
	                $("#advanceSearchPopId").widget().setPopShow(true);
	                callback();
	            });
	        };


	        $scope.FROM = appUtils.getString("common_term_from_label");
			$scope.TO = appUtils.getString("common_term_to_label");
			$scope.advance = {
				labels: {
					level : appUtils.getString("current_alarm_term_level_column") + ":",
					source : appUtils.getString("syslog_term_operator_label")+ ":",
					type : appUtils.getString("common_term_result_label")+ ":",
					occurredtime : appUtils.getString("current_alarm_term_occurred_time_label")+ ":"
				},
				sysLogLevel: {
					level: appUtils.getStringWithColon("current_alarm_term_level_column"),
                    id : "sysLogLevel",
                    layout: "horizon",
                    contentcls: "#generalDiv sendContentCls",
					values: [
						{ "key": "4", "text": appUtils.getString("syslog_term_level_4"), "checked": false, "disable": false },
                        { "key" : "3", "text" : appUtils.getString("syslog_term_level_3"), "checked" : false, "disable" : false},
                        { "key" : "2", "text" : appUtils.getString("syslog_term_level_2"), "checked" : false, "disable" : false},
                        { "key" : "1", "text" : appUtils.getString("syslog_term_level_1"), "checked" : false, "disable" : false}],
                    spacing : {"width" : "5px", "height": "25px"}
                },
				type : {
					id : "type",
					values : [{selectId : "-1", label : appUtils.getString("common_term_all_label")}, {selectId : "0", label : appUtils.getString("syslog_term_result_0")},{selectId : "1", label : appUtils.getString("syslog_term_result_1")}],
					defaultSelectid:"-1",
					width : "228",
					change : function(){

					}
				},
				source : {
					id : "source",
					value : "",
					validate : "",
					width : "228"
				},
				startDate : {
					id : "startDate",
					type : "datetime",
					dateFormat : 'yy-mm-dd',
		            timeFormat : "h:mm:ss",
		            "ampm" : true
				},
				endDate : {
					id : "endDate",
					type : "datetime",
					dateFormat : 'yy-mm-dd',
		            timeFormat : "h:mm:ss",
		            disable : false,
		            "ampm" : true
				},
				btnOK : {
					id : "btnOK",
					text : appUtils.getString("common_term_confirm_button"),
					click : function() {
					   $scope.isAdvatageQuery = true;
					   highQuery = true;
					   var levelIds = $("#sysLogLevel").widget().opChecked("checked");
					   infoTransferredService.put("logModule","keyArray",levelIds,false);
					   $scope.startPage = 0 ;
					   var url =_getQueryCondition();
					   mask.show();
			           var promise = communicationService.get(utilService.getResouceUrl(url)).promise();
			           promise.always(_updateUI);
			           $scope.maskHandler = promise;
			           $scope.datasTable.curPage = {"pageIndex":0};
					}
				}
			};

            $scope.model = {
            	"id":"opt",
            	"isSearchbox":false,
            	"values":[{selectId:"-1",label:appUtils.getString("syslog_term_level_label")},
            			{selectId:"0",label:appUtils.getString("syslog_term_result_label")}],
            	"defaultSelectid":"-1",
            	"display":true,
            	"disable":false,
            	"showTip":true,
            	"width":constsService.W2,
            	"textwidth":constsService.W2,
            	"levelOptions":{
            		"id":"choiceLevel",
					"values": [
						{
            				selectId:"-1",label:appUtils.getString("common_term_all_label")
            			},{
            				selectId:"4",label:appUtils.getString("syslog_term_level_4")
            			},{
            				selectId:"3",label:appUtils.getString("syslog_term_level_3")
            			},{
            				selectId:"2",label:appUtils.getString("syslog_term_level_2")
						}, {
							selectId: "1", label: appUtils.getString("syslog_term_level_1")
						}
					],
            		"display":true,
            		"default-selectid":"-1",
            	},
            	"resultOptions":{
            		"id":"choiceResult",
            		"values":[{
            			selectId:"-1",label:appUtils.getString("common_term_all_label")
            			},{
            			selectId:"0",label:appUtils.getString("syslog_term_result_0")
            			},{
            			selectId:"1",label:appUtils.getString("syslog_term_result_1")
            		}],
            		"display":true,
            		"default-selectid":"-1",
            	},
            	"change":function(){
            		var widget = $("#opt").widget();
            		var searchid = widget.getSelectedId();
            		if (searchid == "0") {
            			widget.changeTextBox(false,this.resultOptions);
            		} else{
            			widget.changeTextBox(false,this.levelOptions);
            		};
            	},
            	"click": function(){
            		$scope.isAdvatageQuery = false;
            		!_.isEmpty($("#source").widget()) && $("#source").widget().option("value","");
            		highQuery = false;
            		$scope.startPage = 0;
            		$scope.datasTable.curPage={"pageIdex":0};
            		var url = _getQueryCondition();
            		mask.show();
	          		var promise = communicationService.get(utilService.getResouceUrl(url)).promise();
		        	promise.always(_updateUI);
		        	$scope.maskHandler = promise;
		        	$scope.$apply();
            	},
            };
            var getAdminValue = function(adminObj){
            	var admin = $("#source").widget();
				var adminValue = [];
				if (!utilService.isNotEmpty(admin)){
					adminValue = "";
				}else{
					adminValue =admin.getValue();
					adminValue.split(',');
				}

			    var levelValue;
				if (!highQuery){
					var choise = $("#opt").widget().getSelectedId();
    	        	if(choise == "-1"){
    	        		levelValue = $("#choiceLevel").widget().getSelectedId();
    	        	}
    	        	if(choise == "0"){
    	        		levelValue =[1,2,3];
    	        	}

				}else{
					levelValue = [];
					var keyArray = infoTransferredService.get("logModule","keyArray");
           		  if(!keyArray || keyArray.length == 0){
           			  levelValue = [1,2,3];
           		  }else{
           			levelValue = keyArray;
           		  }
				}
				adminObj ={
					admin : adminValue,
					level : levelValue
				}
				return adminObj;
            };
            var gerExportParam = function(exporturl){
                var result = $("#type").widget();
                var resultValue;
				if (!highQuery){
					var choise = $("#opt").widget().getSelectedId();
    	        	if(choise == "-1"){
    	        		resultValue = -1;
    	        	}
    	        	if(choise == "0"){
    	        		resultValue = $("#choiceResult").widget().getSelectedId();
    	        	}
				}else{
					resultValue = result.getSelectedId();
				}


				var dateFrom = $("#startDate").widget();
				var dataFormValue;
				if (!highQuery){
					dataFormValue = 0;
				}else{
					dataFormValue = dateFrom.getDateTime();
                       if(!utilService.isNotEmpty(dataFormValue)){
                           dataFormValue = 0;
                       }else{
                           dataFormValue = appUtils.newDate(dataFormValue).getTime();
                       }
				}
            	var dateTo = $("#endDate").widget();
            	var dateToValue;
            	if (!highQuery){
            		dateToValue = 0;
            	}else{
            		dateToValue = dateTo.getDateTime();
                       if(!utilService.isNotEmpty(dateToValue)){
                           dateToValue = 0;
                       }else{
                           dateToValue = appUtils.newDate(dateToValue).getTime();
                       }
            	}

            	exporturl = exporturl + '&result='+resultValue +'&dateFrom='+dataFormValue +'&dateTo='+dateToValue+"&orderBy="+$scope.datasTable.orderBy
	        	 +"&orderType="+$scope.datasTable.orderType;
            	return exporturl;
			};

            var _getQueryCondition = function(){
            	if(!_.isUndefined(infoTransferredService.get("sysLog", "loadLoginFilter"))) {
            		loadLoginFilter = infoTransferredService.get("sysLog", "loadLoginFilter");
            	};
            	infoTransferredService.remove("sysLog", "loadLoginFilter");
            	var url = "/operationlogs?startPage="+$scope.startPage+"&pageSize="+ $scope.datasTable.displayLength +"&orderBy="+$scope.datasTable.orderBy
	        	 +"&orderType="+$scope.datasTable.orderType ;
            	if(!$scope.isAdvatageQuery){
            		if($("#opt").widget()){
	            		var choise = $("#opt").widget().getSelectedId();

	    	        	if(choise == "-1"){
	    	        		url+= "&level="+$("#choiceLevel").widget().getSelectedId();
	    	        	}
	    	        	if(choise == "0"){
	    	        		url+= "&result="+$("#choiceResult").widget().getSelectedId();
	    	        	}
            		}
            		if(loadLoginFailed) {
            			var addFilter = "&dateTo="+loadLoginFilter.dateTo+"&dateFrom="+loadLoginFilter.dateFrom
            			     +"&admin="+loadLoginFilter.admin+"&level=1&level=2&level=3&result="+loadLoginFilter.result;
            			url += addFilter;
            		}
            	}else{
            		var level = [];
            		var keyArray = infoTransferredService.get("logModule","keyArray");
             		  if(!keyArray || keyArray.length == 0){
             			 level = [1,2,3];
             		  }else{
             			 level = keyArray;
             		  }

            		var result = $("#type").widget().getSelectedId();
            		var admin = encodeURIComponent($.trim($("#source").widget().getValue()));
            		var dateFrom = $("#startDate").widget().getDateTime();
            		var dateTo = $("#endDate").widget().getDateTime();

            		if(dateTo){
            			url += "&dateTo="+appUtils.newDate(dateTo).getTime();
            		}
            		if(dateFrom){
            			url += "&dateFrom="+appUtils.newDate(dateFrom).getTime();
            		}
            		if(admin){
            			url += "&admin="+admin;
            		}
            		if( level.length > 0 ){
            			for(var i = 0 ; i < level.length ; i++){
                			url = url+ "&level="+level[i];
                		}
            		}
            		url = url+ "&result="+result;
            	}
            	return url;
            };

			$scope.datasTable = {
				id : "datasTable",
				paginationStyle:"full_numbers",
				lengthMenu: constsService.TABLE_LENGTH_AUTO_MENU,
				columns : [{
					"sTitle" : "id",
					"mData" : "id",
					"bVisible" : false
				}, {
					"sTitle" : appUtils.getString("syslog_term_operation_label"),
					"mData" : "operation"
				}, {
					"sTitle" : appUtils.getString("syslog_term_level_label"),
					"mData" : "level"
				},
				{
					"sTitle" : appUtils.getString("setting_sysoperlog_list_user_column"),
					"mData" : "operator"
				},
				{
					"sTitle" : appUtils.getString("syslog_term_date_label"),
					"mData" : "gmt"
				},
				{
					"sTitle" : appUtils.getString("syslog_term_result_label"),
					"mData" : "result"
				},{
					"sTitle" : appUtils.getString("syslog_term_terminalIp_label"),
					"mData" : "terminalIp"
				},{
					"sTitle" : appUtils.getString("syslog_term_target_label"),
					"mData" : "target"
				},{
					"sTitle" : appUtils.getString("syslog_term_detail_label"),
					"mData" : "detail"
				},{
					"sTitle" :"targetPara",
					"mData" : "targetPara",
					"bVisible" :false
				},{
					"sTitle" : "detailPara",
					"mData" : "detailPara",
					"bVisible" :false
				}],
				displayLength:constsService.TABLE_COUNT_PER_PAGE_BIG,
				changeSelect: function(evtObj) {
				    var start = evtObj.currentPage - 1;
                    $scope.startPage = evtObj.currentPage - 1;
                    $scope.datasTable.displayLength = evtObj.displayLength;
                    mask.show();
                    communicationService.get(utilService.getResouceUrl(_getQueryCondition())).promise().always(_updateUI);
				},
	            callback :function(evtObj) {
				    var start = evtObj.currentPage - 1;
				    $scope.startPage = evtObj.currentPage - 1;
	                $scope.datasTable.displayLength = evtObj.displayLength;
	                mask.show();
	                communicationService.get(utilService.getResouceUrl(_getQueryCondition())).promise().always(_updateUI);
	            },
				renderRow : function(nRow, aData, iDataIndex) {
	            	$('td:eq(1)', nRow).html(appUtils.getString(aData["operation"]));
	            	$('td:eq(7)', nRow).html(appUtils.getString(aData["target"], aData["targetPara"]));
	            	if(!appUtils.isEn() && aData["detail"] == "dataMaintainence_modifyDebugLog_operateDetail"){
	            		var logObj = {
	            			"DEBUG": appUtils.getString("settings_logmgr_debug_log_level_debug_label"),
	            			"INFO": appUtils.getString("settings_logmgr_debug_log_level_info_label"),
	            			"WARN": appUtils.getString("settings_logmgr_debug_log_level_warn_label"),
	            			"ERROR": appUtils.getString("settings_logmgr_debug_log_level_error_label")
	            		};
	            		for(var i=0;i<aData["detailPara"].length;i++){
	            			aData["detailPara"][i] = logObj[aData["detailPara"][i]]
	            		}
	            	}
	            	$('td:eq(8)', nRow).html(appUtils.getString(aData["detail"], aData["detailPara"]));
	            	var level = aData["level"];
	            	$('td:eq(2)', nRow).html(statusEnumService.getStatus("SYSTEM_LOGS_LEVEL" ,level));
	            	var result = aData["result"];
	            	$('td:eq(5)', nRow).html(statusEnumService.getStatus("SYSTEM_LOGS_RESULT" ,result));
				},
				orderBy:"date",
				orderType:"desc",
				data : [],
				cellClickActive : function(e, param) {
					$scope.current = param;

			     },
                 sortCallback: function(nNode, sortArr){
                	 $scope.datasTable.orderBy = $scope.datasTable.columns[sortArr[0][0]-1].mData;
                	 if ($scope.datasTable.orderBy == "gmt") {
                	 	$scope.datasTable.orderBy = "date";
                	 }
                	 $scope.datasTable.orderType = sortArr[0][1];
                	 $scope.startPage = 0;
                	 mask.show();
                	 communicationService.get(utilService.getResouceUrl(_getQueryCondition())).promise().always(_updateUI);
                 }

			};

		  $scope.refreshDataTable  = function(){
			  $scope.datasTable.orderBy = "date";
			  $scope.datasTable.orderType = "desc";
			  $("#opt").widget().setSearchboxValue("-1");
			  $scope.startPage = 0;
			  mask.show();
			  var promise = communicationService.get(utilService.getResouceUrl(_getQueryCondition())).promise();
			  promise.always(_updateUI);
			  $scope.maskHandler = promise;
			  $scope.datasTable.curPage = {"pageIndex":0};
		  };

          var _updateUI = function(result) {
          		mask.hide();
	            if (exception.check(result)) {
	                var arr = [];
	                _.each(result.records, function(d) {
	                    var tmo =_.pick(d, "id", "operation", "level","operator","gmt","result","terminalIp","target","detail","targetPara","detailPara");
	                    arr.push(tmo);
	                });
	                if(loadLoginFailed) {
	                	arr = _.filter(arr, function(record) {
	                		return record.operation == "user_login_operateName";
	                	});
	               		$scope.showAdvanceSearch(function() {
	                		$("#type").widget().opChecked("0");
	                		$("#source").widget().option("value", loadLoginFilter.admin);

	                		var formatFromTime = appUtils.convertDate2String(loadLoginFilter.dateFrom).replace(" ", ",");
	                		var formatToTime = appUtils.convertDate2String(loadLoginFilter.dateTo).replace(" ", ",");
	                		$("#startDate").widget().option("defaultDate", formatFromTime.split(",")[0]);
	                		$("#startDate").widget().option("defaultTime", formatFromTime.split(",")[1]);
	                		$("#endDate").widget().option("defaultDate", formatToTime.split(",")[0]);
	                		$("#endDate").widget().option("defaultTime", formatToTime.split(",")[1]);
	                	});
	                	loadLoginFailed = !loadLoginFailed;
	                };

	                $scope.datasTable.data = appUtils.encodeForHTML(arr);
	                $scope.datasTable.totalRecords = result["totalCount"];
	                if(result["totalCount"] > constsService.TABLE_COUNT_PER_PAGE_BIG){
	                	$scope.datasTable.paging = true;
	                }else{
	                	$scope.datasTable.paging = false;
	                }
	                $scope.$apply();
	            }
	        } ;

          var _init = function(){
          		mask.show();
          		var promise = communicationService.get(utilService.getResouceUrl(_getQueryCondition()+"&pageSize="+constsService.TABLE_COUNT_PER_PAGE_BIG)).promise();
	        	promise.always(_updateUI);
	        	$scope.maskHandler = promise;
	        };

	        _init();


		}]

		var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.sysOperLog.ctrl', ctrler);
        return module;
})
