define([],

    function () {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                $scope.model = {
                    boTree: {
                        "id": "boTree",
                        "width": "400px",
                        "height": "300px",
                        "setting": {
                            view: {
                                selectedMulti: false
                            },
                            check: {
                                enable: true,
                                autoCheckTrigger: true
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onCheck: function (event, id, node) {
                                    if (node.children && node.children.length) {
                                        return;
                                    }
                                    $scope.$emit('change-bo', _.pick(node, 'id', 'checked'));
                                }
                            }
                        },
                        "values": []
                    }
                };

                var eSelectBo = $scope.$on('select-bo', function(evtObj, bos) {
                    bos = bos || {};
                    var checkedKeys = _.keys(bos);
                    communicationService.get(utilService.getResouceUrl("/users/action/getBizObjectTree")).promise().always(function (response) {
                        if (exception.check(response)) {
                            var mos = [],
                                selectNodes = [];
                            _.each(response, function(ele, index) {
                                var name = appUtils.getString(ele.name) || ele.name;

                                name = name.replace(/\(\S+\)/, function(str) {
                                    str = str.substr(1);
                                    str = str.substr(0, str.length - 1);
                                    return "(" + (appUtils.getString(str) || str) + ")";
                                });
                                var node = {
                                    id: ele.id,
                                    pId: ele.pid,
                                    name: name,
                                    open: appUtils.toBoolean(ele.open)
                                };
                                if (_.contains(checkedKeys, ele.id)) {
                                    node.checked = true;
                                    selectNodes.push(node);
                                }
                                mos.push(node);
                            });
                            $scope.model.boTree.values = mos;
                            $scope.$apply();
                            var boTree = $("#boTree").widget().getZTreeObj();
                            _.each(selectNodes, function(node) {
                                boTree.checkNode(boTree.getNodeByParam("id", node.id), true, true, null);
                            });
                        }
                    });
                });

                $scope.$emit('notify-selected', 'bo');
                $scope.$on('$destroy', eSelectBo);
            }
        ];

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.boTree.ctrl', ctrler);
        return module;
    }
)
