define(["tiny-common/UnifyValid", "tiny-widgets/Window"],

    function (UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "appUtils",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            function ($scope, $state, $stateParams, appUtils, exception, message, communicationService, utilService, mask, constsService) {
                $scope.enabledEdit = true;
                $scope.enabledDel = false;
                $scope.data = {};
                var __priv_props__ = {};
                var __priv_func__ = {};
                $scope.btnCreate = {
                    id: "btnRangCreate",
                    text: appUtils.getString("common_term_add_button"),
                    click: function () {
                        var options = {
                            "winId": "addSegWinId",
                                "helpId" : "addSeg",
                                "data": $scope.data,
                                "title": appUtils.getString("user_term_iprangeadd_title"),
                                "width" : 430,
                                "height": constsService.MODIFY_SITE_WIN.height,
                                "content-type": "url",
                                "content": constsService.USER_IP_RANGE_EDIT_URL,
                                "minimizable": false,
                                "maximizable": false,
                                "buttons": [{
                                    key: "ok",
                                    label: appUtils.getString("common_term_confirm_button"),
                                    focused: true,
                                    handler: function (event) {
                                        if (!UnifyValid.FormValid($("#modify-div"), {focusInvalid: true})) {
                                            return;
                                        }
                                        var beginIp = $('#modify-div').find('#win_iprange_beginIp').widget().getValue();
                                        var endIp = $('#modify-div').find('#win_iprange_endIp').widget().getValue();
                                        var desc = $('#modify-div').find('#win_iprange_des').widget().getValue();

                                        if (!__priv_func__.validateIp(beginIp, endIp)) {
                                            return;
                                        }

                                        __priv_props__.data.push({
                                            index: __priv_props__.data.length + 1,
                                            startIpStr: beginIp,
                                            endIpStr: endIp,
                                            des: desc
                                        });

                                        var data = angular.copy(__priv_props__.data);
                                        $scope.datasTable.data = appUtils.encodeForHTML(data, __priv_func__.iteratorForDes);
                                        $scope.$apply();
                                        $scope.$emit('change-ip', __priv_props__.data);
                                        $("#addSegWinId").widget().destroy();
                                    }
                                }, {
                                    key: "cancel",
                                    label: appUtils.getString("common_term_cancel_button"),
                                    focused: false,
                                    handler: function (event) {
                                        $("#addSegWinId").widget().destroy();
                                    }
                                }
                            ],
                                "close": function () {

                            }
                        };

                        var win = new Window(options);
                        win.show();
                    }
                };

                $scope.datasTable = {
                    id: "datasRangTable",
                    operateButtonCount: 1,
                    columns: [{
                        "sTitle": appUtils.getString("common_term_beginip_label"),
                            "mData": "startIpStr",
                            "validate": "required;ip"
                    }, {
                        "sTitle": appUtils.getString("common_term_endip_label"),
                            "mData": "endIpStr",
                            "validate": "required;ip"
                    }, {
                        "sTitle": appUtils.getString("user_term_des_label"),
                            "mData": "des",
                            "validate": constsService.VALID.DES_REMARK
                    }],
                    renderRow: function (nRow, aData, iDataIndex) {
                    },
                    data: [],
                    opAreaConfig: [{
                        id: "iconBtnEdit",
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                        clickActive: function () {
                            var selectedIndex = $('#datasRangTable').widget().getHoverData()[0].index;
                            var selectData = {};
                            _.each(__priv_props__.data, function(ele, index) {
                                if (ele.index !== selectedIndex) {
                                    return;
                                }
                                selectData = {
                                    index: selectedIndex,
                                    startIp: ele.startIpStr,
                                    endIp: ele.endIpStr,
                                    des: ele.des
                                };
                            });
                            var options = {
                                "winId": "addSegWinId",
                                "helpId" : "modifySeg",
                                    "data": selectData,
                                    "title": appUtils.getString("user_term_iprangeedit_title"),
                                    "width" : constsService.WIN_SIZE.S3[0],
                                    "height": constsService.MODIFY_SITE_WIN.height,
                                    "content-type": "url",
                                    "content": constsService.USER_IP_RANGE_EDIT_URL,
                                    "minimizable": false,
                                    "maximizable": false,
                                    "buttons": [{
                                        key: "ok",
                                        label: appUtils.getString("common_term_confirm_button"),
                                        focused: true,
                                        handler: function (event) {
                                            if (!UnifyValid.FormValid($("#modify-div"), {focusInvalid: true})) {
                                                return;
                                            }
                                            var beginIp = $('#modify-div').find('#win_iprange_beginIp').widget().getValue();
                                            var endIp = $('#modify-div').find('#win_iprange_endIp').widget().getValue();
                                            var desc = $('#modify-div').find('#win_iprange_des').widget().getValue();

                                            if (!__priv_func__.validateIp(beginIp, endIp, selectData.index)) {
                                                return;
                                            }

                                            _.each(__priv_props__.data, function(ele, index) {
                                                if (ele.index !== selectData.index) {
                                                    return;
                                                }

                                                ele.startIpStr = beginIp;
                                                ele.endIpStr = endIp;
                                                ele.des = desc;
                                            });

                                            var data = angular.copy(__priv_props__.data);
                                            $scope.datasTable.data = appUtils.encodeForHTML(data, __priv_func__.iteratorForDes);
                                            $scope.$apply();
                                            $scope.$emit('change-ip', __priv_props__.data);
                                            $("#addSegWinId").widget().destroy();
                                        }
                                    }, {
                                        key: "cancel",
                                        label: appUtils.getString("common_term_cancel_button"),
                                        focused: false,
                                        handler: function (event) {
                                            $("#addSegWinId").widget().destroy();
                                        }
                                    }
                                ],
                                "close": function () {
                                }
                            };

                            var win = new Window(options);
                            win.show();
                        }
                    }, {
                        id: "iconBtnDel",
                        template: "<div class='iconbutton-delete'  title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                        clickActive: function () {
                            if (!$scope.enabledDel) {
                                return;
                            }
                            var index = $('#datasRangTable').widget().getHoverData()[0].index;
                            message.warn({content: appUtils.getString("user_term_iprange_delete_confirm_msg"), ok: function() {
                                var datas = [];
                                _.each(__priv_props__.data, function(data){
                                    if (data.index === index) {
                                        return;
                                    }
                                    datas.push(data);
                                })
                                __priv_props__.data = datas;
                                $scope.datasTable.data = appUtils.encodeForHTML(angular.copy(datas), __priv_func__.iteratorForDes);
                                $scope.$emit('change-ip', __priv_props__.data);
                                $scope.$apply();
                            }});
                        }
                    }],
                    cellClickActive: function (e, param) {
                        $scope.current = param;
                    },
                    hoverActive: function (e, param) {
                        var options;
                        if ($('#datasRangTable').widget().getTableData().length === 1) {
                            $scope.enabledDel = false;
                            options = [{
                                id: "iconBtnEdit",
                                enable: true
                            },{
                                id: "iconBtnDel",
                                enable: false
                            }];
                        } else {
                            $scope.enabledDel = true;
                            options = [{
                                id: "iconBtnEdit",
                                enable: true
                            }, {
                                id: "iconBtnDel",
                                enable: true
                            }];
                        }
                        appUtils.setOpAreaEnable(options);
                    }
                };
                __priv_func__.iteratorForDes = function(key, value) {
                    if (key === "des" && value === null) {
                        return "";
                    }
                    return value;
                };
                __priv_func__.selectIp = $scope.$on('select-ip', function(event, ipRanges) {
                    __priv_props__.data = [];
                    if (!ipRanges || !ipRanges.length) {
                        __priv_props__.data.push({
                            index: 1,
                            startIpStr: "1.0.0.1",
                            endIpStr: "223.255.255.255",
                            des: ""
                        });

                        __priv_props__.data.push({
                            index: 2,
                            startIpStr: "0::0",
                            endIpStr: "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
                            des: ""
                        });

                        var ips = angular.copy(__priv_props__.data);
                        $scope.datasTable.data = appUtils.encodeForHTML(ips, __priv_func__.iteratorForDes);
                        $scope.$apply();
                        return;
                    }
                    var index = 1;
                    _.each(ipRanges, function(ip) {
                        __priv_props__.data.push({
                            index: index,
                            startIpStr: ip.startIpStr,
                            endIpStr: ip.endIpStr,
                            des: ip.des
                        });
                        index++;
                    });
                    var data = angular.copy(__priv_props__.data);
                    $scope.datasTable.data = appUtils.encodeForHTML(data, __priv_func__.iteratorForDes);
                    $scope.$apply();
                });
                __priv_func__.validateIp = function(startIp, endIp, ignoreIndex) {
                    if (!startIp || !endIp) {
                        message.error(appUtils.getString("validate_term_ip_empty_msg"));
                        return false;
                    }

                    // 判断是IPv4还是IPv6
                    var isIPv4 = false;
                    var isIPv6 = false;
                    if (appUtils.validIPv4Address(startIp) && appUtils.validIPv4Address(endIp)) {
                        isIPv4 = true;
                        isIPv6 = false;
                    } else if (appUtils.validIPv6Address(startIp) && appUtils.validIPv6Address(endIp)) {
                        isIPv4 = false;
                        isIPv6 = true;
                    } else {
                        message.error(appUtils.getString("validate_ipv4_ipv6_label"));
                        return false;
                    };

                    var data = $('#datasRangTable').widget().getTableData();

                    // 若输入为IPv4，判断起始是否正常
                    if (isIPv4 && !isIPv6) {
                        if (!appUtils.compareIPv4Address(startIp, endIp)) {
                            message.error(appUtils.getString("validate_term_ip_start_greater_than_end_msg"))
                            return false;
                        }
                    };
                    // 若输入为IPv6，判断起始是否正常
                    if (!isIPv4 && isIPv6) {
                        if (!appUtils.compareIPv6Address(startIp, endIp)) {
                            message.error(appUtils.getString("validate_term_ip_start_greater_than_end_msg"))
                            return false;
                        }
                    };

                    // 判断是否和已知的范围重复
                    var isValid = true;
                    _.each(data, function(ipRange) {
                        if (ipRange.index === ignoreIndex) {
                            return;
                        }

                        if (!ipRange.startIpStr || !ipRange.endIpStr) {
                            isValid = false;
                        }

                        // 判断从表格中拿到的数据是IPv4还是IPv6
                        var isIPv4Table = appUtils.validIPv4Address(ipRange.startIpStr);

                        // 若输入为IPv4，判断IP是否全包含
                        if(isIPv4Table && isIPv4 && !isIPv6){
                            var compareIPv4Start = appUtils.compareIPv4Address(ipRange.startIpStr, startIp);
                            var compareIPv4End = appUtils.compareIPv4Address(endIp, ipRange.endIpStr);

                            // 如果返回为0，说明相等
                            if(compareIPv4Start === 0){
                                if(compareIPv4End === 0){
                                    isValid = false;
                                }else if(compareIPv4End){
                                    isValid = false;
                                };
                            }else if (compareIPv4Start) {
                                // 若添加的起始IP比现有的起始IP大，并且结束IP比现有的结束IP小
                                isValid = false;
                                if(compareIPv4End === 0){
                                    isValid = false;
                                }else if(compareIPv4End){
                                    isValid = false;
                                };
                            };
                        };
                        // 若输入为IPv6，判断IP是否全包含
                        if(!isIPv4Table && !isIPv4 && isIPv6){
                            var compareIPv6Start = appUtils.compareIPv6Address(ipRange.startIpStr, startIp);
                            var compareIPv6End = appUtils.compareIPv6Address(endIp, ipRange.endIpStr);

                            // 如果返回为0，说明相等
                            if(compareIPv6Start === 0){
                                if(compareIPv6End === 0){
                                    isValid = false;
                                }else if(compareIPv6End){
                                    isValid = false;
                                };
                            }else if (compareIPv6Start) {
                                // 若添加的起始IP比现有的起始IP大，并且结束IP比现有的结束IP小
                                if(compareIPv6End === 0){
                                    isValid = false;
                                }else if(compareIPv6End){
                                    isValid = false;
                                };
                            };
                        };


                    });

                    if (!isValid) {
                        message.error(appUtils.getString("validate_term_ip_range_existed_msg"));
                        return false;
                    }

                    return true;
                };
                (function() {
                    var timer = setTimeout(function() {
                        $scope.$emit('notify-selected', 'ip');
                        clearTimeout(timer);
                    }, 500);
                })();

                $scope.$on('$destroy', function() {
                    delete __priv_func__.selectIp;
                    delete __priv_func__.validateIp;
                    delete __priv_func__.iteratorForDes;
                    delete __priv_props__.data;
                });
            }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.ipRang.ctrl', ctrler);
        return module;
    }
)
