define(["tiny-common/UnifyValid"],

    function (UnifyValid) {
        "use strict";
        var ctrl = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService", "appUtils",

            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                $scope.model = {
                    labels: {
                        beginIp: appUtils.getString("common_term_beginip_label") + ":",
                        endIp: appUtils.getString("common_term_endip_label") + ":",
                        des: appUtils.getString("common_term_description_label") + ":"
                    },
                    beginIp: {
                        id: "win_iprange_beginIp",
                        width: constsService.W3,
                        value: $("#addSegWinId").widget().option("data").startIp,
                        extendFunction: ["checkIP"],
                        validate: "checkIP : extend function;"
                    },
                    endIp: {
                        id: "win_iprange_endIp",
                        width: constsService.W3,
                        value: $("#addSegWinId").widget().option("data").endIp,
                        extendFunction: ["checkIP"],
                        validate: "checkIP : extend function;"
                    },
                    des: {
                        id: "win_iprange_des",
                        type: "multi",
                        height: constsService.DESCR_HEIGHT,
                        value: $("#addSegWinId").widget().option("data").des,
                        width: constsService.W3,
                        labelcls: "label-middle",
                        validate: constsService.VALID.DES_REMARK
                    }
                };

                UnifyValid.checkIP = function() {
                    var val = this[0].value;
                    if (_.isEmpty(val)) {
                        return appUtils.getString("common_term_empty_label");
                    };
                    if (!appUtils.validIPv4OrIPv6Address(val)) {
                        return appUtils.getString("validate_ipv4_ipv6_label");
                    }
                    return "";
                };

                $scope.$on('$destroy', function() {
                    delete UnifyValid.checkIP;
                });

            }];

            var module = angular.module("recoverydirector.setting.config");
            module.tinyController("user.modifyRangeCtrl", ctrl);
            return module;
    })
