define([],
    function () {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",

            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                $scope.model = {
                    moTree: {
                        "id": 'userMoTree',
                            "width": "400px",
                            "height": "300px",
                            "setting": {
                            view: {
                                selectedMulti: false
                            },
                            check: {
                                enable: true,
                                autoCheckTrigger: true
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onCheck: function (evtObj, id, node) {
                                    if (node.children && node.children.length) {
                                        return;
                                    }
                                    $scope.$emit('change-mo', _.pick(node, 'id', 'checked'));
                                }
                            }
                        },
                        "values": []
                    }
                };

                var eSelectMo = $scope.$on('select-mo', function (evtObj, selectedMos) {
                    selectedMos = selectedMos || {};
                    var checkedKeys = _.keys(selectedMos);
                    communicationService.get(utilService.getResouceUrl("/resources/action/getResourceTree")).promise().always(function (response) {
                        if (exception.check(response)) {
                            var mos = [],
                                selectNodes = [];
                            _.each(response, function (ele, index) {
                                var node = {
                                    id: ele.id,
                                    pId: ele.pid,
                                    name: appUtils.getString(ele.name) || ele.name,
                                    open: appUtils.toBoolean(ele.open)
                                };
                                if (selectedMos[ele.id]) {
                                    node.checked = true;
                                    selectNodes.push(node);
                                }
                                mos.push(node);
                            });
                            $scope.model.moTree.values = mos;
                            $scope.$apply();
                            var userMoTree = $("#userMoTree").widget().getZTreeObj();
                            _.each(selectNodes, function(node) {
                                userMoTree.checkNode(userMoTree.getNodeByParam("id", node.id), true, true, null);
                            });
                        }
                    });
                });

                // notify parent scope send me last selected mos
                $scope.$emit('notify-selected', 'mo');
            }];

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.moTree.ctrl', ctrler);
        return module;
    }
)
