define([],

    function () {
        "use strict";
        var ctrler = ["$scope", "$state", "exception", "message",
            "communicationService", "utilService", "mask", "constsService", "appUtils", "cookieService",

        function ($scope, $state, exception, message, communicationService, utilService, mask, constsService, appUtils, cookieService) {

            $scope.enableForce = true;

            var __props__ = {
                pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                pageIndex: 1,
                orderBy: "stayTime",
                orderType: "desc",
                queryUri: "/users/onlineUsers?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}"
            };


            $scope.datasTable = {
                id: "datasTable",
                paginationStyle:"full_numbers",
                columns: [{
                    "sTitle": "userId",
                        "mData": "userId",
                        "bVisible": false
                }, {
                    "sTitle": appUtils.getString("onlineuser_term_name_label"),
                        "mData": "userName"
                }, {
                    "sTitle": appUtils.getString("common_term_ip_column"),
                        "mData": "ipAdr"
                }, {
                    "sTitle": appUtils.getString("onlineuser_term_logintime_label"),
                        "mData": "loginDate",
                        "bVisible": true
                }, {
                    "sTitle": appUtils.getString("onlineuser_term_time_label"),
                        "mData": "stayTime",
                        "bSortable": false
                }],
                displayLength: __props__.pageSize,
                totalRecords: 0,
                callback: function (evtObj) {
                    mask.show();
                    __props__.pageIndex = evtObj.currentPage;
                    __initDataTable(function() {
                        mask.hide();
                    })
                },
                sortCallback: function(thead, sortObj) {
                    __props__.orderBy = $scope.datasTable.columns[sortObj[0][0]].mData;
                    __props__.orderType = sortObj[0][1];
                    mask.show();
                    __initDataTable(function() {
                        mask.hide();
                    })
                },
                renderRow: function (nRow, aData, iDataIndex) {
                    var data = aData["stayTime"];
                    var dealedData = data.replace("day", appUtils.getString("common_term_day_label")).replace("hour", appUtils.getString("common_term_hour_label")).replace("minute", appUtils.getString("common_term_minute_label")).replace("second", appUtils.getString("common_term_second_label"))
                    $('td:eq(3)', nRow).text(dealedData);
                },

                data: [],
                opAreaConfig: [],
                cellClickActive: function (e, param) {},
                hoverActive: function (e, param) {
                    if (!__props__.curUser.isAdmin && !__props__.curUser.isAdministrator) {
                        return;
                    }
                    if (__props__.curUser.isAdmin) {
                        if (param.userName == "admin") {
                            $scope.enableForce = false;
                            $("#iconBtnEdit div").removeClass("iconbutton-forcedown").addClass("iconbutton-forcedown-disabled");
                        } else {
                            $scope.enableForce = true;
                            $("#iconBtnEdit div").removeClass("iconbutton-forcedown-disabled").addClass("iconbutton-forcedown");
                        }
                    } else {
                        if (param.userName == "admin" || param.isAdministrator) {
                            $scope.enableForce = false;
                            $("#iconBtnEdit div").removeClass("iconbutton-forcedown").addClass("iconbutton-forcedown-disabled");
                        } else {
                            $scope.enableForce = true;
                            $("#iconBtnEdit div").removeClass("iconbutton-forcedown-disabled").addClass("iconbutton-forcedown");
                        }
                    }
                }

            };

            var opConfig = [{
                id: "iconBtnEdit",
                authKey: "lego.sys.onlineUserMgr.down",
                template: "<div class='iconbutton-forcedown' title='" + appUtils.getString("common_term_forcedown_button") + "'></div>",
                clickActive: function () {
                    var data = $('#datasTable').widget().getHoverData()[0];
                    if (!data) {
                        return;
                    }
                    if ($scope.enableForce) {
                        $scope.forceDown(data.userId, data.session);
                    }
                }
            }];

            $scope.refreshDataTable = function () {
                mask.show();
                __props__.pageIndex = 1;
                $scope.datasTable.currPage = {"pageIndex": 1};
                __initDataTable(function() {
                    mask.hide();
                });
            };

            $scope.forceDown = function (userId, session) {
                message.warn({
                    "content": appUtils.getString("user_term_online_user_kickout_confirm_msg"),
                        "ok": function () {
                        mask.show();
                        var url = "/users/onlineUsers/action/forceLogout";
                        url += "?userId=" + userId + "&sessionId=" + session;
                        url = utilService.getResouceUrl(url);
                        communicationService.put(url).promise().always(function (result) {
                            if (!exception.check(result)) {
                                mask.hide();
                                return;
                            }
                            __props__.pageIndex = 1;
                            $scope.datasTable.currPage = {pageIndex: 1};
                            __initDataTable(function() {
                                mask.hide();
                                message.success(appUtils.getString("common_term_operation_success_label"));
                            });
                        });
                    }
                });
            };

            var __getCurrentUser = function () {
                __props__.curUser = appUtils.getCurrentUser();
                if (__props__.curUser.isAdmin || __props__.curUser.isAdministrator) {
                    $scope.datasTable.opAreaConfig = opConfig;
                }
                return appUtils.getCurrentUser();
            }

            var __initDataTable = function(callback) {
                var url = appUtils.stringFormat(__props__.queryUri, __props__.pageSize, __props__.pageIndex - 1, __props__.orderBy, __props__.orderType);
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    if (!exception.check(result)) {
                        mask.hide();
                        return;
                    }

                    var arr = [];
                    _.each(result.records, function (d) {
                        var tmo = _.pick(d, "userId", "userName", "ipAdr", "loginDate", "stayTime", "session", "isAdmin", "isAdministrator");
                        tmo.isAdmin = tmo.isAdmin == "true";
                        tmo.isAdministrator = tmo.isAdministrator == "true";
                        arr.push(tmo);
                    });
                    if (result["totalCount"] > __props__.pageSize) {
                        $scope.datasTable.paging = true
                    } else {
                        $scope.datasTable.paging = false
                        __props__.pageIndex = 1;
                        $scope.datasTable.currPage = {pageIndex: 1};
                    }
                    $scope.datasTable.data = appUtils.encodeForHTML(arr);
                    $scope.datasTable.totalRecords = result["totalCount"];
                    if (typeof callback === "function") {
                        (callback)();
                    }
                    $scope.$apply();
                });
            };

            __getCurrentUser();
            $scope.refreshDataTable();
        }];

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.onlineUserList.ctrl', ctrler);
        return module;
    }
);
