define(["tiny-common/UnifyValid", "tiny-widgets/Window"],

    function (UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$rootScope",
            "$scope",
            "$state",
            "exception",
            "message",
            "communicationService", "utilService", "mask", "constsService", "cookieService", "appUtils",

            function ($rootScope, $scope, $state, exception, message, communicationService,
                      utilService, mask, constsService, cookieService, appUtils) {
                $scope.configformTitle = appUtils.getString("user_term_userlist_title");
                $scope.enableDel = true;
                $scope.enableLock = true;
                $scope.enableUnLock = false;
                $scope.enableEdit = true;
                $scope.enableEditPwd = false;
                $scope.isOCAdmin = "sso" == cookieService.get("user.login.mode");

                var __Props = {
                    curUser: {},
                    pageIndex: 1,
                    pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    orderBy: "id",
                    orderType: "desc"
                };

                $scope.btnCreate = {
                    id: "btnCreate",
                    text: appUtils.getString("common_term_create_button"),
                    click: function () {
                        $state.go("settings.userEdit.userGroup", {
                            id: ''
                        });
                    }
                };
                $scope.btnDel = {
                    id: "btnDel",
                    text: appUtils.getString("common_term_delete_button"),
                    click: function () {

                    }
                };
                $scope.btnLock = {
                    id: "btnLock",
                    text: appUtils.getString("common_term_lock_button"),
                    click: function () {

                    }

                };
                $scope.btnunLock = {
                    id: "btnunLock",
                    text: appUtils.getString("common_term_unlock_button"),
                    click: function () {

                    }

                };
                var opConfig = [{
                    id: "iconBtnEdit",
                    template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                    clickActive: function () {
                        if (!$scope.enableEdit) {
                            return;
                        }

                        var userId = _getOpID();
                        if(getSyncAdmin()){
                           $state.go("settings.userEdit.ipRange", {
                               id: "syncAdmin_"+userId
                           });
                           return;
                        }
                        $state.go("settings.userEdit.userGroup", {
                            id: userId
                        });
                    }
                }, {
                    id: "iconBtnEditPwd",
                    template: "<div class='iconbutton-password' title='" + appUtils.getString("user_term_editauth_button") + "'></div>",
                    clickActive: function () {
                        if (!$scope.enableEditPwd) {
                            return;
                        }
                        var userId = _getOpID();
                        if (userId == "1") {
                            return;
                        }

                        // 认证弹框
                        var winOps = {
                            "winId": "userAuthWin",
                            "data" : null,
                            "title": appUtils.getString("user_term_user_auth_title"),
                            "width": constsService.MODIFY_PWD_WIN.width,
                            "height": constsService.MODIFY_PWD_WIN.height,
                            "content-type": "url",
                            "content": constsService.USER_AUTH_URL,
                            "buttons": [{
                                key: "ok",
                                label: appUtils.getString('common_term_confirm_button'),
                                focused: true,
                                handler: function (event) {
                                    __userAuthSubmit();
                                }
                            },
                            {
                                key: "cancel",
                                label: appUtils.getString('common_term_cancel_button'),
                                focused: false,
                                handler: function (event) {
                                    $("#userAuthWin").widget().destroy();
                                }
                            }],
                            "maximizable": false,
                            "minimizable": false,
                            "close": function () {
                                $("#userAuthWin").widget().destroy();
                            }
                        };
                        var win = new Window(winOps);
                        win.show();
                    }
                }, {
                    id: "iconBtnDel",
                    template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                    clickActive: function () {
                        if (!$scope.enableDel) {
                            return;
                        }

                        var userId = _getOpID();
                        message.warn({
                            content: appUtils.getString("user_term_users_operations_delete_confirm_msg"),
                            ok: function () {
                                mask.show();
                                communicationService.remove(utilService.getResouceUrl("/users"), [userId]).promise().always(function (response) {
                                    if (!exception.check(response)) {
                                        mask.hide();
                                        return;
                                    }
                                    __Props.pageIndex = 1;
                                    __detectTableData(null, function() {
                                        mask.hide();
                                        $scope.datasTable.currPage = {pageIndex: 1};
                                        message.success(appUtils.getString("common_term_operation_success_label"));
                                    });
                                });
                            }
                        });
                    }
                }, {
                    id: "iconBtnLock",
                    template: "<div class='iconbutton-lock' title='" + appUtils.getString("common_term_lock_button") + "'></div>",
                    clickActive: function () {
                        if (!$scope.enableLock) {
                            return;
                        }
                        var userId = _getOpID();
                        message.warn({
                            content: appUtils.getString("user_term_users_operations_lock_confirm_msg"),
                            ok: function () {
                                mask.show();
                                communicationService.put(utilService.getResouceUrl("/users/action/lockUser"), [userId]).promise()
                                    .always(function (response) {
                                        if (!exception.check(response)) {
                                        	mask.hide();
                                            return;
                                        }
                                        __detectTableData(null, function() {
                                            mask.hide();
                                            message.success(appUtils.getString("common_term_operation_success_label"));
                                        });
                                });
                            }
                        });
                    }
                }, {
                    id: "iconBtnUnlock",
                    template: "<div class='iconbutton-unlock'  title='" + appUtils.getString("common_term_unlock_button") + "'></div>",
                    clickActive: function () {
                        if (!$scope.enableUnLock) {
                            return;
                        }

                        var userId = _getOpID();
                        message.warn({
                            content: appUtils.getString("user_term_users_operations_unlock_confirm_msg"),
                            ok: function () {
                                mask.show();
                                communicationService.put(utilService.getResouceUrl("/users/action/unlockUser"), [userId]).promise()
                                    .always(function (response) {
                                        if (!exception.check(response)) {
                                            mask.hide();
                                            return;
                                        }
                                        __detectTableData(null, function() {
                                            mask.hide();
                                            message.success(appUtils.getString("common_term_operation_success_label"));
                                        });
                                });
                            }
                        });
                    }
                }];

                $scope.datasTable = {
                    id: "datasTable",
                    paginationStyle:"full_numbers",
                    operateButtonCount: 1,
                    buttonContainerPosition: "right",
                    columns: [{
                        "sTitle": "userId",
                            "mData": "userId",
                            "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("user_term_username_label"),
                            "mData": "userName"
                    }, {
                        "sTitle": appUtils.getString("user_term_status_label"),
                            "mData": "isLock",
                            "bVisible": true,
                            "bSortable":false
                    }, {
                        "sTitle": appUtils.getString("user_term_des_label"),
                            "mData": "description",
                            "bSortable":false
                    },{
                        "sTitle": appUtils.getString("setting.admin.term.sessionLimit"),
                        "mData": "sessionLimit",
                        "bSortable":false
                    }],
                    displayLength: __Props.pageSize,
                    totalRecords: 0,
                    callback: function (evtObj) {
                        __Props.pageIndex = evtObj.currentPage;
                        mask.show();
                        var url = appUtils.stringFormat("/users?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}",
                                __Props.pageSize, __Props.pageIndex - 1, __Props.orderBy, __Props.orderType);
                        __detectTableData(url, function() {
                            mask.hide();
                        });
                    },
                    sortCallback: function(th, sortObj) {
                        __Props.orderBy = $scope.datasTable.columns[sortObj[0][0]].mData;
                        __Props.orderType = sortObj[0][1];
                        mask.show();
                        var url = appUtils.stringFormat("/users?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}",
                                __Props.pageSize, __Props.pageIndex - 1, __Props.orderBy, __Props.orderType);
                        __detectTableData(url, function() {
                           mask.hide();
                        });
                    },
                    renderRow: function (nRow, aData, iDataIndex) {
                        var lockStatus = aData["isLock"];
                        if (lockStatus == "false") {
                            $('td:eq(1)', nRow).html("<span class='_normal'>" + appUtils.getString("user_term_status_normal") + "</span>");
                        } else {
                            $('td:eq(1)', nRow).html("<span class='_critical'>" + appUtils.getString("user_term_status_locked") + "</span>");
                        };
                        if(aData['syncAdmin']){
                            $('td:eq(2)', nRow).html(aData['description'] == "user_syncAdmin_description_label" ? appUtils.getString("user_syncAdmin_description_label") : aData['description']);
                        }
                    },

                    data: [],
                    opAreaConfig: [],
                    cellClickActive: function (e, param) {
                        $scope.current = param;
                    },
                    hoverActive: function (e, param) {
                        if (!__Props.curUser.isAdmin && !__Props.curUser.isAdministrator) {
                            return;
                        }
                        if (__Props.curUser.isAdmin == "1") {
                            if (param.userId == "1") {
                                $("#iconBtnEditPwd div").removeClass("iconbutton-password").addClass("iconbutton-password-disabled");
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#iconBtnLock div").removeClass("iconbutton-lock").addClass("iconbutton-lock-disabled");
                                $("#iconBtnUnlock div").removeClass("iconbutton-unlock").addClass("iconbutton-unlock-disabled");
                                $scope.enableEditPwd = false;
                                $scope.enableEdit = true;
                                $scope.enableDel = false;
                                $scope.enableLock = false;
                                $scope.enableUnLock = false;
                                return;
                            }
                            else if (param.syncAdmin) {
                                $("#iconBtnEditPwd div").removeClass("iconbutton-password-disabled").addClass("iconbutton-password");
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#iconBtnLock div").removeClass("iconbutton-lock-disabled").addClass("iconbutton-lock");
                                $("#iconBtnUnlock div").removeClass("iconbutton-unlock-disabled").addClass("iconbutton-unlock");
                                $scope.enableEditPwd = true;
                                $scope.enableEdit = true;
                                $scope.enableDel = false;
                                $scope.enableLock = true;
                                $scope.enableUnLock = true;
                            } else {
                                $("#iconBtnEditPwd div").removeClass("iconbutton-password-disabled").addClass("iconbutton-password");
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#iconBtnLock div").removeClass("iconbutton-lock-disabled").addClass("iconbutton-lock");
                                $("#iconBtnUnlock div").removeClass("iconbutton-unlock-disabled").addClass("iconbutton-unlock");
                                $scope.enableDel = true;
                                $scope.enableLock = true;
                                $scope.enableUnLock = true;
                                $scope.enableEdit = true;
                                $scope.enableEditPwd = true;
                            }
                        } else if (__Props.curUser.isAdministrator) {
                            if (param.isAdmin || param.isAdministrator) {
                                $("#iconBtnEditPwd div").removeClass("iconbutton-password").addClass("iconbutton-password-disabled");
                                $("#iconBtnEdit div").removeClass("iconbutton-edit").addClass("iconbutton-edit-disabled");
                                $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#iconBtnLock div").removeClass("iconbutton-lock").addClass("iconbutton-lock-disabled");
                                $("#iconBtnUnlock div").removeClass("iconbutton-unlock").addClass("iconbutton-unlock-disabled");
                                $scope.enableEditPwd = false;
                                $scope.enableEdit = false;
                                $scope.enableDel = false;
                                $scope.enableLock = false;
                                $scope.enableUnLock = false;
                                if(param.syncAdmin){
                                    $("#iconBtnEditPwd div").removeClass("iconbutton-password-disabled").addClass("iconbutton-password");
                                    $scope.enableEditPwd = true;
                                    if ($scope.isOCAdmin) {
                                        $scope.enableEditPwd = false;
                                        $("#iconBtnEditPwd div").removeClass("iconbutton-password").addClass("iconbutton-password-disabled");
                                    }
                                    if (param.isLock == "false") {
                                        $("#iconBtnLock div").addClass("iconbutton-lock").removeClass("iconbutton-lock-disabled");
                                        $("#iconBtnUnlock div").removeClass("iconbutton-unlock").addClass("iconbutton-unlock-disabled");
                                        $scope.enableLock = true;
                                        $scope.enableUnLock = false;
                                    } else {
                                        $("#iconBtnLock div").removeClass("iconbutton-lock").addClass("iconbutton-lock-disabled");
                                        $("#iconBtnUnlock div").addClass("iconbutton-unlock").removeClass("iconbutton-unlock-disabled");
                                        $scope.enableLock = false;
                                        $scope.enableUnLock = true;
                                    }
                                };
                                return;
                            }  else {
                                $("#iconBtnEditPwd div").removeClass("iconbutton-password-disabled").addClass("iconbutton-password");
                                $("#iconBtnEdit div").removeClass("iconbutton-edit-disabled").addClass("iconbutton-edit");
                                $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#iconBtnLock div").removeClass("iconbutton-lock-disabled").addClass("iconbutton-lock");
                                $("#iconBtnUnlock div").removeClass("iconbutton-unlock-disabled").addClass("iconbutton-unlock");
                                $scope.enableDel = true;
                                $scope.enableLock = true;
                                $scope.enableUnLock = true;
                                $scope.enableEdit = true;
                                $scope.enableEditPwd = true;
                            }
                        }
                        if (param.isLock == "false") {
                            $("#iconBtnLock div").addClass("iconbutton-lock").removeClass("iconbutton-lock-disabled");
                            $("#iconBtnUnlock div").removeClass("iconbutton-unlock").addClass("iconbutton-unlock-disabled");
                            $scope.enableLock = true;
                            $scope.enableUnLock = false;
                        } else {
                            $("#iconBtnLock div").removeClass("iconbutton-lock").addClass("iconbutton-lock-disabled");
                            $("#iconBtnUnlock div").addClass("iconbutton-unlock").removeClass("iconbutton-unlock-disabled");
                            $scope.enableLock = false;
                            $scope.enableUnLock = true;
                        }
                    }

                };

                $scope.refreshDataTable = function (callback) {
                    mask.show();
                    var url = appUtils.stringFormat("/users?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}",
                            __Props.pageSize, 0, __Props.orderBy, __Props.orderType);
                    __detectTableData(url, function() {
                        $scope.datasTable.currPage = {"pageIndex": 1};
                        __Props.pageIndex = 1;
                        mask.hide();
                    });
                }
                $scope.editAction = function () {
                    var id = _getOpID();
                    $state.go("user.userEdit", { id: id });
                };

                var _getOpID = function () {
                    return $("#datasTable").widget().getHoverData()[0].userId;
                };
                var getSyncAdmin = function(){
                    return $("#datasTable").widget().getHoverData()[0].syncAdmin;
                }

                var __getCurrentUser = function() {
                    __Props.curUser = appUtils.getCurrentUser();
                    var config = angular.copy(opConfig);
                    if (!__Props.curUser.isAdministrator && !__Props.curUser.isAdmin) {
                        config = [];
                    }
                    $scope.datasTable.opAreaConfig = config;
                    return appUtils.getCurrentUser();
                }

                var __detectTableData = function(url, callback) {
                    url = url || appUtils.stringFormat("/users?pageSize={0}&startPage={1}&orderBy={2}&orderType={3}",
                            __Props.pageSize, __Props.pageIndex - 1, __Props.orderBy, __Props.orderType);
                    communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                        if (!exception.check(result)) {
                            mask.hide();
                            return;
                        }
                        var arr = [];
                        _.each(result.userList, function (d) {
                            d.userName = $.encoder.encodeForHTML(d.userName);
                            d.description = $.encoder.encodeForHTML(d.description);
                            var tmo = _.pick(d, "userId", "userName", "isLock", "description", "isAdmin", "isAdministrator","syncAdmin");
                            tmo.isAdmin = tmo.isAdmin == "true";
                            tmo.isAdministrator = tmo.isAdministrator == "true";
                            //最大会话连接数
                            if(d.sessionControl){
                                tmo.sessionLimit = d.sessionLimit;
                            }else{
                                tmo.sessionLimit = '--';
                            }

                            arr.push(tmo);
                        });
                        if (result["total"] > __Props.pageSize) {
                            $scope.datasTable.paging = true;
                        } else {
                            $scope.datasTable.paging = false;
                            $scope.datasTable.currPage = {pageIndex: 1};
                            __Props.pageIndex = 1;
                        }
                        $scope.datasTable.data = arr;
                        $scope.datasTable.totalRecords = result["total"];
                        if (typeof callback === "function") {
                            (callback)();
                        }
                        $scope.$apply();
                    });
                };

                __getCurrentUser();
                $scope.refreshDataTable();
                $scope.p_create = appUtils.checkRight("lego.sys.operatorMgr.operator.add");

                var __successFn = function (response) {
                    if (response && response.status === 200) {
                        $("#userAuthWin").widget().destroy();
                        __editPwdWin();
                    } else {
                        var PERMANENT_LOCK_ERROR_COE = 293;
                        var TEMP_LOCK_ERROR_COE = 284;
                        if (response && response.status === 500 &&
                            (response.responseJSON.errorCode === PERMANENT_LOCK_ERROR_COE || response.responseJSON.errorCode === TEMP_LOCK_ERROR_COE)) {
                            __forwardToLoginPage();
                        } else {
                            message.error(appUtils.getString('user_term_user_auth_fail_tip'));
                        }
                    }
                }

                var __userAuthSubmit = function () {
                    if (!UnifyValid.FormValid($("#userauth-content"), {focusInvalid: true})) {
                        return;
                    }
                    var paraObj = {
                        userName: __getCurrentUser().userName,
                        pwd: $("#userPass").widget().getValue(),
                    };
                    communicationService.post(utilService.getResouceUrl("/auth/adminAuth"), paraObj).promise().always(__successFn);
                }
                var __editPwdWin = function() {
                    var userName = $('#datasTable').widget().getHoverData()[0].userName;
                    var winOps = {
                        "winId": "modifyPwdWin",
                        "helpId" : "resetPwdWin",
                        "data": {userId: _getOpID(), userName: userName, syncAdminFlag: getSyncAdmin()},
                        "title": appUtils.getString("user_term_editauth_win_title"),
                        "width": constsService.MODIFY_PWD_WIN.width,
                        "height": constsService.MODIFY_PWD_WIN.height,
                        "content-type": "url",
                        "content": constsService.PASSWORD_EDIT_URL,
                        "buttons": null,
                        "maximizable": false,
                        "minimizable": false,
                        "close": function () {
                            $("#modifyPwdWin").widget().destroy();
                            __detectTableData();
                        }
                    };
                    var win = new Window(winOps);
                    win.show();
                }

                var __forwardToLoginPage = function() {
                    communicationService.post(utilService.getResouceUrl("/ws/auth/logout"), {timeOut:false}).promise().always(function(result) {
                        var rootPath = utilService.getRootPath();
                        window.location.href = rootPath + "/src/login/view/login.html"
                    });
                };
            }]

            var module = angular.module('recoverydirector.setting.config');
            module.tinyController('settings.user.ctrl', ctrler);
            return module;
    })
