define(["tiny-common/UnifyValid"],

    function (UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",

            function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils) {

                var minLen = 0 , pwdComplex = 0;
                var paramId = $stateParams.id;
                if(paramId.indexOf("syncAdmin") != -1){
                    paramId = paramId.substring(10);
                };
                $scope.btnOk = {
                    id: "btnCreateOk",
                    text: appUtils.getString("common_term_confirm_button"),
                    click: function () {
                        var validRes = UnifyValid.FormValid($('#form'), {focusInvalid: true});

                        if (!validRes) {
                            return;
                        }

                        var param = {};

                        param.userName = $('#name').widget().getValue();
                        param.userPassword = $('#password').widget().getValue();
                        param.description = $('#description').widget().getValue();
                        param.userAclSet = [];
                        param.rolesIdsSet = [];

                        param.confirmPassword = $('#repassword').widget().getValue();
                        param.bizObjs = _.keys(RoleParams.bussObjs);
                        param.resIds = _.keys(RoleParams.resObjs);
                        param.rolesIdsSet = RoleParams.rolesIdsSet;

                        //最大会话连接数
                        param.sessionControl = $scope.model.maxSessions.tswitch.on;
                        if(param.sessionControl){
                            param.sessionLimit = Number($scope.model.maxSessions.textbox.value);
                        }else{
                            param.sessionLimit = 0;
                        }

                        if (!RoleParams.ipRanges.length) {
                            param.userAclSet.push({
                                startIpStr: "1.0.0.1",
                                endIpStr: "223.255.255.255",
                                des: ""
                            });
                        } else {
                            _.each(RoleParams.ipRanges, function (ele, index) {
                                param.userAclSet.push(_.pick(ele, "startIpStr", "endIpStr", "des"));
                            });
                        }

                        if ($stateParams.id) {
                            delete param.userName;
                            delete param.passwordModel;
                            delete param.userPassword;
                            delete param.confirmPassword;

                            if (!param.rolesIdsSet.length && $scope.notAdmin && !$scope.isSyncAdmin) {
                                message.error(appUtils.getString("user_term_users_operations_empty_selection_msg"));
                                return;
                            }

                            mask.show();
                            communicationService.put(utilService.getResouceUrl("/users/" + paramId), param).promise().always(function (result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            $state.go("settings.userList");
                                        }
                                    })
                                }
                            });
                            return;
                        }

                        if (param.passwordModel === "1") {
                            param.userPassword = "";
                            param.confirmPassword = "";
                        }

                        if (!param.rolesIdsSet.length) {
                            message.error(appUtils.getString("user_term_users_operations_empty_selection_msg"));
                            return;
                        }

                        mask.show();
                        communicationService.post(utilService.getResouceUrl("/users"), param).promise().always(function (result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $state.go("settings.userList");
                                    }
                                })
                            }
                        });

                    }
                };

                $scope.btnCancel = {
                    id: "btnCreateCancel",
                    text: appUtils.getString("common_term_cancel_button"),
                    click: function () {
                        $state.go("settings.userList");
                    }
                };

                $scope.model = {
                    labels: {
                        name: appUtils.getString("user_term_username_label") + ":",
                        description: appUtils.getString("common_term_description_column") + ":",
                        password: appUtils.getString("user_term_userpwd_label") + ":",
                        repassword: appUtils.getStringWithColon("user_term_userrepwd_label"),
                        advanced: appUtils.getString("common_term_advance_button"),
                        right: appUtils.getStringWithColon("role_term_right_label"),
                        rightCls : "tabLabel"
                    },
                    tbName: {
                        id: "name",
                        width: constsService.DESCR_WIDTH,
                        validate: constsService.VALID.ROLE_NAME_REQUIRED
                    },
                    tbDescription: {
                    	id : "description",
						value : "",
                        labelcls: "label-middle",
                        type : "multi",
						height:constsService.DESCR_HEIGHT,
		                width:constsService.DESCR_WIDTH,
						validate : constsService.VALID.DES_REMARK_HUNDRED
                    },
                    password: {
                        id: "password",
                        width: constsService.DESCR_WIDTH,
                        type: "password",
                        extendFunction: ["checkAuthPwd"],
                        validate: "checkAuthPwd : extend function;"
                    },
                    repassword: {
                        id: "repassword",
                        width: constsService.DESCR_WIDTH,
                        type: "password",
                        extendFunction: ["checkRepeateAuthPwd"],
                        validate: "checkRepeateAuthPwd : extend function;"
                    },
                    maxSessions: {
                        label: appUtils.getStringWithColon("setting.admin.term.sessionLimit"),
                        maxSecurityTips: appUtils.getString("setting.admin.term.sessionLimit.tips"),
                        tswitch: {
                            id: "sessionSwitch",
                            items: [{label : appUtils.getString("common_term_enable_label"), value : "on"},
                                     {label : appUtils.getString("common_term_disable_label"), value : "off"}],
                            standard: true,
                            selected: "on",
                            on: true,
                            change : function() {
                                this.on = !this.on;
                                if(!this.on){
                                    $scope.model.maxSessions.textbox.value = '';
                                }else{
                                    $scope.model.maxSessions.textbox.value = 5;
                                }
                            }
                        },
                        textbox: {
                            id: "sessionNumber",
                            value: 5,
                            afterText: "(1-8)",
                            promptText: appUtils.getString("setting.admin.term.sessionLimit.NBIRolePrompt"),
                            width: "165px",
                            validate: [{
                                validFn: "rangeValue",
                                params: [1, 8],
                            }, {
                                validFn: "required",
                            }, {
                                validFn: "integer",
                            }
                            ]
                        }
                    },
                    credentialsContainerClass: "configform-subcontainer"
                };
                if ($stateParams.id) {
                    $scope.model.isAdd = false;
                    $scope.configformTitle = appUtils.getString("user_term_edit_title");
                } else {
                    $scope.model.isAdd = true;
                    $scope.configformTitle = appUtils.getString("user_term_add_title");
                }

                UnifyValid.reqiredExt = function () {
                    var id = $("#parentId").widget().getSelectedId();
                    if (!id || id == "") {
                        return false;
                    }
                    return true;
                }

                UnifyValid.checkAuthPwd = function () {

					var userName = $("#name").widget().getValue();
					var authPwd = $.trim($("#password").widget().getValue());
	                var reverseName = userName.split('').reverse();
	                reverseName = reverseName.join('');
	                var isSameWithName = authPwd == userName || authPwd == reverseName;

	                if (!authPwd) {
	                    return appUtils.getString("common_term_empty_label");
	                }

	                if (!appUtils.checkUserPwd(authPwd, minLen, pwdComplex, 64, true) || isSameWithName) {
	                	var tipContent = appUtils.getString("Login_Message_Password_Complex", $.trim(minLen), 64, "");
                        if (pwdComplex == 2) {
                            tipContent = appUtils.getString("Login_Message_Password_Complex",
                                    $.trim(minLen), 64,
                                    appUtils.getString("Login_Message_Password_Complex_Special"));
                        }

						return tipContent;
					}
					return "";
                };

                UnifyValid.checkRepeateAuthPwd = function () {
                	var authPwd = $.trim($("#password").widget().getValue());
                	var reAuthPwd = $.trim($("#repassword").widget().getValue());

                	if (authPwd != reAuthPwd) {
                		return appUtils.getString('Login_Message_Password_Different');
                	}
                	return "";
                };

                var RoleParams = {
                    rolesIdsSet: [],
                    resObjs: {},
                    bussObjs: {},
                    ipRanges: []
                };

                var eChangeRole = $scope.$on('change-role', function (evtObj, role) {
                    RoleParams.rolesIdsSet = role;
                });
                var eChangeMo = $scope.$on('change-mo', function (evtObj, mo) {
                    if (!mo) {
                        return;
                    }
                    if (!mo.checked && RoleParams.resObjs[mo.id]) {
                        delete RoleParams.resObjs[mo.id];
                        return;
                    }
                    if (mo.checked && !RoleParams.resObjs[mo.id]) {
                        RoleParams.resObjs[mo.id] = true;
                        return;
                    }
                });
                var eChangeBo = $scope.$on('change-bo', function (evtObj, bo) {
                    if (!bo) {
                        return;
                    }

                    if (!bo.checked && RoleParams.bussObjs[bo.id]) {
                        delete RoleParams.bussObjs[bo.id];
                        return;
                    }

                    if (bo.checked && !RoleParams.bussObjs[bo.id]) {
                        RoleParams.bussObjs[bo.id] = true;
                        return;
                    }
                });
                var eChangeIp = $scope.$on('change-ip', function (event, ipRanges) {
                    RoleParams.ipRanges = ipRanges;
                });
                var eNotify = $scope.$on('notify-selected', function (evtObj, tab) {
                    if (!tab) {
                        return;
                    }

                    switch (tab) {
                        case 'roles':
                            $scope.$broadcast('select-role', RoleParams.rolesIdsSet);
                            break;
                        case 'mo':
                            $scope.$broadcast('select-mo', RoleParams.resObjs);
                            break;
                        case 'ip':
                            $scope.$broadcast('select-ip', RoleParams.ipRanges);
                            break;
                        case 'bo':
                            $scope.$broadcast('select-bo', RoleParams.bussObjs);
                            break;
                        default:
                            break;
                    }
                });

                var __init = function () {
                    if (!$.trim($stateParams.id)) {
                        communicationService.get(utilService.getResouceUrl("/securitypolicy")).promise().always(function (response) {
                            if (exception.check(response)) {
                                minLen = response.passLenVal || 8;
                                pwdComplex = response.passComplexVal || 2;
                            }
                        });
                        return;
                    }

                    communicationService.get(utilService.getResouceUrl("/users/" + paramId)).promise().always(function (result) {
                        if (!exception.check(result)) {
                            return;
                        }

                        $('#name').widget().option('value', result.userName);
                        $('#name').widget().option('disable', true);
                        $('#password').widget().option('value', "********");
                        $('#repassword').widget().option('value', "********");
                        $('#description').widget().option('value', result.description == "user_syncAdmin_description_label" ? appUtils.getString(result.description) : result.description);

                        if(!$scope.model.isAdd){
                            $scope.model.maxSessions.tswitch.on = result.sessionControl;
                            $scope.model.maxSessions.tswitch.selected = result.sessionControl ? "on" : "off";
                            $scope.model.maxSessions.textbox.value = result.sessionLimit || '';
                            $scope.$apply();
                        }

                        _.each(result.rolesIdsSet, function (role) {
                            RoleParams.rolesIdsSet.push(role);
                        })

                        _.each(result.bizObjs, function (bo) {
                            if (!$.trim(bo)) {
                                return;
                            }
                            bo = bo.toString();
                            if (!RoleParams.bussObjs[bo]) {
                                RoleParams.bussObjs[bo] = true;
                            }
                        });

                        _.each(result.resIds, function (mo) {
                            if (!$.trim(mo)) {
                                return;
                            }

                            mo = mo.toString();

                            if (!RoleParams.resObjs[mo]) {
                                RoleParams.resObjs[mo] = true;
                            }
                        });

                        _.each(result.userAclSet, function (ipRange) {
                            RoleParams.ipRanges.push({
                                startIpStr: ipRange.startIpStr,
                                endIpStr: ipRange.endIpStr,
                                des: ipRange.des
                            })
                        });

                    });
                }

                $scope.notAdmin = $stateParams.id != "1";
                $scope.isSyncAdmin = $stateParams.id.indexOf("syncAdmin") != -1;
                if ($scope.isSyncAdmin) {
                    $scope.plugins=[{
                        "openState": "settings.userEdit.ipRange",
                        "id": "ipRange",
                        "name": appUtils.getString("user_term_iprange_title")
                    }]
                } else {
                    $scope.plugins = [{
                        "openState": "settings.userEdit.userGroup",
                        "id": "userGroup",
                        "name": appUtils.getString("role_term_rolelist_title")
                    }, {
                        "openState": "settings.userEdit.resource",
                        "id": "resource",
                        "name": appUtils.getString("common_term_source_label")
                    }, {
                        "openState": "settings.userEdit.ipRange",
                        "id": "ipRange",
                        "name": appUtils.getString("user_term_iprange_title")
                    }, {
                        "openState": "settings.userEdit.bo",
                        "id": "bo",
                        "name": appUtils.getString("user_term_bo_title")
                    }];
                };
                __init();

            }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.userEdit.ctrl', ctrler);
        return module;
    })
