define([],

    function () {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
        function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService,appUtils) {
            var _orderBy = "iRoleID",
                _orderType = "asc",
                _startPage = 0,
                _pageSize = 10;
            $scope.datasTable = {
                id: "datasTable",
                columns: [{
                    "sTitle": "roleId",
                        "mData": "roleId",
                        "bVisible": false
                }, {
                    "sTitle": appUtils.getString("role_term_name_label"),
                        "mData": "roleName"
                }, {
                    "sTitle": appUtils.getString("user_term_des_label"),
                        "mData": "roleDes"
                }],
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                enablePagination: false,
                totalRecords: 0,
                callback: function (evtObj) {
                    var start = (evtObj.currentPage - 1) * evtObj.displayLength;
                    var end = start + evtObj.displayLength;
                    var option = {
                        range: "[" + start + "-" + end + "]"
                    }
                    if ($scope.datasTable.filter) {
                        option.filter = $scope.datasTable.filter;
                    }
                    _startPage = evtObj.currentPage - 1;
                    _pageSize = evtObj.displayLength;
                    communicationService.get(utilService.getResouceUrl("/roles/?orderBy=" + _orderBy + "&orderType=" + _orderType
                        + "&startPage=" + _startPage + "&pageSize=" + _pageSize)).promise().always(_updateUI);
                },
                sortCallback: function(nNode, sortArr){
                    _orderBy = $scope.datasTable.columns[sortArr[0][0] - 1].mData;
                    _orderType = sortArr[0][1];
                    communicationService.get(utilService.getResouceUrl("/roles/?orderBy=" + _orderBy + "&orderType=" + _orderType
                        + "&startPage=" + _startPage + "&pageSize=" + _pageSize)).promise().always(_updateUI);
                },
                renderRow: function (nRow, aData, iDataIndex) {},
                data: [],
                cellClickActive: function (evtObj, oData) {
                    var checkItems = $('#datasTable').widget().getTableCheckedItems();
                    if (checkItems) {
                        var roles = [];
                        _.each(checkItems, function (role) {
                            roles.push(role['roleId'])
                        })
                        $scope.$emit('change-role', roles);
                    } else {
                        $scope.$emit('change-role', [])
                    }
                },
                checkAll: function (checked, evtObj) {
                    if (checked) {
                        var roles = [];
                        _.each($scope.datasTable.data, function (role) {
                            role['roleId'] != "-1" && roles.push(role['roleId']);
                        });
                        $scope.$emit('change-role', roles);
                    } else {
                        $scope.$emit('change-role', [])
                    }
                }
            };

            var evtSelectRole = $scope.$on('select-role', function (evtObj, roles) {
                if (!roles || !roles.length) {
                    return;
                }
                for (var i = 0; i < roles.length; i++) {
                    $('#datasTable').widget().setSelectedRow('roleId', roles[i]);
                }
                // call private method for init title checkbox
                $('#datasTable').widget()._doAllCheckState();
            });

            $scope.$on('$destroy', evtSelectRole);
            var _updateUI = function (result) {
                if (exception.check(result)) {
                    var arr = [];
                    _.each(result.roleList, function (d) {
                        var tmo = _.pick(d, "roleId", "roleName", "roleDes");
                        if (!appUtils.getCurrentUser().isAdmin && tmo.roleName == "administrator") {
                            return;
                        }
                        tmo.roleName = $.encoder.encodeForHTML(tmo.roleName);
                        tmo.roleDes = $.encoder.encodeForHTML(tmo.roleDes);
                        //OC admin用户不能勾选
                        tmo.roleId == "-1" && (tmo.tinyCheckDisabled = true);
                        arr.push(tmo);
                    });
                    $scope.datasTable.data = arr;
                    $scope.datasTable.totalRecords = parseInt(result.total, 10);
                    $scope.datasTable.enablePagination = parseInt(result.total, 10) > 10;
                    $scope.$apply();
                }
                mask.hide();

                // notify parent scope send me last selected roles
                var timeoutInitRoles = setTimeout(function() {
                    $scope.$emit('notify-selected', 'roles');
                    clearTimeout(timeoutInitRoles);
                }, 200);
            };

            communicationService.get(utilService.getResouceUrl("/roles")).promise().always(_updateUI);

        }]

        var module = angular.module('recoverydirector.setting.config');
        module.tinyController('settings.userRole.ctrl', ctrler);
        return module;
    }
)
