define(["lazy-load/lazyLoad", "ui-router/angular-ui-router.min", "tiny-extra-directives/FloatingPanel", "tiny-extra-directives/DualSelectBox"],
    function(lazyLoadModule, router) {
        "use strict";

        var routerConfig = [{
            name: "site",
            url: "/site",
            breadcrumbs: {
                name: "disaster_recovery_environment"
            },
            templateUrl: "app/business/recoverydirector/site/views/main.html",
            controller: "site.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/siteCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function(infoTransferredService) {
                infoTransferredService.remove("resource", "currentNode");
                infoTransferredService.remove("server", "currentServer");
                infoTransferredService.remove("site", "currentSite");
                infoTransferredService.remove("resourceMapping", "add");
            },
            onEnter: function() {}
        }, {
            name: "site.siteList",
            url: "/siteList/{serverUuid}/{randomId}",
            templateUrl: "app/business/recoverydirector/site/views/siteList.html",
            controller: "site.siteList.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/siteListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.home",
            url: "/home/{siteId}/{randomId}",
            templateUrl: "app/business/recoverydirector/site/views/siteHome.html",
            controller: "site.home.ctrl",
            scripts: {
                'controllers': [
                    'app/business/recoverydirector/site/controllers/siteHomeCtrl',
                    'app/business/recoverydirector/site/controllers/poolCirqueTempleteCtrl'
                ],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.storage",
            url: "/storage/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/storage/storageList.html",
            controller: "site.storage.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/storage/storageListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.storage.resourcePool",
            url: "/resourcePool",
            templateUrl: "app/business/recoverydirector/site/views/resource/storage/resourcePool.html",
            controller: "site.storage.resourcePool.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/storage/resourcePoolCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.storage.backupPool",
            url: "/backupPool",
            templateUrl: "app/business/recoverydirector/site/views/resource/storage/backupStoragePool.html",
            controller: "site.storage.backupPool.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/storage/backupStoragePoolCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.storage.backupRespo",
            url: "/backupRespo",
            templateUrl: "app/business/recoverydirector/site/views/resource/storage/backupStorageRespo.html",
            controller: "site.storage.backupRespo.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/storage/backupStorageRespoCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.discovery",
            url: "/discovery/{type}/{siteId}",
            stateParamsKey: "type",
            templateUrl: "app/business/recoverydirector/site/views/resource/storage/discovery.html",
            controller: "site.storage.discovery.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/storage/discoveryCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud",
            url: "/cloud/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/cloudList.html",
            controller: "site.cloud.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/cloudListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.vmList",
            url: "/vmList",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/rm/vmList.html",
            controller: "site.cloud.vm.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/rm/vmListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.fcList",
            url: "/fcList",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/rm/fcList.html",
            controller: "site.cloud.fc.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/rm/fcListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloudDiscovery",
            url: "/cloudDiscovery/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/discovery.html",
            controller: "site.cloud.discovery.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/discoveryCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.rm",
            url: "/rm/{type}",
            stateParamsKey: "type",
            templateUrl: "app/business/recoverydirector/site/views/resource/base/rm/rmList.html",
            controller: "site.cloud.rm.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/base/rm/rmListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.addRMWizard",
            url: "/addRMWizard/{type}",
            stateParamsKey: "type",
            template: "<tiny-wizard options='addResourceMapping'></tiny-wizard><style>.configform-title{font-size : 20px !important;}</style>",
            controller: "site.resourceMapping.addWizard.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/base/rm/add/addResourceMappingCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.vrg",
            url: "/vrg/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/vrg/vrgList.html",
            controller: "site.vrg.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/vrg/vrgListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.pairInfo",
            url: "/pairInfo",
            templateUrl: "app/business/recoverydirector/site/views/resource/vrg/pairInfo.html",
            controller: "site.vrg.pairInfo.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/vrg/pairInfoCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.drSetting",
            url: "/{type}",
            templateUrl: "app/business/recoverydirector/site/views/resource/vrg/drSites.html",
            controller: "site.vrg.drSites.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/vrg/drSitesCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.region",
            url: "/region",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/region.html",
            controller: "site.openStack.region.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/regionCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.openStackVmList",
            url: "/openStackVmList",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/openStackVmList.html",
            controller: "site.openStack.region.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/openStackVmListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.relationVM",
            url: "/relationVM",
            templateUrl: "app/business/recoverydirector/site/views/resource/vrg/protectVMS/protectVMS.html",
            controller: "site.vrg.relationVM.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/vrg/protectVMS/protectVMSCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.vmware",
            url: "/vmware/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/vmware/vmwareList.html",
            controller: "site.vmware.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/vmware/vmwareListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.vmware.vmList",
            url: "/vmList",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/rm/vmList.html",
            controller: "site.cloud.vm.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/rm/vmListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloud.openStackAzPairList",
            url: "/{type}",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/openStackPairList.html",
            controller: "site.openStack.pairList.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/openStackPairListCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.addPair",
            url: "/addPair/{pairType}/{volTypePairId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/cloud/addOpenstackPair.html",
            controller: "site.openstack.addpair.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/cloud/addOpenstackPairCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.backupRespo",
            url: "/backupRespo/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/respo/backupRespo.html",
            controller: "site.backuprespo.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/respo/backupRespoCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }, {
            name: "site.cloudServer",
            url: "/cloudServer/{siteId}",
            templateUrl: "app/business/recoverydirector/site/views/resource/server/cloudServer.html",
            controller: "site.cloudserver.ctrl",
            scripts: {
                'controllers': ['app/business/recoverydirector/site/controllers/resource/server/cloudServerCtrl'],
                'services': [],
                'js': []
            },
            resolve: {},
            onExit: function() {},
            onEnter: function() {}
        }]

        var module = angular.module("recoverydirector.site.config", ["ui.router"]);
        module = lazyLoadModule.makeLazy(module);
        module.tinyStateConfig({ stateConfig: routerConfig });
        return module;
    });