define([], function() {
    "use strict";
    var ctrl = ["$scope", "$state", "constsService", "appUtils", "$sce", "message", "restService", "infoTransferredService", "$timeout",
        function($scope, $state, constsService, appUtils, $sce, message, restService, infoTransferredService, $timeout) {
            var data = $("#" + constsService.SITE_ADD_EDIT.winId).widget().option("data");
            $scope.isCreateSite = data.isCreateSite;
            $scope.model = {
                labels: {
                    name: appUtils.getStringWithColon("common_term_name_label"),
                    des: appUtils.getStringWithColon("common_term_description_label"),
                    type: appUtils.getString("site_add_iscloudsite_lable"),
                    brand: appUtils.getStringWithColon("site_create_brand_label"),
                    ak: appUtils.getStringWithColon("site_create_ak_label"),
                    sk: appUtils.getStringWithColon("site_create_sk_label"),
                    skTip: $sce.trustAsHtml(appUtils.getString("site_create_sktip_label")),
                    area: appUtils.getStringWithColon("site_create_area_label"),
                    areaTip: appUtils.getString("site_create_areatip_label"),
                    project: appUtils.getStringWithColon("site_create_project_label"),
                    projectTip: $sce.trustAsHtml(appUtils.getString("site_create_projecttip_label")),
                    proxy: appUtils.getStringWithColon("site_type_proxy_label"),
                    areaManagerTip: $sce.trustAsHtml(appUtils.getString("site_create_areamanager_label")),
                    class:"labels-style",
                },
                name: {
                    id: "name",
                    width: constsService.W4,
                    value: data.name,
                    disabled: +data.siteType === 1,
                    validate: constsService.VALID.NAME_REQUIRED
                },
                des: {
                    id: "description",
                    type: "multi",
                    height: constsService.DESCR_HEIGHT,
                    value: data.description,
                    width: constsService.W4,
                    labelcls: "label-middle",
                    validate: constsService.VALID.DES_REMARK
                },
                brand: {
                    display: !data.isCreateSite && data.isCloudSite,
                    value: appUtils.getString("site_brand_huawei_label"),
                },
                ak: {
                    id: "ak",
                    type: "password",
                    width: constsService.W4,
                    value: !data.isCreateSite ? "********" : "",
                    display: !data.isCreateSite && data.isCloudSite,
                    disabled: +data.siteType === 1,
                    isFocusAk: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [128],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 128)
                    }],
                    focus: function() {
                        if (!this.isFocusPwd) {
                            this.isFocusPwd = true;
                            $('#ak').widget().option('value', "");
                        }
                    },
                    blur: function() {
                        var value = $("#ak").widget().getValue();
                        if (_.isEmpty(value) && !data.isCreateSite) {
                            this.isFocusPwd = false;
                            $('#ak').widget().option("value", "********");
                        }
                    },
                    contentChange: function(e, value) {
                        infoTransferredService.put("akModule", "protocalName", !_.isEmpty($.trim(value)));
                    }
                },
                sk: {
                    id: "sk",
                    type: "password",
                    width: constsService.W4,
                    value: !data.isCreateSite ? "********" : "",
                    disabled: +data.siteType === 1,
                    display: !data.isCreateSite && data.isCloudSite,
                    isFocusPwd: false,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [255],
                        errorDetail: appUtils.getString("validate_term_common_length_range_1_255_msg")
                    }],
                    focus: function() {
                        if (!this.isFocusPwd) {
                            this.isFocusPwd = true;
                            $('#sk').widget().option('value', "");
                        }
                    },
                    blur: function() {
                        var value = $("#sk").widget().getValue();
                        if (_.isEmpty(value) && !data.isCreateSite) {
                            this.isFocusPwd = false;
                            $('#sk').widget().option("value", "********");
                        }
                    },
                    contentChange: function(e, value) {
                        infoTransferredService.put("skPwdModule", "protocalPwd", !_.isEmpty($.trim(value)));
                    },
                    getAKSK:function() {
                        window.open(constsService.WEBSITE.GETAKSK, "_blank");
                    }
                },
                project: {
                    id: "project",
                    width: constsService.W4,
                    display: false,
                    value: "",
                    disabled: +data.siteType === 1,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [255],
                        errorDetail: appUtils.getString("validate_term_common_length_range_1_255_msg")
                    }],
                    getProjectId: function() {
                        window.open(constsService.WEBSITE.GETPROJECTID, "_blank");
                    }
                },
                siteType: {
                    id: "siteType",
                    display: window.isUltraVR ? false : data.isCreateSite,
                    cloudSiteChecked: false,
                    text:appUtils.getString("site_add_iscloudsite_lable"),
                    change: function(checked) {
                        $scope.model.brand.display = checked;
                        $scope.model.ak.display = checked;
                        $scope.model.sk.display = checked;
                        $scope.model.area.display = checked;
                        $scope.model.project.display = checked;
                        $scope.model.proxy.display = checked;
                        $scope.model.siteType.cloudSiteChecked = checked;
                        $scope.$apply();
                    }
                },
                area: {
                    id: "area",
                    display: !data.isCreateSite && data.isCloudSite,
                    disabled: +data.siteType === 1,
                    values: [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                    defaultId: "-1",
                    width: constsService.W4,
                    areaManager: function() {
                        $state.go("settings.area_manage");
                    },
                    openFn: function(object) {
                        restService.queryRegions([], function(datas) {
                            if (!datas.totalCount) {
                                return;
                            }

                            var vals = [{
                                selectId: "-1",
                                label: appUtils.getString("common_term_pleaseSelect_listbox")
                            }];
                            _.each(datas.records, function(v, k) {
                                v.name = (v.name === null) ? "null" :  appUtils.getString(v.name);
                                vals.push({
                                    selectId: v.uuid,
                                    label: v.name
                                })
                            });
                            $("#area").widget().option("values", vals);
                            object.open();
                        });
                    },
                    queryArea: function() {
                        var regionId = data.regionId;
                        !_.isEmpty(regionId) && "-1" != regionId && restService.queryRegion(data.regionId, function(result) {
                            $("#area").widget().option("values", [{selectId: result.uuid, label: appUtils.getString(result.name)}]);
                            $("#area").widget().opChecked(result.uuid);
                        });
                    }()
                },
                proxy: {
                    id: "proxy",
                    display: !data.isCreateSite && data.isCloudSite,
                    modifyLabel: appUtils.getString("proxy_win_create_label"),
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultId: "-1",
                    disabled: +data.siteType === 1,
                    width: constsService.W4,
                    change: function() {},
                    closeFn: function() {},
                    openFn: function(object) {
                        restService.queryProxys([], function(datas) {
                            if (!datas.totalCount) {
                                return;
                            }
                            appUtils.updateSelectValues("proxy", datas.records, "proxyId", "name",
                                appUtils.getString("common_term_pleaseSelect_listbox"));
                            object.open();
                        });
                    },
                    queryProxy: function() {
                        var proxyId = data.proxyId;
                        !_.isEmpty(proxyId) && "-1" != proxyId && restService.queryProxy(data.proxyId, function(result) {
                            appUtils.updateSelectValues("proxy", [_.extend(result, {proxyId: proxyId})], "proxyId", "name", false);
                            $("#proxy").widget().opChecked(proxyId);
                        });
                    }(),
                    create: function() {
                        var win = angular.copy(constsService.PROXY_ADD_EDIT_WIN);
                        win.title = appUtils.getString(win.title);
                        win.data = {isCreateProxy: true};
                        appUtils.showWindow(win);
                    }
                }
            };
            $timeout(function() {
                _.isFunction(data.callback) && (data.callback());
            }, 0);

            window["getSk"] = function() {
                window.open(constsService.WEBSITE.GETAKSK, "_blank");
            };
            window["getProjectId"] = function() {
                window.open(constsService.WEBSITE.GETPROJECTID, "_blank");
            };
        }
    ];
    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.addModifySiteCtrl', ctrl);
    return module;
})