define(["tiny-widgets/CirqueChart"], function(CirqueChartExt) {
    "use strict";

    var ctrl = ["$scope", "$state", "$stateParams", "$compile", "exception", "message", "mask", "appUtils", "communicationService", "constsService", "utilService", "infoTransferredService", function($scope, $state, $stateParams, $compile, exception, message, mask, appUtils, communicationService, constsService, utilService, infoTransferredService) {
        var currentSite = infoTransferredService.get("site", "currentSite");
        if (!currentSite) {
            return;
        }
        /**监听其他模块对本模块的操作通知*/
        var createRPOMeetChart = function() {
            var url = "/reports/action/getRpoMetStatisticInfo?siteId=" + currentSite.id;
            communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                if (!exception.check(result)) {
                    return;
                }
                initChar(+result.notmeetCount, +result.unknownCount, +result.meetCount);
            });
        };
        var createDonutChart = function(container, chartDatas, width, height) {
            /**chartId: 图的Id 需要唯一
             * container: 画图的容器的Id
             * chartDatas: 数据
             * width: 宽
             * height: 高
             */
            var options = {
                id: container,
                r: 65,
                height: height,
                width: width,
                strokeWidth: 12,
                showShadow: true,
                showLegend: false,
                showClickEvent: true,
                data: chartDatas

            };
            var testStatusChart = new CirqueChart(options);
            return testStatusChart;
        };

        var initChar = function(s, f, d) {

            var dataRes = [{
                value: s,
                name: appUtils.getString("home_term_RPOmet_no_tab"),
                color: "#fc5043",
                tooltip: appUtils.getString("home_term_RPOmet_no_tab"),
                capacityView: s
            }, {
                value: f,
                name: appUtils.getString("home_term_RPOmet_unknown_tab"),
                color: "#e5e5e5",
                tooltip: appUtils.getString("home_term_RPOmet_unknown_tab"),
                capacityView: f
            }, {
                value: d,
                name: appUtils.getString("home_term_RPOmet_yes_tab"),
                color: "#5ecc49",
                tooltip: appUtils.getString("home_term_RPOmet_yes_tab"),
                capacityView: d
            }];
            var tempData = [];
            tempData.push(_.min(dataRes, function(o) {
                return o.value;
            }));
            tempData.push(_.max(dataRes, function(o) {
                return o.value;
            }));
            tempData = _.union(tempData, dataRes);
            var options = {
                id: "rpoContainer",
                "r": "65",
                width: "362",
                height: "250",
                "showLegend": false,
                "strokeWidth": "15",
                "valuestyle": false,
                "percent": false,
                "data": tempData
            };

            var pool_cirque = new CirqueChartExt(options);
            pool_cirque.createLegend();
        }

        createRPOMeetChart();
    }];

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.home.poolCirqueTempleteCtrl', ctrl);
    return module;

});
