define(["tiny-common/UnifyValid", "tiny-extra-lib/jquery.base64"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService",
        "appUtils",
        "$compile",
        function($scope, $state, $stateParams, exception, message,
            communicationService, utilService, mask, constsService, appUtils, $compile) {
            var winObj = $("#modifyDevAliasWinId").widget(),
                data = winObj.option("data"),
                isVmware = data.deviceType == "ism.drm.deviceType.drvsphere.mainType";
            $scope.TIPS = appUtils.getString("res_term_alias_tips");
            $scope.isOpenStack = false;

            if (!data.isStorage) {
                var rowData = $("#datasCloudTable").widget().getHoverData()[0];
                $scope.isOpenStack = rowData.cloudType == "OpenStack";
            };

            $scope.regionTable = {
                id: "regionTable",
                data:[],
                columns: [{
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "regionName",
                    "sWidth":"60%"
                },{
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "sWidth":"28%",
                    "bSortable":false
                }],
                renderRow: function(nRow, aData, iDataIndex){
                    var optColumn = "<a href='javascript:void(0)' class='deleteRegionBtn btn-link-disable' ng-click='delete()'>" + appUtils.getString("common_term_delete_button") + "</a> ";
                    var optLink = $compile($(optColumn));
                    var optScope = $scope.$new();
                    optScope.data = aData;
                    optScope.delete = function() {
                        if($(".deleteRegionBtn").hasClass("btn-link-disable")){
                            return;
                        }
                        $("#regionTable").widget().deleteTableRow(nRow);
                    };
                    var optNode = optLink(optScope);
                    $("td:eq(1)", nRow).html(optNode);
                }
            }
            $scope.model = {
                labels: {
                    name: appUtils.getStringWithColon("common_term_name_label"),
                    authinfo: appUtils.getStringWithColon("res_term_modifyauth_label"),
                    username: appUtils.getStringWithColon("common_term_username_label"),
                    ip: appUtils.getStringWithColon("common_term_ip_column"),
                    port: appUtils.getStringWithColon("common_term_port_label"),
                    ssl: "TLS/SSL:",
                    password: appUtils.getStringWithColon("common_term_password_label"),
                    Domain: appUtils.getString("openStack_domain_title_label"),
                    https: appUtils.getString("openStack_httpsMessage_label"),
                    region: "Region:",
                    regionType: appUtils.getStringWithColon("common_term_type_label"),
                    version: appUtils.getString("common_term_version_label")
                },
                regionTex: {
                    labels: "Region:",
                    id: "regionInput",
                    width:constsService.W3,
                    validate:"required",
                    disable:true,
                    desc:appUtils.getString("common_term_openstack_add_region_refresh_desc"),
                    regionAdd: function(){
                        if($("#regionAddBtn").hasClass('iconbutton-add-disabled')){
                            return;
                        }
                        if (!UnifyValid.FormValid($("#regionArea"), {focusInvalid: true})) {
                            return;
                        };
                        var regionValue = $("#regionInput").widget().getValue();
                        var currentData = $("#regionTable").widget().option('data');
                        currentData.push({regionName:regionValue});
                        $("#regionTable").widget().option('data',currentData);
                        $(".deleteRegionBtn").removeClass('btn-link-disable').addClass("btn-link");
                        $scope.$apply();
                    },
                    tip: appUtils.getString("common_term_modifyOpenstack_tip")
                },
                name: {
                    id: "name",
                    width: constsService.W2,
                    extendFunction: ["checkDeviceName"],
                    validate: "checkDeviceName : extend function;"
                },
                authinfo: {
                    id: "authinfo",
                    items: [{
                        label: appUtils.getString("common_term_enable_label"),
                        value: "on"
                    }, {
                        label: appUtils.getString("common_term_disable_label"),
                        value: "off"
                    }],
                    standard: true,
                    change: function() {
                        var selected = $("#authinfo").widget().option("selected");
                        if (selected == "on") {

                            $scope.model.ip.disabled = true;
                            $scope.model.ip.require = false;
                            $scope.model.port.disabled = true;
                            $scope.model.port.require = false;
                            $scope.model.username.disabled = true;
                            $scope.model.username.require = false;
                            $scope.model.password.disabled = true;
                            $scope.model.password.require = false;
                            $scope.model.ssl.disabled = true;
                            $scope.model.ssl.require = false;
                            $scope.model.password.values = "********";
                            $scope.model.Domain.disabled = true;
                            $scope.model.Domain.require = false;
                            $scope.model.https.disabled = true;
                            $scope.model.https.require = false;
                            $scope.model.regionTex.disable = true;
                        }
                        if (selected == "off") {

                            $scope.model.ip.disabled = false;
                            $scope.model.ip.require = true;
                            $scope.model.port.disabled = false;
                            $scope.model.port.require = true;
                            $scope.model.username.disabled = false;
                            $scope.model.username.require = true;
                            $scope.model.password.disabled = false;
                            $scope.model.password.require = true;
                            $scope.model.ssl.disabled = false;
                            $scope.model.ssl.require = true;
                            $scope.model.password.values = "";
                            $scope.model.Domain.disabled = false;
                            $scope.model.Domain.require = true;
                            $scope.model.https.disabled = false;
                            $scope.model.https.require = true;
                            $scope.model.regionTex.disable = false;
                        }
                    }
                },
                Domain:{
                    id:"Domain",
                    width: constsService.W3,
                    disabled: true,
                    validate: constsService.VALID.Trap_NAME,
                    require:false
                },
                https:{
                    id:"https",
                    width:constsService.W3,
                    disabled:true,
                    extendFunction: ["checkHttps"],
                    validate: "checkHttps : extend function;",
                    require:false
                },
                port: {
                    id: "port",
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }],
                    width: constsService.W2,
                    disabled: true,
                    isAllowModifyPort: false,
                    value: "59526",
                    min: "1",
                    max: "65535",
                    change: function() {
                        var val = $("#port").widget().options.value;
                        if ($.trim(val) == "") {
                            $("#port").widget().option("value", $scope.previousPort);
                        }
                    }
                },
                password: {
                    id: "password",
                    width: constsService.W3,
                    disabled: true,
                    type: "password",
                    validate: (isVmware || $scope.isOpenStack) ? constsService.VALID.AUTH_PWD_64 : constsService.VALID.AUTH_PWD
                },
                username: {
                    id: "username",
                    disabled: true,
                    width: constsService.W3,
                    validate: (isVmware || $scope.isOpenStack) ? [{validFn:"required"},{validFn:"maxSize", params:[255], errorDetail:appUtils.getString("validate_term_common_length_range_1_255_msg")}] : constsService.VALID.AUTH_NAME
                },
                ip: {
                    id: "ip",
                    disabled: true,
                    width: constsService.W3,
                    extendFunction: ["checkIP"],
                    validate: "checkIP : extend function;"
                },
                ssl: {
                    id: "ssl",
                    width: constsService.W3,
                    validate: "",
                    value: [{
                        selectId: "0",
                        label: appUtils.getString("common_term_disabled_label")
                    }, {
                        selectId: "1",
                        label: appUtils.getString("common_term_enabled_label")
                    }],
                    "selectedid": "0",
                    disabled: true,
                    change: function() {

                    }
                },
                regionTypeLabel: "Keystone",
                versionLabel: "6.0"
            };

            /**
             * 校验设备名称
             * @return
             */
            UnifyValid.checkDeviceName = function() {
                var deviceName = $.trim($("#name").widget().getValue());
                if (!deviceName) {
                    return appUtils.getString("common_term_empty_label");
                }

                if (deviceName.length < 1 || deviceName.length > 128) {
                    return appUtils.getString("validate_term_expr_length");
                }

                return "";
            }

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkDeviceName;
            });
            //域名校验函数
            UnifyValid.checkHttps = function(){
                var val = this[0].value;
                var ipReg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                var httpsReg = /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
                if(_.isEmpty(val)){
                    return appUtils.getString("common_term_empty_label");
                };
                if (ipReg.test(val) || httpsReg.test(val) || appUtils.validIPv4OrIPv6Address(val)) {
                    return "";
                }
                if (!ipReg.test(val) && !httpsReg.test(val) && !appUtils.validIPv4OrIPv6Address(val)) {
                    return appUtils.getString("validate_term_https_erro");
                }
                return "";
            }

            UnifyValid.checkIP = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (!appUtils.validIPv4OrIPv6Address(val)) {
                    return appUtils.getString("validate_ipv4_ipv6_label");
                }
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkIP;
                delete UnifyValid.checkHttps;
            });

            var _init = function() {
                $scope.model.name.value = $("#modifyDevAliasWinId").widget().option("data").name;
                $scope.model.password.values = "********";
                var sn = $("#modifyDevAliasWinId").widget().option("data").sn;
                if ("ism.drm.deviceType.drvsphere.mainType" == $("#modifyDevAliasWinId").widget().option("data").deviceType) {
                    $scope.model.username.validate = [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [255],
                        errorDetail: appUtils.getString("validate_term_common_length_range_1_255_msg")
                    }];
                    $scope.model.password.validate = [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [64],
                        errorDetail: appUtils.getString("validate_term_common_length_range_1_64_msg")
                    }];
                }
                var url = "/resources/" + $.base64.encode(sn) + "/action/getMgrProtocol";
                mask.show();
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    mask.hide();
                    if (exception.check(result)) {
                        $scope.isOpenStack ? $("#https").widget().option("value", result.networkIpAddress) : $("#ip").widget().option("value", result.networkIpAddress);
                        $("#username").widget().option("value", result.networkUserName);
                        $("#port").widget().option("value", result.extendParams.port);
                        $scope.isOpenStack && $("#Domain").widget().option("value",result.extendParams.domain);
                        if($scope.isOpenStack){
                            if(!_.isEmpty(result.extendParams.discoveryregions)){
                                var regionData = JSON.parse(result.extendParams.discoveryregions);
                                var regionArray = [];
                                for(var i=0;i<regionData.length;i++){
                                    regionArray.push({
                                        regionName:regionData[i]
                                    });
                                };
                                $scope.regionTable.data = regionArray;
                            }else{
                                $scope.regionTable.data = [];
                            }
                            $scope.model.regionTypeLabel = !_.isEmpty(result.extendParams.authType) ? result.extendParams.authType : "KeyStone";
                            $scope.model.versionLabel = !_.isEmpty(result.extendParams.version) ? result.extendParams.version : "6.0";
                        }
                        if ($("#modifyDevAliasWinId").widget().option("data") && $("#modifyDevAliasWinId").widget().option("data").isStorage) {

                            var protocal = result.extendParams.protocol;
                            $("#protocalHidden").val(protocal);
                            if (protocal == "DEFAULT") {
                                $scope.model.port.isAllowModifyPort = false;

                            }
                            if (protocal == "REST") {
                                $scope.model.port.isAllowModifyPort = true;
                            }
                        }
                        $scope.previousPort = $("#port").widget().options.value;
                        $scope.$apply();
                    }
                });
            };

            _init();

            function changeOkHandler(okcb) {
                var okBtn = _.findWhere(winObj.options.buttons, {
                        key: "ok"
                    }),
                    okHandler = okBtn.handler;

                okBtn.handler = function() {
                    okcb.call(winObj, okHandler);
                }
            }

            //可以将确定逻辑放到这
            changeOkHandler(function(callback) {
                if (!UnifyValid.FormValid($("#protocalForm"), {focusInvalid: true})) {
                    return;
                }
                var msg, switchFlag = $("#authinfo").widget().option("selected") == "on";
                if (switchFlag) {
                    msg = [appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg1"), appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg2"), appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg3")].join("<br/>");
                    message.warn(msg).then(function() {
                        callback();
                    });
                    return;
                }
                callback();
            })

        }
    ]

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("resModule.aliasEditCtrl", ctrler);
    return module;
})
