define(["tiny-widgets/Window"], function(Window) {
        "use strict";
        var ctrler = [
            "$rootScope",
            "$scope",
            "$state",
            "$stateParams",
            "$location",
            "$compile",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "cookieService",
            "appUtils",
            "infoTransferredService",
            function($rootScope, $scope, $state, $stateParams, $location, $compile, exception, message, communicationService, utilService, mask, constsService, cookieService, appUtils, infoTransferredService) {
                var mappingViewTypeText = $stateParams.type,
                    currentSite = infoTransferredService.get("site", "currentSite"),
                    mappingViewType = +constsService.RM_ENUM[mappingViewTypeText],
                    isAddVPC = constsService.RM_ENUM.network !== mappingViewType && constsService.RM_ENUM.securityGroup !== mappingViewType ? false : true,
                    addParamObj = infoTransferredService.get("resourceMapping", "add"),
                    pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox"),
                    requestDataObj = {
                        resourceType: mappingViewType
                    },
                    wizardCtrl = {
                        settingSite: {
                            isInit: false,
                            init: function(obj) {
                                angular.forEach(listboxs, function(box) {
                                    if (angular.isDefined(box.isInit) && box.isInit) {
                                        rmBoxs.initBoxView(box);
                                    }
                                    this[box.name] = -1;
                                }, obj);
                            },
                            checkNext: function(obj) {
                                var errorMsg, preViewOdd = [addParamObj.productionSite.value,addParamObj.productionCloud.value],
                                    preViewEven = [],
                                    isEn = appUtils.isEn(),
                                    boxs = angular.copy(listboxs);

                                obj[rmFormLabels.productionSite.name] = rmFormLabels.productionSite.id;
                                obj[rmFormLabels.productionCloud.name] = rmFormLabels.productionCloud.id;

                                isAddVPC && (boxs.push.apply(boxs,[boxs.pop(),boxs.pop()]));
                                $.each(boxs, function(index) {
                                    var selectId = $("#" + this.id).widget().getSelectedId(),
                                        label = $("#" + this.id).widget().getSelectedLabel();

                                    if (angular.isUndefined(selectId) || -1 === +selectId) {
                                        errorMsg = this.label
                                        return false;
                                    }

                                    if (obj[this.name] !== selectId) {
                                        wizardCtrl.mappingView.isInit = false;
                                    }
                                    obj[this.name] = selectId;

                                    preViewEven.push(label);

                                });

                                if (isAddVPC) {
                                    preViewOdd.push(preViewEven[2]);
                                    preViewEven.splice(2, 1);
                                }

                                if (angular.isDefined(errorMsg)) {
                                    message.error(pleaseSelect_label + (isEn ? " " : "") + errorMsg.replace(":",isEn ? "." : "。"));
                                    return false;
                                }

                                $scope.settingSite.preViewDesc = preViewOdd.concat(preViewEven);
                                appUtils.encodeForHTML($scope.settingSite.preViewDesc);

                                return true;
                            }
                        },
                        mappingView: {
                            isInit: false,
                            init: function(obj) {
                                $(".seal-borders table thead").remove();

                                $("#mappingViewTable").widget().clearTable();
                                angular.forEach(tableViewSites, function(tab) {
                                    requestAjax.initResourView(tab.table.dataUrl, tab.table.getUrlParams(), tab.table.id);
                                }, obj);
                            },
                            checkFinish: function(obj) {
                                var allData = $("#mappingViewTable").widget().getTableData(),
                                    isEn = appUtils.isEn(),
                                    msg = (isEn ? " " : "") + appUtils.getString("rm_term_wizard_mapping_view_title") + (isEn ? "." : "。");

                                if (!angular.isArray(allData) || 0 == allData.length) {
                                    message.error(pleaseSelect_label + msg);
                                    return false;
                                }

                                obj.productResourceId = [];
                                obj.recoveryResourceId = [];

                                angular.forEach(allData, function(row) {
                                    this.productResourceId.push(row.id[0]);
                                    this.recoveryResourceId.push(row.id[1]);
                                }, obj);

                                return true;
                            },
                            addRow: function() {
                                var allData = $("#mappingViewTable").widget().getTableData(),
                                    isEn = appUtils.isEn();
                                if (_.isArray(allData) && allData.length > 9) {
                                    message.error(appUtils.getString("setting_resourceMapping_task_map_createMappingView_para_mappingView_limit_tip"));
                                    return false;
                                }

                                var errorMsg;
                                var addObj = {
                                    id: [],
                                    name: [],
                                    arch: []
                                };
                                var selects = [];
                                $.each(tableViewSites, function(index) {
                                    var tableId = this.table.id;
                                    var select = $("#" + tableId).widget().getTableCheckedItems();

                                    if (!angular.isArray(select) || 0 == select.length) {
                                        errorMsg = this.title;
                                        return false;
                                    }
                                    selects.push({
                                        id: tableId,
                                        data: select[0]
                                    });
                                    addObj.name.push(select[0].name);
                                    addObj.id.push(select[0].id);
                                    addObj.arch.push(select[0].arch);
                                });

                                if (angular.isDefined(errorMsg)) {
                                    message.error(pleaseSelect_label + (isEn ? " " : "") + errorMsg + (isEn ? "." : "。"));
                                    return false;
                                }

                                $("#mappingViewTable").widget().addTableRows(addObj);

                                if (1 === $scope.mappingView.preViewDesc.length) {
                                    $scope.mappingView.preViewDesc = [];
                                }
                                angular.forEach(selects, function(row) {

                                    var domObj = $("#" + row.id).widget();
                                    var sourceDatas = domObj.getTableData();
                                    var removeDatas = [row.data];
                                    appUtils.removeFromArray(sourceDatas, removeDatas, "id");
                                    domObj.option("data", sourceDatas);
                                    $scope.mappingView.preViewDesc.push(row.data.name);
                                    appUtils.encodeForHTML($scope.mappingView.preViewDesc);
                                });

                            },
                            changePairStatus : function(isProductionResTable){
                                var selectCount = 0,status = {
                                    0: { "class" :  "resource-unpaired", "text" : appUtils.getString("common_term_add_mapping_unmapped")},
                                    1: { "class" :  "resource-unselect-all-paired", "text" : appUtils.getString("common_term_add_mapping_mapping")},
                                    2: { "class" :  "resource-paired", "text" : appUtils.getString("common_term_add_mapping_mapped")}
                                };
                                $.each(tableViewSites, function(index) {
                                        var tableId = this.table.id;
                                        var select = $("#" + tableId).widget().getTableCheckedItems();
                                        if (_.contains([0, 1], +mappingViewType) && tableId == productionResTable.table.id && isProductionResTable === true) {
                                            var filterData = _.filter(drResTableCloneData, function(item) {
                                                return !_.isEmpty(_.first(select)) && _.first(select).arch == item.arch && _.isEmpty(_.find($("#mappingViewTable").widget().getTableData(), function(value){
                                                    return value.id[1] == item.id;
                                                }));
                                            });
                                            $("#" + drResTable.table.id).widget().option("data", filterData);
                                        };

                                        if (!angular.isArray(select) || 0 == select.length) {
                                            return;
                                        }
                                        selectCount ++;
                                });

                                $scope.mappingView.pairStatusClass = status[selectCount];
                                $scope.$apply();
                            },
                            operation: appUtils.newOpAreaAction("mappingViewTable", {
                                remove: function(row) {
                                    $.each(tableViewSites, function(index) {
                                        var rowObj = {
                                            id: row.id[index],
                                            name: row.name[index],
                                            arch: row.arch[index]
                                        };
                                        $("#" + this.table.id).widget().addTableRows(rowObj);
                                    });

                                    var mappingViewTable = $("#mappingViewTable").widget();

                                    var sourceDatas = mappingViewTable.getTableData();
                                    appUtils.removeFromArray(sourceDatas, [row], "id");
                                    mappingViewTable.option("data", sourceDatas);

                                    $scope.mappingView.preViewDesc.splice($scope.mappingView.preViewDesc.indexOf(row.name[0]), 1);
                                    $scope.mappingView.preViewDesc.splice($scope.mappingView.preViewDesc.indexOf(row.name[1]), 1);
                                    appUtils.encodeForHTML($scope.mappingView.preViewDesc);

                                    if (0 === sourceDatas.length) {
                                        $scope.mappingView.preViewDesc = [appUtils.getString("rm_term_wizard_mapping_view_desc")];
                                    }

                                    $scope.$apply();

                                    wizardCtrl.mappingView.changePairStatus();
                                    $(".seal-borders .dataTables_opArea").parent().css({
                                        "width": "50px"
                                    });
                                }
                            })
                        }
                    };

                var rmFormLabels = {
                    productionSite: {
                        id: addParamObj.productionSite.id,
                        name: "productSiteId",
                        label: appUtils.getStringWithColon("rm_term_production_site"),
                        value: addParamObj.productionSite.value
                    },
                    productionCloud: {
                        id: addParamObj.productionCloud.id,
                        name: "productResourceProviderId",
                        label: appUtils.getStringWithColon("site.term.localCloudPlatform.label"),
                        value: addParamObj.productionCloud.value
                    }
                }
                var rmBoxs = {
                    drSite: {
                        id: "drSite",
                        name: "recoverySiteId",
                        label: appUtils.getStringWithColon("rm_term_dr_site"),
                        values: [appUtils.getDefaultOption()],
                        width: getComBoxWidth(),
                        change: function() {
                            var selectSiteId = $("#drSite").widget().getSelectedId();
                            $("#drCloud").widget().opChecked("-1");
                            rmBoxs.initBoxView(rmBoxs.drCloud);
                            if (isAddVPC) {
                                var drVPC = $("#drVPC").widget();
                                drVPC.option("values", [appUtils.getDefaultOption()]);
                                drVPC.opChecked("-1");
                            }
                        },
                        itemKey: {
                            key: "siteId",
                            value: "name"
                        },
                        isInit: true,
                        type: -1,
                        dataUrl: "/sites",
                        deleteItemId : addParamObj.productionSite.id
                    },
                    drCloud: {
                        id: "drCloud",
                        name: "recoveryResourceProviderId",
                        label: appUtils.getStringWithColon("site.term.remoteCloudPlatform.label"),
                        values: [appUtils.getDefaultOption()],
                        width: getComBoxWidth(),
                        change: function() {
                            try {
                                var productionVPC = $("#productionVPC").widget().getSelectedId();
                                if (isAddVPC && -1 !== +productionVPC) {
                                    $("#drVPC").widget().opChecked("-1");
                                    rmBoxs.initBoxView(rmBoxs.drVPC);
                                }
                            } catch (e) {

                            }
                        },
                        type: -1,
                        itemKey: {
                            key: "deviceSn",
                            value: "cloudName"
                        },
                        dataUrl: constsService.RM_URL.fusionsphereURL,
                        getUrlParam: function() {
                            var selectSiteId = $("#drSite").widget().getSelectedId();

                            var params = {
                                siteId: selectSiteId,
                                cloudType: cloudTypeView[1].value
                            };
                            return params;
                        }
                    },
                    drVPC: {
                        id: "drVPC",
                        name: "recoveryVpcId",
                        label: appUtils.getStringWithColon("rm_term_dr_vpc"),
                        values: [appUtils.getDefaultOption()],
                        width: getComBoxWidth(),
                        change: function() {

                        },
                        type: -1,
                        itemKey: {
                            key: "uuid",
                            value: "name"
                        },
                        dataUrl: constsService.RM_URL.fusionsphereURL + "/{fmsn}/vpcs",
                        getUrlParam: function() {
                            var selectSn = $("#drCloud").widget().getSelectedId();
                            var productSn = $("#productionVPC").widget().getSelectedId();
                            var selectSiteId = $("#drSite").widget().getSelectedId();
                            var params = {
                                fmsn: selectSn,
                                siteId: selectSiteId,
                                editFlag: false,
                                searchType: "recovery",
                                vpcSn: -1 === +productSn ? "" : productSn
                            };
                            return params;
                        }
                    },
                    productionVPC: {
                        id: "productionVPC",
                        name: "productVpcId",
                        label: appUtils.getStringWithColon("rm_term_production_vpc"),
                        values: [appUtils.getDefaultOption()],
                        width: getComBoxWidth(),
                        change: function() {
                            var drCloud = $("#drCloud").widget().getSelectedId();
                            if (-1 !== +drCloud) {
                                $("#drVPC").widget().opChecked("-1");
                                rmBoxs.initBoxView(rmBoxs.drVPC);
                            }
                        },
                        isInit: true,
                        type: -1,
                        itemKey: {
                            key: "uuid",
                            value: "name"
                        },
                        dataUrl: constsService.RM_URL.fusionsphereURL + "/{fmsn}/vpcs",
                        getUrlParam: function() {
                            var selectSn = addParamObj.productionCloud.id,
                                selectSiteId = addParamObj.productionSite.id,
                                params = {
                                    fmsn: selectSn,
                                    siteId: selectSiteId,
                                    searchType: "product"
                                };
                            return params;
                        }
                    },
                    initBoxView: function(box) {
                        var url = box.dataUrl;
                        if (angular.isDefined(box.getUrlParam)) {
                            url = appUtils.fillUrl(url, box.getUrlParam());
                        }

                        requestAjax.initBoxView(url, box.id, box.type, box.itemKey, box.deleteItemId);
                    }
                };

                var listboxs = [
                        rmBoxs.drSite,
                        rmBoxs.drCloud,
                    ],
                    listlabels = [
                        rmFormLabels.productionSite,
                        rmFormLabels.productionCloud
                    ];

                isAddVPC && (listboxs.push(rmBoxs.drVPC, rmBoxs.productionVPC));

                var cloudTypeView = [{
                    label: appUtils.getString("resource_mapping_cloud_type") + ":",
                    value: appUtils.getString(isAddVPC ? "resource_mapping_cloud_fm_type" : "resource_mapping_cloud_fc_type"),
                    "class": "cloudType"
                }, {
                    label: appUtils.getString("resource_mapping_cloud_type") + ":",
                    value: appUtils.getString(isAddVPC ? "resource_mapping_cloud_fm_type" : "resource_mapping_cloud_fc_type"),
                    "class": "cloudType"
                }];
                var productionResTable = {
                    title: appUtils.getString("rm_term_production_res_column"),
                    filterkey: {
                        id: "pfilterkey",
                        values: [{
                            "selectId": "name",
                            "label": appUtils.getString("notify_alarm_term_name_column"),
                            "checked": true
                        }],
                        change: function() {

                        },
                        disable: false,
                        width: 100
                    },
                    filtervalue: {
                        id: "pfiltervalue",
                        value: "",
                        validate: "",
                        width: constsService.W2 - (isEn() ? 45 : 0)
                    },
                    table: {

                        "checkbox": false,
                        "currPage": 1,
                        "id": "productionResTable",
                        "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name"
                        }],
                        "callback": function(evtObj) {

                        },
                        sortCallback: function(nNode, sortArr) {

                        },
                        "renderRow": function(nRow, aData, iDataIndex) {},
                        data: [],
                        dataUrl: constsService.RM_URL.mappingURL + "/action/getResource",
                        getUrlParams: function() {
                            return {
                                resourceType: mappingViewType,
                                siteId: addParamObj.productionSite.id,
                                resourceProviderId: isAddVPC ? requestDataObj.productVpcId : addParamObj.productionCloud.id,
                                filterName: "name",
                                filterValue: $("#pfiltervalue").widget().getValue()
                            };
                        },
                        cellClickActive : function(){
                            wizardCtrl.mappingView.changePairStatus(true)
                        }
                    },
                    search: function() {
                        requestAjax.initResourView(productionResTable.table.dataUrl, productionResTable.table.getUrlParams(), productionResTable.table.id);
                    }
                };

                var drResTable = {
                    title: appUtils.getString("rm_term_dr_res_column"),
                    filterkey: {
                        id: "dfilterkey",
                        values: [{
                            "selectId": "name",
                            "label": appUtils.getString("notify_alarm_term_name_column"),
                            "checked": true
                        }],
                        change: function() {

                        },
                        disable: false,
                        width: 100
                    },
                    filtervalue: {
                        id: "dfiltervalue",
                        value: "",
                        validate: "",
                        width: constsService.W2 - (isEn() ? 40 : 0)
                    },
                    table: {

                        "checkbox": false,
                        "currPage": 1,
                        "id": "drResTable",
                        "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name"
                        }],
                        "callback": function(evtObj) {},
                        sortCallback: function(nNode, sortArr) {},
                        "renderRow": function(nRow, aData, iDataIndex) {},
                        data: [],
                        dataUrl: constsService.RM_URL.mappingURL + "/action/getResource",
                        getUrlParams: function() {
                            return {
                                resourceType: mappingViewType,
                                siteId: requestDataObj.recoverySiteId,
                                resourceProviderId: isAddVPC ? requestDataObj.recoveryVpcId : requestDataObj.recoveryResourceProviderId,
                                filterName: "name",
                                filterValue: $("#dfiltervalue").widget().getValue()
                            };
                        },
                        cellClickActive : wizardCtrl.mappingView.changePairStatus
                    },
                    search: function() {
                        requestAjax.initResourView(drResTable.table.dataUrl, drResTable.table.getUrlParams(), drResTable.table.id);
                    }
                };
                var tableViewSites = [productionResTable, drResTable];

                $scope.settingSite = {
                    title: appUtils.getString("rm_term_wizard_setting_site_title"),
                    desc: appUtils.getString("rm_term_wizard_setting_site_desc"),
                    preViewDesc: [appUtils.getString("rm_term_wizard_setting_site_desc")],
                    listboxs: listboxs,
                    listlabels: listlabels

                };


                $scope.mappingView = {
                    isAddVPC: isAddVPC,
                    title: appUtils.getString("rm_term_wizard_mapping_view_title"),
                    desc: appUtils.getString("rm_term_wizard_mapping_view_desc"),
                    preViewDesc: [appUtils.getString("rm_term_wizard_mapping_view_desc")],
                    addBtn: {
                        id: "addBtn",
                        text: appUtils.getString("common_term_add_mapping_button"),
                        click: function() {
                            wizardCtrl.mappingView.addRow();
                            wizardCtrl.mappingView.changePairStatus();
                            $(".seal-borders .dataTables_opArea").parent().css({
                                "width": "50px"
                            });
                        },
                        "iconsClass": {
                            "left": "btn-arrow-down"
                        },
                    },
                    pairStatusClass : { "class" :  "resource-unpaired", "text" : appUtils.getString("common_term_add_mapping_unmapped")},
                    mappingViewTable: {
                        "checkbox": false,
                        "currPage": 1,
                        "id": "mappingViewTable",
                        "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name",
                            "sWidth": "94%"
                        }],
                        "callback": function(evtObj) {},
                        sortCallback: function(nNode, sortArr) {},
                        "renderRow": function(nRow, aData, iDataIndex) {
                            var nameDiv = "<span class='tooltip inlineTrDiv' title='value' >value</span>";
                            var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' style='vertical-align: middle;margin-left:20px;margin-right:20px;'>";
                            var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/" + mappingViewTypeText + ".png' style='vertical-align: middle;margin-right:10px;'>";
                            var nameHTML = [];
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                            nameHTML.push(arrow);
                            nameHTML.push(mappingTypeImg);
                            nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                            $('td:eq(0)', nRow).html("<div style='text-align: center; margin-left: 40px;'>" + nameHTML.join("") + "</div>");
                            $('td:eq(0)', nRow).css({
                                "text-align": "left"
                            });
                        },
                        opAreaConfig: [{
                            id: "iconBtnDel",
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: wizardCtrl.mappingView.operation.remove
                        }],
                        data: []
                    },
                    tableViewSites: tableViewSites

                };

                /*--------初始化向导-------------*/
                $scope.addResourceMapping = {
                    id: "addResourceMapping",
                    exclude: [],
                    steps: [{
                        id: "settingSite",
                        title: $scope.settingSite.title,
                        templateUrl: "app/business/recoverydirector/site/views/resource/base/rm/add/settingSite.html",
                        previewDescr: $scope.settingSite.preViewDesc
                    }, {
                        id: "mappingView",
                        title: $scope.mappingView.title,
                        templateUrl: "app/business/recoverydirector/site/views/resource/base/rm/add/mappingView.html",
                        previewDescr: $scope.mappingView.preViewDesc
                    }],
                    load: function(currentStep) {},
                    active: function(currentStep) {
                        if (!wizardCtrl[currentStep.id].isInit) {
                            wizardCtrl[currentStep.id].isInit = true;
                            wizardCtrl[currentStep.id].init(requestDataObj);
                        }
                    },
                    previous: function(param) {},
                    finish: function(param) {
                        var isOk = wizardCtrl.mappingView.checkFinish(requestDataObj);
                        if (!isOk) {
                            return;
                        };

                        mask.show();
                        communicationService.post(utilService.getResouceUrl(constsService.RM_URL.mappingURL), requestDataObj).promise().always(function(response) {
                            mask.hide();
                            if (!exception.check(response) || _.isUndefined(response) || _.isUndefined(response.failCount)) {
                                return;
                            }

                            if (0 === +response.failCount) {
                                message.success({
                                    content: appUtils.getString(+constsService.RM_ENUM.vrg === +mappingViewType ? "setting_resourceMapping_task_map_createMappingView_success_message" : "common_term_operation_success_label"),
                                    ok: function() {
                                        infoTransferredService.put("wizard", "isFinish", true);
                                        $scope.addResourceMapping.go();
                                    }
                                });
                                return;
                            }

                            _.each(response.result, function(msg) {
                                var params = msg.targetName.split(",");
                                params[0] = constsService.RM_ENUM.getName(+params[0]);
                                params[0] = appUtils.getString("resource_mapping_" + params[0]);
                                msg.targetName = appUtils.getString("setting_resourceMapping_task_map_createMappingView_success_message_detail", params);
                            });

                            $scope.addResourceMapping.openWindow(response, function() {
                                infoTransferredService.put("wizard", "isFinish", true);
                                $scope.addResourceMapping.go();
                            });

                        }, function(response) {
                            mask.hide();
                        });
                    },
                    next: function(param) {
                        return wizardCtrl[param.from.id].checkNext(requestDataObj);
                    },
                    go: function() {
                        $state.go("site.cloud.vmList", {siteId: currentSite.siteId});
                    },
                    cancel: function(param) {
                        $state.go("site.cloud.vmList", {siteId: currentSite.siteId});
                    },
                    openWindow: function(param, callback) {
                        var options = {
                            "winId": "alarmClearFailWin",
                            "title": appUtils.getString(constsService.ALARM_CLEAR_ERROR_TITLE),
                            "data": param,
                            "height": "550px",
                            "width": "500px",
                            "modal": true,
                            "content-type": "url",
                            "draggable": true,
                            "content": constsService.COURRENT_BATCH_RESULT_URL,
                            "minimizable": false,
                            "maximizable": false,
                            "buttons": [{
                                key: "cancel",
                                focused: true,
                                label: appUtils.getString("common_term_close_button"),
                                handler: function(event) {
                                    $("#alarmClearFailWin").widget().destroy();
                                    (callback)();
                                }
                            }],
                            "close": function() {
                                (callback)();
                            }
                        };
                        var win = new Window(options);
                        win.show();
                    }
                };
                var drResTableCloneData = [];
                var requestAjax = {
                    initBoxView: function(url, boxId, type, itemKey, deleteSiteId) {
                        communicationService.get(utilService.getResouceUrl(url), null, null, 3600000).promise().always(function(result) {
                            var isOk = exception.check(result, false);
                            isOk = isOk === true;
                            if (!isOk) {
                                result = [];
                                isOk = !isOk;
                            }
                            if (isOk) {

                                appUtils.encodeForHTML(result);

                                var arr = [appUtils.getDefaultOption()];
                                var selectId = $("#" + boxId).widget().getSelectedId();
                                if (angular.isDefined(selectId) && +selectId !== -1) {
                                    arr[0] = angular.copy(arr[0]);
                                    arr[0].checked = false;
                                }

                                _.each(result, function(d) {
                                    if (angular.isDefined(deleteSiteId) && angular.equals(deleteSiteId + "", d.siteId + "")) {
                                        return;
                                    }

                                    if (-1 !== type && type !== d.siteType) {
                                        return;
                                    }
                                    var tmo = {
                                        selectId: d[itemKey.key],
                                        label: d[itemKey.value]
                                    };
                                    arr.push(tmo);
                                });

                                var box = $("#" + boxId).widget();
                                var selectId = box.getSelectedId();
                                box.option("values", arr);
                                box.opChecked(selectId);
                                $scope.$apply();
                            }
                        });
                    },
                    initResourView: function(url, param, tabId) {
                        mask.show();
                        url = appUtils.fillUrl(url, param);
                        communicationService.get(utilService.getResouceUrl(url), null, null, 3600000).promise().always(function(result) {
                            mask.hide();
                            if (exception.check(result)) {

                                appUtils.encodeForHTML(result);

                                var selectIds = [];
                                angular.forEach($("#mappingViewTable").widget().getTableData(), function(row) {
                                    this.push(row.id[0]);
                                    this.push(row.id[1]);
                                }, selectIds);

                                var arr = [];
                                _.each(result, function(d) {
                                    if (-1 !== selectIds.indexOf(d.resourceId)) {
                                        return;
                                    }
                                    var tmo = {
                                        id: d.resourceId,
                                        name: d.resourceName,
                                        arch: d.arch
                                    };
                                    arr.push(tmo);
                                });

                                $("#" + tabId).widget().option("data", arr);
                                tabId == drResTable.table.id && (drResTableCloneData = angular.copy(arr));
                                $scope.$apply();
                            }
                        });
                    }
                };

                function getComBoxWidth() {
                    return isEn() ? 165 : 208;
                }

                function isEn() {
                    var language = cookieService.get("language");
                    return "zh" !== language && "zh_CN" !== language;
                }

                var stateChangeStart = $rootScope.$on('$stateChangeStart',
                    function(event, toState, toParams, fromState, fromParams) {
                        if (infoTransferredService.get("wizard", "isFinish")) {
                            infoTransferredService.remove("wizard", "isFinish");
                            stateChangeStart();
                            return;
                        }
                        event.preventDefault();
                        message.confirm({
                            content: appUtils.getString("common_term_exitWizard_message"),
                            ok: function() {
                                infoTransferredService.remove("wizard", "isFinish");
                                stateChangeStart();
                                if (toState.name.indexOf("site") != -1) {
                                    $state.go("site.cloud", {siteId: addParamObj.productionSite.id});
                                } else{
                                    $state.go(toState, toParams);
                                }
                            }
                        });
                    });

            }
        ];

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.resourceMapping.addWizard.ctrl', ctrler);
        return module;
    });
