define([], function() {
	"use strict";
	var ctrl = [
			"$scope",
			"$state",
			"$stateParams",
			"exception",
			"message",
			"communicationService",
			"utilService",
			"mask",
			"constsService","appUtils",
			function($scope, $state, $stateParams, exception, message,
					communicationService, utilService, mask, constsService ,appUtils) {
				var widget = $("#" + constsService.RM_EDIT.winId).widget();
                var id = widget.option("params").id;
                var mappingViewType = +widget.option("params").type;

                var isAddVPC = constsService.RM_ENUM.network !== mappingViewType && constsService.RM_ENUM.securityGroup !== mappingViewType ? false : true;
                var cloudType = appUtils.getString(isAddVPC ? "resource_mapping_cloud_fm_type" : "resource_mapping_cloud_fc_type");
                var lineSpace = ":";

                var modifyRMObj;

                var rmBoxs =
                {
                		drSite : {
							id : "drSite",
							name : "recoverySiteId",
							label : appUtils.getString("rm_term_dr_site") + lineSpace,
							values : [],
							change : function(){

                				rmLabels.drRes.value = constsService.INVALID_VALUE;
                				$("#avilableResTable").widget().clearTable();
								$("#drCloud").widget().opChecked("-1");
								rmBoxs.initBoxView(rmBoxs.drCloud);
								if(isAddVPC)
								{
									var drVPC = $("#drVPC").widget();
									drVPC.option("values",[appUtils.getDefaultOption()]);
									drVPC.opChecked("-1");
								}
							},
							itemKey : {key:"siteId",value:"name"},
							dataUrl : "/sites",
							init : function(b,obj)
							{
	                			var defaultSelect = {"selectId" : obj[b.name],
	                								"label" : obj["recoverySiteName"],
	                								checked : true};
								$("#drSite").widget().option("values",[defaultSelect]);
								rmBoxs.initBoxView(b,obj[b.name],[obj.productSiteId]);
							}
						},
						drCloud : {
							id : "drCloud",
							name : "recoveryResourceProviderId",
							label : appUtils.getString("rm_term_dr_cloud") + lineSpace,
							values : [],
							change : function(){
								$("#avilableResTable").widget().clearTable();
								rmLabels.drRes.value = constsService.INVALID_VALUE;

								var drCloud = $("#drCloud").widget().getSelectedId();
								if(-1 === +drCloud)
								{
									if(isAddVPC)
									{
										$("#drVPC").widget().option("values",[appUtils.getDefaultOption()])
									}
									return;
								}

								if(isAddVPC)
								{
									$("#drVPC").widget().opChecked("-1");
									rmBoxs.initBoxView(rmBoxs.drVPC);
								}else
								{
									availableRes.table.queryData();
								}
							},
							itemKey : {key:"deviceSn",value:"cloudName"},
							dataUrl : constsService.RM_URL.fusionsphereURL,
							getUrlParam : function()
							{
								var selectSiteId = $("#drSite").widget().getSelectedId();

								var params =
								{
										siteId : selectSiteId,
										cloudType : cloudType
								};
								return params;
							},
							init : function(b,obj)
							{
	                			var defaultSelect = {"selectId" : obj[b.name],
        								"label" : obj["recoveryResourceProviderName"],
        								checked : true};

	                			$("#drCloud").widget().option("values",[defaultSelect]);
								rmBoxs.initBoxView(b,obj[b.name]);
							}
						},
						drVPC : {
							id : "drVPC",
							name : "recoveryVpcId",
							label : appUtils.getString("rm_term_dr_vpc") + lineSpace,
							values : [],
							change : function(){
								rmLabels.drRes.value = constsService.INVALID_VALUE;

								var vpcId = $("#drVPC").widget().getSelectedId();
								if(-1 === +vpcId)
								{
									$("#avilableResTable").widget().clearTable();
									return;
								}

								availableRes.table.queryData();
							},
							itemKey : {key:"uuid",value:"name"},
							dataUrl : constsService.RM_URL.fusionsphereURL + "/{fmsn}/vpcs",
							getUrlParam : function()
							{
								var selectSn = $("#drCloud").widget().getSelectedId();
								var selectSiteId = $("#drSite").widget().getSelectedId();
								var params =
								{
										fmsn : selectSn,
										siteId : selectSiteId,
										editFlag : true,
										searchType : "recovery",
										vpcSn : modifyRMObj.productVpcId
								};
								return params;
							},
							init : function(b,obj)
							{
								var defaultSelect = {"selectId" : obj[b.name],
        								"label" : obj["recoveryVpcName"],
        								checked : true};

	                			$("#drVPC").widget().option("values",[defaultSelect]);
								rmBoxs.initBoxView(b,obj[b.name]);
							}
						},
						initBoxView : function(box,selectId,deleteItems)
						{
							var url = box.dataUrl;
							if(angular.isDefined(box.getUrlParam))
							{
								url = appUtils.fillUrl(url,box.getUrlParam());
							}

							requestAjax.initBoxView(url,box.id,box.itemKey,selectId,deleteItems);
						}
                };

                var rmLabels =
                {
						productionSite : {
		                	id : "productionSite",
							name : "productSiteName",
		                	label : appUtils.getString("rm_term_production_site") + lineSpace,
		                	value : constsService.INVALID_VALUE
		                },
		                productionCloud : {
		                	id : "productionCloud",
							name : "productResourceProviderName",
		                	label : appUtils.getString("rm_term_production_cloud") + lineSpace,
		                	value : constsService.INVALID_VALUE
		                },
		                productionVPC : {
		                	id : "productionVPC",
							name : "productVpcName",
		                	label : appUtils.getString("rm_term_production_vpc") + lineSpace,
		                	value : constsService.INVALID_VALUE
		                },
		                productionRes : {
		                	id : "productionRes",
							name : "productResourceName",
		                	label : appUtils.getString("rm_term_production_res") + lineSpace,
		                	value : constsService.INVALID_VALUE
		                },
		                drRes : {
							id : "drRes",
							name : "recoveryResourceName",
							label : appUtils.getString("rm_term_dr_res") + lineSpace,
							value : constsService.INVALID_VALUE,
							change : function(){

							}
						}
                };

                var listboxs = [
								rmLabels.productionSite,
								rmBoxs.drSite,
								rmLabels.productionCloud,
								rmBoxs.drCloud,
								rmLabels.productionVPC,
								rmBoxs.drVPC,
								rmLabels.productionRes,
								rmLabels.drRes
				            ];

                var availableRes = {
						title : appUtils.getString("rm_term_avilable_dr_res"),
						filterkey : {
							id : "filterkey",
							values : [{"selectId" : "name", "label" : appUtils.getString("notify_alarm_term_name_column"), "checked" : true}],
							change : function(){

							},
							disable : false,
							width : 120
						},
						filtervalue : {
							id : "filtervalue",
							value : "",
							validate : "",
							width : constsService.W2
						},
						table :
						{

							"checkbox" : false,
							"currPage": 1,
			                "id": "avilableResTable",
			                "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
			                "totalRecords": 0,
			                "enablePagination" : false,
			                "columns" : [ { "mData" : "id", "bSortable" : false, "bVisible" : false },
										{"sTitle" : appUtils.getString("notify_alarm_term_name_column"),"mData" : "name"}
										],
			                "callback": function (evtObj) {
			                },
			                sortCallback: function (nNode, sortArr) {
		                    },
			                "renderRow": function (nRow, aData, iDataIndex) {
			                },
			                data : [],
			                changeSelect : function(event, oData)
			                {
			                	if(isAddVPC)
                				{
                					listboxs[7].value = oData.name;
                				}else
                				{
                					listboxs[5].value = oData.name;
                				}

			                	$scope.$apply();
			                },
			                dataUrl : constsService.RM_URL.mappingURL + "/action/getResource",
			                getUrlParams : function(){
			                	return {
			                		resourceType : mappingViewType,
				                	siteId : modifyRMObj.recoverySiteId,
				                	resourceProviderId : isAddVPC ? $("#drVPC").widget().getSelectedId(): $("#drCloud").widget().getSelectedId(),
				                	filterName : "name",
				                	filterValue : $("#filtervalue").widget().getValue()
				                };
			                },
			                queryData : function ()
			                {
			                	var errorMsg,isEn = appUtils.isEn();
			                	try{
				                	for(var b in rmBoxs)
			                		{
				                		var box = rmBoxs[b];
				                		if(!angular.isObject(box)){
				                			continue;
				                		}
			                			var box = rmBoxs[b];
		                				var selectId = $("#"+box.id).widget().getSelectedId();

			                			if(-1 == +selectId || "" == selectId)
			                			{
			                				errorMsg = box.label;
			                				break;
			                			}
			                		}

				                	if(angular.isDefined(errorMsg))
				                	{
				                		message.error(appUtils.getString("common_term_pleaseSelect_listbox") + (isEn ? " " : "") + errorMsg.replace(lineSpace,isEn ? "." : "。"));
										return;
				                	}
			                	}catch(e)
			                	{

			                	}
			                	requestAjax.initResourView(availableRes.table.dataUrl,availableRes.table.getUrlParams(),availableRes.table.id);
			                }
						}
				};
                $scope.editMapping =
                {
                		isAddVPC : isAddVPC,
                		listboxs : listboxs,
                		availableRes : availableRes
                };

                var requestAjax =
                {
                		initBoxView : function (url,boxId,itemKey,selectId,deleteItems)
						{
							communicationService.get(utilService.getResouceUrl(url), null, null, 3600000).promise().always(function(result){
								var isOk = exception.check(result,false);
								isOk = isOk === true;

								if(!isOk)
								{
									result = [];
									isOk = !isOk;
								}
								if (isOk) {
									var arr = [appUtils.getDefaultOption()];

									appUtils.encodeForHTML(result);

			                        _.each(result, function (d) {
			                        	if(angular.isDefined(deleteItems) && -1 !== deleteItems.indexOf(d[itemKey.key]))
			                        	{
			                        		return;
			                        	}
			                        	var tmo =
			                            {
			                            	selectId : d[itemKey.key],
			                            	label : d[itemKey.value]
			                            };
			                            arr.push(tmo);
			                        });

			                        var box = $("#" + boxId).widget();
			                        try{
			                        	box.option("values",arr);
			                        	if(angular.isDefined(selectId))
			                        	{
			                        		box.opChecked(selectId);
			                        	}else
			                        	{
			                        		box.opChecked("-1");
			                        	}
			                        }catch(e)
			                        {
			                        	rmBoxs[boxId].values = arr;
			                        }
			                    }
							});
						},
                		queryEditRMObj : function(id,callBack)
                		{
							mask.show();
		    			    communicationService.get(utilService.getResouceUrl(constsService.RM_URL.mappingURL + "/" + id)).promise().always(function(response){
		    			    	mask.hide();
		    			    	if(exception.check(response))
		    			    	{
		    			    		appUtils.encodeForHTML(response);

		    			    		modifyRMObj = response;
		    			    		callBack(modifyRMObj);
		    			    	}
		    			    });
                		},
                		initResourView : function(url,param,tabId)
						{
							mask.show();
							url = appUtils.fillUrl(url,param);
							communicationService.get(utilService.getResouceUrl(url), null, null, 3600000).promise().always(function(result){
								mask.hide();
			                	if (exception.check(result)) {

			                		appUtils.encodeForHTML(result);

			                        var arr = [];
			                        _.each(result, function (d) {
			                        	if(d.resourceId == modifyRMObj.recoveryResourceId)
			                        	{
			                        		return;
			                        	}
			                            var tmo = {
			                                id: d.resourceId,
			                                name: d.resourceName,
			                                arch: d.arch
			                            };
			                            arr.push(tmo);
			                        });
			                        if (_.contains([0, 1], +mappingViewType)) {
									    try {
									        var productUrl = appUtils.fillUrl(constsService.RM_URL.mappingURL + "/action/getResource", {
									            resourceType: mappingViewType,
									            siteId: modifyRMObj.productSiteId,
									            resourceProviderId: modifyRMObj.productResourceProviderId,
									        });
									        communicationService.get(utilService.getResouceUrl(productUrl), null, null, 3600000).promise().always(function(response) {
									            if (exception.check(response)) {
									            	appUtils.encodeForHTML(response);
									            	var resourceObj = _.find(response, function(map){
									            		return map.resourceId == modifyRMObj.productResourceId
									            	});
									            	if(!_.isEmpty(resourceObj)){
									            		var newArr = _.filter(arr, function(val){
									            			return val.arch == resourceObj.arch
									            		});
									            		$("#" + tabId).widget().option("data", newArr);
									            	}else{
									            		$("#" + tabId).widget().option("data", arr);
									            	}
									            }else{
									            	$("#" + tabId).widget().option("data", arr);
									            }
									        });
									    } catch (err) {
									        $("#" + tabId).widget().option("data", arr);
									    }
									} else {
									    $("#" + tabId).widget().option("data", arr);
									}
			                        $scope.$apply();
			                	}
							});
						}
                };

                var _init = function()
                {
                	requestAjax.queryEditRMObj(id, function(obj){
                		for(var label in rmLabels)
                    	{
                    		var labelObj = rmLabels[label];
                    		labelObj.value = obj[labelObj.name];
                    	}

                		for(var box in rmBoxs)
                		{
                			var b = rmBoxs[box];
                			if(!angular.isObject(b)){
                				continue;
                			}

                			b.init(b,obj);
                		}
                		$scope.$apply();
                		availableRes.table.queryData();
                	});
                };

                if(!isAddVPC)
				{
                	listboxs.splice(4, 2);
                	delete rmBoxs.drVPC;
				}

                _init();
			} ];

	var module = angular.module("recoverydirector.site.config");
	module.tinyController("settings.resourceMappingList.edit.ctrl", ctrl);
	return module;
});
