define(["tiny-widgets/Window"], function(Window) {
    "use strict";
    var ctrler = [
        "$rootScope",
        "$scope",
        "$state",
        "$stateParams",
        "$timeout",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService",
        "statusEnumService",
        "appUtils",
        "infoTransferredService",
        function($rootScope, $scope, $state, $stateParams, $timeout, exception, message,
            communicationService, utilService, mask, constsService, statusEnumService, appUtils, infoTransferredService) {
            var cloudObj = $scope.$parent.getData(),
                mappingViewType = constsService.RM_ENUM[$stateParams.type],
                isAddVPC = constsService.RM_ENUM.network !== mappingViewType && constsService.RM_ENUM.securityGroup !== mappingViewType ? false : true;

            $scope.btnCreate = {
                id: "btnCreate",
                text: appUtils.getString("common_term_add_button"),
                authKey : $scope.$parent.optResAuthKey,
                click: function() {
                    var site = infoTransferredService.get("site", "currentSite"),
                        addParam = {
                            type: mappingViewType,
                            productionSite: {
                                id: site.id,
                                value: site.name
                            },
                            productionCloud: {
                                id: cloudObj.deviceSn,
                                value: cloudObj.cloudName
                            }
                        };

                    infoTransferredService.put("resourceMapping", "add", addParam);
                    $state.go("site.addRMWizard", {
                        type: $stateParams.type,
                        productionInfo: addParam
                    }, {
                        reload: false
                    });
                }
            };

            var columns = [{
                "sTitle": appUtils.getString("site.term.localResource.cloumn"),
                "mData": "productResourceName"
            }, {
                "sTitle": appUtils.getString("site.term.remoteResource.cloumn"),
                "mData": "recoveryResourceName"
            }, {
                "sTitle": appUtils.getString(isAddVPC ? "site.term.remoteResourceOwingFusionManager.tab" : "site.term.remoteResourceOwingFusionCompute.tab"),
                "mData": "recoveryResourceProviderName"
            }, {
                "sTitle": appUtils.getString("site.term.remoteResourceOwingSite.cloumn"),
                "mData": "recoverySiteName"
            }];

            var operation = appUtils.newOpAreaAction("datasTable", {
                modify: function(row) {
                    var options = {
                        "title": appUtils.getString(constsService.RM_EDIT.title),
                        "params": {
                            id: row.mappingId,
                            type: mappingViewType
                        },
                        "buttons": [{
                            key: "ok",
                            label: appUtils.getString('common_term_confirm_button'),
                            focused: true,
                            handler: function(event) {
                                var requestObj = {
                                    mappingId: row.mappingId
                                };

                                var checkBox = {
                                    drSite: {
                                        id: "drSite",
                                        name: "recoverySiteId",
                                        label: appUtils.getString("rm_term_dr_site"),
                                        getValue: function() {
                                            return $("#drSite").widget().getSelectedId();
                                        }
                                    },
                                    drCloud: {
                                        id: "drCloud",
                                        name: "recoveryResourceProviderId",
                                        label: appUtils.getString("rm_term_dr_cloud"),
                                        getValue: function() {
                                            return $("#drCloud").widget().getSelectedId();
                                        }
                                    },
                                    drVPC: {
                                        id: "drVPC",
                                        name: "recoveryVpcId",
                                        label: appUtils.getString("rm_term_dr_vpc"),
                                        getValue: function() {
                                            return $("#drVPC").widget().getSelectedId();
                                        }
                                    },
                                    availableRes: {
                                        id: "avilableResTable",
                                        name: "recoveryResourceId",
                                        label: appUtils.getString("rm_term_avilable_dr_res"),
                                        getValue: function() {
                                            var select = $("#avilableResTable").widget().getTableCheckedItems();
                                            if (angular.isDefined(select[0])) {
                                                return select[0].id;
                                            }
                                            return select[0];
                                        }
                                    }
                                };

                                if (!isAddVPC) {
                                    delete checkBox.drVPC;
                                }

                                var errorMsg,isEn = appUtils.isEn();
                                $.each(checkBox, function(item) {
                                    var box = checkBox[item],
                                        value = box.getValue();

                                    errorMsg = box.label;
                                    if (angular.isUndefined(value)) {
                                        return false;
                                    }

                                    if (0 == value.length) {
                                        return false;
                                    }
                                    if (angular.isString(value)) {
                                        if ("--" == value || -1 === +value) {
                                            return false;
                                        }
                                    }

                                    if (angular.isNumber(value) && -1 === value) {
                                        return false;
                                    }

                                    requestObj[box.name] = value;
                                    errorMsg = undefined;
                                });

                                if (angular.isDefined(errorMsg)) {
                                    message.error(appUtils.getString("common_term_pleaseSelect_listbox") + (isEn ? " " : "") + errorMsg + (isEn ? "." : "。"));
                                    return;
                                }

                                message.warn({
                                    content: appUtils.getString("resource_mapping_edit_msg", row.productSiteName, row.productResourceName, row.recoverySiteName, row.recoveryResourceName),
                                    ok: function() {
                                        mask.show();
                                        communicationService.put(utilService.getResouceUrl(constsService.RM_URL.mappingURL + "/" + row.mappingId), requestObj).promise().always(function(response) {
                                            mask.hide();
                                            if (exception.check(response)) {
                                                message.success({
                                                    content: appUtils.getString("common_term_operation_success_label"),
                                                    ok: function() {
                                                        $("#" + constsService.RM_EDIT.winId).widget().destroy();
                                                        _init();
                                                    }
                                                });
                                            }
                                        }, function(response) {
                                            mask.hide();
                                        });
                                    }
                                });

                            }
                        }, {
                            key: "cancel",
                            label: appUtils.getString('common_term_cancel_button'),
                            focused: false,
                            handler: function(event) {
                                $("#" + constsService.RM_EDIT.winId).widget().destroy();
                            }
                        }],
                        "close": function() {
                            $("#" + constsService.RM_EDIT.winId).widget().destroy();
                        }
                    };
                    options = angular.extend(constsService.RM_EDIT, options);
                    if (isAddVPC) {
                        options.height = +options.height.replace("px", "") + 34;
                        options.height += "px";
                    }

                    var win = new Window(options);
                    win.show();
                },
                remove: function(row) {
                    if (1 !== +row.role) {
                        return;
                    }

                    message.warn({
                        content: appUtils.getString("resource_mapping_remove_msg", row.productSiteName, row.productResourceName, row.recoverySiteName, row.recoveryResourceName),
                        ok: function() {
                            mask.show();
                            communicationService.remove(utilService.getResouceUrl(constsService.RM_URL.mappingURL + "/" + row.mappingId)).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            $("#datasTable").widget().option("cur-page", {
                                                "pageIndex": 1
                                            });
                                            $scope.datasTable.start = 0;
                                            _init();
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });

            var operationAre = {
                    edit: {
                        id: "iconBtnEdit",
                        authKey : $scope.$parent.optResAuthKey,
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                        clickActive: operation.modify,
                        hover: function(rowData) {
                            return 1 === +rowData.role;
                        }
                    },
                    remove: {
                        id: "iconBtnDel",
                        authKey : $scope.$parent.optResAuthKey,
                        template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                        clickActive: operation.remove,
                        hover: function(rowData) {
                            return 1 === +rowData.role;
                        }
                    }
                },
                operationAre = appUtils.tableHoverWrapper(operationAre);;

            $scope.datasTable = {
                id: "datasTable",
                paginationStyle:"full_numbers",
                isDraggedRemember: false,
                columns: columns,
                displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                totalRecords: 0,
                enablePagination: true,
                currPage: {
                    "pageIndex": 1
                },
                start: 0,
                callback: function(evtObj) {
                    $scope.datasTable.start = evtObj.currentPage - 1;
                    _init();
                },
                renderRow: function(nRow, aData, iDataIndex) {},
                cellClickActive: function(e, param) {},
                data: [],
                opAreaConfig: appUtils.flilterOperRight([operationAre.edit, operationAre.remove]),
                hoverActive: function(e, param) {
                    operationAre.notify(param);
                },
                sortCallback: function(nNode, sortArr) {
                    $scope.datasTable.orderBy = $scope.datasTable.columns[sortArr[0][0]].mData;
                    $scope.datasTable.orderType = sortArr[0][1];
                    _init();
                },
                orderBy: "productResourceName",
                orderType: "desc",
                refreshData: function() {
                    _init();
                }
            };

            var _init = function(id) {
                var paramObj = {
                        filterName: "resourceProviderId",
                        filterValue: cloudObj.deviceSn,
                        resourceType: mappingViewType,
                        orderBy: $scope.datasTable.orderBy,
                        orderType: $scope.datasTable.orderType,
                        startPage: $scope.datasTable.start,
                        pageSize: $scope.datasTable.displayLength
                    },
                    url = appUtils.fillUrl(constsService.RM_URL.mappingURL, paramObj),
                    promise = communicationService.get(url, null, null, 3600000).promise();

                promise.always(_updateUI);

                $scope.maskHandler = promise;
            };

            var _updateUI = function(result) {
                if (exception.check(result)) {

                    appUtils.encodeForHTML(result);

                    $scope.datasTable.data = result.records;
                    $scope.datasTable.totalRecords = result["totalCount"];
                    $scope.datasTable.enablePagination = +$scope.datasTable.totalRecords > $scope.datasTable.displayLength;
                    $scope.$apply();
                }
            };

            $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, function(ev, data) {
                if (2 === constsService.FUSIONSPHERE_ENUM[data.cloudType]) {
                    return;
                }

                cloudObj = data;
                _init();
            });

            !_.isEmpty(cloudObj) && (_init());
        }
    ];

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.cloud.rm.ctrl', ctrler);
    return module;
});
