define(["tiny-common/UnifyValid", "tiny-extra-lib/jquery.base64"], function (UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService",
        "appUtils",
        "infoTransferredService",
        "cookieService",
        function ($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService, appUtils, infoTransferredService, cookieService) {

            var winObj =  $("#modifyVrgHostDevAliasWinId").widget(),
                deviceType = winObj.option("data").deviceType, versionType = "";

            $scope.TIPS = appUtils.getString("res_term_vrg_host_alias_tips");
            $scope.securityTips = appUtils.getString("common_term_security_auth_message", "ism.drm.deviceType.drhost.mainType" == deviceType ? "HMAC_SHA2" : "HMAC_SHA1");
            $scope.snmpv3Form = constsService.RES_SNMPV3_URL;
            $scope.model = {
                labelwidth: "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? "75px" : "145px",
                labels: {
                    name: appUtils.getStringWithColon("common_term_name_label"),
                    manageInfo: appUtils.getString("common_term_auth_label"),
                    protocolUsername: appUtils.getStringWithColon("common_term_username_label"),
                    ip: appUtils.getStringWithColon("common_term_ip_column"),
                    pwd: appUtils.getStringWithColon("common_term_password_label"),
                    protocalPort: appUtils.getStringWithColon("common_term_port_label"),
                    mask: appUtils.getStringWithColon("common_term_netmask_label"),
                    gateway: appUtils.getStringWithColon("common_term_gateway_label"),
                    alarmInfo: appUtils.getString("res_term_modify_alarminfo_labele"),
                    type: appUtils.getStringWithColon("common_term_type_label"),
                    count: appUtils.getStringWithColon("vrg_term_count_label"),
                    alarmPort: appUtils.getStringWithColon("common_term_port_label"),
                    env: appUtils.getStringWithColon("vrg_term_env_label"),
                    authProtocol: appUtils.getStringWithColon("vrg_term_auth_protocol_label"),
                    encryptProtocol: appUtils.getStringWithColon("vrg_term_encrypt_protocol_label"),
                    timeout: appUtils.getStringWithColon("vrg_term_timeout_label"),
                    alarmUsername: appUtils.getStringWithColon("common_term_username_label"),
                    engine: appUtils.getStringWithColon("vrg_term_engine_label"),
                    encryptPwd: appUtils.getStringWithColon("vrg_term_encrypt_pwd_label"),
                    authPwd: appUtils.getStringWithColon("vrg_term_auth_pwd_label")

                },
                name: {
                    id: "name",
                    value: $("#modifyVrgHostDevAliasWinId").widget().option("data").name,
                    width: constsService.W3,
                    extendFunction: ["checkDeviceName"],
                    validate: "checkDeviceName : extend function;"
                },
                manageInfo: {
                    id: "manageInfo",
                    items: [
                        {label: appUtils.getString("common_term_enable_label"), value: "on"},
                        {label: appUtils.getString("common_term_disable_label"), value: "off"}
                    ],
                    standard: true,
                    change: function () {
                        var selected = $("#manageInfo").widget().option("selected");
                        if (selected == "on") {
                            $scope.model.ip.disable = true;
                            $scope.model.ip.require = false;
                            $scope.model.protocalPort.disable = true;
                            $scope.model.protocalPort.require = false;
                            $scope.model.mask.disable = true;
                            $scope.model.gateway.disable = true;
                            $scope.model.protocolUsername.disable = true;
                            $scope.model.protocolUsername.require = false;
                            $scope.model.pwd.disable = true;
                            $scope.model.pwd.require = false;
                            $scope.model.pwd.value = "********";
                        }
                        if (selected == "off") {
                            $scope.model.ip.disable = false;
                            $scope.model.ip.require = true;
                            $scope.model.protocalPort.disable = false;
                            $scope.model.protocalPort.require = true;
                            $scope.model.mask.disable = false;
                            $scope.model.gateway.disable = false;
                            $scope.model.protocolUsername.disable = false;
                            $scope.model.protocolUsername.require = true;
                            $scope.model.pwd.disable = false
                            $scope.model.pwd.require = true;
                            $scope.model.pwd.value = "";
                        }
                    }
                },
                protocolUsername: {
                    id: "protocolUsername",
                    value: "",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    validate: constsService.VALID.AUTH_NAME
                },
                ip: {
                    id: "ip",
                    value: "",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    "validate": constsService.VALID.IP_STANDARD
                },
                protocalPort: {
                    id: "protocalPort",
                    width: constsService.W3,
                    require: false,
                    disable: true,
                    value: "ism.drm.deviceType.drhost.mainType" == deviceType ? "59526" : "8080",
                    min: "1",
                    max: "65535",
                    change: function () {
                        if ($("#protocalPort").widget().option("value") === "") {
                            if ("ism.drm.deviceType.drhost.mainType" == deviceType) {
                                $("#protocalPort").widget().option("value", "59526");
                                $scope.model.protocalPort.value = "59526";
                            } else {
                                $("#protocalPort").widget().option("value", "8080");
                                $scope.model.protocalPort.value = "8080";
                            }
                        }
                    },
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }]
                },
                pwd: {
                    id: "protocalPwd",
                    type: "password",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    validate: constsService.VALID.AUTH_PWD,
                    isFocusPwd: false,
                    focus: function (event) {
                        if (!this.isFocusPwd) {
                            this.isFocusPwd = true;
                            infoTransferredService.put("protocalPwdModule", "protocalPwd", true);
                            $('#protocalPwd').widget().option('value', "");
                        }
                    }
                },
                mask: {
                    id: "mask",
                    value: "",
                    require: false,
                    disable: true,
                    display: "ism.drm.deviceType.drhost.mainType" == deviceType ? false : true,
                    width: constsService.W3,
                    validate: constsService.VALID.MASK
                },
                gateway: {
                    id: "gateway",
                    value: "",
                    require: false,
                    disable: true,
                    display: "ism.drm.deviceType.drhost.mainType" == deviceType ? false : true,
                    width: constsService.W3,
                    "validate": [
                        {
                            validFn: "ipv4Standard",
                            errorDetail: appUtils.getString("validate_term_common_ip_standard_rule_label")
                        }]
                },
                alarmInfo: {
                    id: "alarmInfo",
                    items: [
                        {label: appUtils.getString("common_term_enable_label"), value: "on"},
                        {label: appUtils.getString("common_term_disable_label"), value: "off"}
                    ],
                    standard: true,
                    change: function () {
                        var selected = $("#alarmInfo").widget().option("selected");
                        if (selected == "on") {
                            $scope.securityContainer = false;
                            $scope.model.count.disable = true;
                            $scope.model.count.require = false;
                            $scope.model.timeout.disable = true;
                            $scope.model.timeout.require = false;
                            $scope.model.alarmUsername.disable = true;
                            $scope.model.alarmUsername.require = false;
                            $scope.model.authPwd.disable = true;
                            $scope.model.authPwd.require = false;
                            $scope.model.encryptPwd.disable = true;
                            $scope.model.encryptPwd.require = false;
                            $scope.model.alarmPort.disable = true;
                            $scope.model.alarmPort.require = false;
                            $scope.model.env.disable = true;
                            $scope.model.authProtocol.disable = true;
                            $scope.model.encryptProtocol.disable = true;
                            $scope.model.engine.disable = true;
                            $scope.model.authPwd.disable = true;
                            $scope.model.authPwd.require = false;
                            $scope.model.encryptPwd.disable = true;
                            $scope.model.encryptPwd.require = false;
                        }
                        if (selected == "off") {
                            $scope.model.count.disable = false;
                            $scope.model.count.require = true;
                            $scope.model.timeout.disable = false;
                            $scope.model.timeout.require = true;
                            $scope.model.alarmUsername.disable = false;
                            $scope.model.alarmUsername.require = true;
                            $scope.model.alarmPort.disable = false;
                            $scope.model.alarmPort.require = true;
                            if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                                $scope.securityContainer = false;
                                $scope.model.env.disable = true;
                                $scope.model.engine.disable = true;
                                $scope.model.authProtocol.disable = true;
                                $scope.model.encryptProtocol.disable = true;
                                $scope.model.authPwd.disable = false;
                                $scope.model.authPwd.require = true;
                                $scope.model.encryptPwd.disable = false;
                                $scope.model.encryptPwd.require = true;
                                $scope.model.authProtocol.selectedid = "HMAC_SHA1";
                                $scope.model.encryptProtocol.selectedid = "AES";
                            } else {
                                $scope.securityContainer = true;
                                $scope.model.env.disable = false;
                                $scope.model.engine.disable = true;
                                $scope.model.authPwd.disable = false;
                                $scope.model.authPwd.require = true;
                                $scope.model.authProtocol.disable = false;
                                $scope.model.encryptProtocol.disable = false;
                                var authProtocolId = $("#authProtocol").widget().getSelectedId();
                                switch (authProtocolId) {
                                    case "":
                                        $scope.model.authPwd.disable = true;
                                        $scope.model.authPwd.require = false;
                                        $scope.model.encryptProtocol.disable = true;
                                        $scope.model.encryptProtocol.require = false;
                                        break;
                                    case "HMAC_SHA1":
                                    case "HMAC_SHA2":
                                    case "HMACMD5":
                                        if (_.isUndefined(versionType) || _.isEmpty(versionType)) {
                                            $("#authPwd").widget().option("value", "");
                                        }
                                        $scope.model.authPwd.disable = false;
                                        $scope.model.authPwd.require = true;
                                        $scope.model.encryptProtocol.disable = false;
                                        $scope.model.encryptProtocol.require = true;
                                        break;
                                }
                                var encryptProtocolId = $("#encryptProtocol").widget().getSelectedId();
                                switch (encryptProtocolId) {
                                    case "":
                                        $scope.model.encryptPwd.disable = true;
                                        $scope.model.encryptPwd.require = false;
                                        break;
                                    case "DES":
                                    case "AES":
                                        if ((_.isUndefined(versionType) || _.isEmpty(versionType) && !_.isEmpty(authProtocolId))) {
                                            $("#encryptPwd").widget().option("value", "");
                                        }
                                        $scope.model.encryptPwd.disable = false;
                                        $scope.model.encryptPwd.require = true;
                                        break;
                                }
                            }
                        }
                    }
                },
                type: {
                    id: "type",
                    width: constsService.W3,
                    validate: "",
                    disable: true,
                    value: [
                        {
                            selectId: "SNMPv3",
                            label: "SNMPv3"
                        }
                    ],
                    "selectedid": "SNMPv3"
                },
                count: {
                    id: "count",
                    width: constsService.W3,
                    require: false,
                    disable: true,
                    value: "3",
                    min: "0",
                    max: "5",
                    change: function () {
                        if ($("#count").widget().option("value") === "") {
                            $("#count").widget().option("value", "3");
                            $scope.model.count.value = "3";
                        }
                    },
                    validate: "required"
                },
                env: {
                    id: "env",
                    value: "",
                    width: constsService.W3,
                    disable: true,
                    validate: constsService.VALID.ENV_NAME
                },
                alarmPort: {
                    id: "alarmPort",
                    width: constsService.W3,
                    require: false,
                    disable: true,
                    value: "161",
                    min: "1",
                    max: "65535",
                    change: function () {
                        if ($("#alarmPort").widget().option("value") === "") {
                            $("#alarmPort").widget().option("value", "161");
                            $scope.alarmPort.count.value = "161";
                        }
                    },
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 65535],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                    }, {
                        validFn: "integer"
                    }]
                },
                authProtocol: {
                    id: "authProtocol",
                    width: constsService.W3,
                    validate: "",
                    disable: true,
                    value: [
                        {
                            selectId: "",
                            label: "None"
                        },
                        {
                            selectId: "HMACMD5",
                            label: "HMACMD5"
                        },
                        {
                            selectId: "HMAC_SHA1",
                            label: "HMAC_SHA1"
                        },
                        {
                            selectId: "HMAC_SHA2",
                            label: "HMAC_SHA2"
                        }
                    ],
                    selectedid: "HMAC_SHA2",
                    change: function () {
                        var authProtocolId = $("#authProtocol").widget().getSelectedId();
                        switch (authProtocolId) {
                            case "":
                                $scope.model.authPwd.disable = true;
                                $scope.model.authPwd.require = false;
                                $scope.model.encryptProtocol.disable = true;
                                $scope.model.encryptProtocol.require = false;
                                $scope.model.encryptPwd.disable = true;
                                $scope.model.encryptPwd.require = false;
                                break;
                            case "HMAC_SHA1":
                            case "HMAC_SHA2":
                            case "HMACMD5":
                                $scope.model.authPwd.disable = false;
                                $scope.model.authPwd.require = true;
                                $scope.model.encryptProtocol.disable = false;
                                $scope.model.encryptProtocol.require = true;
                                if ("" != $("#encryptProtocol").widget().getSelectedId()) {
                                    $scope.model.encryptPwd.disable = false;
                                    $scope.model.encryptPwd.require = true;
                                } else {
                                    $scope.model.encryptPwd.disable = true;
                                    $scope.model.encryptPwd.require = false;
                                }
                                break;
                        }
                    }
                },
                encryptProtocol: {
                    id: "encryptProtocol",
                    width: constsService.W3,
                    validate: "",
                    disable: true,
                    value: [
                        {
                            selectId: "",
                            label: "None"
                        },
                        {
                            selectId: "DES",
                            label: "DES"
                        },
                        {
                            selectId: "AES",
                            label: "AES"
                        }
                    ],
                    selectedid: "AES",
                    change: function () {
                        var encryptProtocolId = $("#encryptProtocol").widget().getSelectedId();
                        switch (encryptProtocolId) {
                            case "":
                                $scope.model.encryptPwd.disable = true;
                                $scope.model.encryptPwd.require = false;
                                break;
                            case "DES":
                            case "AES":
                                $scope.model.encryptPwd.disable = false;
                                $scope.model.encryptPwd.require = true;
                                break;
                        }
                    }
                },
                timeout: {
                    id: "timeout",
                    width: constsService.W3,
                    require: false,
                    disable: true,
                    value: "5",
                    min: "0",
                    max: "5",
                    change: function () {
                        if ($("#timeout").widget().option("value") === "") {
                            $("#timeout").widget().option("value", "5");
                            $scope.model.port.value = "5";
                        }
                    },
                    validate: "required"
                },
                alarmUsername: {
                    id: "alarmUsername",
                    value: "",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    extendFunction: ["checkAuthSecriyName"],
                    validate: "checkAuthSecriyName : extend function;"
                },
                engine: {
                    id: "engineId",
                    value: "",
                    width: constsService.W3,
                    disable: true,
                    validate: constsService.VALID.ENGINE_ID
                },
                authPwd: {
                    id: "authPwd",
                    type: "password",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    isFocusPwd: false,
                    focus: function (event) {
                        if (!this.isFocusPwd) {
                            this.isFocusPwd = true;
                            infoTransferredService.put("authPwdModule", "authPwd", true);
                            $('#authPwd').widget().option('value', "");
                        }
                    },
                    extendFunction: ["checkAuthPassword"],
                    validate: "checkAuthPassword : extend function;"
                },
                encryptPwd: {
                    id: "encryptPwd",
                    type: "password",
                    require: false,
                    disable: true,
                    width: constsService.W3,
                    isFocusPwd: false,
                    focus: function (event) {
                        if (!this.isFocusPwd) {
                            this.isFocusPwd = true;
                            infoTransferredService.put("encryptPwdModule", "encryptPwd", true);
                            $('#encryptPwd').widget().option('value', "");
                        }
                    },
                    extendFunction: ["checkEncryptPassword"],
                    validate: "checkEncryptPassword : extend function;"
                }
            }

            /**
             * 校验设备名称
             * @return
             */
            UnifyValid.checkDeviceName = function () {
                var deviceName = $.trim($("#name").widget().getValue());
                if (!deviceName) {
                    return appUtils.getString("common_term_empty_label");
                }

                if (deviceName.length < 1 || deviceName.length > 128) {
                        return appUtils.getString("validate_term_expr_length");
                }

                return "";
            }

            /**
             * 校验告警用户名
             * @returns {}
             */
            UnifyValid.checkAuthSecriyName = function () {
                var userName = $.trim($("#alarmUsername").widget().getValue());
                if (!userName) {
                    return appUtils.getString("common_term_empty_label");
                }

                if ("ism.drm.deviceType.drhost.mainType" === deviceType) {
                    if (userName.length > 64) {
                        return appUtils.getString("validate_term_common_length_range_1_64_msg");
                    }
                } else {
                    var reg = /^[\\x00-\xff]*$/;
                    if (!reg.test(userName)) {
                        return appUtils.getString("common_term_ver_regexSnmp_label");
                    }
                }

                return "";
            };

            /**
             * 校验认证密码
             */
            UnifyValid.checkAuthPassword = function () {
                //compare password with user name
                var userName = $("#alarmUsername").widget().getValue();
                var authPwd = $.trim($("#authPwd").widget().getValue());
                var reverseName = userName.split('').reverse();
                reverseName = reverseName.join('');
                var isSameWithName = authPwd == userName || authPwd == reverseName;

                if (!authPwd) {
                    return appUtils.getString("common_term_empty_label");
                }

                var authPwdIsFocusPwd = infoTransferredService.get("authPwdModule", "authPwd");
                if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                    if (utilService.isNotEmpty(authPwdIsFocusPwd) && authPwdIsFocusPwd) {
                        if (!appUtils.checkUserPwd(authPwd, 8, 4) || isSameWithName) {
                            return appUtils.getString("validate_term_Message_Password_Complex", 8, 32);
                        }
                    }
                } else {
                    if (utilService.isNotEmpty(authPwdIsFocusPwd) && authPwdIsFocusPwd) {
                        if (authPwd.length > 64) {
                            return appUtils.getString("validate_term_common_length_range_1_64_msg");
                        }
                    }
                }

                return "";
            }

            /**
             * 校验加密密码
             */
            UnifyValid.checkEncryptPassword = function () {
                //compare password with user name
                var userName = $("#alarmUsername").widget().getValue();
                var encryptPwd = $.trim($("#encryptPwd").widget().getValue());
                var reverseName = userName.split('').reverse();
                reverseName = reverseName.join('');
                var isSameWithName = encryptPwd == userName || encryptPwd == reverseName;

                if (!encryptPwd) {
                    return appUtils.getString("common_term_empty_label");
                }

                var encryptPwdIsFocusPwd = infoTransferredService.get("encryptPwdModule", "encryptPwd");
                if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                    if (utilService.isNotEmpty(encryptPwdIsFocusPwd) && encryptPwdIsFocusPwd) {
                        if (!appUtils.checkUserPwd(encryptPwd, 8, 4) || isSameWithName) {
                            return appUtils.getString("validate_term_Message_Password_Complex", 8, 32);
                        }
                    }
                } else {
                    if (utilService.isNotEmpty(encryptPwdIsFocusPwd) && encryptPwdIsFocusPwd) {
                        if (encryptPwd.length > 64) {
                            return appUtils.getString("validate_term_common_length_range_1_64_msg");
                        }
                    }
                }

                return "";
            }

            $scope.$on('$destroy', function () {
                delete UnifyValid.checkDeviceName;
                delete UnifyValid.checkAuthPassword;
                delete UnifyValid.checkEncryptPassword;
                delete UnifyValid.checkAuthSecriyName;
            })

            var authProtocol = [{
                selectId: "",
                label: "None"
            }, {
                selectId: "HMACMD5",
                label: "HMACMD5"
            }, {
                selectId: "HMAC_SHA1",
                label: "HMAC_SHA1"
            }];

            if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                $scope.model.authProtocol.value = authProtocol;
                $scope.model.authProtocol.selectedid = "HMAC_SHA1";
            }


            var _init = function () {
                //清除会话中的值
                var protocalPwdIsFocusPwd = infoTransferredService.get("protocalPwdModule", "protocalPwd");
                if (utilService.isNotEmpty(protocalPwdIsFocusPwd)) {
                    infoTransferredService.remove("protocalPwdModule", "protocalPwd");
                }

                var authPwdIsFocusPwd = infoTransferredService.get("authPwdModule", "authPwd");
                if (utilService.isNotEmpty(authPwdIsFocusPwd)) {
                    infoTransferredService.remove("authPwdModule", "authPwd");
                }

                var encryptPwdIsFocusPwd = infoTransferredService.get("encryptPwdModule", "encryptPwd");
                if (utilService.isNotEmpty(encryptPwdIsFocusPwd)) {
                    infoTransferredService.remove("encryptPwdModule", "encryptPwd");
                }

                var sn = $("#modifyVrgHostDevAliasWinId").widget().option("data").sn;
                var url = "/resources/" + $.base64.encode(sn) + "/action/getMgrProtocol";
                mask.show();
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function (result) {
                    mask.hide();
                    if (exception.check(result)) {
                        //发消息给父界面
                        infoTransferredService.put("protocalTypeModule", "NMPv3", result.extendParams.snmpVersion);

                        if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                            $scope.model.mask.value = result.extendParams.mac_address;
                            $scope.model.gateway.value = result.extendParams.gateway_address;
                        }
                        $scope.model.ip.value = result.networkIpAddress;
                        $scope.model.protocalPort.value = result.extendParams.port;
                        $scope.model.protocolUsername.value = result.networkUserName;
                        if (!$scope.model.pwd.isFocusPwd) {
                            $scope.model.pwd.value = "********";
                        }

                        versionType = result.extendParams.snmpVersion;
                        $scope.model.count.value = _.isEmpty(result.extendParams.snmpRetries) ? "3" : result.extendParams.snmpRetries;
                        $scope.model.timeout.value = _.isEmpty(result.extendParams.snmpTimeout) ? "5" : result.extendParams.snmpTimeout;
                        $scope.model.alarmPort.value = _.isEmpty(result.extendParams.snmpPort) ? "161" : result.extendParams.snmpPort;
                        $scope.model.alarmUsername.value = result.extendParams.snmpSecurityName;
                        $scope.model.env.value = result.extendParams.snmpContextName;
                        $scope.model.engine.value = result.extendParams.snmpContextEngineId;
                        if (!$scope.model.authPwd.isFocusPwd) {
                            $scope.model.authPwd.value = "********";
                        }
                        if (!$scope.model.encryptPwd.isFocusPwd) {
                            $scope.model.encryptPwd.value = "********";
                        }

                        if ("ism.drm.deviceType.vrg.mainType" == deviceType) {
                            $scope.model.authProtocol.selectedid = "HMAC_SHA1";
                            $scope.model.encryptProtocol.selectedid = "AES";
                        } else {
                            var snmpAuthProtocol = result.extendParams.snmpAuthProtocol;
                            switch (snmpAuthProtocol) {
                                case "":
                                    $scope.model.authProtocol.selectedid = "";
                                    $scope.model.authPwd.disable = true;
                                    $scope.model.encryptProtocol.disable = true;
                                    break;
                                case "HMACMD5":
                                    $scope.model.authProtocol.selectedid = "HMACMD5";
                                    $scope.model.authPwd.disable = true;
                                    $scope.model.encryptProtocol.disable = true;
                                    break;
                                case "HMAC_SHA1":
                                case "HMACSHA":
                                    $scope.model.authProtocol.selectedid = "HMAC_SHA1";
                                    $scope.model.authPwd.disable = true;
                                    $scope.model.encryptProtocol.disable = true;
                                    break;
                                case "HMAC_SHA2":
                                    $scope.model.authProtocol.selectedid = "HMAC_SHA2";
                                    $scope.model.authPwd.disable = true;
                                    $scope.model.encryptProtocol.disable = true;
                                    break;
                            }
                            ;
                            var snmpEncryptProtocol = result.extendParams.snmpEncryptProtocol;
                            switch (snmpEncryptProtocol) {
                                case "":
                                    $scope.model.encryptProtocol.selectedid = "";
                                    $scope.model.encryptPwd.disable = true;
                                    break;
                                case "DES":
                                    $scope.model.encryptProtocol.selectedid = "DES";
                                    $scope.model.encryptPwd.disable = true;
                                    break;
                                case "AES":
                                    $scope.model.encryptProtocol.selectedid = "AES";
                                    $scope.model.encryptPwd.disable = true;
                                    break;
                            }
                            ;
                        }
                    }
                    $scope.$apply();
                });
            };

            _init();

            function changeOkHandler(okcb) {
                var okBtn = _.findWhere(winObj.options.buttons, {
                        key: "ok"
                    }),
                    okHandler = okBtn.handler;

                okBtn.handler = function() {
                    okcb.call(winObj, okHandler);
                }
            }

            //可以将确定逻辑放到这
            changeOkHandler(function(callback) {
                if (!UnifyValid.FormValid($("#container"), {focusInvalid: true})) {
                    return;
                }
                var msg, switchFlag = $("#manageInfo").widget().option("selected") == "on";
                if (switchFlag) {
                    msg = [appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg1"), appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg2"), appUtils.getString("site_DRmanagementServer_task_modifyDeviceCommunicationPara_warm_msg3")].join("<br/>");
                    message.warn(msg).then(function() {
                        callback();
                    });
                    return;
                }
                callback();
            })
        }]

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("resModule.vrgHostEdit.ctrl", ctrler);
    return module;
});

