define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "$timeout",
        "message",
        "constsService",
        "appUtils",
        "infoTransferredService",
        "restService",
        "communicationService",
        "exception",
        function($scope, $state, $stateParams, $timeout, message, constsService, appUtils,
            infoTransferredService, restService, communicationService, exception) {
            var site = infoTransferredService.get("site", "currentSite");
            var openstackObj = infoTransferredService.get("openstackPairKey", "openstackUuid");
            var azPairFlag = $stateParams.pairType == "azPair";
            var cloneFilters1 = [];
            var cloneFilters2 = [];
            var cloneFilters3 = [];
            var defaultTable = {
                labelClass: "labelClass",
                primaryId: {
                    id: "primaryId0",
                    width: 120,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function() {
                        return $("#" + this.id).widget().getValue()
                    }
                },
                primaryName: {
                    id: "primaryName0",
                    disable: false,
                    width: azPairFlag ? 120 : 150,
                    extendFunction: ["checkVoltype"],
                    validate: "checkVoltype : extend function;",
                    placeholder: appUtils.getString("site_openstack_vol_type_placeholder_label"),
                    getVal: function() {
                        return $.trim($("#" + this.id).widget().getValue())
                    },
                    blur: function(volMappings, azPairSelect, primaryVolType, typeId) {
                        var typeId = $("#" + typeId).widget().getSelectedId();
                        var primaryAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[0];
                        var secondAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[1];
                        if (_.isEmpty(secondAz) || _.isEmpty(primaryAz)) {
                            return;
                        }
                        angular.forEach(volMappings, function (vol) {
                            var sameDestPrimaryType = _.findWhere(pairsList, { "primary_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": typeId });
                            var sameDestSecondType = _.findWhere(pairsList, { "second_volType": vol.mapType.value, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": typeId });
                            if (typeId === "vha") {
                                sameDestPrimaryType = sameDestPrimaryType || _.findWhere(pairsList, {"primary_volType": vol.mapType.value, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": typeId});
                                sameDestSecondType = sameDestSecondType || _.findWhere(pairsList, {"second_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": typeId});
                            }
                            vol.priority.value = "";
                            vol.priority.show = !_.isUndefined(sameDestPrimaryType) || !_.isUndefined(sameDestSecondType) || _.size(volMappings) > 1;
                            $scope.$evalAsync();
                        });

                        var filters = _.filter($scope.pairRelation.table, function(t) {
                            return t.primaryName.getVal() == primaryVolType && !_.isEmpty($.trim(primaryVolType));
                        });

                        if (_.size(filters) > 1) {
                            cloneFilters1 = filters;
                            _.each(filters, function(f) {
                                _.each(f.volMappings, function(v) {
                                    v.priority.value = "";
                                    v.priority.show = true;
                                    $scope.$evalAsync();
                                });
                            });
                        } else {
                            _.each(_.reject(cloneFilters1, function(v, i, list) {
                                return v.primaryName.getVal() == primaryVolType;
                            }), function(value, key, list) {
                                if (value.volMappings.length == 1) {
                                    value.volMappings[0].priority.value = "";
                                    value.volMappings[0].priority.show = false;
                                    $scope.$evalAsync();
                                }
                            });;
                        }
                    }
                },
                secondId: {
                    id: "secondId0",
                    width: 120,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function() {
                        return $("#" + this.id).widget().getValue()
                    }
                },
                secondName: {
                    id: "secondName0",
                    showCondition: 'csha',
                    width: azPairFlag ? 120 : 150,
                    extendFunction: ["checkVoltype"],
                    validate: "checkVoltype : extend function;",
                    placeholder: appUtils.getString("site_openstack_vol_type_placeholder_label"),
                    getVal: function() {
                        if ( $("#typer" + this.id.slice(10)).widget().getSelectedId() == "vha") {
                            return "";
                        }
                        return $.trim($("#" + this.id).widget().getValue())
                    }
                },
                volMappings: [{
                    mapType: {
                        id: "mapType11",
                        width: azPairFlag ? 120 : 150,
                        value: "",
                        disable: true,
                        extendFunction: ["checkVoltype"],
                        validate: "checkVoltype : extend function;",
                        placeholder: appUtils.getString("site_openstack_vol_type_placeholder_label"),
                        getVal: function() {
                            return $.trim($("#" + this.id).widget().getValue());
                        },
                        blur: function(volMappings, azPairSelect, primaryVolType, secondVolType, priority, typeId) {
                            var selectedType = $("#" + typeId).widget().getSelectedId();
                            var primaryAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[0];
                            var secondAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[1];
                            if (_.isEmpty(secondAz) || _.isEmpty(primaryAz)) {
                                return;
                            }

                            var sameDestPrimaryType = _.findWhere(pairsList, {"primary_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});
                            var sameDestSecondType = _.findWhere(pairsList, {"second_volType": secondVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});

                            if (selectedType === "vha") {
                                sameDestPrimaryType = sameDestPrimaryType || _.findWhere(pairsList, {"primary_volType": secondVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});
                                sameDestSecondType = sameDestSecondType || _.findWhere(pairsList, {"second_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});
                            }

                            priority.value = "";
                            priority.show = !_.isUndefined(sameDestPrimaryType) || !_.isUndefined(sameDestSecondType) || _.size(volMappings) > 1;

                            var maps = [];
                            _.each($scope.pairRelation.table, function(pair) {
                                maps = _.union(maps, _.filter(pair.volMappings, function(v) {
                                    return v.mapType.value == secondVolType && !_.isEmpty($.trim(v.mapType.value));
                                }));
                            });

                            if(_.size(_.filter($scope.pairRelation.table, function(item){
                                return item.primaryName.getVal() == primaryVolType
                            })) > 1){
                                priority.show = true;
                            };

                            if (_.size(maps) > 1) {
                                cloneFilters3 = maps;
                                _.each(maps, function(m) {
                                    m.priority.value = "";
                                    m.priority.show = true;
                                });
                            }
                            else {
                                _.each($scope.pairRelation.table, function(pair) {
                                    if (_.size(pair.volMappings) == 1 && !_.isUndefined(_.find(cloneFilters3, function(c) {
                                        return pair.volMappings[0].mapType.value == c.mapType.value;
                                    }))) {
                                        pair.volMappings[0].priority.value = "";
                                        pair.volMappings[0].priority.show = false;
                                    }
                                });

                            }
                            $scope.$evalAsync();
                        }
                    },
                    priority: {
                        id: "priority11",
                        width: 120,
                        disabled: false,
                        value: "",
                        min: "1",
                        value: "",
                        max: "1000",
                        show: false,
                        validate: [{
                                validFn: "required",
                                errorDetail: appUtils.getString("validate_term_common_priority_msg")
                            }, {
                                validFn: "rangeValue",
                                params: [1, 1000],
                                errorDetail: appUtils.getString("validate_term_common_priority_msg")
                            }, {
                                validFn: "integer",
                                errorDetail: appUtils.getString("validate_term_common_priority_msg")
                        }],
                        change: function(pair, currentVolMapping) {
                            var {volMappings, azPairSelect, primaryName, typer} = pair;
                            var {mapType, priority} = currentVolMapping;
                            var primaryVolType = $("#" + primaryName.id).widget().currentValue;
                            var secondVolType = $("#" + mapType.id).widget().currentValue;
                            var primaryAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[0];
                            var secondAz = $("#" + azPairSelect.id).widget().getSelectedId().split(" <--> ")[1];
                            var selectedType = $("#" + typer.id).widget().getSelectedId();
                            if (_.isEmpty(secondAz) || _.isEmpty(primaryAz)) {
                                return;
                            }

                            var sameDestPrimaryPriority = _.findWhere(pairsList, {"primary_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType, "priority": +priority.value});
                            var sameDestSecondPriority = _.findWhere(pairsList, {"second_volType": secondVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType, "priority": +priority.value});

                            if (selectedType === "vha") {
                                sameDestPrimaryPriority = sameDestPrimaryPriority || _.findWhere(pairsList, {"primary_volType": secondVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType, "priority": +priority.value});
                                sameDestSecondPriority = sameDestSecondPriority || _.findWhere(pairsList, {"second_volType": primaryVolType, "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType, "priority": +priority.value});
                            }

                            var manySamePriority = _.find(_.reject(volMappings, function(v) {
                                return v.priority.id === priority.id;
                            }), function(vol) {
                                return vol.priority.value == priority.value;
                            });
                            var prioritys = [];
                            _.each($scope.pairRelation.table, function(pair) {
                                _.each(pair.volMappings, function(v) {
                                    if (v.mapType.value == secondVolType && !_.isEmpty($.trim(v.priority.value)) && priority.id != v.priority.id && $.trim(v.priority.value) == priority.value) {
                                        prioritys.push(v.priority.value);
                                    }
                                });
                            });
                            priority.value = !_.isUndefined(sameDestPrimaryPriority) || !_.isUndefined(sameDestSecondPriority) || !_.isUndefined(manySamePriority) || !!_.size(prioritys) ? "" : priority.value;
                            $scope.$evalAsync();
                        },
                        getVal: function() {
                            return +$("#" + this.id).widget().option("value");
                        },
                        placeholder: appUtils.getString("site_openstack_vol_priority_placeholder_label"),
                    },
                    btnRemoveMapping: {
                        text: appUtils.getString("common_term_delete_button"),
                        getVal: function() {},
                        click: function(pair, vol) {
                            var index = _.indexOf(pair.volMappings, vol);
                            var primaryName = $("#" + pair.primaryName.id).widget().getValue();
                            var primaryAz = $("#" + pair.azPairSelect.id).widget().getSelectedId().split(" <--> ")[0];
                            var secondAz = $("#" + pair.azPairSelect.id).widget().getSelectedId().split(" <--> ")[1];
                            var selectedType = $("#" + pair.typer.id).widget().getSelectedId();
                            if (_.isEmpty(secondAz) || _.isEmpty(primaryAz)) {
                                return;
                            }
                            pair.volMappings.splice(index, 1);
                            _.size(pair.volMappings) == 1 && angular.forEach(pair.volMappings, function(vol) {
                                var sameDestPrimaryType = _.findWhere(pairsList, {"primary_volType": $.trim(pair.primaryName.value), "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});
                                var sameDestSecondType = _.findWhere(pairsList, {"second_volType": $.trim($("#" + vol.mapType.id).widget().getValue()), "primary_az_id": primaryAz, "second_az_id": secondAz, "type": selectedType});
                                vol.priority.show = !_.isUndefined(sameDestPrimaryType) || !_.isUndefined(sameDestSecondType);
                                $scope.$evalAsync();
                            });

                            var filters = _.filter($scope.pairRelation.table, function(t) {
                                return t.primaryName.getVal() == pair.primaryName.value && !_.isEmpty(pair.primaryName.value);
                            });

                            if (_.size(filters) > 1) {
                                cloneFilters2 = filters;
                                _.each(filters, function(f) {
                                    _.each(f.volMappings, function(v) {
                                        v.priority.value = "";
                                        v.priority.show = true;
                                        $scope.$evalAsync();
                                    });
                                });
                            } else {
                                _.each(_.reject(cloneFilters2, function(v, i, list) {
                                    return v.primaryName.getVal() == pair.primaryName.value;
                                }), function(value, key, list) {
                                    if (value.volMappings.length == 1) {
                                        value.volMappings[0].priority.value = "";
                                        value.volMappings[0].priority.show = false;
                                        $scope.$evalAsync();
                                    }
                                });
                            }
                        }
                    }
                }],
                btnAddVols: {
                    show: false,
                    text: appUtils.getString("site_openstack_addvoltype_label"),
                    click: function(volMappings) {
                        var volMapping = angular.copy(_.last(volMappings));
                        volMappings.push({
                            mapType: _.extend(volMapping.mapType, {
                                id: "mapType" + _.size($scope.pairRelation.table) + (_.size(volMappings) + 1),
                                value: ""
                            }),
                            priority: _.extend(volMapping.priority, {
                                id: "priority" + _.size($scope.pairRelation.table) + (_.size(volMappings) + 1),
                                value: ""
                            }),
                            btnRemoveMapping: volMapping.btnRemoveMapping
                        })
                        _.each(volMappings, function(volMapping) {
                            volMapping.priority.show = true;
                        });
                        $scope.$evalAsync();
                    }
                },
                typer: {
                    id: "typer0",
                    values: [{
                        "selectId": "csha",
                        "label": appUtils.getString("cloud_service_csha_instance_label")
                    }, {
                        "selectId": "csdr",
                        "label": appUtils.getString("cloud_service_csdr_instance_label")
                    }, {
                        "selectId": "vha",
                        "label": appUtils.getString("cloud_service_vha_instance_label")
                    }],
                    width: 150,
                    defaultSelectId: "csha",
                    change: function() {
                        var that = this;
                        $("#azPairSelect" + that.id.slice(5)).widget().option("values", [{
                            "selectId": "-1",
                            "label": appUtils.getString("site_openstack_pair_az_select_label")
                        }]);
                        
                        _.each($scope.pairRelation.table, function(val) {
                            
                            val.secondName.showCondition = $("#" + val.typer.id).widget().getSelectedId();
                            if (val.azPairSelect.id == "azPairSelect" + that.id.slice(5)) {
                                val.azPrimary = "";
                                val.azSecond = "";
                                val.azPairSelect.defaultSelectId = "-1";
                                var length = _.size(val.volMappings);
                                val.volMappings.splice(1, length);
                                angular.forEach(val.volMappings, function(vol) {
                                    vol.mapType.value = "";
                                    vol.priority.value = "";
                                    vol.priority.show = false;
                                    vol.mapType.disable = $("#" + val.azPairSelect.id).widget().getSelectedId() == "-1" || _.isEmpty($("#" + val.azPairSelect.id).widget().getSelectedId());
                                    vol.priority.disable = $("#" + val.azPairSelect.id).widget().getSelectedId() == "-1" || _.isEmpty($("#" + val.azPairSelect.id).widget().getSelectedId());
                                });
                                val.primaryName.value = "";
                                val.primaryName.disable = $("#" + val.azPairSelect.id).widget().getSelectedId() == '-1' || _.isEmpty($("#" + val.azPairSelect.id).widget().getSelectedId());
                                val.btnAddVols.show = true;
                            };
                        });
                        $scope.$evalAsync();
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId()
                    }
                },
                azPrimary: "",
                azSecond: "",
                azPairSelect: {
                    id: "azPairSelect0",
                    require: true,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("site_openstack_pair_az_select_label")
                    }],
                    hasValue: false,
                    disable: false,
                    defaultSelectId: "-1",
                    width: 150,
                    openFn: function(object) {
                        var that = this;
                        var openstackObj = infoTransferredService.get("openstackPairKey", "openstackUuid");
                        var azType = $("#typer" + that.id.slice(12)).widget().getSelectedId();
                        var url = "/ws/openstack/" + openstackObj.deviceSn + "/azpairs?type=" + azType;
                        communicationService.get(url).promise().always(function(result) {
                            if (!exception.check(result)) {
                                return;
                            };
                            if (!_.isEmpty(result)) {
                                var azValues = [];
                                _.each(result, function(item, index) {
                                    if (azType === "vha") {
                                        item.second_region_id = item.primary_region_id;
                                        item.second_az_id = item.primary_az_id;
                                    }
                                    azValues.push({
                                        "selectId": item.primary_region_id + "_@_" + item.primary_az_id + " <--> " + item.second_region_id + "_@_" + item.second_az_id,
                                        "label":  item.primary_region + ":" + item.primary_az + (azType === "vha" ? "" : (" <--> " + item.second_region + ":" + item.second_az)),
                                        "checked": index == 0
                                    });
                                });
                                $("#" + that.id).widget().option("values", azValues);
                                $scope.$apply();
                            } else {
                                object.open();
                            };
                        });
                    },
                    closeFn: function() {
                        var that = this;
                        var azPairId = $("#" + that.id).widget().getSelectedId();
                        if (azPairId != "-1") {
                            _.each($scope.pairRelation.table, function(item) {
                                if (item.azPairSelect.id == "azPairSelect" + that.id.slice(12)) {
                                    item.azPrimary = $("#" + that.id).widget().getSelectedLabel().split(" <--> ")[0].split(":")[1];
                                    if ($("#typer" + that.id.slice(12)).widget().getSelectedId() == "vha") {
                                        item.azSecond = ""
                                    } else {
                                        item.azSecond = $("#" + that.id).widget().getSelectedLabel().split(" <--> ")[1].split(":")[1];
                                    }
                                }
                            })
                        };
                        $scope.$evalAsync();
                    },
                    validateFn: function() {
                        if ($("#typer" + this.id.slice(12)).widget().getSelectedId() == "vha") {
                            return true;
                        };
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    },
                    getVal: function() {
                        if ($("#" + this.id).widget().getSelectedId() == "-1") {
                            return {};
                        };
                        var azValue = $("#" + this.id).widget().getSelectedId().split(" <--> ");
                        return {
                            primaryAz: azValue[0],
                            secondAz: azValue[1]
                        }
                    },
                    change: function(pair) {
                        var azPairCheckedId = $("#" + pair.azPairSelect.id).widget().getSelectedId();
                        pair.azPairSelect.defaultSelectId = azPairCheckedId;
                        pair.primaryName.disable = azPairCheckedId == "-1";
                        angular.forEach(pair.volMappings, function(vol) {
                            vol.mapType.disable = azPairCheckedId == "-1";
                            vol.priority.disable = azPairCheckedId == "-1";
                        });
                        $scope.$evalAsync();
                    }
                },
                removeRow: function() {
                    if (this.removeCls == "default") {
                        return
                    }
                    var pairRelationTable = $scope.pairRelation.table;
                    var index = pairRelationTable.indexOf(this);
                    index != -1 && (pairRelationTable.splice(index, 1));
                    disableDeleteBtn();
                },
                lable: appUtils.getString("common_term_delete_button"),
                removeCls: "default"
            };
            var pairsList = [], pairInfo;
            function queryVolTypePairs() {
                !_.isUndefined(openstackObj) && restService.queryVolTypePairs(openstackObj.deviceSn, function(result) {
                    if (!!_.size(result)) {
                        pairsList = result;
                        if ($stateParams.volTypePairId) {
                            pairsList = _.reject(result, {volType_pair_id: parseInt($stateParams.volTypePairId)})
                        }
                    }
                    if (_.isEmpty($stateParams.volTypePairId)) {
                        return;
                    }
                    pairInfo = _.findWhere(result, {volType_pair_id: parseInt($stateParams.volTypePairId)});
                    restService.queryAzPairs([openstackObj.deviceSn, pairInfo.type], function(result) {
                        var azPair = _.findWhere(result, function(item) {
                            return item.type == pairInfo.type && (item.primary_region_id + "_@_" + primary_az_id) == pairInfo.primary_az_id && (item.second_region_id + "_@_" + second_az_id) == pairInfo.second_az_id;
                        });
                        _.each($scope.pairRelation.table, function(val) {
                            val.btnAddVols.show = false;
                            val.azPrimary = azPair.primary_az;
                            val.azSecond = azPair.second_az;
                            val.secondName.showCondition = pairInfo.type;
                            $("#" + val.typer.id).widget().opChecked(pairInfo.type);
                            $("#" + val.typer.id).widget().option("disable", true);
                            $("#" + val.azPairSelect.id).widget().option("disable", true);
                            $("#" + val.azPairSelect.id).widget().option("values", [{
                                "selectId": azPair.primary_region_id + "_@_" + azPair.primary_az_id + " <--> " + azPair.second_region_id + "_@_" + azPair.second_az_id,
                                "label": azPair.primary_region + ":" + azPair.primary_az + " <--> " + azPair.second_region + ":" + azPair.second_az,
                                "checked": true
                            }]);
                            $("#" + val.primaryName.id).widget().option("disable", true);
                            $("#" + val.primaryName.id).widget().option("value", pairInfo.primary_volType);
                            _.each(val.volMappings, function(volMapping) {
                                volMapping.priority.show = !_.isEmpty($.trim(pairInfo.priority));
                                $("#" + volMapping.mapType.id).widget().option("disable", true);
                                $("#" + volMapping.mapType.id).widget().option("value", pairInfo.second_volType);
                                $("#" + volMapping.priority.id).widget().option("value", $.trim(pairInfo.priority));
                            });
                        })
                        $scope.btnAddRow.show = false;
                        $scope.$apply();
                    })
                })
            }
            //当只有一条数据时，按钮才能灰化
            function disableDeleteBtn() {
                if (_.size($scope.pairRelation.table) == 1) {
                    _.extend($scope.pairRelation.table[0], {
                        removeCls: "default"
                    });
                } else {
                    _.each($scope.pairRelation.table, function(item) {
                        _.extend(item, {
                            removeCls: "pointer"
                        });
                    });
                };
            };
            $scope.addPairLabel = azPairFlag ? appUtils.getString("site_openstack_add_az_pair_label") : appUtils.getString("site_openstack_add_volumetype_pair_label")
            $scope.pairRelation = {
                mappingTitle: appUtils.getString("site_openstack_volume_type_pair_label"),
                typeTitle: appUtils.getString("common_term_type_label"),
                opreationTitle: appUtils.getString("recovery.term.colum.operate.title"),
                table: [angular.copy(defaultTable)],
                id: "ID",
                name: appUtils.getString("common_term_name_label"),
                azSelectTitle: appUtils.getString("site_openstack_pair_az_column_label")
            }
            $scope.isAzPair = $stateParams.pairType == "azPair";
            $scope.btnAddRow = {
                addText: appUtils.getString("common_term_addline_button"),
                show: true,
                click: function() {
                    var addTable = angular.copy(defaultTable);
                    var addId = parseInt($scope.pairRelation.table[$scope.pairRelation.table.length - 1].typer.id.slice(5), 10) + 1;
                    _.each(addTable, function(val, key) {
                        if (!_.isUndefined(val.id) && val.id.indexOf("primaryId") != -1) {
                            val.id = "primaryId" + addId;
                        }
                        if (!_.isUndefined(val.id) && val.id.indexOf("primaryName") != -1) {
                            val.id = "primaryName" + addId;
                        }
                        if (!_.isUndefined(val.id) && val.id.indexOf("secondId") != -1) {
                            val.id = "secondId" + addId;
                        }
                        if (!_.isUndefined(val.id) && val.id.indexOf("secondName") != -1) {
                            val.id = "secondName" + addId;
                        }
                        if (!_.isUndefined(val.id) && val.id.indexOf("typer") != -1) {
                            val.id = "typer" + addId;
                        }
                        if (!_.isUndefined(val.id) && val.id.indexOf("azPairSelect") != -1) {
                            val.id = "azPairSelect" + addId;
                        }
                        if (key == 'volMappings') {
                            _.each(val, function(v) {
                                v.mapType.id = "mapType" + (_.size($scope.pairRelation.table) + 1) + 1;
                                v.priority.id = "priority" + (_.size($scope.pairRelation.table) + 1) + 1;
                            });
                        }
                    })
                    _.extend(addTable, {
                        removeCls: "pointer"
                    });
                    $scope.pairRelation.table.push(addTable);
                    disableDeleteBtn();
                    $scope.$apply();
                }
            }
            $scope.btnOk = {
                id: "addPairBtn",
                text: appUtils.getString("common_term_confirm_button"),
                click: function() {
                    if (!UnifyValid.FormValid($("#pairAddDiv"), {focusInvalid: true})) {
                        return;
                    }
                    var openstackObj = infoTransferredService.get("openstackPairKey", "openstackUuid");
                    var sendObj = $scope.pairRelation.table;
                    var uniqArray = [];
                    var sendArray = [];
                    _.each(sendObj, function(val) {
                        var param = {};
                        if (azPairFlag) {
                            param.primary_az_id = val.primaryId.getVal();
                            param.primary_az = val.primaryName.getVal();
                            param.second_az_id = val.secondId.getVal();
                            param.second_az = val.secondName.getVal();
                            param.type = val.typer.getVal();
                        } else {
                            if (!val.azPairSelect.validateFn()) {
                                return;
                            };
                            param.primary_volType = val.primaryName.getVal();
                            param.second_volType = function() {
                                var second_volTypes = [];
                                _.each(val.volMappings, function(vol) {
                                    second_volTypes.push({second_volType: vol.mapType.getVal(), priority: vol.priority.getVal()})
                                });
                                return second_volTypes;
                            }();
                            param.type = val.typer.getVal();
                            param.primary_az_id = val.azPairSelect.getVal().primaryAz;
                            param.second_az_id = val.azPairSelect.getVal().secondAz;
                        }
                        sendArray.push(param)
                        _.each(val.volMappings, function(vol){
                            uniqArray.push(val.primaryName.getVal() + vol.mapType.getVal())
                        });
                    });
                    if (sendArray.length != sendObj.length) {
                        message.error(appUtils.getString("site_openstack_pair_az_select_label") + (appUtils.isEn() ? "." : "。"));
                        return;
                    };
                    var afterUniqArray = _.uniq(uniqArray);
                    if (afterUniqArray.length != uniqArray.length) {
                        message.error(appUtils.getString("common_term_name_exist_tip"));
                        return;
                    };
                    if (azPairFlag) {
                        restService.addOpenstackAzPair({
                            openstackUuid: openstackObj.deviceSn
                        }, {
                            data: sendArray,
                            success: function(result) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        infoTransferredService.remove("openstackPairKey", "openstackUuid");
                                        infoTransferredService.put("openstackPair", "pairType", $stateParams.pairType);
                                        $state.go("site.cloud.openStackAzPairList", {
                                            siteId: site.id,
                                            type: "volumePair"
                                        });
                                    }
                                })
                            }
                        })
                    } else {
                        //修改
                        if (!_.isEmpty($stateParams.volTypePairId)) {
                            restService.updateVolTypePairs(openstackObj.deviceSn, {
                                data: function() {
                                    var results = [];
                                    _.each(sendArray, function(obj) {
                                        _.each(obj.second_volType, function(v) {
                                            var cloneObj = angular.copy(obj);
                                            results.push(_.pick(_.extend(cloneObj, v, {voltype_pair_id: pairInfo.volType_pair_id}), "voltype_pair_id", "priority"));
                                        });
                                    });
                                    return results;
                                }(),
                                success: function(result) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            infoTransferredService.remove("openstackPairKey", "openstackUuid");
                                            infoTransferredService.put("openstackPair", "pairType", $stateParams.pairType);
                                            $state.go("site.cloud.openStackAzPairList", {
                                                siteId: site.id,
                                                type: "volumePair"
                                            });
                                        }
                                    })
                                }
                            })
                        }
                        //创建
                        else {
                            restService.addVolumTypePair({
                                openstackUuid: openstackObj.deviceSn
                            }, {
                                interceptor: function(callback) {
                                    var results = [];
                                    _.each(sendArray, function(obj) {
                                        _.each(obj.second_volType, function(v) {
                                            var cloneObj = angular.copy(obj);
                                            results.push(_.extend(cloneObj, v));
                                        });
                                    });
                                    var primary_volType = [], second_volType = [];
                                    _.each(results, function(value){
                                        if (value.type == 'csdr') {
                                            return;
                                        }
                                        primary_volType.push(value.primary_volType);
                                        second_volType.push(value.second_volType);
                                    });

                                    if (!!_.size(_.intersection(primary_volType, second_volType))) {
                                        message.error(appUtils.getString("common_term_name_exist_tip"));
                                        return false;
                                    }
                                    callback();
                                    return true;
                                },
                                data: function() {
                                    var results = [];
                                    _.each(sendArray, function(obj) {
                                        _.each(obj.second_volType, function(v) {
                                            var cloneObj = angular.copy(obj);
                                            results.push(_.extend(cloneObj, v));
                                        });
                                    });
                                    return results;
                                }(),
                                success: function(result) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            infoTransferredService.remove("openstackPairKey", "openstackUuid");
                                            infoTransferredService.put("openstackPair", "pairType", $stateParams.pairType);
                                            $state.go("site.cloud.openStackAzPairList", {
                                                siteId: site.id,
                                                type: "volumePair"
                                            });
                                        }
                                    })
                                }
                            })
                        }
                    }
                }
            };
            $scope.btnCancel = {
                id: "canclePairBtn",
                text: appUtils.getString("common_term_cancel_button"),
                click: function() {
                    infoTransferredService.put("openstackPair", "pairType", $stateParams.pairType);
                    $state.go("site.cloud.openStackAzPairList", {
                        siteId: site.id,
                        type: "volumePair"
                    });
                }
            }
            UnifyValid.checkVoltype = function() {
                var val = this[0].value;
                if (_.isEmpty(val)) {
                    return appUtils.getString("common_term_empty_label");
                };
                if (_.contains($.trim(val).split(""), " ")) {
                    return appUtils.getString("ism.drm.protectgroup.input.password.reg.msg");
                }
                if ($.trim(val).split("").length > 255) {
                    return appUtils.getString("validate_term_common_length_range_1_255_msg");
                }
                return "";
            };
            $scope.$on('$destroy', function() {
                delete UnifyValid.checkVoltype;
            });
            queryVolTypePairs();
        }
    ];

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.openstack.addpair.ctrl', ctrler);
    return module;
});