define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "message",
        "constsService",
        "appUtils",
        "restService",
        function($scope, message, constsService, appUtils, restService) {
            var _winData = $("#" + constsService.ADD_REGION_ENDPOINT_WIN.winId).widget().option("data");
            $scope.isAddRegionWin = _.isUndefined(_winData.regionData);
            $scope.region = {
                label: "Region ID:",
                labelwidth: 100,
                id: "regionText",
                value: "",
                width: constsService.W3,
                validate: "required",
                setValue: function(value) {
                    this.value = value;
                    $scope.$apply();
                },
                getValue: function() {
                    return this.value
                }
            };
            $scope.endpointLabel = "Endpoint";
            $scope.endpoint = {
                compute: {
                    id: "computeText",
                    label: "Compute:",
                    key: "compute",
                    validate: "required",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                volume: {
                    id: "volumeText",
                    label: "Volume:",
                    key: "volume",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                network: {
                    id: "networkText",
                    label: "Network:",
                    key: "network",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                drExtend: {
                    id: "agentText",
                    label: "DRExtend:",
                    key: "agent",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                computeExt: {
                    id: "computeExtText",
                    label: "Compute-ext:",
                    key: "compute-ext",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                metering: {
                    id: "meteringText",
                    label: "Metering:",
                    key: "metering",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                image: {
                    id: "imageText",
                    label: "Image:",
                    key: "image",
                    width: constsService.W3,
                    validate: "required",
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                apicom: {
                    id: "apicomText",
                    label: "apicom:",
                    key: "apicom",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                csha: {
                    id: "cshaText",
                    label: "CSHA:",
                    key: "csha",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                elb: {
                    id: "elbText",
                    label: "ELB:",
                    key: "elb",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                cce: {
                    id: "cceText",
                    label: "CCE:",
                    key: "cce",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                rds: {
                    id: "rdsText",
                    label: "RDS:",
                    key: "rds",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                },
                dcs: {
                    id: "dcsText",
                    label: "DCS:",
                    key: "dcs",
                    width: constsService.W3,
                    value: "",
                    setValue: function(value) {
                        this.value = value;
                        $scope.$apply();
                    },
                    getValue: function() {
                        return $("#" + this.id).widget().getValue();
                    }
                }
            };
            //修改region窗口数据回显
            if (!_.isUndefined(_winData.regionData)) {
                $scope.region.setValue(_winData.regionData.regionId.split(":")[1]);
                $scope.regionIdLabel = _winData.regionData.regionId.split(":")[1];
                _.each($scope.endpoint, function(value) {
                    _.each(_winData.regionData.services, function(serviceItem) {
                        value.key == serviceItem.serviceType && (value.setValue(serviceItem.serviceUrl))
                    })
                });
            };
            var buttons = [{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function() {
                    if (!UnifyValid.FormValid($("#addRegionEndpointWin"), {
                            focusInvalid: true
                        })) {
                        return;
                    };
                    var services = [];
                    //添加Region
                    if (_winData.addRegion) {
                        _.each($scope.endpoint, function(item, index) {
                            if (_.isEmpty(item.getValue())) {
                                return;
                            }
                            services.push({
                                serviceType: item.key,
                                serviceUrl: item.getValue()
                            })
                        });
                        var params = {
                            regionId: $scope.region.getValue(),
                            services: services
                        };
                        $("#" + constsService.ADD_REGION_ENDPOINT_WIN.winId).widget().destroy();
                        restService.addOpenstackRegion([_winData.opnestanckObj.deviceSn], {
                            data: [params],
                            success: function() {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        _.isFunction(_winData['init']) && (_winData.init.call(this, null, _winData.opnestanckObj))
                                    }
                                });
                            }
                        })
                    } else {
                        //修改Region
                        _.each($scope.endpoint, function(item, index) {
                            if (_.isEmpty(item.getValue())) {
                                return;
                            }
                            services.push({
                                serviceType: item.key,
                                serviceUrl: item.getValue()
                            })
                        });
                        $("#" + constsService.ADD_REGION_ENDPOINT_WIN.winId).widget().destroy();
                        if (_.isEmpty(services)) {
                            return;
                        };
                        restService.modifyOpenstackRegion([_winData.opnestanckObj.deviceSn, _winData.regionData.regionId], {
                            data: {
                                services: services
                            },
                            success: function() {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        _.isFunction(_winData['init']) && (_winData.init.call(this, null, _winData.opnestanckObj))
                                    }
                                });
                            }
                        })
                    }
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + constsService.ADD_REGION_ENDPOINT_WIN.winId).widget().destroy();
                }
            }];
            $("#" + constsService.ADD_REGION_ENDPOINT_WIN.winId).widget().option("buttons", buttons);
        }
    ];
    var module = angular.module("recoverydirector.site.config");
    module.tinyController("addRegionEndpoint.ctrl", ctrl);
    return module;
})
