define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$stateParams",
        "message",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $state, $stateParams, message, constsService, appUtils, restService){
            var winData = $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().option("data");
            $scope.isMS = winData.azFlag == "MS";
            $scope.azPairInfo = appUtils.getString("resource_openstack_az_pair_win_label");
            if(winData.detailFlag){
                $scope.detailFlag = winData.detailFlag == "detailFlag";
                $scope.isMSFlag = winData.aData.type != "csha";
                $scope.deltailType = winData.aData.type == "csha" ? appUtils.getString("cloud_service_csha_instance_label") : appUtils.getString("cloud_service_csdr_instance_label");
                $scope.azPairObj = winData.aData;
                $scope.typeTitle = appUtils.getStringWithColon("common_term_type_label");
            }
            $scope.model = {
                label:{
                    primaryAz: "Availablity Zone 1",
                    secondAz: "Availablity Zone 2",
                    regionLabel: "Region"
                },
                cshaRegionId: {
                    id: "cshaRegionId",
                    label: "Region ID:",
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                cshaRegionName:{
                    id: "cshaRegionName",
                    label: "Region " + appUtils.getStringWithColon("common_term_name_label"),
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                primaryRegionId:{
                    id: "primaryRegionId",
                    label: "Region ID:",
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                primaryRegionName:{
                    id: "primaryRegionName",
                    label: "Region " + appUtils.getStringWithColon("common_term_name_label"),
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                primaryAzId:{
                    id: "primaryAzId",
                    label: "Availablity Zone ID:",
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                primaryAzName:{
                    id: "primaryAzName",
                    label: "Availablity Zone " + appUtils.getStringWithColon("common_term_name_label"),
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                secondRegionId:{
                    id: "secondRegionId",
                    label: "Region ID:",
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                secondRegionName:{
                    id: "secondRegionName",
                    label: "Region " + appUtils.getStringWithColon("common_term_name_label"),
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                secondAzId:{
                    id: "secondAzId",
                    label: "Availablity Zone ID:",
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                },
                secondAzName:{
                    id: "secondAzName",
                    label: "Availablity Zone " + appUtils.getStringWithColon("common_term_name_label"),
                    value: "",
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                    getVal: function(){
                        return $("#" + this.id).widget().getValue()
                    }
                }
            };
            !$scope.detailFlag && $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().option("buttons",[{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function(){
                    if (!UnifyValid.FormValid($("#addAzPairWin"), {focusInvalid: true})) {
                        return;
                    }
                    var param = {};
                    if($scope.isMS){
                        param.primary_region_id = $scope.model.primaryRegionId.getVal();
                        param.primary_region = $scope.model.primaryRegionName.getVal();
                        param.primary_az_id = $scope.model.primaryAzId.getVal();
                        param.primary_az = $scope.model.primaryAzName.getVal();
                        param.second_region_id = $scope.model.secondRegionId.getVal();
                        param.second_region = $scope.model.secondRegionName.getVal();
                        param.second_az_id = $scope.model.secondAzId.getVal();
                        param.second_az = $scope.model.secondAzName.getVal();
                        param.type = "csdr";
                        if(param.primary_region_id == param.second_region_id){
                           message.error(appUtils.getString("site_openstack_region_pair_error_label"));
                           return;
                        };
                        restService.addOpenstackAzPair({openstackUuid:winData.openstackObj.deviceSn},{
                            data: param,
                            success:function(result){
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok:function(){
                                        $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().destroy()
                                        winData.init(null,winData.openstackObj)
                                    }
                                })
                            }
                        })
                    }else{
                        param.primary_region_id = $scope.model.cshaRegionId.getVal();
                        param.primary_region = $scope.model.cshaRegionName.getVal();
                        param.primary_az_id = $scope.model.primaryAzId.getVal();
                        param.primary_az = $scope.model.primaryAzName.getVal();
                        param.second_az_id = $scope.model.secondAzId.getVal();
                        param.second_az = $scope.model.secondAzName.getVal();
                        param.type = "csha";
                        if(param.primary_az_id == param.second_az_id){
                            message.error(appUtils.getString("site_openstack_az_pair_error_label"));
                            return;
                        };
                        restService.addOpenstackAzPair({openstackUuid:winData.openstackObj.deviceSn},{
                            data: param,
                            success:function(result){
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok:function(){
                                        $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().destroy()
                                        winData.init(null,winData.openstackObj)
                                    }
                                })
                            }
                        })
                    }
                }
            },{
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(){
                    $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().destroy()
                }
            }])
        }];

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("az-pair-add-win-ctrl", ctrl);
    return module;
});
