define(["tiny-common/UnifyValid", "tiny-widgets/Window", "tiny-extra-lib/jquery.base64"],
    function(UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "infoTransferredService",
            function($scope, $state, $stateParams, $timeout, exception, message,
                communicationService, utilService, mask,
                constsService, appUtils, statusEnumService, cookieService, infoTransferredService) {
                var refreshTimer, phase, PHASE_STATUS = {
                        "refresh": 0,
                        "timeout": 1
                    },
                    deviceType = "ism.drm.deviceType.cloud.mainType",
                    selectData = {},
                    currentSite = infoTransferredService.get("site", "currentSite");
                if (!currentSite) {
                    return;
                }

                $scope.optResAuthKey = $scope.$parent.site.resourceOptAuth;
                $scope.isRemoteSite = currentSite.siteType === 1;
                $scope.getData = function() {
                    !_.isEmpty(selectData) && (selectData.type = "cloud");
                    return selectData;
                };
                // cloud
                $scope.btnCloudCreate = {
                    id: "menubtnvsphere",
                    dropbtn: true,
                    content: [],
                    text: appUtils.getString("site.term.addFusionShpere.label"),
                    type: "button"
                };
                if ("true" != "false") {
                    $scope.btnCloudCreate.content.push({
                        title: "OpenStack",
                        click: function() {
                            $state.go("site.discovery", {
                                siteId: currentSite.siteId,
                                type: 'openStack'
                            });
                        }
                    });
                }


                var opt = {
                        modify: {
                            id: "iconBtnEdit",
                            authKey: $scope.optResAuthKey,
                            template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                            clickActive: function() {
                                var rowData = $("#datasCloudTable").widget().getHoverData()[0],
                                    cloudType = constsService.FUSIONSPHERE_ENUM[rowData.cloudType];
                                if (2 === cloudType) {
                                    _editVrgDevAction();
                                    return;
                                }
                                _editCloudDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        },
                        delete: {
                            id: "iconBtnDel",
                            authKey: $scope.optResAuthKey,
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: function() {
                                _deleteDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        },
                        refresh: {
                            id: "iconBtnDevRefresh",
                            authKey: $scope.optResAuthKey,
                            template: "<div class='iconbutton-pg-refresh' title='" + appUtils.getString("common_term_refresh_button") + "'></div>",
                            clickActive: function() {
                                _refreshDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        }
                    },
                    opt = appUtils.tableHoverWrapper(opt);

                $scope.refreshCloudPage = function() {
                    _init();
                };

                $scope.datasCloudTable = {
                    id: "datasCloudTable",
                    paginationStyle:"full_numbers",
                    isDraggedRemember: true,
                    operateButtonCount: 3,
                    buttonContainerPosition: "right",
                    columns: [{
                        "sTitle": appUtils.getString("common_term_status_column"),
                        "mData": "cloudStatus"
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "cloudName"
                    }, {
                        "sTitle": appUtils.getString("common_term_ip_keystone_column"),
                        "mData": "ipAddress"
                    }, {
                        "sTitle": appUtils.getString("site_term_cloud_type_column"),
                        "mData": "cloudType"
                    }, {
                        "sTitle": "",
                        "mData": "deviceSn",
                        "bVisible": false
                    }],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    renderRow: function(nRow, aData, iDataIndex) {
                        var status = $.trim(aData["cloudStatus"]);

                        if (status == "0") {
                            $("td:eq(0)", nRow).html("<span class='icon-registered'>&nbsp;&nbsp;&nbsp;&nbsp;</span>" + appUtils.getString("common_term_status_normal_label"));
                        } else {
                            $("td:eq(0)", nRow).html("<span class='icon-unregistered'>&nbsp;&nbsp;&nbsp;&nbsp;</span>" + appUtils.getString("common_term_status_offline_label"));
                        }
                    },
                    data: [],
                    callback: function(evtObj) {
                        $scope.datasCloudTable.currPage.pageIndex = evtObj.currentPage;
                        $scope.datasCloudTable.defaultSelectId = undefined;
                    },
                    opAreaConfig: appUtils.flilterOperRight([opt.refresh, opt.modify, opt.delete]),
                    cellClickActive: function(e, param, isFind) {
                        _.isEmpty(isFind) && (phase === PHASE_STATUS.refresh);

                        $scope.datasCloudTable.defaultSelectId = param.deviceSn;
                        selectData = param;

                        if (currentSite.siteType === 1 || (isFind && phase === PHASE_STATUS.timeout)) {
                            if(+$(".tinyTabActive", $("#cloudTabs")).attr("cid") === 9){
                                $scope.$broadcast(constsService.TOPIC.SITE_CLOUD_TAB, param);
                            }
                            return;
                        }

                        var tabLis = _.range(13),
                            tabMapping = {
                                1: [1, 2, 3],
                                0: [1, 4, 5, 6, 7],
                                2: [8, 9],
                                3: [10, 11, 12]
                            },
                            cloudType = constsService.FUSIONSPHERE_ENUM[param.cloudType],
                            showLi = tabMapping[cloudType],
                            hideLi = tabLis.shift(),
                            hideLi = _.difference(tabLis, showLi),
                            tabLiDom = $("#cloudTabs"),
                            selectTabIndex = +($(".tinyTabActive", tabLiDom).attr("cid"));

                        _.each(showLi, function(i) {
                            $("li[cid=" + i + "]", tabLiDom).show();
                        });
                        _.each(hideLi, function(i) {
                            $("li[cid=" + i + "]", tabLiDom).hide();
                        })

                        if(cloudType == 3 && showLi.indexOf(selectTabIndex) == -1){
                            var pairIndex = infoTransferredService.get("openstackPair", "pairType");
                            selectTabIndex = (pairIndex == "azPair" || _.isEmpty(pairIndex)) ? showLi[0] : showLi[1]
                            if(!$("li[cid='" + selectTabIndex + "']", tabLiDom).hasClass("tinyTabActive")){
                                $("li[cid='" + selectTabIndex + "']", tabLiDom).addClass("tinyTabActive")
                            }
                        }else{
                            !_.isEmpty(infoTransferredService.get("openstackPair", "pairType")) && (infoTransferredService.remove("openstackPair", "pairType"))
                        }

                        if (showLi.indexOf(selectTabIndex) == -1) {
                            selectTabIndex = showLi[0];
                            if(!$("li[cid='" + showLi[0] + "']", tabLiDom).hasClass("tinyTabActive")){
                                $("li[cid='" + showLi[0] + "']", tabLiDom).addClass("tinyTabActive")
                            }
                        }

                        var plugin = $scope.plugins[selectTabIndex - 1],
                            state = plugin.state;
                        if (_.isEmpty(plugin.state)) {
                            state = plugin.openState;
                        }
                        $state.go(state, {
                            type: plugin.type
                        });

                        $("li", tabLiDom).not($("li[cid=" + selectTabIndex + "]", tabLiDom)).removeClass("tinyTabActive");
                        $scope.$broadcast(constsService.TOPIC.SITE_CLOUD_TAB, param);
                    },
                    enablePagination: false,
                    currPage: {
                        pageIndex: 1
                    },
                    defaultSelectId: undefined,
                    hoverActive: function(e, param) {
                        opt.notify(param);
                    },
                    drawCallback: function(oSetting) {
                        var selectSn = $scope.datasCloudTable.defaultSelectId,
                            isFind = true;
                        if (!oSetting.aoData.length) return;

                        var currPageData = [],
                            aData;
                        _.each($scope.datasCloudTable.data, function(rowData) {
                            currPageData = currPageData.concat(rowData);
                            rowData.childResources && (currPageData = currPageData.concat(rowData.childResources));
                        })

                        !_.isEmpty(selectSn) && !_.isEmpty(currPageData) && _.isEmpty(aData = _.findWhere(currPageData, {
                            deviceSn: selectSn
                        })) && (isFind = false, aData = currPageData[0], selectSn = currPageData[0].deviceSn);

                        _.isEmpty(selectSn) && (isFind = false, aData = currPageData[0], selectSn = currPageData[0].deviceSn);
                        $('#datasCloudTable').widget().setSelectedRow('deviceSn', selectSn);
                        $scope.datasCloudTable.cellClickActive("defaultSelectRow", aData, isFind);
                    },
                    updateUI: function(result, callback) {

                        if (!exception.check(result)) {
                            return;
                        }

                        $scope.datasCloudTable.data = appUtils.encodeForHTML(result);
                        $scope.datasCloudTable.enablePagination = result.length > $scope.datasCloudTable.displayLength;

                        var oldTableStatus = {
                            currPage: {
                                pageIndex: $scope.datasCloudTable.currPage.pageIndex
                            },
                            defaultSelectId: $scope.datasCloudTable.defaultSelectId
                        };

                        _.extend($scope.datasCloudTable, oldTableStatus);
                        $scope.$apply();

                        $timeout.cancel(refreshTimer);
                        refreshTimer = $timeout(function() {
                            $scope.datasCloudTable.queryData(PHASE_STATUS.timeout)
                        }, 10000);

                        _.isFunction(callback) && (callback)();
                    },
                    queryData: function(status, callback) {
                        var url = "/fusionsphere",
                            urlParam = {
                                siteId: currentSite.siteId,
                                cloudType: ""
                            };

                        url = appUtils.fillUrl(url, urlParam);

                        phase = PHASE_STATUS.refresh;
                        status && (phase = status);
                        phase !== PHASE_STATUS.timeout && (mask.show());

                        communicationService.get(url).promise().always(function(result) {

                            status !== PHASE_STATUS.timeout && (mask.hide());

                            $scope.datasCloudTable.updateUI(result, callback);
                        });
                    }
                };

                currentSite.siteType === 0 && ($scope.plugins = [{
                    "openState": "site.cloud.vmList",
                    "id": "vmList",
                    "name": appUtils.getString("site.term.vmlist.tab")
                }, {
                    "openState": "site.cloud.rm({type:'network'})",
                    "id": "network",
                    state: "site.cloud.rm",
                    type: "network",
                    "name": appUtils.getString("resource_mapping_network_title")
                }, {
                    "openState": "site.cloud.rm({type:'securityGroup'})",
                    "id": "securityGroup",
                    state: "site.cloud.rm",
                    type: "securityGroup",
                    "name": appUtils.getString("resource_mapping_security_group_title")
                }, {
                    "openState": "site.cloud.rm({type:'cluster'})",
                    "id": "clusterRM",
                    state: "site.cloud.rm",
                    type: "cluster",
                    "name": appUtils.getString("site.term.clusterMapping.tab")
                }, {
                    "openState": "site.cloud.rm({type:'host'})",
                    "id": "hostRM",
                    state: "site.cloud.rm",
                    type: "host",
                    "name": appUtils.getString("site.term.hostMapping.tab")
                }, {
                    "openState": "site.cloud.rm({type:'portGroup'})",
                    "id": "protGroupRM",
                    state: "site.cloud.rm",
                    type: "portGroup",
                    "name": appUtils.getString("site.term.portGroupMapping.tab")
                }, {
                    "openState": "site.cloud.rm({type:'dataStore'})",
                    "id": "dataStoreRM",
                    state: "site.cloud.rm",
                    type: "dataStore",
                    "name": appUtils.getString("site.term.dataStoreMapping.tab")
                }, {
                    "openState": "site.cloud.pairInfo",
                    "id": "pairInfo",
                    "name": appUtils.getString("site.term.pairInfo.column")
                }, {
                    "openState": "site.cloud.relationVM",
                    "id": "relation",
                    "name": appUtils.getString("site.term.relateVM.column")
                }, {
                    "openState": "site.cloud.openStackAzPairList({type:'azPair'})",
                    "id": "azPairList",
                    state: "site.cloud.openStackAzPairList",
                    type: "azPair",
                    "name": appUtils.getString("site_openstack_az_pair_label")
                },{
                    "openState": "site.cloud.openStackAzPairList({type:'volumePair'})",
                    "id": "volumeTypePairList",
                    state: "site.cloud.openStackAzPairList",
                    type:"volumePair",
                    "name": appUtils.getString("site_openstack_volume_type_pair_label")
                },{
                    "openState": "site.cloud.drSetting({type:'sites'})",
                    "id": "sites",
                    "name": appUtils.getString("common_dr_site_label")
                },{
                    "openState": "site.cloud.drSetting({type:'cloudserv'})",
                    "id": "cloudserv",
                    "name": appUtils.getString("common_ecs_setting_label")
                },{
                    "openState": "site.cloud.region",
                    "id": "region",
                    "name": appUtils.getString("site.term.region.tab")
                }]);

                $scope.activeTab = function(id) {
                    $("li", $("#cloudTabs")).not($("li[id=" + id + "]", $("#cloudTabs"))).removeClass("tinyTabActive");
                }

                var _deleteCloudAction = function() {
                    var url = "/sites/" + currentSite.siteId + "/action/unregisterRes?resType=ism.drm.deviceType.cloud.mainType";
                    var dbId = _getOpID();
                    var name = _getOpName();
                    var tmp = [];
                    tmp.push(dbId);
                    message.warn({
                        content: appUtils.getString("site_term_cloud_delete_message", $scope.currentSiteName, name),
                        ok: function() {
                            mask.show();
                            communicationService.put(utilService.getResouceUrl(url), tmp).promise().always(function(result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            _init()
                                        }
                                    });
                                }
                            })
                        }
                    });

                };


                var _getOpID = function() {
                    var opID = $scope.currentdeviceSn ? $scope.currentdeviceSn : null;
                    if (opID == null) {
                        opID = $("#datasCloudTable").widget().getHoverData()[0].deviceSn;
                    }
                    return opID;
                };

                var _getOpName = function() {
                    var name = $scope.currentName ? $scope.currentName : null;
                    if (name == null) {
                        name = $("#datasCloudTable").widget().getHoverData()[0].cloudName;
                    }
                    return name;
                };

                var _editVrgDevAction = function() {
                    var id = _getOpID();
                    var data = {};
                    communicationService.get(utilService.getResouceUrl("/resources/" + $.base64.encode(id))).promise().always(function(response) {
                        if (exception.check(response)) {
                            data.sn = response.sn;
                            if (Object.prototype.toString.call(response.moName) === "[object Null]") {
                                data.name = "null";
                            } else {
                                data.name = response.moName;
                            }
                            data.deviceType = "ism.drm.deviceType.vrg.mainType";
                            data.isStorage = false;
                            var options = {
                                "winId": "modifyVrgHostDevAliasWinId",
                                "helpId" : "modifyVrgDevAlias",
                                "data": data,
                                "title": appUtils.getString("res_term_modifyalias_label"),
                                "width": "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? "920px" : "1050px",
                                "height": "600px",
                                "content-type": "url",
                                "content": constsService.RES_VRG_HOST_EDIT_URL,
                                "minimizable": false,
                                "maximizable": false,
                                "buttons": [{
                                    key: "ok",
                                    label: appUtils.getString('common_term_confirm_button'),
                                    focused: true,
                                    handler: function(event) {
                                        if (!UnifyValid.FormValid($("#container"), {focusInvalid: true})) {
                                            return;
                                        }

                                        var manageInfoSwitchFlag = $("#manageInfo").widget().option("selected") == "on" ? true : false;
                                        var alarmInfoSwitchFlag = $("#alarmInfo").widget().option("selected") == "on" ? true : false;
                                        var param = {};
                                        var id = $("#modifyVrgHostDevAliasWinId").widget().option("data").sn;
                                        param.moName = $.trim($("#name").widget().getValue());
                                        param.deviceType = $scope.deviceType;
                                        var url = utilService.getResouceUrl("/resources/" + $.base64.encode(id));
                                        mask.show();
                                        communicationService.put(url, param).promise().always(function(result) {
                                            mask.hide();
                                            if (exception.check(result)) {
                                                //只修改名称
                                                if (!manageInfoSwitchFlag && !alarmInfoSwitchFlag) {
                                                    mask.hide();
                                                    message.success({
                                                        content: appUtils.getString("common_term_operation_success_label"),
                                                        ok: function() {
                                                            $("#modifyVrgHostDevAliasWinId").widget().destroy();
                                                            _init();
                                                        }
                                                    });
                                                    return;
                                                }

                                                var editParam = {},
                                                    extendParams = {};
                                                editParam.isModifyPwd = false;
                                                if (manageInfoSwitchFlag) {
                                                    editParam.isModifyPwd = true;
                                                    editParam.networkUserName = $("#protocolUsername").widget().getValue();
                                                    if (infoTransferredService.get("protocalPwdModule", "protocalPwd")) {
                                                        editParam.networkPassword = $("#protocalPwd").widget().getValue();
                                                    }
                                                    editParam.networkIpAddress = $("#ip").widget().option("value");
                                                    extendParams.port = $("#protocalPort").widget().option("value");
                                                }

                                                if ("ism.drm.deviceType.vrg.mainType" == $scope.deviceType) {
                                                    extendParams.netMask = $("#mask").widget().option("value");
                                                    extendParams.netGetWay = $("#gateway").widget().option("value");
                                                }
                                                if (alarmInfoSwitchFlag) {
                                                    extendParams.snmpVersion = "SNMPv3";
                                                    extendParams.snmpRetries = $("#count").widget().option("value");
                                                    extendParams.snmpTimeout = $("#timeout").widget().option("value");
                                                    extendParams.snmpPort = $("#alarmPort").widget().option("value");
                                                    extendParams.snmpSecurityName = $("#alarmUsername").widget().getValue();
                                                    extendParams.snmpContextName = $("#env").widget().getValue();
                                                    extendParams.snmpContextEngineId = $("#engineId").widget().getValue();
                                                    var authId = $("#authProtocol").widget().getSelectedId();
                                                    var encryptId = $("#encryptProtocol").widget().getSelectedId();
                                                    extendParams.snmpAuthProtocol = authId;
                                                    if ("" != authId) {
                                                        if (infoTransferredService.get("authPwdModule", "authPwd")) {
                                                            extendParams.snmpAuthPwd = $("#authPwd").widget().getValue();
                                                        }
                                                        extendParams.snmpEncryptProtocol = encryptId;
                                                        if ("" != encryptId) {
                                                            if (infoTransferredService.get("encryptPwdModule", "encryptPwd")) {
                                                                extendParams.snmpEncryptPwd = $("#encryptPwd").widget().getValue();
                                                            }
                                                        }
                                                    }
                                                }

                                                editParam.extendParams = extendParams;
                                                mask.show();
                                                communicationService.put(utilService.getResouceUrl("/resources/" + $.base64.encode(data.sn) + "/action/modifyMgrProtocol"), editParam).promise().always(function(response) {
                                                    mask.hide();
                                                    if (exception.check(response)) {
                                                        message.success({
                                                            content: appUtils.getString("common_term_operation_success_label"),
                                                            ok: function() {
                                                                $("#modifyVrgHostDevAliasWinId").widget().destroy();
                                                                _init();
                                                            }
                                                        });
                                                    }
                                                });
                                            } else {
                                                mask.hide();
                                            }
                                        });



                                    }
                                }, {
                                    key: "cancel",
                                    label: appUtils.getString('common_term_cancel_button'),
                                    focused: false,
                                    handler: function(event) {
                                        $("#modifyVrgHostDevAliasWinId").widget().destroy();
                                    }
                                }],
                                "close": function() {
                                    $("#modifyVrgHostDevAliasWinId").widget().destroy();
                                }
                            }

                            var win = new Window(options);
                            win.show();
                        }
                    });
                };
                var _editCloudDevAction = function() {

                    var id = _getOpID();
                    var data = {};
                    var rowData = $("#datasCloudTable").widget().getHoverData()[0];
                    communicationService.get(utilService.getResouceUrl("/resources/" + $.base64.encode(id))).promise().always(function(response) {
                        if (exception.check(response)) {
                            data.sn = response.sn;
                            if (Object.prototype.toString.call(response.moName) === "[object Null]") {
                                data.name = "null";
                            } else {
                                data.name = response.moName;
                            }
                            data.deviceType = deviceType;
                            data.isStorage = false;

                            var options = {
                                "winId": "modifyDevAliasWinId",
                                "helpId": rowData.cloudType == "OpenStack" ? "modifyOpenstackAlias" : "modifyFcAndFm",
                                "data": data,
                                "title": appUtils.getString("res_term_modifyalias_label"),
                                "width": constsService.WIN_SIZE.S3[0],
                                "height": rowData.cloudType == "OpenStack" ? "450px":"400px",
                                "content-type": "url",
                                "content": constsService.RES_AILES_EDIT_URL,
                                "minimizable": false,
                                "maximizable": false,
                                "buttons": [{
                                    key: "ok",
                                    label: appUtils.getString('common_term_confirm_button'),
                                    focused: true,
                                    handler: function(event) {

                                        if (!UnifyValid.FormValid($("#protocalForm"), {focusInvalid: true})) {
                                            return;
                                        }

                                        var param = {};
                                        var id = $("#modifyDevAliasWinId").widget().option("data").sn;
                                        param.moName = $.trim($("#name").widget().getValue());
                                        param.deviceType = deviceType;
                                        var url = utilService.getResouceUrl("/resources/" + $.base64.encode(id));
                                        mask.show();
                                        communicationService.put(url, param).promise().always(function(result) {
                                            mask.hide();
                                            if (exception.check(result)) {
                                                var switchFlag = $("#authinfo").widget().option("selected") == "on" ? true : false;
                                                //只修改别名称
                                                if (!switchFlag) {
                                                    message.success({
                                                        content: appUtils.getString("common_term_operation_success_label"),
                                                        ok: function() {
                                                            _init();
                                                            $("#modifyDevAliasWinId").widget().destroy();
                                                        }
                                                    });
                                                    return;
                                                }
                                                var editParam = {};
                                                editParam.networkIpAddress = rowData.cloudType == "OpenStack" ? $("#https").widget().getValue() : $("#ip").widget().getValue();
                                                editParam.networkUserName = $("#username").widget().getValue();
                                                editParam.isModifyPwd = switchFlag;
                                                editParam.networkPassword = $("#password").widget().getValue();
                                                var extendParams = {}
                                                if (deviceType == "ism.deviceType.storage.mainType") {
                                                    //DEFAULT
                                                    if ($("#protocalHidden").val() == "DEFAULT") {
                                                        extendParams.sslFlag = $("#ssl").widget().getSelectedId();
                                                    }
                                                    //REST
                                                    if ($("#protocalHidden").val() == "REST") {
                                                        extendParams.port = $("#port").widget().options.value;
                                                    }
                                                    extendParams.protocol = $("#protocalHidden").val();
                                                    editParam.networkIpAddress = $("#ip").widget().option("value");
                                                } else if (deviceType == "ism.drm.deviceType.drhost.mainType") {

                                                    extendParams.port = $("#port").widget().options.value;
                                                    editParam.networkIpAddress = $("#ip").widget().option("value");
                                                } else {
                                                    extendParams.port = $("#port").widget().options.value;
                                                    rowData.cloudType == "OpenStack" && (extendParams.domain = $("#Domain").widget().getValue());
                                                }
                                                editParam.extendParams = extendParams;
                                                mask.show();
                                                communicationService.put(utilService.getResouceUrl("/resources/" + $.base64.encode(data.sn) + "/action/modifyMgrProtocol"), editParam).promise().always(function(response) {
                                                    mask.hide();
                                                    if (exception.check(response)) {
                                                        message.success({
                                                            content: appUtils.getString("common_term_operation_success_label"),
                                                            ok: function() {
                                                                _init();
                                                                $("#modifyDevAliasWinId").widget().destroy();
                                                            }
                                                        });
                                                    }
                                                });
                                            } else {
                                                mask.hide();
                                            }
                                        }, function(result) {
                                            exception.check(result);
                                        });
                                    }
                                }, {
                                    key: "cancel",
                                    label: appUtils.getString('common_term_cancel_button'),
                                    focused: false,
                                    handler: function(event) {
                                        $("#modifyDevAliasWinId").widget().destroy();
                                    }
                                }],
                                "close": function() {
                                    $("#modifyDevAliasWinId").widget().destroy();
                                }
                            };
                            var win = new Window(options);
                            win.show();
                        }
                    });
                };

                var _deleteDevAction = function() {
                    var name = _getOpName(),
                        id = _getOpID(),
                        rowData = $("#datasCloudTable").widget().getHoverData()[0],
                        cloudType = constsService.FUSIONSPHERE_ENUM[rowData.cloudType],
                        msg = {
                            0: [appUtils.getString("site_FC_task_deleteFC_warm_msg1",currentSite.name, name),
                                appUtils.getString("site_FC_task_deleteFC_warm_msg2"),
                                appUtils.getString("site_FC_task_deleteFC_warm_msg3")
                            ].join("<br/>"),
                            1: [appUtils.getString("site_FM_task_deleteFM_warm_msg1",currentSite.name, name),
                                appUtils.getString("site_FM_task_deleteFM_warm_msg2"),
                                appUtils.getString("site_FM_task_deleteFM_warm_msg3")
                            ].join("<br/>"),
                            2: [appUtils.getString("site_FM_task_deleteVRG_warm_msg1",currentSite.name, name),
                                appUtils.getString("site_FM_task_deleteVRG_warm_msg2"),
                                appUtils.getString("site_FM_task_deleteVRG_warm_msg3")
                            ].join("<br/>"),
                            3: [appUtils.getString("site_FC_task_deleteOpenStack_warm_msg1",currentSite.name, name),
                                appUtils.getString("site_FC_task_deleteOpenStack_warm_msg2"),
                                appUtils.getString("site_FC_task_deleteOpenStack_warm_msg3")
                            ].join("<br/>")
                        };
                    message.warn({
                        content: msg[cloudType],
                        ok: function() {
                            mask.show();
                            communicationService.remove(utilService.getResouceUrl("/resources/action/deleteBatch?sns=" + id)).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response)) {
                                    //改成异步任务
                                    message.prompt({
                                        content: appUtils.getString("site_term_refresh_message"),
                                        ok: function(){
                                            _init(function(){
                                                var dom = $('tbody tr>td:eq(1)','#datasCloudTable');
                                                if(dom.length > 0){
                                                    dom.click();
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                };


                var _refreshDevAction = function() {
                    var rowData = $("#datasCloudTable").widget().getHoverData()[0],
                        deviceSn = rowData.deviceSn,
                        cloudType = constsService.FUSIONSPHERE_ENUM[rowData.cloudType],
                        refreshUrl = {
                            0: "/fusionsphere/{deviceSn}/action/refresh",
                            1: "/fusionsphere/{deviceSn}/action/refresh",
                            2: "/vrg/{deviceSn}/action/refresh",
                            3:"/fusionsphere/{deviceSn}/action/refresh"
                        },
                        url = refreshUrl[cloudType];

                    cloudType != 2 && (deviceSn = $.base64.encode(deviceSn))

                    url = appUtils.fillUrl(url, {
                        deviceSn: deviceSn
                    });

                    mask.show();
                    communicationService.put(url).promise().always(function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {}
                            });
                        }
                    });
                };

                var _init = function(callback) {
                    $scope.datasCloudTable.queryData(undefined, callback);

                    function _clickOnce(){
                        var dom = $('tbody tr>td:eq(1)','#datasCloudTable');
                        if(dom.length > 0){
                            dom.click();
                        }else{
                            $timeout(_clickOnce,30);
                        }
                    }
                    !_.isFunction(callback) && $timeout(_clickOnce,50);

                };

                _init();

                $scope.$on("$destroy", function() {
                    refreshTimer && $timeout.cancel(refreshTimer);
                });

                $timeout(function() {
                    $("#menubtnvsphere").unbind("mouseenter")
                }, 0);
            }
        ];

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.cloud.ctrl', ctrler);
        return module;
    });
