define(["tiny-common/UnifyValid"],
    function(UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            function($scope, $state, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model) {
                var siteId = $stateParams.siteId,
                    mainType = constsService.RESOURCE_MAINTYPE_ENUM[$stateParams.type],
                    tempRowComponent = (function() {
                        var components = {
                                ip: {
                                    id: "ip",
                                    require: true,
                                    width: constsService.W2,
                                    value: "",
                                    extendFunction: ["checkIP"],
                                    validate: "checkIP : extend function;",
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    }
                                },
                                port: {
                                    id: "port",
                                    require: true,
                                    width: constsService.W1 + 50,
                                    value: "9443",
                                    min: "1",
                                    max: "65535",
                                    change: function() {
                                        var v = $("#" + this.id).widget().options.value;
                                        if (!/^\d+$/.test(v)) {
                                            $("#" + this.id).widget().option("value", "9443");
                                        }
                                    },
                                    validate: [{
                                        validFn: "required"
                                    }, {
                                        validFn: "rangeValue",
                                        params: [1, 65535],
                                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                                    }, {
                                        validFn: "integer"
                                    }],
                                    val: function(val) {
                                        var param = ["value"],
                                            dom = $("#" + this.id).widget();
                                        if (!_.isUndefined(val)) {
                                            if (_.isNumber(val)) {
                                                param.push(val);
                                            } else {
                                                param.push(9443);
                                            }
                                        }

                                        return this.value = dom.option.apply(dom, param);
                                    }
                                },
                                password: {
                                    id: "password",
                                    require: true,
                                    width: constsService.W2,
                                    type: "password",
                                    value: "",
                                    validate: constsService.VALID.AUTH_PWD_64,
                                    val: function(val) {
                                        var dom = $("#" + this.id).widget();
                                        !_.isUndefined(val) && (dom.option("value", val));

                                        return this.value = dom.getValue();
                                    }
                                },
                                username: {
                                    id: "username",
                                    require: true,
                                    width: constsService.W2,
                                    value: "",
                                    validate: constsService.VALID.AUTH_NAME,
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    }
                                }
                            },
                            val = function(val) {
                                //统一的val方法实现
                            },
                            opt = {
                                removeRow: function() {
                                    var components = $scope.discovery.components,
                                        index = components.indexOf(this);

                                    (index != -1 && index != 0) && (components.splice(index, 1));
                                },
                                title: appUtils.getString("common_term_delete_button")
                            };

                        _.extend(components, opt);
                        return components;
                    }());
                var port = appUtils.getString("ism.sys.user.port.lable");
                $scope.discovery = {
                    labels: {
                        title: appUtils.getString("res_term_cloud_title"),
                        manufacturer: appUtils.getString("ism.drm.protect.group.manufacturer"),
                        type: appUtils.getString("common_term_type_label"),
                        ip: appUtils.getString("recovery.term.recovery.unusedHost.colum.ip.title"),
                        port: appUtils.getString(" ism.sys.user.port.lable"),
                        username: appUtils.getString("common_term_username_label"),
                        password: appUtils.getString("common_term_password_label")
                    },
                    desc: appUtils.getString("site.storage.task.add.des.label"),
                    sameVerifyInfo: {
                        id: "checkboxVerify",
                        require: false,
                        text: appUtils.getString("res_term_discovrycheck_label")
                    },
                    components: [angular.copy(tempRowComponent)],
                    add: {
                        text: appUtils.getString("common_term_addline_button"),
                        click: function() {
                            var checked = $("#checkboxVerify").widget().options.checked,
                                components = $scope.discovery.components,
                                idEnd = _.isEmpty(components[components.length-1].ip.id.slice(2)) ? 1 : parseInt(components[components.length-1].ip.id.slice(2),10)+1,
                                addComponent = angular.copy(tempRowComponent);
                            if (checked) {
                                addComponent.port.value = components[0].port.val();
                                addComponent.username.value = components[0].username.val();
                                addComponent.password.value = components[0].password.val();
                            }

                            _.each(addComponent, function(v, k) {
                                !_.isUndefined(v.id) && (v.id += idEnd);
                            });
                            components.push(addComponent);
                            $scope.$apply();
                        }
                    },
                    ok: {
                        id: "btnOk",
                        text: appUtils.getString("common_term_confirm_button"),
                        click: function() {
                            if (!UnifyValid.FormValid($("#cloudDiscoveryContainer"), {focusInvalid: true})) {
                                return;
                            }

                            var datas = [];
                            _.each($scope.discovery.components, function(componentObj) {
                                var dataObj = {},paramMap = {};
                                _.each(componentObj,function(component){
                                    var key = _.isEmpty(component.name) ? component.id : component.name,
                                        value = _.isFunction(component.val) ? component.val() : component.value;

                                    if (_.isEmpty(key) && _.isObject(value)) {
                                        _.extend(this,value);
                                        return;
                                    }
                                    this[key] = value;

                                },paramMap);
                                dataObj.siteId = siteId;
                                dataObj.deviceType = paramObj.mainType;

                                dataObj.ip = paramMap.ip;
                                delete paramMap.ip;

                                dataObj.paramMap = paramMap;

                                this.push(dataObj);
                            }, datas)

                            mask.show();
                            communicationService.post(utilService.getResouceUrl("/resources/action/discoverResource"), datas).promise().always(function(result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: function() {
                                            $state.go("site.cloud.vmList", {
                                                siteId: siteId
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    },
                    cancel: {
                        id: "btnCancel",
                        text: appUtils.getString("common_term_cancel_button"),
                        click: function() {
                            $state.go("site.cloud.vmList", {
                                siteId: siteId
                            });
                        }
                    }
                };

                UnifyValid.checkIP = function() {
                    var val = this[0].value;
                    if (_.isEmpty(val)) {
                        return appUtils.getString("common_term_empty_label");
                    };
                    if (!appUtils.validIPv4OrIPv6Address(val)) {
                        return appUtils.getString("validate_ipv4_ipv6_label");
                    }
                    return "";
                };

                $scope.$on('$destroy', function() {
                    delete UnifyValid.checkIP;
                });
            }
        ];
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.cloud.discovery.ctrl', ctrler);
        return module;
    })
