define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "$timeout",
        "message",
        "constsService",
        "appUtils",
        "restService",
        function($scope, $timeout, message, constsService, appUtils, restService) {
            var _winData = $("#" + constsService.MODIFY_REGION_CONFIG_WIN.winId).widget().option("data");
            $scope.networkCard = {
                labelwidth: 100,
                title: appUtils.getString("site_openstack_region_network_config_label"),
                label: appUtils.getStringWithColon("site_term_openstack_switch_network_label"),
                id: "netWorkSwitch",
                selected: "off",
                standard: true
            };
            $scope.shareVolume = {
                labelwidth: 100,
                label: appUtils.getStringWithColon("site_term_openstack_switch_shareVolume_label"),
                id: "shareVolumeSwitch",
                selected: "off",
                standard: true
            };

            function init() {
                restService.queryRegionConfig([_winData.opnestanckObj.deviceSn, _winData.regionData.regionId.split(":")[1]], function(result) {
                    $scope.networkCard.selected = _.isEmpty(result) ? "on" : result.isSwitchNetwork ? "on" : "off";
                    $scope.shareVolume.selected = _.isEmpty(result) ? "off" : result.supportSharedVolumes ? "on" : "off";
                    $scope.$apply();
                });
            };

            init();
            $timeout(function() {
                $("#networkCardHelp").html($scope.networkCard.title);
                $("#shareVolumeHelp").html(appUtils.getString("site_openstack_region_shareVolume_config_label"))
            }, 0)
        }
    ];
    var module = angular.module("recoverydirector.site.config");
    module.tinyController("modifyRegionConfig.ctrl", ctrl);
    return module;
})
