define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrler = [
        "$scope",
        "$state",
        "$stateParams",
        "message",
        "constsService",
        "appUtils",
        "infoTransferredService",
        "restService",
        "exception",
        "communicationService",
        "$compile",
        function($scope, $state, $stateParams, message, constsService, appUtils,
            infoTransferredService, restService, exception, communicationService,$compile){
            var openstackObj = $scope.$parent.getData();
            var pairKey = $stateParams.type == "azPair";
            var hasRight = appUtils.checkRight($scope.$parent.optResAuthKey);
            $scope.isAzPair = $stateParams.type == "azPair";
            var deleteWarnTitle = $scope.isAzPair ? appUtils.getString("site_openstack_az_pair_label") : appUtils.getString("site_openstack_volume_type_pair_label");
            $scope.isEn = appUtils.isEn();
            var azPairColums = [{
                    "bVisible" : false,
                    "mData" : "az_pair_id"
                },{
                    "sTitle": appUtils.getString("site_openstack_pair_az_column_label"),
                    "mData": "primary_az",
                    "sWidth":"15%",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "",
                    "sWidth":"12%",
                    "sClass": "center",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "second_az",
                    "sWidth":"18%",
                    "bSortable" : false
                },{
                    "sTitle": appUtils.getString("common_term_type_label"),
                    "mData": "type",
                    "bSortable" : false
                },{
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "bSortable":false
                }];
            var volTypePairColums = [{
                    "bVisible" : false,
                    "mData" : "volType_pair_id"
                },{
                    "sTitle": appUtils.getString("common_term_type_label"),
                    "mData": "type",
                    "bSortable" : false
                },{
                    "sTitle": appUtils.getString("site_openstack_pair_az_column_label"),
                    "mData": "primary_az_id",
                    "sWidth":"10%",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "",
                    "sWidth":"15%",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "second_az_id",
                    "sWidth":"10%",
                    "bSortable" : false
                },{
                    "sTitle":appUtils.getString("site_openstack_volume_type_pair_label"),
                    "mData": "primary_volType",
                    "sWidth":"10%",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "",
                    "sWidth":"15%",
                    "bSortable" : false
                },{
                    "sTitle": "",
                    "mData": "second_volType",
                    "sWidth":"10%",
                    "bSortable" : false
                },{
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "bSortable":false
                }];
            $scope.pairTable = {
                id: "pairTable",
                data: [],
                isDraggedRemember: true,
                checkbox: true,
                columns:[],
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                paginationStyle: "full_numbers",
                enablePagination: false,
                renderRow:function(nRow, aData, iDataIndex) {
                    var optColumn = "<a href='javascript:void(0)' style='margin-right:18px' ng-if='"+ hasRight + '&&' + !pairKey + "' class='btn-link' ng-click='editOpt()'>" + appUtils.getString("common_term_edit_button") + "</a>" + "<a href='javascript:void(0)' ng-if='"+ hasRight +"' class='btn-link' ng-click='delete()'>" + appUtils.getString("common_term_delete_button") + "</a>" + "<a href='javascript:void(0)' style='margin-left:18px' ng-if='"+ hasRight + '&&' + pairKey +"' class='btn-link' ng-click='detail()'>" + appUtils.getString("common_term_detail_label") + "</a> ";
                    var optLink = $compile($(optColumn));
                    var optScope = $scope.$new();
                    optScope.data = aData;
                    optScope.delete = function() {
                        message.warn({
                        content: appUtils.getString("pair_mapping_delete_warn_label", deleteWarnTitle),
                        ok: function() {
                                var currentData = $("#pairTable").widget().getHoverData();
                                deletePair(currentData);
                            }
                        })
                    };

                    optScope.editOpt = function() {
                        infoTransferredService.put("openstackPairKey", "openstackUuid", $scope.$parent.getData());
                        $state.go("site.addPair", {
                            pairType: $stateParams.type,
                            volTypePairId: aData["volType_pair_id"]
                        });
                    };

                    optScope.detail = function() {
                        if (angular.lowercase(aData['type']) == 'vha') {
                            var win = angular.copy(constsService.ADD_VHA_AZ_WIN);
                            win.title = appUtils.getString("common_term_detail_label");
                            win.data = aData;
                            win.buttons = [{
                                key: "ok",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function(event){
                                    $("#" + constsService.ADD_VHA_AZ_WIN.winId).widget().destroy();
                                }
                            }];
                            appUtils.showWindow(win);
                        }
                        else {
                            var win = angular.copy(constsService.ADD_AZ_PAIR_WIN);
                            win.title = appUtils.getString("common_term_detail_label");
                            if(aData.type == "csha"){
                                win.height = "450px";
                            }
                            win.data = {detailFlag: "detailFlag", aData: aData};
                            win.buttons = [{
                                key: "ok",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function(event){
                                    $("#" + constsService.ADD_AZ_PAIR_WIN.winId).widget().destroy();
                                }
                            }]
                            appUtils.showWindow(win);
                        }
                    };

                    var optNode = optLink(optScope);
                    if(pairKey){
                        $('td:eq(1)', nRow).html(aData['primary_region'] + ":" + aData['primary_az']);
                        if (angular.lowercase(aData['type']) == 'vha') {
                            $('td:eq(2)', nRow).html("--");
                            $('td:eq(3)', nRow).html("--");
                            $('td:eq(4)', nRow).html(appUtils.getString("cloud_service_vha_instance_label"));
                            $('td:eq(5)', nRow).html(optNode);
                        } else {
                            var html = "<div><img style='width:100%' src='/theme/recoverydirector/images/vis/arrow_collect.png'></div>";
                            $('td:eq(2)', nRow).html(html);
                            $('td:eq(3)', nRow).html(aData['second_region'] + ":" + aData['second_az']);
                            $('td:eq(4)', nRow).html(aData.type == "csha" ? appUtils.getString("cloud_service_csha_instance_label") : appUtils.getString("cloud_service_csdr_instance_label"));
                            $('td:eq(5)', nRow).html(optNode);
                        }
                    }else{
                        var html = "<div><img style='width:77%' src='/theme/recoverydirector/images/vis/arrow_collect.png'></div>";
                        var typeLabel = {
                            "csha": appUtils.getString("cloud_service_csha_instance_label"),
                            "csdr": appUtils.getString("cloud_service_csdr_instance_label"),
                            "vha": appUtils.getString("cloud_service_vha_instance_label")
                        };
                        if (aData.primary_az_id) {
                            $('td:eq(2)', nRow).html(aData.primary_az_id.replace("_@_", ":"))
                        }
                        if (aData.type != "vha") {
                            $('td:eq(3)', nRow).html(html);
                            $('td:eq(4)', nRow).html(aData.second_az_id.replace("_@_", ":"))
                        }
                        aData.type == "vha" && $('td:eq(4)', nRow).html("--");
                        $('td:eq(6)', nRow).html(html);
                        $('td:eq(1)', nRow).html(typeLabel[aData.type]);
                        $('td:eq(8)', nRow).html(optNode);
                    }
                },
                hoverActive:function(){},
                drawCallback:function(){
                    if(pairKey){
                        $("#pairTable .tiny-th-content").eq(1).children('div').removeClass("tiny-th-vertival-line");
                        $("#pairTable .tiny-th-content").eq(2).children('div').removeClass("tiny-th-vertival-line");
                    }else{
                        $("#pairTable .tiny-th-content").eq(2).children('div').removeClass("tiny-th-vertival-line");
                        $("#pairTable .tiny-th-content").eq(3).children('div').removeClass("tiny-th-vertival-line");
                        $("#pairTable .tiny-th-content").eq(5).children('div').removeClass("tiny-th-vertival-line");
                        $("#pairTable .tiny-th-content").eq(6).children('div').removeClass("tiny-th-vertival-line");
                    }
                },
                tHeadCheckboxFn:function(){
                    deleteCls()
                },
                click:function(){
                    deleteCls()
                },
                callback:function(){
                    deleteCls()
                },
                refreshData: function(){
                   !_.isEmpty(openstackObj) && queryPairs(null,openstackObj);
                }
            };
            $scope.azModel = {
                id: "azPairAdd",
                text: appUtils.getString("common_term_add_button"),
                content: [{
                    title : "<div class='msg-info'>" + appUtils.getString("cloud_service_csha_instance_label") + "</div>",
                    click: function(evt, item, widgetThis){
                        var win = angular.copy(constsService.ADD_AZ_PAIR_WIN);
                        win.title = appUtils.getString(win.title);
                        win.height = "500px";
                        win.data = {openstackObj:openstackObj, azFlag: "HA", init: queryPairs}
                        appUtils.showWindow(win);
                    }
                },{
                    title : "<div class='msg-info'>" + appUtils.getString("cloud_service_csdr_instance_label") + "</div>",
                    click: function(evt, item, widgetThis){
                        var win = angular.copy(constsService.ADD_AZ_PAIR_WIN);
                        win.title = appUtils.getString(win.title);
                        win.height = "520px";
                        win.data = {openstackObj:openstackObj, azFlag: "MS", init: queryPairs}
                        appUtils.showWindow(win);
                    }
                }, {
                    title : "<div class='msg-info'>" + appUtils.getString("cloud_service_vha_instance_label") + "</div>",
                    click: function(evt, item, widgetThis){
                        var win = angular.copy(constsService.ADD_VHA_AZ_WIN);
                        win.data = openstackObj;
                        appUtils.showWindow(win, function() {
                            var options = this.options;
                            if (!UnifyValid.FormValid($("#" + options.verifyId), {focusInvalid: true})) {
                                return;
                            }

                            var param = {
                                type: "vha"
                            };
                            param.primary_region_id = $.trim($("#regionId").widget().getValue());
                            param.primary_region = $.trim($("#regionName").widget().getValue());
                            param.primary_az_id = $.trim($("#azoneId").widget().getValue());
                            param.primary_az = $.trim($("#azoneName").widget().getValue());
                            restService.addOpenstackAzPair(openstackObj.deviceSn, {
                                data: param,
                                success: function(result) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok:function() {
                                            $("#" + constsService.ADD_VHA_AZ_WIN.winId).widget().destroy()
                                            queryPairs(null, openstackObj);
                                        }
                                    })
                                }
                            })
                        })
                    }
                }],
                type: "button",
                btnIcon: "icon-class"
            };
            $scope.btnCreate = {
                authKey: $scope.$parent.optResAuthKey,
                text:appUtils.getString("common_term_add_button"),
                click: function(){
                    infoTransferredService.put("openstackPairKey", "openstackUuid", $scope.$parent.getData());
                    $state.go("site.addPair", {
                        pairType: $stateParams.type,
                        volTypePairId: ""
                    });
                }
            };
            $scope.btnDelete = {
                text: appUtils.getString("common_term_delete_button"),
                disabled: true,
                click: function(){
                    if($scope.btnDelete.disabled){
                        return
                    }

                    message.warn({
                        content: appUtils.getString("pair_mapping_delete_warn_label", deleteWarnTitle),
                        ok: function() {
                            var checkedObj = $("#pairTable").widget().getTableCheckedItems();
                            deletePair(checkedObj);
                        }
                    })
                }
            }
            function deleteCls(){
                if($("#pairTable").widget() && $("#pairTable").widget().getTableCheckedItems().length > 0){
                    $scope.btnDelete.disabled = false;
                }else{
                    $scope.btnDelete.disabled = true;
                }
                $scope.$apply();
            }
            function deletePair(obj){
                var deleteArray = [];
                _.each(obj,function(val){
                    var param = {};
                    if(pairKey){
                        param.az_pair_id = val.az_pair_id
                    }else{
                        param.voltype_pair_id = val.volType_pair_id
                    }
                    deleteArray.push(param)
                })
                if(pairKey){
                    restService.delOpenstackAzPair({openstackUuid:openstackObj.deviceSn},{
                        data: deleteArray,
                        success:function(result){
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    queryPairs(null,openstackObj,deleteCls);
                                }
                            });
                        }
                    })
                }else{
                    restService.delVolumTypePair({openstackUuid:openstackObj.deviceSn},{
                        data: deleteArray,
                        success:function(result){
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    queryPairs(null,openstackObj,deleteCls);
                                }
                            });
                        }
                    })
                }
            }
            function queryPairs(even,param,callback) {
                if(_.isEmpty(param.deviceSn) || $scope.$parent.isRemoteSite || 3 != constsService.FUSIONSPHERE_ENUM[param.cloudType]){
                    return
                };
                _.isEmpty(openstackObj) && !_.isEmpty($("#datasCloudTable").widget()) && (openstackObj = _.first($("#datasCloudTable").widget().getTableCheckedItems()));
                var typePair = $stateParams.type == "azPair" ? "azpairs?type=" : "voltypepairs";
                var url = "/ws/openstack/" + param.deviceSn + "/" + typePair;
                var promise = communicationService.get(url).promise();
                promise.always(function(result){
                    if (!exception.check(result)) {
                        return;
                    };
                    $scope.pairTable.columns = pairKey ? angular.copy(azPairColums) : angular.copy(volTypePairColums);
                    $scope.pairTable.totalRecords = result.length;
                    $scope.pairTable.data = appUtils.encodeForHTML(result);
                    $scope.pairTable.enablePagination = result.length > 10;
                    $scope.$apply();
                    _.isFunction(callback) && (callback())
                });
                $scope.maskHandler = promise;
                $scope.$apply();
            }
            $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, queryPairs);
            !_.isEmpty(openstackObj) && queryPairs(null, openstackObj);
        }];

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.openStack.pairList.ctrl', ctrler);
    return module;
});
