define(["tiny-common/UnifyValid", "tiny-widgets/Window", "tiny-extra-lib/jquery.base64"],
    function(UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "exception",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "infoTransferredService",
            function($scope, $state,$compile,exception,communicationService, utilService, mask,constsService, appUtils, statusEnumService, cookieService, infoTransferredService) {
                var cloudObj = $scope.$parent.getData(),
                    poType=12,
                    openStack_columns = [{
                        "sTitle": appUtils.getString("common_term_status_label"),
                        "mData": "osStatus",
                        "bSortable": false,
                    },{
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("site_term_openstack_vm_region"),
                        "mData": "regionName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("site_term_openstack_vm_project"),
                        "mData": "projectName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("site_term_openstack_vm_zone"),
                        "mData": "zoneName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("site.term.resourceOwingProtectGroup.label"),
                        "bSortable": false,
                        "mData": "protectgroupName"
                    }],
                    vmStatus = {
                        0: appUtils.getString("vm_term_currentStatus_value_running_label"),
                        14: appUtils.getString("vm_term_currentStatus_value_stopped_label"),
                        15: appUtils.getString("vm_term_currentStatus_value_stopped_label"),
                        17: appUtils.getString("vm_term_currentStatus_value_unknown_label")
                    };
                $scope.cloudOpenStackTable = {
                    id:"cloudVmsOpenstackTable",
                    paginationStyle:"full_numbers",
                    data:[],
                    isDraggedRemember:true,
                    columns:openStack_columns,
                    displayLength:constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination:false,
                    currPage:{
                        "pageIndex": 1
                    },
                    renderRow:function(nRow, aData, iDataIndex){
                        $('td:eq(0)', nRow).html(vmStatus[aData.osStatus]);
                        $('td:eq(2)', nRow).html(aData.regionId);
                        if (_.isEmpty(aData.protectGroupList)) {
                            $('td:eq(5)', nRow).html("--");
                            return;
                        }
                        var optColumn="<div class=\"configform-cell\" ng-class=\"{true : 'link',false : 'btn-link-disable'}[isLinkPg]\" title=\"{{linkPgBtn.title}}\" ng-bind=\"linkPgBtn.title\" ng-click=\"linkPgBtn.click()\"></div><div class=\"configform-cell\"><tiny-menubutton id=\"linkPgBtn.id\" content=\"linkPgBtn.content\" expand=\"linkPgBtn.expand()\" dropbtn=\"linkPgBtn.dropbtn\"></tiny-menubutton></div>",
                        optLink = $compile($(optColumn)),
                        optScope = $scope.$new();
                        optScope.isLinkPg = appUtils.checkRight("9006");
                        optScope.linkPgBtn = {
                            id: "menubtnlinkpg",
                            dropbtn: aData.protectGroupList.length > 1,
                            text: "<span class='menu-item-btn'></span>",
                            type: "button",
                            expand: function() {
                                !optScope.isLinkPg && ($(".tiny-menubutton-dropdown-a").css({
                                    color: "#999"
                                }));
                            },
                            content: [],
                            click: function() {},
                            onClick: function(pg) {
                                infoTransferredService.put("resource", "linkPg", {
                                    pgName: pg.protectgroupName
                                });
                                $state.go("protection.pg.list", {
                                    poType: pg.poType
                                });
                            }
                        };
                        var pg = aData.protectGroupList.shift();
                        optScope.linkPgBtn.title = pg.protectgroupName;
                        optScope.linkPgBtn.click = function() {
                            optScope.isLinkPg && optScope.linkPgBtn.onClick(pg);
                        };

                        _.each(aData.protectGroupList, function(pg) {
                            this.content.push({
                                title: pg.protectgroupName,
                                click: function() {
                                    optScope.isLinkPg && optScope.linkPgBtn.onClick(pg);
                                }
                            });
                        }, optScope.linkPgBtn);

                        $('td:eq(5)', nRow).html(optLink(optScope));
                    },
                    callback:function(evtObj){
                        $scope.cloudOpenStackTable.currPage.pageIndex = evtObj.currentPage;
                        $scope.cloudOpenStackTable.queryData();
                    },
                    sortCallback:function(nNode, sortArr){
                        $scope.cloudOpenStackTable.currPage.pageIndex = 1;
                        $scope.cloudOpenStackTable.orderBy = $scope.cloudOpenStackTable.columns[sortArr[0][0]].mData;
                        $scope.cloudOpenStackTable.orderType = sortArr[0][1];
                        $scope.cloudOpenStackTable.queryData();
                    },
                    url:"/fusionsphere/" + $.base64.encode(cloudObj.deviceSn) + "/action/pageQueryVms",
                    updateData:function(result){
                        if (!exception.check(result)) {
                            return;
                        };

                        _.each(result.records, function(vm) {
                            vm.protectGroupList = [];
                            _.each(_.object(vm.protectgroupId, vm.protectgroupName), function(v, k) {
                                this.push({
                                    poType: poType,
                                    protectgroupId: k,
                                    protectgroupName: v
                                });
                            }, vm.protectGroupList);
                        });

                        $scope.cloudOpenStackTable.data = appUtils.encodeForHTML(result.records);
                        $scope.cloudOpenStackTable.totalRecords = result.totalCount;
                        $scope.cloudOpenStackTable.enablePagination = +$scope.cloudOpenStackTable.totalRecords > +$scope.cloudOpenStackTable.displayLength;
                        $scope.$apply();
                    },
                    queryData:function(init){
                        var params = {
                            pageSize: $scope.cloudOpenStackTable.displayLength,
                            startPage:init ? 0 : $scope.cloudOpenStackTable.currPage.pageIndex-1,
                            orderBy: $scope.cloudOpenStackTable.orderBy,
                            orderType: $scope.cloudOpenStackTable.orderType
                        },
                        url = appUtils.fillUrl(this.url, params);
                        init && ($scope.cloudOpenStackTable.currPage = {
                            "pageIndex": 1
                        });
                        var promise = communicationService.get(url).promise();
                        promise.always($scope.cloudOpenStackTable.updateData);
                        $scope.maskHandler = promise;
                    }
                };
                var cloudTabNotify = function(event,data){
                    if(_.isEmpty(data.deviceSn) || $scope.$parent.isRemoteSite || 2 == constsService.FUSIONSPHERE_ENUM[data.cloudType]){
                        return
                    };
                    $scope.cloudOpenStackTable.url = "/fusionsphere/" + $.base64.encode(data.deviceSn) + "/action/pageQueryVms";
                    $scope.cloudOpenStackTable.currPage.pageIndex = 1;
                    $scope.cloudOpenStackTable.queryData(true);
                };

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, cloudTabNotify);
                cloudTabNotify(null,cloudObj)
            }
        ];
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.openStack.region.ctrl', ctrler);
        return module;
    });
