define(["tiny-extra-lib/jquery.base64"],
    function() {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "exception",
            "constsService",
            "appUtils",
            "widgetService",
            "restService",
            "communicationService",
            "infoTransferredService",
            "message",
            function($scope, $state, $stateParams, exception, constsService, appUtils, widgetService, restService, communicationService, infoTransferredService, message) {
                var cloudObj = $scope.$parent.getData();
                var currentSite = infoTransferredService.get("site", "currentSite");
                //操作按钮
                var regionBtn = {
                    modify: {
                        id: "modifyRegionBtn",
                        authKey: $scope.optResAuthKey,
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                        clickActive: function() {
                            var win = angular.copy(constsService.ADD_REGION_ENDPOINT_WIN);
                            _.extend(win.data, {
                                opnestanckObj: cloudObj,
                                regionData: _.first($("#datasRegionTable").widget().getHoverData()),
                                init: regionNotify
                            });
                            win.title = appUtils.getString("common_term_edit_button");
                            appUtils.showWindow(win);
                        },
                        hover: function() {
                            return currentSite.siteType === 0;
                        }
                    },
                    config: {
                        id: "configCshaBtn",
                        authKey: $scope.optResAuthKey,
                        template: "<div class='iconbutton-config' title='" + appUtils.getString("site_term_openstack_config_csha_region_label") + "'></div>",
                        clickActive: function() {
                            var win = angular.copy(constsService.MODIFY_REGION_CONFIG_WIN);
                            var hoverRegion = _.first($("#datasRegionTable").widget().getHoverData());
                            _.extend(win.data, {
                                opnestanckObj: cloudObj,
                                regionData: hoverRegion
                            });
                            win.title = appUtils.getString("site_term_openstack_config_csha_region_label");
                            if (appUtils.isEn()) {
                                win.height = "480px";
                                win.width = "580px";
                            };
                            appUtils.showWindow(win, function() {
                                restService.modifyRegonConfig([cloudObj.deviceSn, hoverRegion.regionId.split(":")[1]], {
                                    data: {
                                        isSwitchNetwork: $("#netWorkSwitch").widget().option("selected") == "on",
                                        supportSharedVolumes: $("#shareVolumeSwitch").widget().option("selected") == "on"
                                    },
                                    success: function() {
                                        message.success({
                                            content: appUtils.getString("common_term_operation_success_label"),
                                            ok: function() {
                                                $("#" + constsService.MODIFY_REGION_CONFIG_WIN.winId).widget().destroy();
                                                regionNotify(null, cloudObj);
                                            }
                                        });
                                    }
                                })
                            });
                        },
                        hover: function() {
                            return currentSite.siteType === 0;
                        }
                    },
                    deleter: {
                        id: "deleteRegionBtn",
                        authKey: $scope.optResAuthKey,
                        template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                        clickActive: function() {
                            var hoverData = _.first($("#datasRegionTable").widget().getHoverData());
                            restService.deleteOpenstackRegion([cloudObj.deviceSn, hoverData.regionId], function() {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        regionNotify(null, cloudObj);
                                    }
                                });
                            });
                        },
                        hover: function() {
                            return currentSite.siteType === 0;
                        }
                    }
                }
                regionBtn = appUtils.tableHoverWrapper(regionBtn);
                $scope.regionAdd = {
                    id: "regionAddBtn",
                    text: appUtils.getString("common_term_openstack_add_region_title"),
                    hasRight: appUtils.checkRight($scope.optResAuthKey),
                    click: function() {
                        var win = angular.copy(constsService.ADD_REGION_ENDPOINT_WIN);
                        _.extend(win.data, {
                            addRegion: true,
                            opnestanckObj: cloudObj,
                            init: regionNotify
                        });
                        appUtils.showWindow(win);
                    }
                };
                $scope.datasRegionTable = {
                    id: "datasRegionTable",
                    paginationStyle: "full_numbers",
                    isDraggedRemember: true,
                    buttonContainerPosition: "left",
                    columns: [{
                        "mData": "regionId",
                        "bVisible": false
                    }, {
                        "sTitle": "Region ID",
                        "mData": "regionId",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "description",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Compute",
                        "mData": "compute",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Volume",
                        "mData": "volume",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Network",
                        "mData": "network",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "DRExtend",
                        "mData": "agent",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Compute-ext",
                        "mData": "compute-ext",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Metering",
                        "mData": "metering",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "Image",
                        "mData": "image",
                        "bSortable": false,
                         
                    },  {
                        "sTitle": "CSHA",
                        "mData": "csha",
                        "bSortable": false,
                         
                    },  {
                        "sTitle": "ELB",
                        "mData": "elb",
                        "bSortable": false,
                         
                    },  {
                        "sTitle": "CCE",
                        "mData": "cce",
                        "bSortable": false,
                         
                    },  {
                        "sTitle": "RDS",
                        "mData": "rds",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "DCS",
                        "mData": "dcs",
                        "bSortable": false,
                         
                    }, {
                        "sTitle": "apicom",
                        "mData": "apicom",
                        "bSortable": false,
                         
                    }],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    data: [],
                    url: "/openstack/" + cloudObj.deviceSn + "/regions",
                    renderRow: function(nRow, aData, iDataIndex) {
                        $("td:eq(0)", nRow).html(aData.regionId.split(":")[1]);
                        _.each(aData.services, function(item){
                            item.serviceType == "compute" && ($("td:eq(2)", nRow).html(item.serviceUrl));
                            item.serviceType == "volume" && ($("td:eq(3)", nRow).html(item.serviceUrl));
                            item.serviceType == "network" && ($("td:eq(4)", nRow).html(item.serviceUrl));
                            item.serviceType == "agent" && ($("td:eq(5)", nRow).html(item.serviceUrl));
                            item.serviceType == "compute-ext" && ($("td:eq(6)", nRow).html(item.serviceUrl));
                            item.serviceType == "metering" && ($("td:eq(7)", nRow).html(item.serviceUrl));
                            item.serviceType == "image" && ($("td:eq(8)", nRow).html(item.serviceUrl));
                            item.serviceType == "csha" && ($("td:eq(9)", nRow).html(item.serviceUrl));
                            item.serviceType == "elb" && ($("td:eq(10)", nRow).html(item.serviceUrl));
                            item.serviceType == "cce" && ($("td:eq(11)", nRow).html(item.serviceUrl));
                            item.serviceType == "rds" && ($("td:eq(12)", nRow).html(item.serviceUrl));
                            item.serviceType == "dcs" && ($("td:eq(13)", nRow).html(item.serviceUrl));
                            item.serviceType == "apicom" && ($("td:eq(14)", nRow).html(item.serviceUrl));
                        });
                    },
                    callback: function(evtObj) {},
                    opAreaConfig: appUtils.flilterOperRight([regionBtn.modify, regionBtn.config, regionBtn.deleter]),
                    cellClickActive: function(e, param, isFind) {},
                    hoverActive: function(e, param) {
                        regionBtn.notify(param);
                    },
                    enablePagination: false,
                    currPage: {
                        "pageIndex": 1
                    },
                    updateData: function(result) {
                        if (!exception.check(result)) {
                            return;
                        };
                        $scope.datasRegionTable.data = appUtils.encodeForHTML(result);
                        $scope.datasRegionTable.enablePagination = result.length > 10;
                        $scope.$apply();
                    },
                    queryData: function() {
                        var url = appUtils.fillUrl(this.url, null);
                        var promise = communicationService.get(url).promise();
                        promise.always($scope.datasRegionTable.updateData);
                        $scope.maskHandler = promise;
                    }
                };

                var regionNotify = function(even, data) {
                    if (_.isEmpty(data.deviceSn) || $scope.$parent.isRemoteSite || 3 != constsService.FUSIONSPHERE_ENUM[data.cloudType]) {
                        return
                    };
                    $scope.datasRegionTable.url = "/openstack/" + data.deviceSn + "/regions";
                    $scope.datasRegionTable.queryData();
                    $scope.$apply();
                };

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, regionNotify);
                regionNotify(null, cloudObj);
            }
        ];
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.openStack.region.ctrl', ctrler);
        return module;
    });
