define([],
    function() {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            function($scope, $state, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model) {
                var columns = [{
                    "sTitle": appUtils.getString("common_term_status_label"),
                    "mData": "status"
                }, {
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "name"
                }, {
                    "sTitle": appUtils.getString("common_term_ip_column"),
                    "mData": "ip"
                }];

                $scope.cloudfcTable = {
                    id: "cloudfcTable",
                    isDraggedRemember: false,
                    columns: columns,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    totalRecords: 0,
                    enablePagination : false,
                    callback: function(evtObj) {
                        $scope.cloudfcTable.currPage = evtObj.currentPage - 1;

                        $scope.cloudfcTable.queryData();

                    },
                    renderRow: function(nRow, aData, iDataIndex) {
                        var status = aData["status"];
                        if (+aData["status"] === 1) {
                            $('td:eq(0)', nRow).html(appUtils.getString("common_term_status_normal_label"));
                        } else {
                            $('td:eq(0)', nRow).html(sappUtils.getString("common_term_status_offline_label"));
                        }

                    },
                    data: [],
                    sortCallback: function(nNode, sortArr) {
                        $scope.cloudfcTable.currPage = 0;
                        $scope.cloudfcTable.orderBy = $scope.cloudfcTable.columns[sortArr[0][0]].mData;
                        $scope.cloudfcTable.orderType = sortArr[0][1];
                        $scope.cloudfcTable.queryData();
                    },
                    currPage : 0,
                    updateData: function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            this.data = appUtils.encodeForHTML(result);
                            this.totalRecords = result.length;
                            this.enablePagination = +this.totalRecords > +this.displayLength;

                            $scope.$apply();
                        }
                    },
                    queryData: function() {
                        var params = {
                                pageSize: $scope.cloudfcTable.displayLength,
                                startPage: $scope.cloudfcTable.currPage,
                                orderBy: $scope.cloudfcTable.orderBy,
                                orderType: $scope.cloudfcTable.orderType
                            },
                            url = appUtils.fillUrl(this.url, params);
                        mask.show();
                        communicationService.get(url).promise().always($scope.cloudfcTable.updateData);
                    }

                };
                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, function(ev, data) {});
            }
        ]

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.cloud.fc.ctrl', ctrler);
        return module;
    })
