define(["tiny-extra-lib/jquery.base64"],
    function() {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            "infoTransferredService",
            function($scope, $state, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model, infoTransferredService) {
                var poType, cloudObj = $scope.$parent.getData(),
                    vmStatus = {},
                    STATUS = {
                        cloud: {
                            1: appUtils.getString("vm_term_currentStatus_value_running_label"),
                            2: appUtils.getString("vm_term_currentStatus_value_stopped_label"),
                            3: appUtils.getString("vm_term_currentStatus_value_unknown_label"),
                            4: appUtils.getString("vm_term_currentStatus_value_beenDormant_label"),
                            5: appUtils.getString("vm_term_currentStatus_value_creatingOrDeploying_label"),
                            6: appUtils.getString("vm_term_currentStatus_value_deleting_label"),
                            7: appUtils.getString("vm_term_currentStatus_value_migrating_label"),
                            8: appUtils.getString("vm_term_currentStatus_value_recovering_label"),
                            9: appUtils.getString("vm_term_currentStatus_value_starting_label"),
                            10: appUtils.getString("vm_term_currentStatus_value_stopping_label"),
                            11: appUtils.getString("vm_term_currentStatus_value_dormanting_label"),
                            12: appUtils.getString("vm_term_currentStatus_value_paused_label"),
                            13: appUtils.getString("vm_term_currentStatus_value_restoring_label")
                        },
                        vmware: {
                            0: appUtils.getString("vm_term_currentStatus_value_running_label"),
                            1: appUtils.getString("vm_term_currentStatus_value_offline_label"),
                            2: appUtils.getString("vm_term_currentStatus_value_offline_label"),
                            3: appUtils.getString("vm_term_currentStatus_value_offline_label"),
                            4: appUtils.getString("vm_term_currentStatus_value_offline_label"),
                            5: appUtils.getString("vm_term_currentStatus_value_unknown_label")
                        }
                    },
                    VM_TYPE = {
                        "-1": appUtils.getString("VMware_term_status_value_unknown_value"),
                        "0": appUtils.getString("VMware_term_status_value_normalVM_value"),
                        "1": appUtils.getString("VMware_term_status_value_templateVM_value"),
                        "2": appUtils.getString("VMware_term_status_value_occupiedVM_value"),
                        "3": appUtils.getString("VMware_term_status_value_linkVM_value"),
                        "4": appUtils.getString("VMware_term_status_value_FTVM_value")
                    },
                    vmWare_columns = [{
                        "sTitle": appUtils.getString("common_term_status_label"),
                        "mData": "osStatus"
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("common_term_system_label"),
                        "mData": "guestFullName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site.term.resourceOwingProtectGroup.label"),
                        "bSortable": false,
                        "mData": "protectgroupName"
                    }],
                    cloud_columns = [{
                        "sTitle": appUtils.getString("common_term_status_label"),
                        "mData": "osStatus",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": "ID",
                        "mData": "vmId",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_type_label"),
                        "mData": "vmType",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_system_label"),
                        "mData": "osType",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site.term.resourceOwingProtectGroup.label"),
                        "bSortable": false,
                        "mData": "protectgroupName"
                    }];

                var vmStatusSelectValues = {
                    cloud: [{
                            selectId: "",
                            label: appUtils.getString("common_term_all_label")
                        },{
                            selectId: "1",
                            label: appUtils.getString("vm_term_currentStatus_value_running_label")
                        },{
                            selectId: "2",
                            label: appUtils.getString("vm_term_currentStatus_value_stopped_label")
                        },{
                            selectId: "3",
                            label: appUtils.getString("vm_term_currentStatus_value_unknown_label")
                        },{
                            selectId: "4",
                            label: appUtils.getString("vm_term_currentStatus_value_beenDormant_label")
                        },{
                            selectId: "5",
                            label: appUtils.getString("vm_term_currentStatus_value_creatingOrDeploying_label")
                        },{
                            selectId: "6",
                            label: appUtils.getString("vm_term_currentStatus_value_deleting_label")
                        },{
                            selectId: "7",
                            label: appUtils.getString("vm_term_currentStatus_value_migrating_label")
                        },{
                            selectId: "8",
                            label: appUtils.getString("vm_term_currentStatus_value_recovering_label")
                        },{
                            selectId: "9",
                            label: appUtils.getString("vm_term_currentStatus_value_starting_label")
                        },{
                            selectId: "10",
                            label: appUtils.getString("vm_term_currentStatus_value_stopping_label")
                        },{
                            selectId: "11",
                            label: appUtils.getString("vm_term_currentStatus_value_dormanting_label")
                        },{
                            selectId: "12",
                            label: appUtils.getString("vm_term_currentStatus_value_paused_label")
                        },{
                            selectId: "13",
                            label: appUtils.getString("vm_term_currentStatus_value_restoring_label")
                        }],
                    vmware: [{
                            selectId: "",
                            label: appUtils.getString("common_term_all_label")
                        },{
                            selectId: "0",
                            label: appUtils.getString("vm_term_currentStatus_value_running_label")
                        },{
                            selectId: "4",
                            label: appUtils.getString("vm_term_currentStatus_value_offline_label")
                        },{
                            selectId: "5",
                            label: appUtils.getString("vm_term_currentStatus_value_unknown_label")
                        }]
                    },
                    vmTypeValues = [{
                            selectId: "1",
                            label: appUtils.getString("common_term_status_label")
                        },{
                            selectId: "0",
                            label: appUtils.getString("common_term_name_label")
                        },{
                            selectId: "-1",
                            label: "ID"
                    }];

                $scope.cloudVmsTable = {
                    id: "cloudVmsTable",
                    paginationStyle:"full_numbers",
                    columns: vmWare_columns,
                    isDraggedRemember: true,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    lengthMenu: constsService.TABLE_LENGTH_MENU,
                    renderRow: function(nRow, aData, iDataIndex) {
                        var isCloud = cloudObj.type === "cloud",
                            groupCellIndex = isCloud ? 5 : 3;
                        $('td:eq(0)', nRow).html(vmStatus[aData.osStatus]);

                        if (isCloud) {
                            $('td:eq(3)', nRow).html(VM_TYPE[aData["vmType"]]);
                        }

                        if (_.isEmpty(aData.protectGroupList)) {
                            $('td:eq('+groupCellIndex+')', nRow).html("--");
                            return;
                        }

                        var optColumn = "<div class=\"configform-cell\" ng-class=\"{true : 'link',false : 'btn-link-disable'}[isLinkPg]\" title=\"{{linkPgBtn.title}}\" ng-bind=\"linkPgBtn.title\" ng-click=\"linkPgBtn.click()\"></div><div class=\"configform-cell\"><tiny-menubutton id=\"linkPgBtn.id\" content=\"linkPgBtn.content\" expand=\"linkPgBtn.expand()\" dropbtn=\"linkPgBtn.dropbtn\"></tiny-menubutton></div>",
                            optLink = $compile($(optColumn)),
                            optScope = $scope.$new();
                        optScope.isLinkPg = appUtils.checkRight("9006");
                        optScope.linkPgBtn = {
                            id: "menubtnlinkpg",
                            dropbtn: aData.protectGroupList.length > 1,
                            text: "<span class='menu-item-btn'></span>",
                            type: "button",
                            expand: function() {
                                !optScope.isLinkPg && ($(".tiny-menubutton-dropdown-a").css({
                                    color: "#999"
                                }));
                            },
                            content: [],
                            click: function() {},
                            onClick: function(pg) {
                                infoTransferredService.put("resource", "linkPg", {
                                    pgName: pg.protectgroupName
                                });
                                $state.go("protection.pg.list", {
                                    poType: pg.poType
                                });
                            }
                        };
                        var pg = aData.protectGroupList.shift();
                        optScope.linkPgBtn.title = pg.protectgroupName;
                        optScope.linkPgBtn.click = function() {
                            optScope.isLinkPg && optScope.linkPgBtn.onClick(pg);
                        };

                        _.each(aData.protectGroupList, function(pg) {
                            this.content.push({
                                title: pg.protectgroupName,
                                click: function() {
                                    optScope.isLinkPg && optScope.linkPgBtn.onClick(pg);
                                }
                            });
                        }, optScope.linkPgBtn);

                        $('td:eq('+groupCellIndex+')', nRow).html(optLink(optScope));
                    },
                    callback: function(evtObj) {
                        $scope.cloudVmsTable.currPage.pageIndex = evtObj.currentPage;

                        $scope.cloudVmsTable.queryData();
                    },
                    data: [],
                    enablePagination: false,
                    currPage: {
                        "pageIndex": 1
                    },
                    updateData: function(result) {
                        if (!exception.check(result)) {
                            return;
                        }

                        _.each(result.records, function(vm) {
                            vm.protectGroupList = [];
                            _.each(_.object(vm.protectgroupId, vm.protectgroupName), function(v, k) {
                                this.push({
                                    poType: poType,
                                    protectgroupId: k,
                                    protectgroupName: v
                                });
                            }, vm.protectGroupList);
                        })

                        $scope.cloudVmsTable.data = appUtils.encodeForHTML(result.records);
                        $scope.cloudVmsTable.totalRecords = result.totalCount;
                        $scope.cloudVmsTable.enablePagination = +$scope.cloudVmsTable.totalRecords > +constsService.TABLE_COUNT_PER_PAGE;
                        $scope.$apply();
                    },
                    sortCallback: function(nNode, sortArr) {
                        $scope.cloudVmsTable.currPage.pageIndex = 1;
                        $scope.cloudVmsTable.orderBy = $scope.cloudVmsTable.columns[sortArr[0][0]].mData;
                        $scope.cloudVmsTable.orderType = sortArr[0][1];
                        $scope.cloudVmsTable.queryData();
                    },
                    url: "",
                    queryData: function(isInit, _pageSize) {
                        var params = {
                                pageSize: _.isUndefined(_pageSize) ? $scope.cloudVmsTable.displayLength : _pageSize,
                                startPage: isInit ? 0 : $scope.cloudVmsTable.currPage.pageIndex - 1,
                                orderBy: $scope.cloudVmsTable.orderBy,
                                orderType: $scope.cloudVmsTable.orderType,
                                filterName: $scope.cloudVmsTable.filterName,
                                filterValue: $scope.cloudVmsTable.filterValue
                            },
                            url = appUtils.fillUrl(this.url, params);

                        isInit && ($scope.cloudVmsTable.currPage = {
                            "pageIndex": 1
                        });

                        var promise = communicationService.get(url).promise();
                        promise.always($scope.cloudVmsTable.updateData);
                        $scope.maskHandler = promise;
                    },
                    changeSelect: function(evtObj){
                        $scope.cloudVmsTable.currPage.pageIndex = 1;
                        $scope.cloudVmsTable.queryData(true, evtObj.displayLength);
                    }
                };

                //初始化过滤值
                $scope.cloudVmsTable.filterValue = "";
                $scope.cloudVmsTable.filterName = "status";

                $scope.cloudVmsQuery = {
                    id: "cloudVmsSearchBox",
                    values:[],
                    defaultSelectid: "1",
                    display: true,
                    isSearchbox: false,
                    showTip: true,
                    textOptions: {
                        id: "textStatusSelect",
                        values: cloudObj.type === "vmware" ? vmStatusSelectValues["vmware"] : vmStatusSelectValues["cloud"]
                    },
                    change: function(){
                        var selectId = $("#"+this.id).widget().getSelectedId();
                        if(selectId == "1"){
                            this.isSearchbox = false;
                            $("#"+this.id).widget().changeTextBox(false,this.textOptions);
                        }else{
                            this.isSearchbox = true;
                            $("#"+this.id).widget().changeTextBox(true);
                        }
                    },
                    click: function(){
                        var searchValue = $("#"+this.id).widget().getSearchboxValue();
                        $scope.cloudVmsTable.filterValue = searchValue.inputValue;
                        if(searchValue.type == "-1"){
                            $scope.cloudVmsTable.filterName = "ID";
                        }else if(searchValue.type == "1"){
                            $scope.cloudVmsTable.filterName = "status";
                        }else{
                            $scope.cloudVmsTable.filterName = "name";
                        }
                        $scope.cloudVmsTable.queryData(true);
                    }
                }

                var cloudTabNotify = function(ev, data) {
                        if ($scope.$parent.isRemoteSite || _.isEmpty(data.deviceSn) || 2 == constsService.FUSIONSPHERE_ENUM[data.cloudType] || window.isPrivateConsole) {
                            return;
                        }

                        vmStatus = STATUS["cloud"];
                        cloudObj = angular.copy(data);
                        cloudObj.type = "cloud";
                        $scope.cloudVmsQuery.values = vmTypeValues;
                        $scope.$apply();

                        $scope.cloudVmsTable.columns = cloud_columns;
                        $scope.cloudVmsTable.url = "/fusionsphere/" + $.base64.encode(data.deviceSn) + "/action/pageQueryVms";
                        $scope.cloudVmsTable.currPage.pageIndex = 1;
                        $scope.cloudVmsTable.filterValue = "";
                        $scope.cloudVmsTable.filterName = "status";
                        if($("#cloudVmsSearchBox").length > 0){
                           $("#cloudVmsSearchBox").widget().opChecked("1");
                           $("#cloudVmsSearchBox").widget().changeTextBox(false,{id: "textStatusSelect",values:vmStatusSelectValues["cloud"]});
                        }
                        poType = 12;
                        $scope.cloudVmsTable.queryData(true);

                    },
                    vmwareTabNotify = function(ev, data) {
                        if (_.isEmpty(data.deviceSn) || $scope.$parent.isRemoteSite) {
                            return;
                        }

                        vmStatus = STATUS["vmware"];
                        cloudObj = angular.copy(data);
                        cloudObj.type = "vmware";
                        vmTypeValues.pop();
                        $scope.cloudVmsQuery.values = vmTypeValues;
                        $scope.$apply();

                        poType = 10;
                        $scope.cloudVmsTable.columns = vmWare_columns;
                        $scope.cloudVmsTable.url = "/vcenters/" + data.deviceSn + "/vms";
                        $scope.cloudVmsTable.currPage.pageIndex = 1;
                        $scope.cloudVmsTable.queryData(true);



                    };

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, cloudTabNotify);
                $scope.$on(constsService.TOPIC.SITE_VRG_TAB, vmwareTabNotify);

                cloudObj.type === "vmware" && (vmwareTabNotify(null, cloudObj));
                cloudObj.type === "cloud" && (cloudTabNotify(null, cloudObj));
            }
        ]

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.cloud.vm.ctrl', ctrler);
        return module;
    })
