define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "message",
        "constsService",
        "appUtils",
        "restService",
        function($scope, message, constsService, appUtils, restService) {

            var data = $("#" + constsService.ADD_VHA_AZ_WIN.winId).widget().option("data");

            $scope.type = {
                label: appUtils.getStringWithColon("common_term_type_label"),
                display: angular.lowercase(data["type"]) == 'vha',
                value: appUtils.getString("cloud_service_vha_instance_label"),
            }
            $scope.region = {
                labelcls: 'label-style',
                titleTdAttr: {
                    colspan: "2",
                    align: "left"
                },
                ID: {
                    id: "regionId",
                    label: "Region ID:",
                    hide: !_.isUndefined(data["primary_region_id"]),
                    value: _.isUndefined(data["primary_region_id"]) ? "" : data["primary_region_id"],
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                },
                name: {
                    id: "regionName",
                    label: "Region " + appUtils.getStringWithColon("common_term_name_label"),
                    hide: !_.isUndefined(data["primary_region"]),
                    value: _.isUndefined(data["primary_region"]) ? "" : data["primary_region"],
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                }
            }

            $scope.azone = {
                labelcls: 'label-style',
                titleTdAttr: {
                    colspan: "2",
                    align: "left"
                },
                ID: {
                    id: "azoneId",
                    label: "Availablity Zone ID:",
                    hide: !_.isUndefined(data["primary_az_id"]),
                    value: _.isUndefined(data["primary_az_id"]) ? "" : data["primary_az_id"],
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                },
                name: {
                    id: "azoneName",
                    hide: !_.isUndefined(data["primary_az"]),
                    label: "Availablity Zone " + appUtils.getStringWithColon("common_term_name_label"),
                    value: _.isUndefined(data["primary_az"]) ? "" : data["primary_az"],
                    width: 200,
                    validate: constsService.VALID.DES_REMARK_REQUIRED,
                }
            }


        }
    ];
    var module = angular.module("recoverydirector.site.config");
    module.tinyController("vhaAzPairCtrl", ctrl);
    return module;
})
