define([], function() {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService", "appUtils", "cookieService",
        function($scope, $state, $stateParams, exception, message,
            communicationService, utilService, mask, constsService, appUtils, cookieService) {
            var data = $("#" + constsService.VRG_PAIR_WIN.winId).widget().option("data");

            $scope.vrgPair = {
                desc : appUtils.getString("site_vrg_task_setPair_des_label"),
                psite: {
                    id : data.psite.id,
                    label: appUtils.getStringWithColon("rm_term_production_site"),
                    value: data.psite.name
                },
                rsite: {
                    id: "rsite",
                    name: "recoverySiteId",
                    label: appUtils.getStringWithColon("rm_term_dr_site"),
                    values: [appUtils.getDefaultOption()],
                    width: getComBoxWidth(),
                    change: function() {
                        $("#rfc").widget().opChecked("-1");
                        var rvrgBox = $("#rvrg").widget();
                        rvrgBox.option("values",[appUtils.getDefaultOption()]);
                        rvrgBox.opChecked("-1");
                        $scope.vrgPair.initBoxView($scope.vrgPair.rfc);
                    },
                    itemKey: {
                        key: "siteId",
                        value: "name"
                    },
                    isInit: true,
                    type: -1,
                    dataUrl: "/sites",
                    delItemId : data.psite.id
                },
                pfc: {
                    id: "pfc",
                    name: "productResourceProviderId",
                    label: appUtils.getStringWithColon("recovery.term.vrg.product_fc.title"),
                    value : data.pfc.name,
                    isInit : false
                },
                rfc: {
                    id: "rfc",
                    name: "recoveryResourceProviderId",
                    label: appUtils.getStringWithColon("recovery.term.vrg.recovery_fc.title"),
                    values: [appUtils.getDefaultOption()],
                    width: getComBoxWidth(),
                    change: function() {
                        $("#rvrg").widget().opChecked("-1");
                        $scope.vrgPair.initBoxView($scope.vrgPair.rvrg);
                    },
                    type: -1,
                    itemKey: {
                        key: "deviceSn",
                        value: "cloudName"
                    },
                    dataUrl: constsService.RM_URL.fusionsphereURL,
                    getUrlParam: function() {
                        var selectSiteId = $("#rsite").widget().getSelectedId();

                        var params = {
                            siteId: selectSiteId,
                            cloudType: appUtils.getString("resource_mapping_cloud_fc_type")
                        };
                        return params;
                    }
                },
                pvrg: {
                    id : data.pvrg.id,
                    label: appUtils.getStringWithColon("common_term_vrg_label"),
                    value: data.pvrg.name
                },
                rvrg: {
                    id: "rvrg",
                    name: "recoverySiteId",
                    label: appUtils.getStringWithColon("common_term_vrg_label"),
                    values: [appUtils.getDefaultOption()],
                    width: getComBoxWidth(),
                    change: function() {},
                    isMask : true,
                    dataUrl: constsService.RM_URL.mappingURL + "/action/getResource",
                    getUrlParam: function() {
                        return {
                            resourceType: constsService.RM_ENUM["vrg"],
                            siteId: $("#rsite").widget().getSelectedId(),
                            resourceProviderId: $("#rfc").widget().getSelectedId()
                        };
                    },
                    itemKey: {
                        key: "resourceId",
                        value: "resourceName"
                    },
                    type: -1,
                },
                initBoxView: function(box) {
                    var url = box.dataUrl;
                    if (angular.isDefined(box.getUrlParam)) {
                        url = appUtils.fillUrl(url, box.getUrlParam());
                    }

                    requestAjax.initBoxView(url, box.id, box.type, box.itemKey, box.delItemId,box.isMask);
                }
            };

            function getComBoxWidth() {
                return isEn() ? 165 : 160;
            }

            function isEn() {
                var language = cookieService.get("language");
                return "zh" !== language && "zh_CN" !== language;
            }

            var _init = function() {
                angular.forEach($scope.vrgPair, function(box) {
                    if (angular.isDefined(box.isInit) && box.isInit) {
                        if(_.isFunction(box.init)){
                            box.init();
                            return;
                        }

                        $scope.vrgPair.initBoxView(box);
                    }
                });
            };

            var requestAjax = {
                initBoxView: function(url, boxId, type, itemKey, deleteSiteId,isMask) {
                    isMask && (mask.show());
                    communicationService.get(utilService.getResouceUrl(url), null, null, 3600000).promise().always(function(result) {
                        isMask && (mask.hide());
                        var isOk = exception.check(result, false);
                        isOk = isOk === true;
                        if (!isOk) {
                            result = [];
                            isOk = !isOk;
                        }
                        if (isOk) {

                            appUtils.encodeForHTML(result);

                            var arr = [appUtils.getDefaultOption()];
                            var selectId = $("#" + boxId).widget().getSelectedId();
                            if (angular.isDefined(selectId) && +selectId !== -1) {
                                arr[0] = angular.copy(arr[0]);
                                arr[0].checked = false;
                            }

                            _.each(result, function(d) {
                                if (angular.isDefined(deleteSiteId) && angular.equals(deleteSiteId + "", d.siteId + "")) {
                                    return;
                                }

                                if (-1 !== type && type !== d.siteType) {
                                    return;
                                }
                                var tmo = {
                                    selectId: d[itemKey.key],
                                    label: d[itemKey.value]
                                };
                                arr.push(tmo);
                            });

                            var box = $("#" + boxId).widget();
                            var selectId = box.getSelectedId();
                            box.option("values", arr);
                            box.opChecked(selectId);
                            $scope.$apply();
                        }
                    });
                }
            };

            _init();
        }
    ];

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("vrg.vrgPair", ctrl);
    return module;
});
