define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "$filter",
        "$timeout",
        "$compile",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "infoTransferredService",
        function($scope, $filter, $timeout, $compile, constsService, appUtils, restService, statusEnumService, message,
            infoTransferredService) {
            var autoRefreshTimer,
                currentSite = infoTransferredService.get("site", "currentSite"),
                PHASE_STATUS = {
                    "refresh": 0,
                    "timeout": 1
                };
            if (_.isEmpty(currentSite)) {
                return;
            }

            var _queryRespos = function(status) {
                if (_.isUndefined(status)) {
                    status = PHASE_STATUS.refresh;
                }

                var startPage = 0;
                if (!_.isUndefined($scope.model.datasTable)) {
                    startPage = $scope.model.datasTable.currPage.pageIndex - 1;
                }

                var params = {
                    siteId: currentSite.siteId,
                    startPage: startPage,
                    limit: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    resourceType: "server",
                    protectType: "backup",
                    cloudType: "hybrid"
                };

                restService.queryBackupRespo(params, {
                    mask: !status,
                    success: function(result) {
                        $scope.model.datasTable.data = appUtils.encodeForHTML(result.records);
                        $scope.model.datasTable.totalRecords = result.totalCount;
                        $scope.$apply();
                        autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
                        autoRefreshTimer = $timeout(function() {
                            _queryRespos(PHASE_STATUS.timeout);
                        }, 10000);
                    },
                    fail: function() {
                        autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
                    }
                })
            }

            var _addRowNode = function(nRow, aData, iDataIndex, anHidden) {
                var link = $compile(
                    '<div><tiny-progressbar value="childModel.value" display="childModel.display" width="childModel.width" height="childModel.height" label-position="childModel.labelPosition"></tiny-progressbar><span style="margin-left:10px">' + appUtils.convertCapacityUnit(+aData.billing.used * 1024) + '/' + appUtils.convertCapacityUnit(+aData.billing.size * 1024 * 1024) + '</span></div>'
                );
                var scope = $scope.$new(false);
                scope.childModel = {
                    "display": true,
                    "width": 100,
                    "height": 12,
                    "value": $filter('number')((+aData.billing.used / (+aData.billing.size * 1024) * 100), 0),
                    "labelPosition": "center"
                }
                var node = link(scope);
                $("td[tdtitle='" + appUtils.getString("common_term_usedcapacity_label") + "']", nRow).html(node);
            }

            $scope.model = {
                btnRefresh: {
                    text: appUtils.getString("common_term_refresh_button"),
                    click: _queryRespos
                },
                btnCreate: {
                    id: "btnCreate",
                    show: true,
                    text: appUtils.getString("site_backuprespo_buy_label"),
                    click: function() {
                        window.open(constsService.HUAWEI_CLOUD_WEBSITE, "_blank");
                    }
                },
                datasTable: {
                    id: "datasTable",
                    data: [],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    totalRecords: 0,
                    currPage: {
                        pageIndex: 1
                    },
                    pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    paginationStyle: "full_numbers",
                    paging: "auto",
                    columns: [{
                        "mData": "id",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("common_term_status_label"),
                        "mData": "billing.status",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_usedcapacity_label"),
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site_backuprespo_billingmode_label"),
                        "mData": "billing.charging_mode",
                        "bSortable": false
                    }],
                    callback: function(evtObj) {
                        $scope.model.datasTable.currPage.pageIndex = evtObj.currentPage;
                        $scope.model.datasTable.pageSize = evtObj.displayLength;
                    },
                    sortCallback: function(th, sortObj) {},
                    renderRow: function(nRow, aData, iDataIndex) {
                        var mode = statusEnumService.getStatus("RESPO_BILLING_MODE", $.trim(
                            aData['billing']["charging_mode"]));
                        var type = statusEnumService.getStatus("RESPO_TYPE", $.trim(
                            aData['billing']['resource_type']));
                        var status = statusEnumService.getStatus("RESPO_STATUS", $.trim(
                            aData['billing']['status']));
                        $("td[tdtitle='" + appUtils.getString("site_backuprespo_billingmode_label") +
                            "']", nRow).html(mode);
                        $("td[tdtitle='" + appUtils.getString("common_term_type_label") +
                            "']", nRow).html(type);
                        $("td[tdtitle='" + appUtils.getString("common_term_status_label") +
                            "']", nRow).html(status);
                        _addRowNode.apply(this, arguments);
                    },
                    cellClickActive: function(e, param) {},
                    hoverActive: function(e, param) {},
                    init: _queryRespos()
                }
            };

            $scope.$on("$destroy", function() {
                autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
            });
        }
    ]

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.backuprespo.ctrl', ctrl);
    return module;
})