define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = [
        "$scope",
        "$timeout",
        "constsService",
        "appUtils",
        "restService",
        "statusEnumService",
        "message",
        "infoTransferredService",
        function($scope, $timeout, constsService, appUtils, restService, statusEnumService, message,
            infoTransferredService) {
            var autoRefreshTimer,
                currentSite = infoTransferredService.get("site", "currentSite"),
                PHASE_STATUS = {
                    "refresh": 0,
                    "timeout": 1
                };
            if (_.isEmpty(currentSite)) {
                return;
            }

            var _queryCloudServers = function(status) {
                if (_.isUndefined(status)) {
                    status = PHASE_STATUS.refresh;
                }
                var params = {
                    siteId: currentSite.siteId
                };

                !status && ($scope.mask = $.Deferred());
                $scope.$apply();
                restService.queryCloudServer(_.extend($scope.model.datasTable.queryParams, params), {
                    mask: false,
                    success: function(result) {
                        $scope.model.datasTable.data = appUtils.encodeForHTML(result.records);
                        $scope.model.datasTable.totalRecords = result.totalCount;
                        $scope.$apply();
                        autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
                        autoRefreshTimer = $timeout(function() {
                            _queryCloudServers(PHASE_STATUS.timeout);
                        }, 10000);
                    },
                    fail: function() {
                        autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
                    },
                    callback: function() {
                        $scope.mask.resolve();
                    }
                })
            }

            $scope.model = {
                btnRefresh: {
                    text: appUtils.getString("common_term_refresh_button"),
                    click: _queryCloudServers
                },
                metalAdd: {
                    id: "metalAdd",
                    show: false,
                    text: appUtils.getString("site_metalserver_buy_label"),
                    click: function() {
                        window.open(constsService.HUAWEI_CLOUD_WEBSITE, "_blank");
                    }
                },
                serverQuery: {
                    id: "serverQuery",
                    display: false,
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_all_label")
                    }, {
                        selectId: "ecs",
                        label: appUtils.getString("site_cloudserver_ecs_label")
                    }, {
                        selectId: "metal",
                        label: appUtils.getString("site_cloudserver_metal_label")
                    }],
                    defaultId: "-1",
                    disabled: false,
                    tableDatas: [],
                    width: constsService.W3,
                    change: function(e) {
                        if (!_.size($scope.model.serverQuery.tableDatas)) {
                            $scope.model.serverQuery.tableDatas = $("#datasTable").widget().getTableData()
                        }
                        var serverType = $("#serverQuery").widget().getSelectedId();
                        var datas = _.filter(angular.copy($scope.model.serverQuery.tableDatas), function(data){
                            return data.serverType === serverType || serverType == "-1";
                        });
                        $scope.model.datasTable.data = datas;
                        $scope.model.datasTable.totalRecords = _.size(datas);
                        $scope.$apply();
                    },
                    openFn: function(e) {},
                    closeFn: function(e) {},
                },
                ecsAdd: {
                    id: "ecsAdd",
                    show: true,
                    text: appUtils.getString("site_ecsserver_buy_label"),
                    click: function() {
                        window.open(constsService.HUAWEI_CLOUD_WEBSITE, "_blank");
                    }
                },
                datasTable: {
                    id: "datasTable",
                    data: [],
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    totalRecords: 0,
                    currPage: {
                        pageIndex: 1
                    },
                    queryParams: {
                        startPage: 0,
                        pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                        orderBy: "name",
                        orderType: "desc"
                    },
                    paginationStyle: "full_numbers",
                    paging: "auto",
                    cloneDatas: [],
                    columns: [{
                        "mData": "id",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name",
                        "bSortable": true
                    }, {
                        "sTitle": appUtils.getString("site_cloudserver_az_label"),
                        "mData": "OS-EXT-AZ:availability_zone",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_status_label"),
                        "mData": "status",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site_cloudserver_spec_label"),
                        "mData": "flavor",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_ip_label"),
                        "mData": "addresses",
                        "bSortable": false
                    }],
                    callback: function(evtObj) {
                        $scope.model.datasTable.queryParams.startPage = evtObj.currentPage - 1;
                        $scope.model.datasTable.queryParams.pageSize = evtObj.displayLength;
                        _queryCloudServers();
                    },
                    sortCallback: function(th, sortObj) {
                        $scope.model.datasTable.queryParams.startPage = 0;
                        $scope.model.datasTable.queryParams.orderType = sortObj[0][1];
                        $scope.model.datasTable.queryParams.orderBy = $scope.model.datasTable.columns[sortObj[0][0]].mData;
                        _queryCloudServers();
                    },
                    renderRow: function(nRow, aData, iDataIndex) {
                        var serverType = statusEnumService.getStatus("CLOUD_SERVER_TYPE", $.trim(aData['serverType']));
                        var status = statusEnumService.getStatus("CLOUD_SERVER_STATUS", angular.uppercase(aData['status']));
                        var ip = "",
                            ipTemplate = "<div style='block;'>{0}&nbsp;({1})</div>";
                        var flavorTemplate = "<div style='block;'>{0}vCPUs&nbsp;|&nbsp{1}MB&nbsp;|&nbsp;{2}</div>",
                            metaDataTemplate = "<div style='block;'>{0}&nbsp;&nbsp;{1}</div>";
                        // 和表格中的可用分区名一一对应，若没有，则展示原有分区名
                        // https://developer.huaweicloud.com/endpoint
                        var availabilityZone = aData['OS-EXT-AZ:availability_zone'];
                        var availabilityZoneName = "--" == statusEnumService.getStatus("AVAILABILITY_ZONE_NAME", availabilityZone) ? availabilityZone : statusEnumService.getStatus("AVAILABILITY_ZONE_NAME", availabilityZone);

                        _.each(_.values(aData["addresses"]["addresses"]), function(v, key, list) {
                            _.each(_.where(v, { "OS-EXT-IPS:type": "floating" }), function(value, key, list) {
                                !_.isUndefined(value["addr"]) &&(ip += appUtils.getString(ipTemplate,value.addr,
                                    appUtils.getString("site_cloudserver_publicip_label")
                                ));
                            });
                            _.each(_.where(v, { "OS-EXT-IPS:type": "fixed" }), function(value, key, list) {
                                !_.isUndefined(value["addr"]) &&(ip += appUtils.getString(ipTemplate,value.addr,
                                    appUtils.getString("site_cloudserver_privateip_label")
                                ));
                            });
                        });

                        $("td[tdtitle='" + appUtils.getString("site_cloudserver_az_label") + "']", nRow).html(availabilityZoneName);
                        $("td[tdtitle='" + appUtils.getString("common_term_type_label") + "']", nRow).html(serverType);
                        $("td[tdtitle='" + appUtils.getString("common_term_status_label") + "']", nRow).html(status);
                        $("td[tdtitle='" + appUtils.getString("common_term_ip_label") + "']", nRow).html(ip);
                        $("td[tdtitle='" + appUtils.getString("site_cloudserver_spec_label") + "']", nRow).html(appUtils.getString(flavorTemplate, aData.flavor.vcpus, aData.flavor.ram, aData.flavor.name)
                            + appUtils.getString(metaDataTemplate, aData.image.name, appUtils.getString("site_cloudserver_os_bit_label", aData.image.metaData.__os_bit)));
                    },
                    cellClickActive: function(e, param) {},
                    hoverActive: function(e, param) {},
                    drawCallback: function(oSetting) {
                        if (!oSetting.aoData.length) return;
                    }
                }
            };

            $scope.$on("$destroy", function() {
                autoRefreshTimer && $timeout.cancel(autoRefreshTimer);
            });

            _queryCloudServers();
        }
    ]

    var module = angular.module('recoverydirector.site.config');
    module.tinyController('site.cloudserver.ctrl', ctrl);
    return module;
})