define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$compile",
        "$stateParams",
        "message",
        "utilService",
        "mask",
        "appUtils",
        "constsService",
        "restService",
        function($scope, $state, $compile, $stateParams, message, utilService, mask, appUtils, constsService, restService) {
            var data = $("#" + constsService.ADD_OPENSTACK_REGION_WIN.winId).widget().option("data");
            $scope.addRegionTips = appUtils.getString("common_term_openstack_add_region_desc");
            $scope.model = {
                labels: "Region:",
                id: "regionInput",
                width:constsService.W3,
                validate:"required",
                regionAdd: function(){
                    if (!UnifyValid.FormValid($("#addRegionDiv"), {focusInvalid: true})) {
                        return;
                    }
                    var regionValue = $("#regionInput").widget().getValue();
                    var currentData = $("#regionTable").widget().option('data');
                    currentData.push({regionName:regionValue});
                    $("#regionTable").widget().option('data',currentData);
                    $scope.$apply();
                }
            };
            $scope.regionTable = {
                id: "regionTable",
                data:data.regionValue,
                columns: [{
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "regionName",
                    "sWidth":"60%"
                },{
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "sWidth":"28%",
                    "bSortable":false
                }],
                renderRow: function(nRow, aData, iDataIndex){
                    var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='delete()'>" + appUtils.getString("common_term_delete_button") + "</a> ";
                    var optLink = $compile($(optColumn));
                    var optScope = $scope.$new();
                    optScope.data = aData;
                    optScope.delete = function() {

                        $("#regionTable").widget().deleteTableRow(nRow);
                    };
                    var optNode = optLink(optScope);
                    $("td:eq(1)", nRow).html(optNode);
                }
            };

        }
    ]
    var module = angular.module("recoverydirector.site.config");
    module.tinyController("openstack.region.addCtrl", ctrl);
    return module;
})
