define(["tiny-common/UnifyValid", "tiny-widgets/Window"], function(UnifyValid, Window) {
    "use strict";
    var ctrl = [
        "$scope",
        "$state",
        "$stateParams",
        "exception",
        "message",
        "communicationService",
        "utilService",
        "mask",
        "constsService", "appUtils", "cookieService",
        function($scope, $state, $stateParams, exception, message,
            communicationService, utilService, mask, constsService, appUtils, cookieService) {

            var winObj = $("#" + constsService.CREATE_RESOURCE_POOL_WIN.winId).widget(),
                data = winObj.option("data"),
                createHandler = function(callback) {

                    if (!UnifyValid.FormValid($("#" + constsService.CREATE_RESOURCE_POOL_WIN.verifyId), {focusInvalid: true})) {
                        return;
                    }

                    var postObj = {
                        name: $("#pool_name").widget().getValue(),
                        type: 1,
                        description: $("#pool_description").widget().getValue(),
                        resourceList: []
                    };

                    postObj.resourceList = selectedVms;
                    if (_.isEmpty(postObj.resourceList)) {
                        message.error(appUtils.getString("common_term_select_data_least_label"));
                        return;
                    }
                    postObj.resourceList = _.map(postObj.resourceList, function(d) {
                        return {
                            uuid: d.uuid
                        }
                    });

                    mask.show();
                    communicationService.post(utilService.getResouceUrl("/storagepool"), postObj).promise().always(function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"),
                                ok: function() {
                                    callback(postObj);
                                }
                            });
                        }

                    });
                },
                modifyHandler = function(callBack) {

                    var basicPostObj = {
                            name: $("#pool_name").widget().getValue(),
                            description: $("#pool_description").widget().getValue()
                        },
                        resourceList = selectedVms,
                        resourceList = _.pluck(resourceList, "uuid"),
                        dataResourceList = _.pluck(data.resourceList, "uuid"),
                        deleteResourceLun = _.difference(dataResourceList, resourceList),
                        addResourceLun = _.difference(resourceList, dataResourceList),
                        isModifyBasicInfo = basicPostObj.name != data.name || basicPostObj.description != data.description,
                        requestCount = +isModifyBasicInfo + +!_.isEmpty(deleteResourceLun) + +!_.isEmpty(addResourceLun);

                    if (requestCount === 0) {
                        $("#" + constsService.CREATE_RESOURCE_POOL_WIN.winId).widget().destroy();
                        return;
                    }

                    if (deleteResourceLun.length) {
                        message.warn([appUtils.getString("site_resourcePool_task_removeResource_warm_msg1",data.name),
                            appUtils.getString("site_resourcePool_task_removeResource_warm_msg2"),
                            appUtils.getString("site_resourcePool_task_removeResource_warm_msg3")
                        ].join("<br/>")).then(function() {
                            if (requestCount !== 1) {
                                batchDialog();
                                $scope.batchResult = [];
                            } else {
                                mask.show();
                            }
                            $.when(isModifyBasicInfo && (modifyResourcePool(basicPostObj, "", appUtils.getStringWithColon("site_resourcePool_task_modify_result_message"))),
                                0 !== deleteResourceLun.length && (modifyResourcePool(deleteResourceLun, "/action/removeResources", appUtils.getStringWithColon("site_resourcePool_task_removeFromPool_result_message"))),
                                0 !== addResourceLun.length && (modifyResourcePool(addResourceLun, "/action/addResources", appUtils.getStringWithColon("site_resourcePool_task_addToPool_result_message")))
                            ).then(function(result) {
                                if (requestCount == 1) {
                                    var results = [];
                                    _.each(Array.prototype.slice.call(arguments), function(d) {
                                        d && (this.push(d));
                                    }, results)

                                    if (results.length === 0) {
                                        return;
                                    }
                                    mask.hide();
                                    if (exception.check(results[0])) {
                                        message.success({
                                            content: appUtils.getString("common_term_operation_success_label"),
                                            ok: function() {
                                                callBack();
                                            }
                                        });
                                    }
                                    return;
                                }
                                $("#batchResultWin").widget().option("buttons", [{
                                    key: "btnOK",
                                    label: appUtils.getString('common_term_confirm_button'),
                                    focused: true,
                                    handler: function(event) {
                                        callBack();
                                        $("#batchResultWin").widget().destroy();
                                    }
                                }]);
                                $("#batchResultWin .tiny-btn-basic").removeClass("tiny-btn-disable");
                            }).pipe(null, null, function() {
                                //when each notify
                                if (requestCount == 1) {
                                    return null;
                                }

                                var resultHtmls = [];
                                _.each(Array.prototype.slice.call(arguments), function(result) {
                                    if (!result) {
                                        return;
                                    }

                                    var isOk = exception.check(result, false),
                                        resultMessage = appUtils.getString("common_term_operation_success_label");

                                    if (isOk !== true) {
                                        resultMessage = $.encoder.encodeForHTML(isOk);
                                        isOk = false;
                                    }

                                    var imgClass = isOk === true ? "icon-success" : "icon-failed";
                                    resultMessage = result.optMessage + resultMessage
                                    resultMessage = '<span style="margin-right:5px;width:16px;height:16px;float:left;" class=' + imgClass + '></span>' + resultMessage;
                                    resultMessage = "<div class='description'>" + resultMessage + "</div>";
                                    this.push(resultMessage);

                                }, resultHtmls)

                                return resultHtmls.join("");
                            }).progress(function(result) {
                                !_.isEmpty(result) && ($("#batchResult").html(result))
                            });
                        })
                        return;
                    }

                    if (requestCount !== 1) {
                        batchDialog();
                        $scope.batchResult = [];
                    } else {
                        mask.show();
                    }

                    $.when(isModifyBasicInfo && (modifyResourcePool(basicPostObj, "", appUtils.getStringWithColon("site_resourcePool_task_modify_result_message"))),
                        0 !== deleteResourceLun.length && (modifyResourcePool(deleteResourceLun, "/action/removeResources", appUtils.getStringWithColon("site_resourcePool_task_removeFromPool_result_message"))),
                        0 !== addResourceLun.length && (modifyResourcePool(addResourceLun, "/action/addResources", appUtils.getStringWithColon("site_resourcePool_task_addToPool_result_message")))
                    ).then(function(result) {
                        if (requestCount == 1) {
                            var results = [];
                            _.each(Array.prototype.slice.call(arguments), function(d) {
                                d && (this.push(d));
                            }, results)

                            if (results.length === 0) {
                                return;
                            }
                            mask.hide();
                            if (exception.check(results[0])) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        callBack();
                                    }
                                });
                            }
                            return;
                        }
                        $("#batchResultWin").widget().option("buttons", [{
                            key: "btnOK",
                            label: appUtils.getString('common_term_confirm_button'),
                            focused: true,
                            handler: function(event) {
                                callBack();
                                $("#batchResultWin").widget().destroy();
                            }
                        }]);
                        $("#batchResultWin .tiny-btn-basic").removeClass("tiny-btn-disable");
                    }).pipe(null, null, function() {
                        //when each notify
                        if (requestCount == 1) {
                            return null;
                        }

                        var resultHtmls = [];
                        _.each(Array.prototype.slice.call(arguments), function(result) {
                            if (!result) {
                                return;
                            }

                            var isOk = exception.check(result, false),
                                resultMessage = appUtils.getString("common_term_operation_success_label");

                            if (isOk !== true) {
                                resultMessage = $.encoder.encodeForHTML(isOk);
                                isOk = false;
                            }

                            var imgClass = isOk === true ? "icon-success" : "icon-failed";
                            resultMessage = result.optMessage + resultMessage
                            resultMessage = '<span style="margin-right:5px;width:16px;height:16px;float:left;" class=' + imgClass + '></span>' + resultMessage;
                            resultMessage = "<div class='description'>" + resultMessage + "</div>";
                            this.push(resultMessage);

                        }, resultHtmls)

                        return resultHtmls.join("");
                    }).progress(function(result) {
                        !_.isEmpty(result) && ($("#batchResult").html(result))
                    });

                    function modifyResourcePool(param, endUrl, optMessage) {
                        var defer = $.Deferred();
                        communicationService.put(utilService.getResouceUrl("/storagepool/" + data.uuid + endUrl), param).promise().always(function(result) {
                            result.optMessage = optMessage;
                            defer.notify(result);
                            defer.resolve(result);
                        });

                        return defer.promise();
                    }


                    function batchDialog() {
                        var options = {
                            winId: "batchResultWin",
                            title: appUtils.getString("current_alarm_term_win_batch_result_title"),
                            height: "280",
                            width: "500px",
                            content: "<div class='ui-dialog-content ui-widget-content' style='display: block; width: auto; min-height: 0px; max-height: none; height: auto;'> <div class='tiny-dialog-pic' style='margin-top:5px;'> <div class='tiny-img-confirm'></div> </div> <div style='width: 415px; overflow-y: auto; max-height: inherit; margin-top: 10px;' class='tiny-dialog-content tinyMessageBox_msgBoxContent'>" + appUtils.getStringWithColon("site_resourcePool_task_edit_result_des_message") + "</div> <div id = 'batchResult' class='tiny-dialog-detail tinyMessageBox_msgBoxContent' style='overflow-y: auto; max-height: inherit;'> </div> </div>",
                            resizable: true,
                            buttons: [{
                                key: "btnOK",
                                label: appUtils.getString('common_term_confirm_button'),
                                focused: false,
                                handler: function(event) {}
                            }]
                        }

                        var win = new Window(options);
                        win.show();
                        $("#batchResultWin .tiny-btn-basic").addClass("tiny-btn-disable");
                    }

                };

            $scope.resourcePool = {
                desc: appUtils.getString("site_resourcePool_task_create_des_label"),
                name: {
                    id: "pool_name",
                    text: appUtils.getStringWithColon("common_term_name_label"),
                    value: data.name,
                    width: constsService.W4,
                    validate: constsService.VALID.NAME_REQUIRED
                },
                poolType: {
                    text: appUtils.getString("site_term_usage_label"),
                    values: [{
                        "selectId": "0",
                        "label": appUtils.getString("site_resourcePool_task_para_usage_value_cloneResourcePool_value"),
                        "checked": true
                    }],
                    width: constsService.W4
                },
                description: {
                    id: "pool_description",
                    text: appUtils.getStringWithColon("common_term_description_label"),
                    value: data.description,
                    height: constsService.DESCR_HEIGHT,
                    width: constsService.W4,
                    type: "multi",
                    validate: constsService.VALID.DES_REMARK
                }
            };

            //---------------------------------------------------------------------------------
            //两个表格copy  vrg下的添加vm 代码。
            var resourceList = angular.copy(data.resourceList);
            var avaliableTableFixer = appUtils.tableFixer("avaliableVmsTable", "uuid");
            var selectedTabelFixer = appUtils.tableFixer("selectedVmsTable", "uuid");

            var selectedVms = !_.isEmpty(resourceList) ? resourceList : [];
            var avaliableVms = [];

            var selectedVmsQuery = "";
            var avaliableVmsQuery = "";

            var filterName = "name";
            var filterValue = "";
            var extFilter = {
                filterName: filterName,
                filterValue: filterValue
            };

            $scope.text = {
                avaliableVms: appUtils.getString("site_term_availabelResourceLUN_label"),
                selectedVms: appUtils.getString("selected_term_resourceLUN_label")
            };
            $scope.start = constsService.start;
            $scope.pageSize = constsService.pageSize;
            $scope.orderBy = constsService.orderBy;
            $scope.orderType = constsService.orderType;
            $scope.Consts = constsService;

            $scope.model = {
                dualSelectBox: {
                    "id": "dualSelectBox",
                    "left-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftContent.html",
                        "content-type": "url"
                    }],
                    "right-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightContent.html",
                        "content-type": "url",
                        "add": {
                            id: "addBtn",
                            click: function() {
                                var checkedItems = avaliableTableFixer.getSelectedRow();

                                appUtils.union(selectedVms, checkedItems, "uuid");


                                _updateSelectedVms("selectedVms", "", selectedVms);
                                updateDisableRow();
                            }
                        },
                        "remove": {
                            id: "removeBtn",
                            click: function() {
                                var removeItems = selectedTabelFixer.getSelectedRow(),
                                    addItem = [];

                                _.each(removeItems, function(d) {

                                    if (null == _.findWhere($scope.model.avaliableVms.data, {
                                            uuid: d.uuid
                                        })) {
                                        addItem.push(d);
                                    }
                                })

                                if (addItem.length) {

                                    $scope.model.avaliableVms.data = $scope.model.avaliableVms.dataBack = $scope.model.avaliableVms.data.concat(addItem);
                                    $scope.model.avaliableVms.totalRecords = $scope.model.avaliableVms.data.length;
                                    $("#avaliableVmsTable").widget().option("data", $scope.model.avaliableVms.data);
                                    $scope.model.avaliableVms.enablePagination = $scope.model.avaliableVms.totalRecords > constsService.TABLE_COUNT_PER_PAGE
                                    $scope.$apply();
                                }

                                appUtils.removeFromArray(selectedVms, removeItems, "uuid");

                                selectedTabelFixer.remove(removeItems, "uuid");
                                avaliableTableFixer.remove(removeItems, "uuid");

                                _updateSelectedVms("selectedVms", "", selectedVms);
                                updateDisableRow();
                                avaliableTableFixer.selectRow();
                            }
                        }
                    }],
                    "setting": {
                        "left-width": "350px",
                        "height": "400px",
                        "right-width": "410px"
                    }
                },

                avaliableVms: {
                    id: "avaliableVmsTable",
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    tableFixer: avaliableTableFixer,
                    data: [],
                    currPage: 0,
                    checkbox: true,
                    columns: [{
                        "bVisible": false,
                        "mData": "uuid"
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site_term_capacity_label"),
                        "mData": "capacity",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_belongedController_column"),
                        "mData": "controllerId",
                        "bSortable": false
                    }],
                    tHeadCheckboxFn: function() {
                        avaliableTableFixer.click();
                    },
                    click: function(event, cell) {
                        updateDisableRow();
                        avaliableTableFixer.click();
                    },
                    callback: function(oPage) {
                        $scope.model.avaliableVms.currPage = oPage.currentPage - 1;
                        updateDisableRow();
                        avaliableTableFixer.click();
                    },
                    sortCallback: function(nNode, sortArr) {
                        updateDisableRow();
                        avaliableTableFixer.click();
                    },
                    drawCallback: function() {
                        avaliableTableFixer.selectRow();
                        updateDisableRow();
                    }
                },

                selectedVms: {
                    id: "selectedVmsTable",
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    tableFixer: selectedTabelFixer,
                    data: [],
                    checkbox: true,
                    columns: [{
                        "bVisible": false,
                        "mData": "uuid"
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("site_term_capacity_label"),
                        "mData": "capacity",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_belongedController_column"),
                        "mData": "controllerId",
                        "bSortable": false
                    }],
                    tHeadCheckboxFn: function() {
                        selectedTabelFixer.click();
                    },
                    click: function(event, cell) {
                        selectedTabelFixer.click();
                    },
                    drawCallback: function() {
                        selectedTabelFixer.selectRow();
                    }
                },

                leftSearchSelect: {
                    id: "leftSearchSelect",
                    isHide: true,
                    values: []
                },

                rightSearchSelect: {
                    id: "rightSearchSelect",
                    isHide: true,
                    values: []
                },

                leftSearch: {
                    id: "leftSearchBox",
                    searchFn: function(query) {
                        avaliableVmsQuery = $.trim(query);
                        _updateSelectedVms("avaliableVms", avaliableVmsQuery, $scope.model.avaliableVms.dataBack);
                    }
                },

                rightSearch: {
                    id: "rightSearchBox",
                    searchFn: function(query) {
                        selectedVmsQuery = $.trim(query);
                        _updateSelectedVms("selectedVms", selectedVmsQuery, selectedVms);
                    }
                }
            };

            function updateAvaliableVms() {
                filterName = "name";
                filterValue = avaliableVmsQuery;
                pageQuery();
            }


            var _updateSelectedVms = function(tableId, query, data) {

                data = angular.copy(data);


                if (query != "" && angular.isArray(data)) {
                    var key = "name";
                    var delCnt = 0;
                    query = $.trim(query);
                    query = query.toLowerCase();
                    for (var i = 0, len = data.length; i < len; i++) {
                        var item = data[i - delCnt];
                        var nameLC = item.name.toLowerCase();

                        if (nameLC.indexOf(query) == -1) {
                            data.splice(i - delCnt++, 1);
                        }
                    }
                }

                var table = $scope.model[tableId];
                table.totalRecords = data.length;
                table.data = data;
                table.enablePagination = data.length > table.displayLength;
                if (table.enablePagination == false) {
                    table.curPage = {
                        "pageIndex": 1
                    };
                }
                $scope.$apply();
            }


            function updateDisableRow() {
                var tbWidget = $("#avaliableVmsTable").widget();
                if (!tbWidget) return;

                var pageIndex = $scope.model.avaliableVms.currPage,
                    start = pageIndex * constsService.TABLE_COUNT_PER_PAGE,
                    end = (pageIndex + 1) * constsService.TABLE_COUNT_PER_PAGE,
                    tbData = tbWidget.getTableData().slice(start, end),
                    selectedData = appUtils.intersection(selectedVms, tbData, "uuid");

                appUtils.enableAllRow("avaliableVmsTable", tbData.length);
                selectedData.forEach(function(item) {
                    tbWidget.setSelectedRow("uuid", item["uuid"]);
                    var index = appUtils.getIndexFromArray(tbData, "uuid", item["uuid"]);
                    appUtils.disableRow("avaliableVmsTable", index);
                });
            }



            function pageQuery() {
                var params = {
                        "deviceSn": data.deviceSn,
                        "resourceType": 1,
                        "orderType": $scope.orderType,
                        "pageSize": $scope.pageSize,
                        "orderBy": $scope.orderBy,
                        "startPage": $scope.start,
                        "extFilter.filterName": filterName,
                        "extFilter.filterValue": filterValue
                    },
                    url = appUtils.fillUrl("/storagepool/action/getAvailableStorageResources", params);
                mask.show();
                communicationService.get(url).promise().always(_updateUI);
            }

            function _updateUI(result) {
                mask.hide();
                if (exception.check(result)) {
                    var filterUuids = data.filterUuids;
                    !_.isEmpty(resourceList) && (result = resourceList.concat(result))
                    var result = {
                        records: result,
                        totalCount: result.length
                    };
                    var arr = [];
                    appUtils.encodeForHTML(result);
                    _.each(result.records, function(d) {
                        d.capacity = d.displayTotalCapacity;
                        arr.push(d);
                    });

                    !_.isEmpty(filterUuids) && (arr = _.filter(arr, function(d) {
                        return filterUuids.indexOf(d.uuid) == -1
                    }));

                    $scope.model.avaliableVms.data = arr;
                    $scope.model.avaliableVms.dataBack = arr;
                    $scope.model.avaliableVms.totalRecords = arr.length;
                    $scope.model.avaliableVms.enablePagination = $scope.model.avaliableVms.totalRecords > constsService.TABLE_COUNT_PER_PAGE
                    $scope.ngShow = $scope.model.avaliableVms.totalRecords != 0
                    avaliableVms = arr;
                    $scope.$apply();

                    if (_.isEmpty(resourceList)) {
                        return;
                    };

                    _updateSelectedVms("selectedVms", "", selectedVms);
                    updateDisableRow();

                }
            };
            //---------------------------------------------------------------------------------
            /**
             * init
             * @param  {[string]} uuid [id]
             * @return {[undefined]}      [undefined]
             */
            var _init = function(uuid) {

                var params = {
                        uuid: uuid,
                        resourceType: 1,
                        orderBy: "name",
                        orderType: "asc",
                        pageSize: 1024,
                        startpage: 0
                    },
                    url = appUtils.fillUrl("/storagepool/{uuid}/storageresources", params);
                mask.show();
                communicationService.get(url).promise().always(function(result) {
                    mask.hide();
                    if (!exception.check(result)) {
                        return;
                    }
                    _.each(result.records, function(d) {
                        d.capacity = d.displayTotalCapacity;
                    });

                    data.resourceList = result.records;
                    selectedVms = angular.copy(data.resourceList);
                    _updateSelectedVms("selectedVms", "", selectedVms);
                    pageQuery();
                });
            }

            data.uuid && (_init(data.uuid));
            !data.uuid && (pageQuery());

            winObj.options.changeOkHandler(data.uuid ? modifyHandler : createHandler)

            /**
             * 设置边框，
             * @param  {[type]} ) {                           var leftBox [description]
             * @param  {[type]} 0 [description]
             * @return {[type]}   [description]
             */
            setTimeout(function() {
                var leftBox = $("div.tiny-dualSelectBox-left-content");
                $("div.tiny-dualSelectBox-right-content div.tiny-dualSelectBox-content-div").height(leftBox.height()).css({
                    "border": "1px solid #d3d3d3",
                    "border-top": "0px solid #d3d3d3"
                });
                $("div.tiny-dualSelectBox-content-div").css("display", "inline-block");
            }, 0);
        }

    ];

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("storage.pool.create.ctrl", ctrl);
    return module;
});
