define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function(UnifyValid, Window) {
        // "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            "infoTransferredService",
            function($scope, $state, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model, infoTransferredService) {
                var currentSite = infoTransferredService.get("site", "currentSite");
                if (!currentSite) {
                    return;
                }
                $scope.regionArray = [];
                $scope.openstackDesc = appUtils.getString("common_term_openstack_add_desc");
                $scope.storageInstructions = appUtils.getString("common_term_addStorageInstructions_label");
                $scope.fmInstructions = appUtils.getString("common_term_addfmInstructions_label");
                $scope.fcInstructions = appUtils.getString("common_term_addfcInstructions_label");
                var type = $stateParams.type,
                    isHome = type.indexOf("home") !== -1,
                    type = type.replace("home", ""),
                    isStorage = type === "storage",
                    isFmAndFc = (type === "fc" || type === "fm"),
                    isOpenStack = type === "openStack",
                    isFusionManager = type === "fm",
                    isFusionCompute = type === "fc",
                    router = {
                        "storage": {
                            port : "8088",
                            type: constsService.RESOURCE_MAINTYPE_ENUM["storage"],
                            state: "site.home",
                            title: appUtils.getString("res_term_storage_title"),
                            desc: "",
                            userNameMessage :appUtils.getString("resource_addstoragePlatform_para_userName_info_tip"),
                            portMessage : appUtils.getString("site_storage_task_add_para_Port_des_tip"),
                            validate : {
                                username : constsService.VALID.AUTH_NAME,
                                password : constsService.VALID.AUTH_PWD
                            }
                        },
                        "fc": {
                            port : "7443",
                            type: constsService.RESOURCE_MAINTYPE_ENUM["fc"],
                            state: isHome ? "site.home" : "site.cloud.vmList",
                            title: appUtils.getString("site_term_addFusionCompute_title"),
                            desc : "",
                            portMessage : "",
                            userNameMessage : appUtils.getString("resource_cloudPlatform_task_addcloudPlatform_para_userName_info_tip"),
                            validate : {
                                username : constsService.VALID.AUTH_NAME,
                                password : constsService.VALID.AUTH_PWD
                            }
                        },
                        "fm": {
                            port : "8195",
                            type: constsService.RESOURCE_MAINTYPE_ENUM["fm"],
                            state: isHome ? "site.home" : "site.cloud.vmList",
                            title: appUtils.getString("site_term_addFusionManager_title"),
                            desc : "",
                            portMessage : "",
                            userNameMessage : appUtils.getString("resource_cloudPlatform_task_addcloudPlatform_para_userName_info_tip"),
                            validate : {
                                username : constsService.VALID.AUTH_NAME,
                                password : constsService.VALID.AUTH_PWD
                            }
                        },
                        "vCenter": {
                            port : "443",
                            type: constsService.RESOURCE_MAINTYPE_ENUM["vCenter"],
                            state: isHome ? "site.home" : "site.vmware.vmList",
                            title: appUtils.getString("site_term_addvcenter_title"),
                            validate : {
                                username : [{validFn:"required"},{validFn:"maxSize", params:[255], errorDetail:appUtils.getString("validate_term_common_length_range_1_255_msg")}],
                                password : constsService.VALID.AUTH_PWD_64
                            },
                            desc : "",
                            portMessage : "",
                            userNameMessage : ""
                        },
                        "openStack": {
                            port : "443",
                            type: constsService.RESOURCE_MAINTYPE_ENUM["openStack"],
                            state: isHome ? "site.home" : "site.cloud.vmList",
                            title: appUtils.getString("site_term_addOpenstack_title"),
                            validate : {
                                username : [{validFn:"required"},{validFn:"maxSize", params:[255], errorDetail:appUtils.getString("validate_term_common_length_range_1_255_msg")}],
                                password : constsService.VALID.AUTH_PWD_64
                            },
                            desc : "",
                            portMessage : appUtils.getString("openStack_port_info"),
                            domainMessage: appUtils.getString("openStack_domainMessage_info"),
                            userNameMessage : ""
                        }
                    },
                    paramObj = router[type],
                    tempRowComponent = (function() {
                        var components = {
                                ip: {
                                    id: "ip",
                                    name: "ip",
                                    require: true,
                                    display: !isOpenStack,
                                    width: constsService.W2,
                                    value: "",
                                    extendFunction: ["checkIP"],
                                    validate: "checkIP : extend function;",
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    }
                                },
                                https:{
                                    id:"https",
                                    name: "https",
                                    require: true,
                                    width: constsService.W2,
                                    value: "",
                                    extendFunction: ["checkHttps"],
                                    validate: "checkHttps : extend function;",
                                    display: isOpenStack,
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    },
                                    message: appUtils.getString("common_term_openStackKeyStone_tip")
                                },
                                domainType:{
                                    id: "authType",
                                    name: "authType",
                                    require: true,
                                    display: isOpenStack,
                                    values: [{
                                        "selectId" : "KeyStone",
                                        "label": "KeyStone"
                                    },{
                                        "selectId" : "IAM",
                                        "label": "IAM"
                                    }],
                                    width: 100,
                                    defaultSelectid: "KeyStone",
                                    val :function(){
                                        return $("#"+this.id).widget().getSelectedId()
                                    }
                                },
                                version:{
                                    id: "version",
                                    name: "version",
                                    require: true,
                                    display: isOpenStack,
                                    values: [{
                                        "selectId" : "6.0",
                                        "label": "6.0"
                                    },{
                                        "selectId" : "6.1",
                                        "label": "6.1"
                                    }],
                                    width: 70,
                                    defaultSelectid: "6.0",
                                    val :function(){
                                        return $("#"+this.id).widget().getSelectedId()
                                    }
                                },
                                port: {
                                    boxValues : [{"selectId" : "0", "label" : appUtils.getString("site_storage_task_add_para_defaultPort_listbox"),"checked" : true},
                                                  {"selectId" : "1", "label" : appUtils.getString("site_storage_task_add_para_customPort_listbox"), "checked" : false}],
                                    boxChange : function(){
                                        this.disable = !this.disable;
                                        var boxDom = $("#" + this.boxId).widget(), portWidget=$("#" + this.id).widget();
                                        if (this.disable) {
                                            portWidget.option("max", null);
                                            portWidget.option("min", null);
                                            portWidget.option("value", "");
                                            boxDom.opChecked('0');
                                        } else {
                                            boxDom.opChecked('1');
                                            portWidget.option("value", paramObj.port);
                                            portWidget.option("max", "65535");
                                            portWidget.option("min", "1");
                                        }
                                    },
                                    display: true,
                                    message : paramObj.portMessage,
                                    boxId: "boxId",
                                    id: "port",
                                    name: "port",
                                    require: true,
                                    width: isOpenStack ? constsService.W1 : constsService.W1 + 50,
                                    value: isStorage ? undefined : paramObj.port,
                                    min: isStorage ? undefined : "1",
                                    max: isStorage ? undefined : "65535",
                                    disable : isStorage,
                                    change: function() {
                                        var v = $("#" + this.id).widget().options.value;
                                        if (!/^\d+$/.test(v)) {
                                            $("#" + this.id).widget().option("value", paramObj.port);
                                        }
                                    },
                                    validate: [{
                                        validFn: "required"
                                    }, {
                                        validFn: "rangeValue",
                                        params: [1, 65535],
                                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
                                    }, {
                                        validFn: "integer"
                                    }],
                                    val: function(val) {
                                        var param = ["value"],
                                            dom = $("#" + this.id).widget();
                                        if (!_.isUndefined(val)) {
                                            if (_.isNumber(val)) {
                                                param.push(val);
                                            } else {
                                                param.push(9443);
                                            }
                                        }else if(this.disable)
                                        {
                                            return "";
                                        }

                                        return this.value = dom.option.apply(dom, param);
                                    },
                                    message: isFmAndFc ? appUtils.getString("common_term_addfcAndFm_tip") : appUtils.getString("common_term_vcenterPort_tip")
                                },
                                password: {
                                    id: "password",
                                    name: "password",
                                    require: true,
                                    display: true,
                                    width: constsService.W2,
                                    type: "password",
                                    value: "",
                                    validate: paramObj.validate.password,
                                    val: function(val) {
                                        var dom = $("#" + this.id).widget();
                                        !_.isUndefined(val) && (dom.option("value", val));

                                        return this.value = dom.getValue();
                                    }
                                },
                                username: {
                                    id: "username",
                                    name: type === "storage" ? "name" : "username",
                                    require: true,
                                    width: constsService.W2,
                                    value: "",
                                    display: true,
                                    message : paramObj.userNameMessage,
                                    validate: paramObj.validate.username,
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    }
                                },
                                domain: {
                                    id: "domain",
                                    name: "domain",
                                    require: true,
                                    width: constsService.W2,
                                    value: "Default",
                                    display: isOpenStack,
                                    message : paramObj.domainMessage,
                                    validate: constsService.VALID.Trap_NAME,
                                    val: function(val) {
                                        return this.value = $("#" + this.id).widget().getValue();
                                    }
                                },
                                region: {
                                    id: "discoveryregions",
                                    name:"discoveryregions",
                                    require: false,
                                    addMessage: appUtils.getString("common_term_openstack_add_region_title"),
                                    modifyMessage:appUtils.getString("common_term_edit_button"),
                                    regionArray: [],
                                    regionAdd: "",
                                    display: isOpenStack,
                                    addRegion: function(){
                                        var that = this;
                                        var win = angular.copy(constsService.ADD_OPENSTACK_REGION_WIN);
                                        win.data = {
                                            regionValue: that.regionArray
                                        };
                                        appUtils.showWindow(win,function(){
                                            var regionString = "";
                                            that.regionArray = $("#regionTable").widget().option("data");
                                            _.each(that.regionArray,function(val){
                                                regionString += val.regionName +","
                                            });
                                            regionString = regionString.replace(/,$/,"");
                                            that.regionAdd = regionString;
                                            $scope.$apply();
                                            $("#"+win.winId).widget().destroy();
                                        });
                                    },
                                    val: function(){
                                        var that = this;
                                        var regionParam = [];
                                        _.each(that.regionArray,function(val){
                                            regionParam.push(val.regionName);
                                        })
                                        regionParam = JSON.stringify(regionParam);
                                        return regionParam;
                                    },
                                    message: appUtils.getString("common_term_openStackRegion_tip"),
                                    messagePosition: "right"
                                }
                            },
                            val = function(val) {
                                //统一的val方法实现
                            },
                            opt = {
                                removeRow: function() {
                                    var components = $scope.discovery.components,
                                        index = components.indexOf(this);

                                    (index != -1 && index != 0) && (components.splice(index, 1));
                                },
                                title: appUtils.getString("common_term_delete_button")
                            };

                        _.extend(components, opt);
                        return components;
                    }());

                $scope.discovery = {
                    isStorage : isStorage,
                    isFmAndFc : isFmAndFc,
                    isOpenStack: isOpenStack,
                    isFusionManager: isFusionManager,
                    isFusionCompute: isFusionCompute,
                    labels: {
                        title: paramObj.title,
                        ip: appUtils.getString("recovery.term.recovery.unusedHost.colum.ip.title"),
                        https:appUtils.getString("openStack_httpsMessage_label"),
                        port: appUtils.getString("ism.sys.user.port.lable"),
                        domain: appUtils.getString("common_term_domain_label"),
                        username: appUtils.getString("common_term_username_label"),
                        password: appUtils.getString("common_term_password_label"),
                        region: "Region",
                        domainType: appUtils.getString("recovery.term.colum.type.title"),
                        version: appUtils.getString("common_term_version_label")
                    },
                    desc: paramObj.desc,
                    sameVerifyInfo: {
                        id: "checkboxVerify",
                        require: false,
                        text: appUtils.getString("res_term_discovrycheck_label")
                    },
                    components: [angular.copy(tempRowComponent)],
                    add: {
                        text: appUtils.getString("common_term_addline_button"),
                        click: function() {
                            var boxSelectedId,
                                checked = $("#checkboxVerify").widget().options.checked,
                                components = $scope.discovery.components,
                                idEnd = _.isEmpty(components[components.length-1].ip.id.slice(2)) ? 1 : parseInt(components[components.length-1].ip.id.slice(2),10)+1,
                                addComponent = angular.copy(tempRowComponent);
                            if (checked) {
                                isStorage && (boxSelectedId = $('#boxId').widget().getSelectedId());
                                isStorage && (components[0].port.boxValues[0].checked = boxSelectedId == "0");
                                isStorage && (components[0].port.boxValues[1].checked = boxSelectedId == "1");
                                addComponent.port.value = components[0].port.val();
                                addComponent.port.disable = components[0].port.disable;
                                addComponent.port.value.length === 0 && !addComponent.port.disable && (addComponent.port.value = paramObj.port);
                                addComponent.port.boxValues = components[0].port.boxValues;

                                //storage port default null
                                !addComponent.port.disable && (addComponent.port.max = "65535",
                                addComponent.port.min = "1")

                                addComponent.username.value = components[0].username.val();
                                addComponent.password.value = components[0].password.val();
                            }

                            _.each(addComponent, function(v, k) {
                                !_.isUndefined(v.id) && (v.id += idEnd);
                                !_.isUndefined(v.boxId) && (v.boxId += idEnd);
                            });
                            components.push(addComponent);
                            $scope.$apply();
                        }
                    },
                    ok: {
                        id: "btnOk",
                        text: appUtils.getString("common_term_confirm_button"),
                        disable: false,
                        click: function() {
                            if (!UnifyValid.FormValid($("#storageDiscoveryContainer"), {focusInvalid: true})) {
                                return;
                            }

                            var datas = [];
                            _.each($scope.discovery.components, function(componentObj) {
                                var dataObj = {},
                                    paramMap = {};
                                _.each(componentObj, function(component) {
                                    if (!component.display) {
                                        return
                                    }

                                    var key = _.isEmpty(component.name) ? component.id : component.name,
                                        value = _.isFunction(component.val) ? component.val() : component.value;

                                    if (_.isEmpty(key) && _.isObject(value)) {
                                        _.extend(this, value);
                                        return;
                                    }
                                    this[key] = value;

                                }, paramMap);
                                dataObj.siteId = currentSite.siteId;

                                dataObj.ip = isOpenStack ? paramMap.https : paramMap.ip;
                                isOpenStack ? delete paramMap.https : delete paramMap.ip;
                                //add mainType and subType
                                _.extend(dataObj, paramObj.type);

                                !_.isEmpty(paramObj.type.paramMap) && (_.extend(paramMap,paramObj.type.paramMap));
                                dataObj.paramMap = paramMap;

                                this.push(dataObj);
                            }, datas)

                            $scope.discovery.ok.disable = true;
                            $scope.$apply();

                            mask.show();
                            communicationService.post(utilService.getResouceUrl("/resources/action/discoverResource"), datas).promise().always(function(response) {
                                mask.hide();

                                if (!exception.check(response)) {
                                    $scope.discovery.ok.disable = false;
                                    $scope.$apply();
                                    return;
                                }
                                if (0 === +response.failCount) {
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: function() {
                                            $state.go(paramObj.state, {
                                                siteId: currentSite.siteId
                                            });
                                        }
                                    });
                                    return;
                                }

                                _.each(response.result, function(detail) {
                                    var temp = detail.target;
                                    detail.targetName = temp;
                                    delete detail.target;
                                });

                                batchResult(response, function() {
                                    $state.go(paramObj.state, {
                                        siteId: currentSite.siteId
                                    });
                                });
                            });
                        }
                    },
                    cancel: {
                        id: "btnCancel",
                        text: appUtils.getString("common_term_cancel_button"),
                        click: function() {
                            $state.go(paramObj.state, {
                                siteId: currentSite.siteId,
                                randomId: Math.floor(Math.random() * 10000)
                            });
                        }
                    }
                }
                $scope.isOpenStack = isOpenStack;
                var batchResult = function(param, callback) {
                    var options = {
                        "winId": "alarmClearFailWin",
                        "title": appUtils.getString(constsService.ALARM_CLEAR_ERROR_TITLE),
                        "data": param,
                        "height": "550px",
                        "width": "500px",
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": constsService.COURRENT_BATCH_RESULT_URL,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": [{
                            key: "cancel",
                            focused: true,
                            label: appUtils.getString("common_term_close_button"),
                            handler: function(event) {
                                $("#alarmClearFailWin").widget().destroy();
                                (callback)();
                            }
                        }],
                        "close": function() {
                            (callback)();
                        }
                    };
                    var win = new Window(options);
                    win.show();
                }

                UnifyValid.checkHttps = function(){
                    var val = this[0].value;
                    var ipReg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                    var httpsReg = /^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$/;
                    if(_.isEmpty(val)){
                        return appUtils.getString("common_term_empty_label");
                    };
                    if (ipReg.test(val) || httpsReg.test(val) || appUtils.validIPv4OrIPv6Address(val)) {
                        return "";
                    }
                    if (!ipReg.test(val) && !httpsReg.test(val) && !appUtils.validIPv4OrIPv6Address(val)) {
                        return appUtils.getString("validate_term_https_erro");
                    }
		            return "";
                }

                UnifyValid.checkIP = function() {
                    var val = this[0].value;
                    if (_.isEmpty(val)) {
                        return appUtils.getString("common_term_empty_label");
                    };
                    if (!appUtils.validIPv4OrIPv6Address(val)) {
                        return appUtils.getString("validate_ipv4_ipv6_label");
                    }
                    return "";
                };

                $scope.$on('$destroy', function() {
                    delete UnifyValid.checkIP;
                    delete UnifyValid.checkHttps;
                });

		        // 监听回车事件
                $("#storageDiscoveryContainer").keypress(function(event) {
                    var curkey = event.which;
                    if (curkey == 13) {
                        !$scope.discovery.ok.disable && $scope.discovery.ok.click();
                        return false;
                    }
                });
            }
        ];

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.storage.discovery.ctrl', ctrler);
        return module;
    })
