define(["tiny-common/UnifyValid", "tiny-widgets/Window", "tiny-extra-lib/jquery.base64"],
    function(UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "infoTransferredService",
            function($scope, $state, $stateParams, $timeout, exception, message,
                communicationService, utilService, mask,
                constsService, appUtils, statusEnumService, infoTransferredService) {

                var refreshTimer, phase, PHASE_STATUS = {
                        "refresh": 0,
                        "timeout": 1
                    },currentSite = infoTransferredService.get("site", "currentSite"),
                    selectData = {};
                if (!currentSite) {
                    return;
                }

                $scope.optResAuthKey = $scope.$parent.site.resourceOptAuth;
                $scope.isRemoteSite = currentSite.siteType === 1;
                $scope.deviceType = "ism.drm.deviceType.drvsphere.mainType";
                $scope.getData = function() {
                    selectData.type = "vmware";
                    return selectData;
                };
                // cloud
                $scope.btnCloudCreate = {
                    id: "btnCloudCreate",
                    text: appUtils.getString("site_term_addvcenter_title"),
                    click: function() {
                        $state.go("site.discovery", {
                            siteId: currentSite.siteId,
                            type: "vCenter"
                        })
                    }
                };


                var opt = {
                        modify: {
                            id: "iconBtnEdit",
                            authKey : $scope.optResAuthKey,
                            template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                            clickActive: function() {
                                _editDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        },
                        delete: {
                            id: "iconBtnDel",
                            authKey : $scope.optResAuthKey,
                            template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                            clickActive: function() {
                                _deleteDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        },
                        refresh: {
                            id: "iconBtnDevRefresh",
                            authKey : $scope.optResAuthKey,
                            template: "<div class='iconbutton-pg-refresh' title='" + appUtils.getString("common_term_refresh_button") + "'></div>",
                            clickActive: function() {
                                _refreshDevAction();
                            },
                            hover: function(rowData) {
                                return currentSite.siteType === 0;
                            }
                        }
                    },
                    opt = appUtils.tableHoverWrapper(opt);

                $scope.refreshCloudPage = function() {
                    $scope.datasCloudTable.currPage = {
                        pageIndex: 1
                    };
                    $scope.datasCloudTable.queryData();
                };

                $scope.datasCloudTable = {
                    id: "datasCloudTable",
                    isDraggedRemember: false,
                    operateButtonCount: 3,
                    buttonContainerPosition: "right",
                    paginationStyle:"full_numbers",
                    columns: [{
                        "sTitle": appUtils.getString("common_term_status_column"),
                        "mData": "status"
                    }, {
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("common_term_ip_column"),
                        "mData": "ipAddress"
                    }],
                    callback: function(evtObj) {
                        $scope.datasCloudTable.currPage.pageIndex = evtObj.currentPage;
                        $scope.datasCloudTable.defaultSelectId = undefined;
                    },
                    renderRow: function(nRow, aData, iDataIndex) {
                        var status = $.trim(aData["status"]);
                        if (status == "0") {
                            $("td:eq(0)", nRow).html("<span class='icon-registered'>&nbsp;&nbsp;&nbsp;&nbsp;</span>" + appUtils.getString("common_term_status_normal_label"));
                        } else {
                            $("td:eq(0)", nRow).html("<span class='icon-unregistered'>&nbsp;&nbsp;&nbsp;&nbsp;</span>" + appUtils.getString("common_term_status_offline_label"));
                        }
                    },
                    enablePagination: false,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    data: [],
                    opAreaConfig: appUtils.flilterOperRight([opt.refresh, opt.modify, opt.delete]),
                    currPage: {
                        pageIndex: 1
                    },
                    defaultSelectId: undefined,
                    cellClickActive: function(e, param, isFind) {
                        $scope.datasCloudTable.defaultSelectId = param.deviceSn;
                        selectData = param;
                        currentSite.siteType === 0 && !isFind && ($scope.$broadcast(constsService.TOPIC.SITE_VRG_TAB, param));
                    },
                    hoverActive: function(e, param) {
                        opt.notify(param);
                    },
                    drawCallback: function(oSetting) {
                        var selectSn = $scope.datasCloudTable.defaultSelectId,
                            isFind = true;
                        if (!oSetting.aoData.length) return;

                        var currPageData = [],
                            aData;
                        _.each($scope.datasCloudTable.data, function(rowData) {
                            currPageData = currPageData.concat(rowData);
                            rowData.childResources && (currPageData = currPageData.concat(rowData.childResources));
                        })

                        !_.isEmpty(selectSn) && !_.isEmpty(currPageData) && _.isEmpty(aData = _.findWhere(currPageData, {
                            deviceSn: selectSn
                        })) && (isFind = false, aData = currPageData[0], selectSn = currPageData[0].deviceSn);

                        _.isEmpty(selectSn) && (isFind = false, aData = currPageData[0], selectSn = currPageData[0].deviceSn);
                        $('#datasCloudTable').widget().setSelectedRow('deviceSn', selectSn);
                        $scope.datasCloudTable.cellClickActive("defaultSelectRow", aData, isFind);
                    },
                    _updateCloudUI: function(result) {

                        if (exception.check(result)) {
                            _.each(result, function(obj) {
                                obj.deviceSn = obj.vCenterUuid;
                            });
                            $scope.datasCloudTable.data = appUtils.encodeForHTML(result);
                            $scope.datasCloudTable.enablePagination = result.length > $scope.datasCloudTable.displayLength;


                            var oldTableStatus = {
                                currPage: {
                                    pageIndex: $scope.datasCloudTable.currPage.pageIndex
                                },
                                defaultSelectId: $scope.datasCloudTable.defaultSelectId
                            };

                            _.extend($scope.datasCloudTable, oldTableStatus);
                            $scope.$apply();

                            $timeout.cancel(refreshTimer);
                            refreshTimer = $timeout(function() {
                                $scope.datasCloudTable.queryData(PHASE_STATUS.timeout);
                            }, 10000);
                        }
                    },
                    queryData: function(status) {
                        var url = "/vcenters/action/getRegisteredVCenter?siteId=" + currentSite.siteId;
                        url = utilService.getResouceUrl(url);

                        phase = PHASE_STATUS.refresh;
                        status && (phase = status);
                        phase !== PHASE_STATUS.timeout && (mask.show());


                        communicationService.get(url).promise().always(function(result) {

                            status !== PHASE_STATUS.timeout && (mask.hide());

                            $scope.datasCloudTable._updateCloudUI(result);
                        });

                    }
                };

                (currentSite.siteType === 0) && ($scope.plugins = [{
                    "openState": "site.vmware.vmList",
                    "id": "vmwareList",
                    "name": appUtils.getString("site.term.vmlist.tab")
                }]);

                var _deleteCloudAction = function() {
                    var url = "/sites/" + currentSite.siteId + "/action/unregisterRes?resType=ism.drm.deviceType.cloud.mainType";
                    var dbId = _getOpID();
                    var name = _getOpName();
                    var tmp = [];
                    tmp.push(dbId);
                    message.warn({
                        content: appUtils.getString("site_term_cloud_delete_message", $scope.currentSiteName, name),
                        ok: function() {
                            mask.show();
                            communicationService.put(utilService.getResouceUrl(url), tmp).promise().always(function(result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            _init()
                                        }
                                    });
                                }
                            })
                        }
                    });

                };


                var _getOpID = function() {
                    var opID = $scope.currentdeviceSn ? $scope.currentdeviceSn : null;
                    if (opID == null) {
                        opID = $("#datasCloudTable").widget().getHoverData()[0].deviceSn;
                    }
                    return opID;
                };

                var _getOpName = function() {
                    var name = $scope.currentName ? $scope.currentName : null;
                    if (name == null) {
                        name = $("#datasCloudTable").widget().getHoverData()[0].name;
                    }
                    return name;
                };

                var _editDevAction = function() {
                    var id = _getOpID();
                    var data = {};
                    communicationService.get(utilService.getResouceUrl("/resources/" + $.base64.encode(id))).promise().always(function(response) {
                        if (exception.check(response)) {
                            data.sn = response.sn;
                            if (Object.prototype.toString.call(response.moName) === "[object Null]") {
                                data.name = "null";
                            } else {
                                data.name = response.moName;
                            }
                            data.deviceType = $scope.deviceType;
                            data.isStorage = false;

                            var options = {
                                "winId": "modifyDevAliasWinId",
                                "helpId": "modifyvCenter",
                                "data": data,
                                "title": appUtils.getString("res_term_modifyalias_label"),
                                "width": constsService.WIN_SIZE.S3[0],
                                "height": "400px",
                                "content-type": "url",
                                "content": constsService.RES_AILES_EDIT_URL,
                                "minimizable": false,
                                "maximizable": false,
                                "buttons": [{
                                    key: "ok",
                                    label: appUtils.getString('common_term_confirm_button'),
                                    focused: true,
                                    handler: function(event) {

                                        if (!UnifyValid.FormValid($("#protocalForm"), {focusInvalid: true})) {
                                            return;
                                        }

                                        var param = {};
                                        var id = $("#modifyDevAliasWinId").widget().option("data").sn;
                                        param.moName = $.trim($("#name").widget().getValue());
                                        param.deviceType = $scope.deviceType;
                                        var url = utilService.getResouceUrl("/resources/" + $.base64.encode(id));
                                        mask.show();
                                        communicationService.put(url, param).promise().always(function(result) {
                                            mask.hide();
                                            if (exception.check(result)) {
                                                var switchFlag = $("#authinfo").widget().option("selected") == "on" ? true : false;
                                                //只修改别名称
                                                if (!switchFlag) {
                                                    message.success({
                                                        content: appUtils.getString("common_term_operation_success_label"),
                                                        ok: function() {
                                                            $("#modifyDevAliasWinId").widget().destroy();
                                                            $scope.datasCloudTable.queryData();
                                                        }
                                                    });
                                                    return;
                                                }
                                                var editParam = {};
                                                editParam.networkIpAddress = $("#ip").widget().getValue();
                                                editParam.networkUserName = $("#username").widget().getValue();
                                                editParam.isModifyPwd = switchFlag;
                                                editParam.networkPassword = $("#password").widget().getValue();
                                                var extendParams = {}
                                                if ($scope.deviceType == "ism.deviceType.storage.mainType") {
                                                    //DEFAULT
                                                    if ($("#protocalHidden").val() == "DEFAULT") {
                                                        extendParams.sslFlag = $("#ssl").widget().getSelectedId();
                                                    }
                                                    //REST
                                                    if ($("#protocalHidden").val() == "REST") {
                                                        extendParams.port = $("#port").widget().options.value;
                                                    }
                                                    extendParams.protocol = $("#protocalHidden").val();
                                                    editParam.networkIpAddress = $("#ip").widget().getValue();
                                                } else if ($scope.deviceType == "ism.drm.deviceType.drhost.mainType") {

                                                    extendParams.port = $("#port").widget().options.value;
                                                    editParam.networkIpAddress = $("#ip").widget().getValue();
                                                } else {
                                                    extendParams.port = $("#port").widget().options.value;
                                                    //TODO
                                                }
                                                editParam.extendParams = extendParams;
                                                mask.show();
                                                communicationService.put(utilService.getResouceUrl("/resources/" + $.base64.encode(data.sn) + "/action/modifyMgrProtocol"), editParam).promise().always(function(response) {
                                                    mask.hide();
                                                    if (exception.check(response)) {
                                                        message.success({
                                                            content: appUtils.getString("common_term_operation_success_label"),
                                                            ok: function() {
                                                                $("#modifyDevAliasWinId").widget().destroy();
                                                                $scope.datasCloudTable.queryData();
                                                            }
                                                        });
                                                    }
                                                });
                                            } else {
                                                mask.hide();
                                            }
                                        }, function(result) {
                                            exception.check(result);
                                        });
                                    }
                                }, {
                                    key: "cancel",
                                    label: appUtils.getString('common_term_cancel_button'),
                                    focused: false,
                                    handler: function(event) {
                                        $("#modifyDevAliasWinId").widget().destroy();
                                    }
                                }],
                                "close": function() {
                                    $("#modifyDevAliasWinId").widget().destroy();
                                }
                            };
                            var win = new Window(options);
                            win.show();
                        }
                    });
                };

                var _deleteDevAction = function() {
                    var name = _getOpName();
                    var id = _getOpID();
                    message.warn({
                        content: appUtils.getString("res_term_deletemo_message", name),
                        ok: function() {
                            mask.show();
                            communicationService.remove(utilService.getResouceUrl("/resources/action/deleteBatch?sns=" + id)).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response)) {
                                    //改成异步任务
                                    message.prompt({
                                        content: appUtils.getString("site_term_refresh_message"),
                                        ok: function(){
                                            $scope.datasCloudTable.queryData();
                                        }
                                    });
                                }
                            });
                        }
                    });
                };


                var _refreshDevAction = function() {
                    var deviceSn = _getOpID();
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/vcenters/" + deviceSn + "/action/refresh")).promise().always(function(result) {
                        mask.hide();
                        if (exception.check(result)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {}
                            });
                        }
                    });
                };

                $scope.datasCloudTable.queryData();

                $scope.$on("$destroy", function() {
                    refreshTimer && $timeout.cancel(refreshTimer);
                });
            }
        ]

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.vmware.ctrl', ctrler);
        return module;
    })
