define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var ctrl = [
            "$scope",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            function ($scope, exception, message, communicationService, utilService, mask, constsService, appUtils) {
                
                $scope.site = {
                    labelwidth: '80px',
                    width: '200px',
                    name: {
                        id: "nameRadio",
                        key: "name",
                        label: appUtils.getString("common_term_name_label"),
                        validate:"required",
                        spacing: { "width": "30px" },
                        click: function () {
                            if (!this.isCreate()) {
                                $scope.site.name.newName.display = false;
                                $scope.site.name.oldName.display = true;
                            } else {
                                $scope.site.name.newName.display = true;
                                $scope.site.name.oldName.display = false;
                            }

                            $scope.$apply();
                        },
                        values: [{
                            "key": "newName",
                            "text": appUtils.getString("dr_site_new_name_label"),
                            "checked": true
                        }, {
                            "key": "oldName",
                            "text": appUtils.getString("dr_site_old_name_label"),
                        }],
                        getValue: function () {
                            var isCheckedNewName = $("#nameRadio").widget().opChecked("checked") === "newName";
                            if (isCheckedNewName) {
                                return $("#" + this.newName.id).widget().getValue();
                            }
                            return $("#" + this.oldName.id).widget().getSelectedId();
                        },
                        isCreate: function () {
                            return $("#nameRadio").widget().opChecked("checked") === "newName";
                        },
                        newName: {
                            id: "newNameText",
                            label: appUtils.getString("dr_site_new_name_label"),
                            validate: constsService.VALID.NAME_REQUIRED.concat([{
                                validFn: "checkSiteName",
                                errorDetail: appUtils.getString("lego.err.335595782")
                            }]),
                            value: "",
                            display: true,
                        },
                        oldName: {
                            id: "oldNameSelect",
                            label: appUtils.getString("dr_site_old_name_label"),
                            validate:"required",
                            defaultSelectId: constsService.DEFAULT_SELECTID,
                            display: false,
                            values: [{
                                "selectId": constsService.DEFAULT_SELECTID,
                                "label": appUtils.getString("common_term_pleaseSelect_listbox")
                            }],
                        },
                    },
                    regionID: {
                        id: "regionIDText",
                        key: "region_id",
                        label: "Region ID",
                        validate: 'required;maxSize(32);regularCheck(/^[a-zA-Z0-9-]+$/):' + appUtils.getString("validate_term_region_id_msg"),
                        value: "",
                        getValue: function() {
                            return $("#" + this.id).widget().getValue();
                        }
                    },
                    regionName: {
                        id: "regionNameText",
                        key: "region_name",
                        validate: 'required;maxSize(100);regularCheck(/^[\\u4e00-\\u9fa5_\\-.@a-zA-Z0-9]+$/):' + appUtils.getString("validate_term_region_name_msg"),
                        label: "Region " + appUtils.getString("common_term_name_label"),
                        value: "",
                        getValue: function() {
                            return $("#" + this.id).widget().getValue();
                        }
                    },
                    azID: {
                        id: "azIDText",
                        key: "az_id",
                        label: "Availablity Zone ID",
                        validate: 'required;maxSize(101);regularCheck(/^[a-zA-Z0-9-.]+$/):' + appUtils.getString("validate_term_az_id_msg"),
                        value: "",
                        getValue: function() {
                            return $("#" + this.id).widget().getValue();
                        }
                    },
                    azName: {
                        id: "azNameText",
                        key: "az_name",
                        label: "Availablity Zone " + appUtils.getString("common_term_name_label"),
                        validate: "required;maxSize(40);regularCheck(/^[\\u4e00-\\u9fa5_\\_.a-zA-Z0-9]+$/):" + appUtils.getString("validate_term_az_name_msg"),
                        value: "",
                        getValue: function() {
                            return $("#" + this.id).widget().getValue();
                        }
                    }
                }

                initAllNames();

                var buttons = [{
                    key: "ok",
                    label: appUtils.getString('common_term_confirm_button'),
                    focused: true,
                    handler: function () {
                        if (!UnifyValid.FormValid($("#addDrSiteDiv"), {
                            focusInvalid: true
                        })) {
                            return;
                        };

                        if (!$scope.site.name.isCreate() && $scope.site.name.getValue() === constsService.DEFAULT_SELECTID) {
                            message.error(appUtils.getString("dr_site_input_isNull_tips", appUtils.getString("common_term_name_label")));
                            return;
                        }

                        var params = {
                            site_name: $scope.site.name.getValue(),
                            region_azs: [{
                                region: {
                                    region_id: $scope.site.regionID.getValue(),
                                    region_name: $scope.site.regionName.getValue()
                                },
                                az: {
                                    az_id: $scope.site.azID.getValue(),
                                    az_name: $scope.site.azName.getValue()
                                }
                            }]

                        };

                        var promise;
                        var url = "/csrconfig/v1/sites";

                        if (!$scope.site.name.isCreate()) {
                            delete params.site_name;
                            _.extend(params, {
                                operate_type: "add"
                            })
                            promise = communicationService.put(utilService.getResouceUrl(url + "/" + $scope.site.name.getValue()), params).promise();
                        } else {
                            promise = communicationService.post(utilService.getResouceUrl(url), params).promise();
                        }

                        promise.always(function(res){
                            if (exception.check(res)) {
                                var winData = $("#drSettingWin").widget().option("data");
                                $("#drSettingWin").widget().destroy();
                                winData.init(winData.type);
                            }
                        })
                    }
                }, {
                    key: "cancel",
                    label: appUtils.getString('common_term_cancel_button'),
                    focused: false,
                    handler: function (event) {
                        $("#drSettingWin").widget().destroy();
                    }
                }];
                $("#drSettingWin").widget().option("buttons", buttons);

                function initAllNames() {
                    var url = "/csrconfig/v1/sites";
                    communicationService.get(utilService.getResouceUrl(url)).promise().always(function (result) {
                        if (!exception.check(result)) {
                            return;
                        }
                        var values = [{
                            "selectId": constsService.DEFAULT_SELECTID,
                            "label": appUtils.getString("common_term_pleaseSelect_listbox")
                        }];
                         _.each(result.sites, function(item) {
                            values.push({
                                selectId: item.site_id,
                                label: item.site_name,
                                region_azs: item.region_azs
                            })
                        });
                        $scope.site.name.oldName.values = values;
                        $scope.$apply();
                    })
                }

                UnifyValid.checkSiteName = function () {
                    var val = $(this).val();
                    if (!val) {
                        return false;
                    }

                    var oldNames = angular.copy($scope.site.name.oldName.values);
                    oldNames.shift();

                    return _.pluck(oldNames, "label").indexOf(val) === -1;
                }

            }
        ]
        var module = angular.module("recoverydirector.monitor.config");
        module.tinyController("addDrSiteCtrl", ctrl);
        return module;
    }
)