define(["tiny-common/UnifyValid"],
    function (UnifyValid) {
        "use strict";
        var ctrl = [
            "$scope",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            function ($scope, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService) {
                var rowData = $("#drSettingWin").widget().option("data").data;

                $scope.isModify = !!rowData;

                $scope.services = {
                    serviceType: {
                        id: "serviceTypeSelect",
                        key: "service_type",
                        label: appUtils.getString("dr_site_service_type_label"),
                        values: getTypeOptions("SERVICE_TYPE"),
                        defaultSelectId: "compute",
                        getValue: function () {
                            return $("#" + this.id).widget().getSelectedId();
                        },
                        display: true,
                        disable: $scope.isModify,
                        change: function () {
                            $scope.services.primaryRegion.label = appUtils.getString("common_term_productRegion_label")
                            if (_.contains(["compute", "cce"], this.getValue())) {
                                $scope.services.secondAZ.display = false;
                                $scope.services.secondRegion.display = false;
                            } else {
                                $scope.services.secondAZ.display = true;
                                if ($scope.services.drType.getValue() === "inter-az") {
                                    $scope.services.primaryRegion.label = appUtils.getString("Region")
                                    $scope.services.secondRegion.display = false;
                                } else {
                                    $scope.services.secondRegion.display = true;
                                }
                            }
                            $scope.$apply();
                        }
                    },
                    drType: {
                        id: "drTypeSelect",
                        key: "dr_type",
                        label: appUtils.getString("dr_site_dr_type_label"),
                        values: getTypeOptions("DR_TYPE"),
                        display: true,
                        defaultSelectId: "inter-az",
                        disable: $scope.isModify,
                        getValue: function () {
                            return $("#" + this.id).widget().getSelectedId();
                        },
                    },
                    primaryRegion: {
                        id: "primaryRegionSelect",
                        key: "dr_type",
                        label: appUtils.getString("common_term_productRegion_label"),
                        values: [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                        display: true,
                        defaultSelectId: constsService.DEFAULT_SELECTID,
                        getValue: function () {
                            return {
                                region_id: $("#" + this.id).widget().getSelectedId(),
                                region_name: $("#" + this.id).widget().getSelectedLabel()
                            };
                        }, 
                        change: function () {
                            $scope.services.primaryRegion.defaultSelectId = this.getValue().region_id;
                            $scope.services.secondRegion.values = getRegionOptions($scope.services.primaryRegion.defaultSelectId)
                            
                            $scope.services.primaryAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId);
                            $scope.services.primaryAZ.defaultSelectId = constsService.DEFAULT_SELECTID;
                            if ($scope.services.drType.getValue() === "inter-az") {
                                $scope.services.secondAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId);
                                $scope.services.secondAZ.defaultSelectId = constsService.DEFAULT_SELECTID;
                            }
                        }
                    }, 
                    primaryAZ: {
                        id: "primaryAZSelect",
                        key: "dr_type",
                        label: appUtils.getString("common_term_productAvaiZone_label"),
                        values: [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                        display: true,
                        defaultSelectId: constsService.DEFAULT_SELECTID,
                        getValue: function () {
                            return {
                                az_id: $("#" + this.id).widget().getSelectedId(),
                                az_name: $("#" + this.id).widget().getSelectedLabel()
                            };
                        },
                        change: function () {
                            $scope.services.primaryAZ.defaultSelectId = this.getValue().az_id;
                            if ($scope.services.drType.getValue() === "inter-az") {
                                $scope.services.secondAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId, $scope.services.primaryAZ.defaultSelectId);
                            }
                        }
                    },
                    secondRegion: {
                        id: "secondRegionSelect",
                        key: "dr_type",
                        label: appUtils.getString("rm_term_openstack_dr_region"),
                        values: [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                        display: false,
                        defaultSelectId: constsService.DEFAULT_SELECTID,
                        getValue: function () {
                            return {
                                region_id: $("#" + this.id).widget().getSelectedId(),
                                region_name: $("#" + this.id).widget().getSelectedLabel()
                            };
                        },
                        change: function () {
                            $scope.services.secondRegion.defaultSelectId = this.getValue().region_id;
                            $scope.services.primaryRegion.values = getRegionOptions($scope.services.secondRegion.defaultSelectId);
                            $scope.services.secondAZ.values = getAzOptions($scope.services.secondRegion.defaultSelectId);
                            $scope.services.secondAZ.defaultSelectId = constsService.DEFAULT_SELECTID;
                        }
                    }, 
                    secondAZ: {
                        id: "secondAZSelect",
                        key: "dr_type",
                        label: appUtils.getString("rm_term_openstack_dr_zone"),
                        values: [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                        defaultSelectId: constsService.DEFAULT_SELECTID,
                        display: false,
                        getValue: function () {
                            return {
                                az_id: $("#" + this.id).widget().getSelectedId(),
                                az_name: $("#" + this.id).widget().getSelectedLabel()
                            };
                        },
                        change: function() {
                            $scope.services.secondAZ.defaultSelectId = this.getValue().az_id;
                            if ($scope.services.drType.getValue() === "inter-az") {
                                $scope.services.primaryAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId, $scope.services.secondAZ.defaultSelectId);
                            }
                        }
                    }
                }
                var regionAzs = [];
                var siteRegionAZS = {};
                var buttons = [{
                    key: "ok",
                    label: appUtils.getString('common_term_confirm_button'),
                    focused: true,
                    handler: function () {
                        //校验
                        if (!UnifyValid.FormValid($("#addServicePairDiv"), {
                            focusInvalid: true
                        })) {
                            return;
                        };

                        
                        var params = { 
                            service_type: $scope.services.serviceType.getValue(),
                            dr_type: $scope.services.drType.getValue()
                        };
                        
                        var primaryRegionAZ = {
                            region: $scope.services.primaryRegion.getValue(),
                            az: $scope.services.primaryAZ.getValue()
                        };
                        
                        if (primaryRegionAZ.region.region_id === constsService.DEFAULT_SELECTID) {
                            message.error(appUtils.getString("dr_site_input_isNull_tips", appUtils.getString("common_term_productRegion_label")));
                            return;
                        }

                        if (primaryRegionAZ.az.az_id === constsService.DEFAULT_SELECTID) {
                            message.error(appUtils.getString("dr_site_input_isNull_tips", appUtils.getString("common_term_productAvaiZone_label")));
                            return;
                        }

                        if (_.contains(["compute", "cce"], params.service_type)) {
                            if ($scope.isModify) {
                                params.region_az = primaryRegionAZ;
                                params.region_pair = {};
                            } else {
                                params.region_azs = [primaryRegionAZ];
                                params.region_pairs = [];
                            }
                        } else {
                            var regionPair = {
                                primary_region: primaryRegionAZ,
                                second_region: {
                                    region: params.dr_type === "inter-az" ? $scope.services.primaryRegion.getValue() : $scope.services.secondRegion.getValue(),
                                    az: $scope.services.secondAZ.getValue()
                                }
                            };
                            if (regionPair.second_region.region.region_id === constsService.DEFAULT_SELECTID) {
                                message.error(appUtils.getString("dr_site_input_isNull_tips", appUtils.getString("rm_term_openstack_dr_region")));
                                return;
                            }

                            if (regionPair.second_region.az.az_id === constsService.DEFAULT_SELECTID) {
                                message.error(appUtils.getString("dr_site_input_isNull_tips", appUtils.getString("rm_term_openstack_dr_zone")));
                                return;
                            }

                            if ($scope.isModify) {
                                params.region_pair = regionPair;
                            } else {
                                params.region_pairs = [regionPair]
                            }
                        }

                        var url = "/csrconfig/v1/cloudserv";
                        var promise;
                        var winData = $("#drSettingWin").widget().option("data");

                        if ($scope.isModify) {
                            delete params.dr_type;
                            promise = communicationService.put(utilService.getResouceUrl(url + "/" + winData.data.id), params).promise();
                        } else {
                            promise = communicationService.post(utilService.getResouceUrl(url), params).promise();
                        }
                        
                        promise.always(function(res){
                            if (exception.check(res)) {
                                $("#drSettingWin").widget().destroy();
                                winData.init(winData.type); 
                            }
                        })
                    }
                }, {
                    key: "cancel",
                    label: appUtils.getString('common_term_cancel_button'),
                    focused: false,
                    handler: function (event) {
                        $("#drSettingWin").widget().destroy();
                    }
                }];
                $("#drSettingWin").widget().option("buttons", buttons);

                init();

                function init() {
                    if ($scope.isModify) {
                        $scope.services.serviceType.defaultSelectId = rowData.service_type;
                        $scope.services.drType.defaultSelectId = rowData.dr_type;
                        if (_.contains(["cce", "compute"], rowData.service_type)) {
                            $scope.services.secondAZ.display = false;
                            $scope.services.secondRegion.display = false;
                            $scope.services.primaryRegion.values = [{
                                selectId: rowData.region_az.region.region_id,
                                label: rowData.region_az.region.region_name,
                                checked: true,
                            }];
                            $scope.services.primaryAZ.values = [{
                                selectId: rowData.region_az.az.az_id,
                                checked: true,
                                label: rowData.region_az.az.az_name
                            }];
                            $scope.services.primaryRegion.defaultSelectId = rowData.region_az.region.region_id;
                            $scope.services.primaryAZ.defaultSelectId = rowData.region_az.az.az_id;
                        } else {
                            $scope.services.secondAZ.display = true;
                            if (rowData.dr_type === "inter-az") {
                                $scope.services.secondRegion.display = false;
                                $scope.services.primaryRegion.label = appUtils.getString("Region");

                            } else {
                                $scope.services.secondRegion.display = true;
                            }
                            $scope.services.primaryRegion.values = [{
                                selectId: rowData.region_pair.primary_region.region.region_id,
                                label: rowData.region_pair.primary_region.region.region_name,
                                checked: true,
                            }];
                            $scope.services.primaryAZ.values = [{
                                selectId: rowData.region_pair.primary_region.az.az_id,
                                checked: true,
                                label: rowData.region_pair.primary_region.az.az_name
                            }];
                            $scope.services.secondRegion.values = [{
                                selectId: rowData.region_pair.second_region.region.region_id,
                                checked: true,
                                label: rowData.region_pair.second_region.region.region_name
                            }];
                            $scope.services.secondAZ.values = [{
                                selectId: rowData.region_pair.second_region.az.az_id,
                                checked: true,
                                label: rowData.region_pair.second_region.az.az_name
                            }];
                            $scope.services.primaryRegion.defaultSelectId = rowData.region_pair.primary_region.region.region_id;
                            $scope.services.primaryAZ.defaultSelectId = rowData.region_pair.primary_region.az.az_id;
                            $scope.services.secondRegion.defaultSelectId = rowData.region_pair.second_region.region.region_id;
                            $scope.services.secondAZ.defaultSelectId = rowData.region_pair.second_region.az.az_id;
                        }
                        $scope.$apply();
                    }
                    initRegionAzs();
                }

                function initRegionAzs () {
                    mask.show();
                    var url = "/csrconfig/v1/sites";
                    communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                        if (!exception.check(result)) {
                            mask.hide();
                            return;
                        }
                        siteRegionAZS = angular.copy(result.sites);
                        regionAzs = getRegionAzsOptions(result.sites);
                        $scope.services.secondRegion.values = getRegionOptions($scope.services.primaryRegion.defaultSelectId);
                        if ($scope.services.drType.defaultSelectId === "inter-az" ) {
                            $scope.services.primaryRegion.values = regionAzs;
                            $scope.services.primaryAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId, $scope.services.secondAZ.defaultSelectId);
                            $scope.services.secondAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId, $scope.services.primaryAZ.defaultSelectId);
                        } else {
                            $scope.services.primaryRegion.values = getRegionOptions($scope.services.secondRegion.defaultSelectId);
                            $scope.services.primaryAZ.values = getAzOptions($scope.services.primaryRegion.defaultSelectId);
                            $scope.services.secondAZ.values = getAzOptions($scope.services.secondRegion.defaultSelectId);
                        }
                        $scope.$apply();
                        mask.hide();
                    })
                }

                function getTypeOptions(key) {
                    var arrays = [], status = statusEnumService.getJsonArray(key);
                    _.each(status, function (obj) {
                        var id = _.first(_.keys(obj)), label = _.first(_.values(obj));
                        this.push({
                            selectId: id,
                            label: label
                        });
                    }, arrays);
                    return arrays;
                }

                // 跨可用region时， 过滤掉存在已选region的站点下的所有region
                function getRegionOptions(regionId) {
                    if (regionId === constsService.DEFAULT_SELECTID || !regionId) {
                        return regionAzs;
                    }
                    var sites = [];
                    _.each(siteRegionAZS, function(item) {
                        var regions = _.pluck(item.region_azs, "region");
                        var regionIds = _.pluck(regions, "region_id");
                        if (regionIds.indexOf(regionId) === -1) {
                            // 不存在相同region的站点才纳入选择
                            sites.push(item);
                        }
                    })
                    var options = getRegionAzsOptions(sites);
                    return options;
                }

                // 跨可用区时，过滤相同region/az的站点
                function getAzOptions(regionId, azId) {
                    var sites = [];
                    if (regionId === constsService.DEFAULT_SELECTID || !regionId) {
                        return [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }]
                    }
                    if (azId === constsService.DEFAULT_SELECTID || !azId) {
                        return _.find(regionAzs, {"selectId": regionId}).azs
                    }
                    _.each(siteRegionAZS, function(item) {
                        var flag = false;
                        _.each(item.region_azs, function (regAz) {
                            if (regAz.region.region_id === regionId && regAz.az.az_id === azId ) {
                                flag = true;
                                return;
                            }
                        })

                        if (!flag) {
                            sites.push(item);
                        }
                    })
                    var options = getRegionAzsOptions(sites);
                    var option = _.find(options, {"selectId": regionId});
                    if (!option) {
                        return [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }];
                    }
                    return option.azs;
                }

                function getRegionAzsOptions(result) {
                    var options = [];
                    var region_azs = _.reduceRight(_.pluck(result, "region_azs"), function(a, b) {
                        return a.concat(b);
                    }, []);

                    var data = _.groupBy(region_azs, function(item) {
                        return item.region.region_id;
                    })
                    _.each(data, function (item) {
                        var azs = _.uniq(_.pluck(item, "az"), false, "az_id");
                        _.each(azs, function(az) {
                            az.label = az.az_name,
                            az.selectId = az.az_id
                        })
                        azs.unshift({
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        })
                        options.push({
                            selectId: item[0].region.region_id,
                            label: item[0].region.region_name,
                            azs: azs
                        })
                    })
                    options.unshift({
                        selectId: constsService.DEFAULT_SELECTID,
                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                        azs: [{
                            selectId: constsService.DEFAULT_SELECTID,
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }]
                    })

                    return options;
                }
            }
        ]
        var module = angular.module("recoverydirector.monitor.config");
        module.tinyController("addServicePairCtrl", ctrl);
        return module;
    }
)