define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function (UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$q",
            "$stateParams",
            "exception",
            "communicationService",
            "utilService",
            "constsService",
            "appUtils",
            "$compile",
            "message",
            'statusEnumService',
            'mask',
            function ($scope, $q, $stateParams, exception, communicationService, utilService, constsService, appUtils, $compile, message, statusEnumService, mask) {

                var isDrSites = $stateParams.type == "sites";

                var siteColumns = [{
                    "bVisible": false,
                    "mData": "site_id"
                }, {
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "site_name",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("Region/AZ"),
                    "mData": "region_az",
                    "sWidth": "18%",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("Region"),
                    "mData": "region_name",
                    "sWidth": "12%",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("AZ"),
                    "mData": "az_name",
                    "sWidth": "10%",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "bSortable": false
                }]

                var serverColumn = [{
                    "bVisible": false,
                    "mData": "id"
                }, {
                    "sTitle": appUtils.getString("dr_site_service_type_label"),
                    "mData": "service_type",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("dr_site_dr_type_label"),
                    "mData": "dr_type",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("dr_site_production_region_az_label"),
                    "mData": "region_az",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("dr_site_dr_region_az_label"),
                    "mData": "region_pair",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("recovery.term.colum.operate.title"),
                    "mData": "",
                    "bSortable": false
                }]

                $scope.btnCreate = {
                    id: "btnCreate",
                    text: appUtils.getString("common_term_add_button"),
                    authKey: $scope.$parent.optResAuthKey,
                    click: openAddWin
                };

                $scope.btnDelete = {
                    text: appUtils.getString("common_term_delete_button"),
                    disabled: true,
                    click: function () {
                        if ($scope.btnDelete.disabled) {
                            return
                        }
                        var data = $("#drSettingTable").widget().getTableCheckedItems();
                        deleteData(data);
                    }
                }

                $scope.drSettingTable = {
                    id: "drSettingTable",
                    data: [],
                    isDraggedRemember: true,
                    checkbox: true,
                    columns: isDrSites ? angular.copy(siteColumns) : angular.copy(serverColumn),
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    lengthMenu: constsService.TABLE_LENGTH_AUTO_MENU,
                    paginationStyle: "full_numbers",
                    totalRecords: 0,
                    enablePagination: false,
                    renderRow: function (nRow, aData, iDataIndex) {
                        var hasRight = appUtils.checkRight($scope.$parent.optResAuthKey);
                        var optHtml = "<a href='javascript:void(0)' style='margin-right:18px' ng-if='" + hasRight + '&&' + !isDrSites + "' class='btn-link' ng-click='editOpt()'>" + appUtils.getString("common_term_edit_button") + "</a>" + "<a href='javascript:void(0)' ng-if='" + hasRight + "' class='btn-link' ng-click='delete()'>" + appUtils.getString("common_term_delete_button") + "</a>";
                        var optLink = $compile($(optHtml));
                        var optScope = $scope.$new();
                        optScope.data = aData;
                        optScope.delete = function () { 
                            var title = appUtils.getString("common_ecs_setting_label");
                            if (isDrSites) {
                                title = appUtils.getString("common_dr_site_label");
                            }
                            message.warn({
                                content: appUtils.getString("pair_mapping_delete_warn_label", title),
                                ok: function () {
                                    var currentData = $("#drSettingTable").widget().getHoverData();
                                    deleteData(currentData)
                                }
                            })
                        };

                        optScope.editOpt = function () {
                            var currentData = $("#drSettingTable").widget().getHoverData();
                            openAddWin(currentData[0])
                        };
                        // 表格处理
                        if (isDrSites) {
                            $('td:eq(2)', nRow).html(aData['pair']['region']['region_id'] + "/" + aData['pair']['az']['az_id']);
                            $('td:eq(3)', nRow).html(aData['pair']['region']['region_name']);
                            $('td:eq(4)', nRow).html(aData['pair']['az']['az_name']);

                        } else {
                            $('td:eq(1)', nRow).html(statusEnumService.getValueByKey("SERVICE_TYPE", aData['service_type']))
                            $('td:eq(2)', nRow).html(statusEnumService.getValueByKey("DR_TYPE", aData['dr_type']))
                            if (!aData['region_pair']) {
                                $('td:eq(3)', nRow).html(aData['region_az']['region']['region_name'] + "/" + aData['region_az']['az']['az_name']);
                                $('td:eq(4)', nRow).html('--')
                            } else {
                                $('td:eq(3)', nRow).html(aData['region_pair']['primary_region']['region']['region_name'] + "/" + aData['region_pair']['primary_region']['az']['az_name']);
                                $('td:eq(4)', nRow).html(aData['region_pair']['second_region']['region']['region_name'] + "/" + aData['region_pair']['second_region']['az']['az_name']);
                            }
                        }

                        $('td:eq(5)', nRow).html(optLink(optScope));

                    },
                    tHeadCheckboxFn: function () {
                        deleteClass()
                    },
                    click: function () {
                        deleteClass()
                    },
                    callback: function () {
                        deleteClass()
                    },
                    refreshData: function () {
                        _init();
                    }
                };

                function _init(type) {
                    // 数据加载
                    var url = "/csrconfig/v1/" + (type || $stateParams.type);
                    $scope.maskHandler = true;
                    var promise = communicationService.get(utilService.getResouceUrl(url)).promise();
                    promise.always(function (result) {
                        $scope.maskHandler = false;
                        if (!exception.check(result)) {
                            return;
                        };
                        //处理表格数据
                        var tableData = [];
                        var data = angular.copy(appUtils.encodeForHTML(result));
                        if (isDrSites) {
                            _.each(data.sites, function (aData) {
                                _.each(aData['region_azs'], function (item) {
                                    tableData.push(_.extend(angular.copy(aData), { pair: item }));
                                })
                            })
                            tableData = _.sortBy(tableData, "site_name");
                        } else {
                            tableData = data.services;
                        }
                        $scope.drSettingTable.data = tableData;
                        $scope.drSettingTable.totalRecords = tableData.length;
                        $scope.drSettingTable.enablePagination = tableData.length > 10;
                    })

                };

                function openAddWin(rowData) {
                    // 添加
                    var title = isDrSites ? "common_add_sites_label" : "common_add_cloudserv_label";
                    var options = {
                        winId: "drSettingWin",
                        title: appUtils.getString(title),
                        data: {
                            type: $stateParams.type,
                            data: rowData,
                            init: _init
                        },
                        width: '450px',
                        height: '500px',
                        closeable: false,
                        'content-type': "url",
                        content: "app/business/recoverydirector/site/views/resource/vrg/addDrSite.html",
                    }
                    if (!isDrSites) {
                        options.content = "app/business/recoverydirector/site/views/resource/vrg/addServicePair.html";
                    }
                    var win = new Window(options);
                    win.show();
                }

                function deleteData(arr) {
                    !_.isArray(arr) && (arr = [arr])
                    // 批量删除
                    var url = "/csrconfig/v1/" + $stateParams.type;
                    if (isDrSites) {
                        deleteSites(arr, url);
                    } else {
                        var ids = _.pluck(arr, "id")
                        communicationService.remove(utilService.getResouceUrl(url), ids).promise().always(function (res) {
                            if (exception.check(res)) {
                                _init();
                            }
                        })
                    }
                }

                function deleteSiteRegionAz(url, item, response) {
                    var params = {
                        operate_type: "remove",
                        region_azs: [item.pair]
                    }
                    var defer = $q.defer();
                    communicationService.put(utilService.getResouceUrl(url + "/" + item.site_id), params).promise().always(function (res) {
                        if (!res) {
                            response.succeedCount++;
                        } else {
                            response.failCount++;
                        }
                        response.result.push({
                            targetName: item.site_name + "(" + item['pair']['region']['region_name'] + ":" + item['pair']['az']['az_name'] + ")",
                            errorObject: res
                        })
                        defer.resolve();
                    })

                    return defer.promise;
                }

                function deleteSiteById(url, item, response) {
                    var defer = $q.defer();
                    url = url + "/" + item.site_id;
                    communicationService.remove(utilService.getResouceUrl(url)).promise().always(function (res) {
                        if (!res) {
                            // 处理
                            response.succeedCount++
                        } else {
                            response.failCount++;
                        }
                        response.result.push({
                            targetName: item.site_name,
                            errorObject: res
                        })
                        defer.resolve();
                    })
                    return defer.promise;
                }

                function deleteSites(arr, url) {
                    var response = {
                        failCount: 0,
                        succeedCount: 0,
                        isCheckResult: true,
                        result: [],
                        totalCount: arr.length
                    };
                    var sitesGroup = _.groupBy(arr, "site_name");
                    var deleteData = [], putDeleteData = [];
                    _.each(sitesGroup, function (sites) {
                        if (sites.length === sites[0].region_azs.length) {
                            deleteData.push(sites[0]);
                        } else {
                            putDeleteData = putDeleteData.concat(sites);
                        }
                    })

                    var promise = [];
                    if (deleteData.length > 0) {
                        _.each(deleteData, function (site) {
                            promise.push(deleteSiteById(url, site, response));
                        })
                    }

                    if (putDeleteData.length > 0) {
                        _.each(putDeleteData, function (site) {
                            promise.push(deleteSiteRegionAz(url, site, response))
                        })
                    }

                    $q.all(promise).then(function () {
                        if (response.failCount == 0) {
                            message.success({
                                content: appUtils.getString("common_term_operation_success_label"), ok: function () {
                                    _init();
                                }
                            });
                        } else if (response.totalCount == 1) {
                            if (exception.check(response.result[0].errorObject)) {
                                _init();
                            }
                        } else {
                            //结果显示
                            appUtils.openBatchResultWin(appUtils.getString("common_message_win_information_title"), {}, response, _init)
                        }
                    })

                }

                function deleteClass() {
                    if ($("#drSettingTable").widget() && $("#drSettingTable").widget().getTableCheckedItems().length > 0) {
                        $scope.btnDelete.disabled = false;
                    } else {
                        $scope.btnDelete.disabled = true;
                    }
                    $scope.$apply();
                }

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, function (ev, data) {
                    _init();
                });

                _init();
            }
        ]
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.vrg.drSites.ctrl', ctrler);
        return module;
    }
)