define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function(UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$sce",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            "infoTransferredService",
            function($scope, $state, $sce, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model, infoTransferredService) {
                var currentSite = infoTransferredService.get("site", "currentSite");
                if (!currentSite) {
                    return;
                }

                var vrgObj = $scope.$parent.getData(),
                    pairObj = {},
                    addVrgPairText = appUtils.getString("site.term,vrgPair.label"),
                    pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox"),
                    linkHtml = "<a class='link'> " + addVrgPairText + " </a>",
                    VRG_STATUS = {
                        0: appUtils.getString("ism.drm.protect.group.replica.status.unactived"),
                        1: appUtils.getString("common_term_vrg_normal_lable"),
                        2: appUtils.getString("common_term_vrg_pairing_lable"),
                        3: appUtils.getString("common_term_vrg_pair_field_lable"),
                        4: appUtils.getString("common_term_vrg_no_pair_lable"),
                        5: appUtils.getString("common_term_vrg_pair_stop_lable"),
                        6 : appUtils.getString("common_term_unknow_label")
                    };

                var cacheInfo = function(result) {
                    var charDatas = [];
                    $("#testStatusChart").empty();
                    var total = +result.totalCapacity/1024/1024;
                    var other = +result.availableCapacity/1024/1024;
                    other = Math.floor(other);
                    total = Math.floor(total);
                    total = total - other;


                    if (total <= 0 && other <= 0) {
                        $("#legendContainer").addClass("hide");
                        charDatas.push({
                            value: 100,
                            name: appUtils.getString("common_term_nodata_label"),
                            color: constsService.COLOR_THIN_GREY,
                            tooltip: appUtils.getString("common_term_nodata_label")
                        });
                    } else {
                        $("#legendContainer").removeClass("hide");
                        charDatas.push({
                            value: total * 100 / (total + other),
                            name: appUtils.getString("site_term_overallCache_label"),
                            color: constsService.COLOR_GREEN,
                            tooltip: appUtils.getString("site_term_overallCache_label") + ": " + total + " GB"
                        });
                        charDatas.push({
                            value: other * 100 / (total + other),
                            name: appUtils.getString("site_term_remainlCache_label"),
                            color: constsService.COLOR_GREY,
                            tooltip: appUtils.getString("site_term_remainlCache_label") + ": " + other + " GB"
                        });
                    }
                    if (!$("#testStatusChart").html()) {
                        var options = {
                            id: "testStatusChart",
                            r: 65,
                            height: 200,
                            width: 300,
                            strokeWidth: 12,
                            showLegend: false,
                            showClickEvent: true,
                            "data": charDatas
                        };
                        var testStatusChart = new tinyWidget.Cirquechart(options);
                        $("#total").eq(0).text(total + " GB");
                        $("#other").eq(0).text(other + " GB");
                    }
                };

                $scope.basicInfo = {
                    title: appUtils.getString("common.term.basicInfo.title.label"),
                    name: {
                        label: appUtils.getStringWithColon("common_term_name_label"),
                        value: "--"
                    },
                    ip: {
                        label: appUtils.getStringWithColon("common_term_ip_column"),
                        value: "--"
                    },
                    status: {
                        label: appUtils.getStringWithColon("site_term_pairStatus_label"),
                        value: "--"
                    }
                };

                $scope.cacheInfo = {
                    title: appUtils.getString("site_term_cacheInfo_label"),
                    total: appUtils.getString("site_term_overallCache_label"),
                    other: appUtils.getString("site_term_remainlCache_label")
                }

                $scope.vrgPair = {
                    title: appUtils.getString("site.term.vrgPairing.label"),
                    isPair: false,
                    mappingId : "",
                    pairInfo: {
                        psite: {
                            name: "productSiteName",
                            label: appUtils.getStringWithColon("rm_term_production_site"),
                            value: "--"
                        },
                        rsite: {
                            name: "recoverySiteName",
                            label: appUtils.getStringWithColon("rm_term_dr_site"),
                            value: "--"
                        },
                        pfc: {
                            name: "productResourceProviderName",
                            label: appUtils.getStringWithColon("recovery.term.vrg.product_fc.title"),
                            value: "--"
                        },
                        rfc: {
                            name: "recoveryResourceProviderName",
                            label: appUtils.getStringWithColon("recovery.term.vrg.recovery_fc.title"),
                            value: "--"
                        },
                        pvrg: {
                            name: "productResourceName",
                            label: appUtils.getStringWithColon("common_term_vrg_label"),
                            value: "--"
                        },
                        rvrg: {
                            name: "recoveryResourceName",
                            label: appUtils.getStringWithColon("common_term_vrg_label"),
                            value: "--"
                        }
                    },
                    btns: {
                        pair: {
                            id: "iconBtnPair",
                            authKey: "ism.drm.resmapping.vrg.auth.map",
                            linkHtml: $sce.trustAsHtml(appUtils.getString("site_vrg_task_setPairWhenThereIsNone_des_label",linkHtml)),
                            text: appUtils.getString("site.term,vrgPair.label"),
                            click: function() {
                                mask.show();
                                communicationService.get(utilService.getResouceUrl("/vrg/" + vrgObj.deviceSn + "/action/associatedFusionCompute")).promise().always(function(result) {
                                    mask.hide();

                                    if (!exception.check(result)) {
                                        return;
                                    }

                                    var win = angular.copy(constsService.VRG_PAIR_WIN);
                                    win.title = appUtils.getString(win.title);
                                    win.data = {
                                        psite: {
                                            id: currentSite.siteId,
                                            name: currentSite.name
                                        },
                                        pfc : {
                                            id : result.deviceSn,
                                            name : result.cloudName
                                        },
                                        pvrg: {
                                            id: vrgObj.deviceSn,
                                            name: vrgObj.cloudName
                                        }
                                    };

                                    appUtils.showWindow(win, function() {
                                        var options = this.options;
                                        if (!UnifyValid.FormValid($("#" + options.verifyId), {focusInvalid: true})) {
                                            return;
                                        }

                                        var rquestObj = {
                                                "productSiteId": options.data.psite.id,
                                                "productResourceProviderId" : options.data.pfc.id,
                                                "productResourceId": [options.data.pvrg.id],
                                                resourceType : 5
                                            },
                                            errorMsg,
                                            validateBox = {
                                                rsite: {
                                                    id: "rsite",
                                                    name: "recoverySiteId",
                                                    label: appUtils.getString("rm_term_dr_site")
                                                },
                                                rfc: {
                                                    id: "rfc",
                                                    name: "recoveryResourceProviderId",
                                                    label: appUtils.getString("recovery.term.vrg.recovery_fc.title")
                                                },
                                                rvrg: {
                                                    id: "rvrg",
                                                    name: "recoveryResourceId",
                                                    label: appUtils.getString("common_term_vrg_label")
                                                }
                                            };

                                        $.each(validateBox, function(index) {
                                            var selectId = $("#" + this.id).widget().getSelectedId();
                                            var label = $("#" + this.id).widget().getSelectedLabel();

                                            if (angular.isUndefined(selectId) || -1 === +selectId) {
                                                errorMsg = this.label;
                                                return false;
                                            }

                                            rquestObj[this.name] = selectId;
                                        });

                                        if (angular.isDefined(errorMsg)) {
                                            message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate",errorMsg));
                                            return false;
                                        }

                                        rquestObj["recoveryResourceId"] = [rquestObj["recoveryResourceId"]];

                                        mask.show();
                                        communicationService.post(utilService.getResouceUrl(constsService.RM_URL.mappingURL), rquestObj).promise().always(function(response) {
                                            mask.hide();
                                            if (!exception.check(response) || _.isUndefined(response)) {
                                                return;
                                            }

                                            message.success({
                                                content: appUtils.getString("setting_resourceMapping_task_map_createMappingView_success_message"),
                                                ok: function() {
                                                    $("#" + options.winId).widget().destroy();
                                                    init();
                                                }
                                            });

                                        }, function(response) {
                                            mask.hide();
                                        });
                                    })
                                });



                            }
                        },
                        afreshPair: {
                            id: "iconBtnAfreshPair",
                            text: appUtils.getString("common_term_vrg_pair_label"),
                            click: function() {
                                var status = pairObj.status;
                                if (1 != status && 2 != status && 0 != pairObj.role) {
                                    var data = {};
                                    var columParams = {
                                        productSiteName: pairObj.productSiteName,
                                        productResourceName: pairObj.productResourceName,
                                        recoverySiteName: pairObj.recoverySiteName,
                                        recoveryResourceName: pairObj.recoveryResourceName
                                    };
                                    message.warn({
                                        content: appUtils.getString('mapping_resource_vrg_rest_warn_tips', columParams.productSiteName, columParams.productResourceName,
                                            columParams.recoverySiteName, columParams.recoveryResourceName),
                                        ok: function() {
                                            mask.show();
                                            communicationService.put(utilService.getResouceUrl("/vrg/action/repair?mappingId=" + pairObj.mappingId)).promise().always(function(response) {
                                                mask.hide();
                                                if (exception.check(response)) {
                                                    message.success({
                                                        content: appUtils.getString("common_term_operation_success_label"),
                                                        ok: function() {
                                                            init();
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        },
                        deletePair: {
                            id: "iconBtnDel",
                            text: appUtils.getString("common_term_delete_button"),
                            click: function() {
                                if (0 != pairObj.role && 2 != pairObj.status) {
                                    $scope.start = constsService.start;
                                    var data = {};
                                    var columParams = {
                                        productSiteName: pairObj.productSiteName,
                                        productResourceName: pairObj.productResourceName,
                                        recoverySiteName: pairObj.recoverySiteName,
                                        recoveryResourceName: pairObj.recoveryResourceName
                                    };

                                var editButtons = [
                                  {
                                      key: "ok",
                                      label: appUtils.getString("common_term_confirm_button"),
                                      handler: function (event) {
                                           var forcedDelete = $('#forcedDelete').is(':checked');
                                           $("#" + constsService.DELETE_VRG_PAIR.winId).widget().destroy();
                                           mask.show();
                                            communicationService.remove(utilService.getResouceUrl("/resourcemapping/" + pairObj.mappingId + "?isForce=" + forcedDelete)).promise().always(function(response) {
                                                mask.hide();
                                                if (exception.check(response)) {
                                                    message.prompt({
                                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                                        ok: function() {
                                                            init();
                                                        }
                                                    });
                                                }
                                            });
                                      }
                                  },
                                  {
                                      key : "cancel",
                                      label: appUtils.getString("common_term_cancel_button"),
                                      focused: true,
                                      handler: function (event) {
                                          $("#" + constsService.DELETE_VRG_PAIR.winId).widget().destroy();
                                      }
                                  }
                                ];

                                constsService.DELETE_VRG_PAIR.data[0] = appUtils.getString('mapping_resource_vrg_delete_warn_tips', columParams.productSiteName, columParams.productResourceName,
                                            columParams.recoverySiteName, columParams.recoveryResourceName)

                                openWindow(constsService.DELETE_VRG_PAIR.winId,appUtils.getString(constsService.DELETE_VRG_PAIR.title),constsService.DELETE_VRG_PAIR.data,constsService.DELETE_VRG_PAIR.width,constsService.DELETE_VRG_PAIR.height,
                                        constsService.DELETE_VRG_PAIR.url,editButtons);
                                }
                            }
                        }
                    }
                }

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, function(evt, rowData) {
                    if(2 !== constsService.FUSIONSPHERE_ENUM[rowData.cloudType])
                    {
                        return;
                    }

                    vrgObj = rowData;
                    queryBasicInfo(queryPairInfo);
                });

                function queryBasicInfo(callBack) {

                    $scope.vrgStatusImgName = vrgObj.cloudStatus ? "vrg_pair" : "vrg_unpair";

                    $scope.maskHandler = true;
                    communicationService.get(utilService.getResouceUrl("/vrg/" + vrgObj.deviceSn + "/action/getBriefInfo")).promise().always(function(result) {

                        (callBack)();
                        if (!exception.check(result)) {
                            return;
                        }
                        cacheInfo(result);

                        var basicInfo = $scope.basicInfo;
                        basicInfo.name.value = result.name;
                        basicInfo.ip.value = result.ipAddress;

                        $scope.$apply();
                    });

                };

                var queryPairInfo = function() {
                    var paramObj = {
                        filterName: "resourceId",
                        filterValue : vrgObj.deviceSn,
                        resourceType : 5,
                        startPage: 0,
                        pageSize: 10
                    };
                    var url = appUtils.fillUrl(constsService.RM_URL.mappingURL, paramObj);

                    communicationService.get(url, null, null, 3600000).promise().always(function(result) {
                        $scope.maskHandler = false;
                        if (!exception.check(result) || _.isEmpty(result.records)) {
                            $scope.vrgPair.isPair = false;
                            $scope.basicInfo.status.value = VRG_STATUS[4];
                            $scope.$apply();
                            return;
                        }

                        pairObj = result.records[0];
                        _.each($scope.vrgPair.pairInfo, function(obj) {
                            obj.value = this[obj.name];
                        }, pairObj)

                        $scope.vrgPair.isPair = true;
                        $scope.basicInfo.status.value = VRG_STATUS[pairObj['status']];

                        $scope.vrgPair.btns.afreshPair.class = 1 != pairObj.status && 2 != pairObj.status && 0 != pairObj.role ? "iconbutton-pair" : "iconbutton-pair-disabled";
                            $scope.vrgPair.btns.afreshPair.disabled = 1 != pairObj.status && 2 != pairObj.status && 0 != pairObj.role ? "btn-link" : "toolbar-disabled";

                            $scope.vrgPair.btns.deletePair.class= 0 != pairObj.role && 2 != pairObj.status ? "iconbutton-delete" : "iconbutton-delete-disabled";
                            $scope.vrgPair.btns.deletePair.disabled = 0 != pairObj.role && 2 != pairObj.status ? "btn-link" : "toolbar-disabled";
                        $scope.$apply();
                    });
                };

                function init(){
                    queryBasicInfo(queryPairInfo);
                };
                !_.isEmpty(vrgObj) && (init());

                function openWindow(id, title, param, width, height, url, buttons) {
                    var options = {
                        "winId": id,
                        "title": title,
                        "data": param,
                        "height": height,
                        "width": width,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": url,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": buttons,
                        "close": function () {
                            $("#" + constsService.DELETE_VRG_PAIR.winId).widget().destroy();
                        }
                    };
                    var win = new Window(options);
                    win.show();
                };
            }
        ]
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.vrg.pairInfo.ctrl', ctrler);
        return module;
    })
